/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.persistence.view.AllowUpdatableEntityViews;
import com.blazebit.persistence.view.BatchFetch;
import com.blazebit.persistence.view.CollectionMapping;
import com.blazebit.persistence.view.IdMapping;
import com.blazebit.persistence.view.MappingInheritance;
import com.blazebit.persistence.view.MappingInheritanceMapKey;
import com.blazebit.persistence.view.MappingInheritanceSubtype;
import com.blazebit.persistence.view.MappingInverse;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.MappingSingular;
import com.blazebit.persistence.view.OptimisticLock;
import com.blazebit.persistence.view.UpdatableMapping;
import com.blazebit.persistence.view.impl.metamodel.AbstractAnnotationAttributeMappingReader;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MethodAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AnnotationMethodAttributeMappingReader
extends AbstractAnnotationAttributeMappingReader {
    public AnnotationMethodAttributeMappingReader(MetamodelBootContext context) {
        super(context);
    }

    public MethodAttributeMapping readMethodAttributeMapping(ViewMapping viewMapping, Annotation mapping, String attributeName, Method method) {
        MappingInverse inverseMapping;
        UpdatableMapping updatableMapping;
        OptimisticLock optimisticLock;
        Class elementType;
        Class keyType;
        Type declaredElementType;
        Type declaredKeyType;
        Type declaredType;
        boolean isCollection;
        Class entityViewClass = viewMapping.getEntityViewClass();
        Type returnType = ReflectionUtils.resolve((Class)entityViewClass, (Type)method.getGenericReturnType());
        Class type = ReflectionUtils.resolveType((Class)entityViewClass, (Type)returnType);
        boolean forceSingular = AnnotationUtils.findAnnotation((Method)method, MappingSingular.class) != null || AnnotationUtils.findAnnotation((Method)method, MappingParameter.class) != null;
        boolean bl = isCollection = !forceSingular && (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type));
        if (isCollection) {
            Type[] typeArguments = ((ParameterizedType)returnType).getActualTypeArguments();
            declaredType = returnType;
            declaredKeyType = typeArguments.length > 1 ? typeArguments[0] : null;
            declaredElementType = typeArguments[typeArguments.length - 1];
            keyType = ReflectionUtils.resolveType((Class)entityViewClass, (Type)declaredKeyType);
            elementType = ReflectionUtils.resolveType((Class)entityViewClass, (Type)declaredElementType);
        } else {
            declaredType = returnType;
            declaredKeyType = null;
            declaredElementType = null;
            keyType = null;
            elementType = null;
        }
        Map<Class<?>, String> typeMappings = this.resolveInheritanceSubtypeMappings(method, type);
        Map<Class<?>, String> keyTypeMappings = this.resolveKeyInheritanceSubtypeMappings(method, keyType);
        Map<Class<?>, String> elementTypeMappings = this.resolveElementInheritanceSubtypeMappings(method, elementType);
        MethodAttributeMapping attributeMapping = new MethodAttributeMapping(viewMapping, mapping, this.context, attributeName, method, isCollection, type, keyType, elementType, declaredType, declaredKeyType, declaredElementType, typeMappings, keyTypeMappings, elementTypeMappings);
        if (AnnotationUtils.findAnnotation((Method)method, IdMapping.class) != null) {
            viewMapping.setIdAttributeMapping(attributeMapping);
        }
        if ((optimisticLock = (OptimisticLock)AnnotationUtils.findAnnotation((Method)method, OptimisticLock.class)) != null) {
            attributeMapping.setOptimisticLockProtected(!optimisticLock.exclude());
        }
        CollectionMapping collectionMapping = (CollectionMapping)AnnotationUtils.findAnnotation((Method)method, CollectionMapping.class);
        this.applyCollectionMapping(attributeMapping, collectionMapping);
        BatchFetch batchFetch = (BatchFetch)AnnotationUtils.findAnnotation((Method)method, BatchFetch.class);
        if (batchFetch != null) {
            attributeMapping.setDefaultBatchSize(batchFetch.size());
        }
        if ((updatableMapping = (UpdatableMapping)AnnotationUtils.findAnnotation((Method)method, UpdatableMapping.class)) != null) {
            attributeMapping.setUpdatable(updatableMapping.updatable(), updatableMapping.orphanRemoval(), updatableMapping.cascade(), updatableMapping.subtypes(), updatableMapping.persistSubtypes(), updatableMapping.updateSubtypes());
        }
        if (AnnotationUtils.findAnnotation((Method)method, AllowUpdatableEntityViews.class) != null) {
            attributeMapping.setDisallowOwnedUpdatableSubview(false);
        }
        if ((inverseMapping = (MappingInverse)AnnotationUtils.findAnnotation((Method)method, MappingInverse.class)) != null) {
            attributeMapping.setInverseRemoveStrategy(inverseMapping.removeStrategy());
            String mappedBy = inverseMapping.mappedBy();
            if (!mappedBy.isEmpty()) {
                attributeMapping.setMappedBy(mappedBy);
            }
        }
        return attributeMapping;
    }

    private Map<Class<?>, String> resolveInheritanceSubtypeMappings(Method method, Class<?> type) {
        MappingInheritance inheritance = (MappingInheritance)AnnotationUtils.findAnnotation((Method)method, MappingInheritance.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = type;
            }
            return this.resolveInheritanceSubtypeMappings(method, baseType, inheritance.value());
        }
        return this.resolveInheritanceSubtypeMappings(method, null, null);
    }

    private Map<Class<?>, String> resolveKeyInheritanceSubtypeMappings(Method method, Class<?> keyType) {
        MappingInheritanceMapKey inheritance = (MappingInheritanceMapKey)AnnotationUtils.findAnnotation((Method)method, MappingInheritanceMapKey.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = keyType;
            }
            return this.resolveInheritanceSubtypeMappings(method, baseType, inheritance.value());
        }
        return null;
    }

    private Map<Class<?>, String> resolveElementInheritanceSubtypeMappings(Method method, Class<?> elementType) {
        MappingInheritance inheritance = (MappingInheritance)AnnotationUtils.findAnnotation((Method)method, MappingInheritance.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = elementType;
            }
            return this.resolveInheritanceSubtypeMappings(method, baseType, inheritance.value());
        }
        return this.resolveInheritanceSubtypeMappings(method, null, null);
    }

    private Map<Class<?>, String> resolveInheritanceSubtypeMappings(Method method, Class<?> baseType, MappingInheritanceSubtype[] subtypes) {
        if (subtypes == null) {
            MappingInheritanceSubtype subtype = (MappingInheritanceSubtype)AnnotationUtils.findAnnotation((Method)method, MappingInheritanceSubtype.class);
            if (subtype == null) {
                return null;
            }
            subtypes = new MappingInheritanceSubtype[]{subtype};
        }
        HashMap mappings = new HashMap(subtypes.length);
        if (baseType != null) {
            mappings.put(baseType, null);
        }
        for (MappingInheritanceSubtype subtype : subtypes) {
            String mapping = subtype.mapping();
            if (mapping.isEmpty()) {
                mapping = null;
            }
            mappings.put(subtype.value(), mapping);
        }
        return mappings;
    }
}

