/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.BatchFetch;
import com.blazebit.persistence.view.CollectionMapping;
import com.blazebit.persistence.view.MappingInheritance;
import com.blazebit.persistence.view.MappingInheritanceMapKey;
import com.blazebit.persistence.view.MappingInheritanceSubtype;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.MappingSingular;
import com.blazebit.persistence.view.impl.metamodel.AbstractAnnotationAttributeMappingReader;
import com.blazebit.persistence.view.impl.metamodel.ConstructorMapping;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.ParameterAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AnnotationParameterAttributeMappingReader
extends AbstractAnnotationAttributeMappingReader {
    public AnnotationParameterAttributeMappingReader(MetamodelBootContext context) {
        super(context);
    }

    public ParameterAttributeMapping readParameterAttributeMapping(ViewMapping viewMapping, Annotation mapping, ConstructorMapping constructorMapping, int index, Annotation[] annotations) {
        Class elementType;
        Class keyType;
        Type declaredElementType;
        Type declaredKeyType;
        Type declaredType;
        boolean isCollection;
        HashMap parameterAnnotations = new HashMap(annotations.length);
        for (Annotation annotation : annotations) {
            parameterAnnotations.put(annotation.annotationType(), annotation);
        }
        Constructor<?> constructor = constructorMapping.getConstructor();
        Class entityViewClass = viewMapping.getEntityViewClass();
        Type parameterType = ReflectionUtils.resolve((Class)entityViewClass, (Type)constructor.getGenericParameterTypes()[index]);
        Class type = ReflectionUtils.resolveType((Class)entityViewClass, (Type)parameterType);
        boolean forceSingular = parameterAnnotations.containsKey(MappingSingular.class) || parameterAnnotations.containsKey(MappingParameter.class);
        boolean bl = isCollection = !forceSingular && (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type));
        if (isCollection) {
            Type[] typeArguments = ((ParameterizedType)parameterType).getActualTypeArguments();
            declaredType = parameterType;
            declaredKeyType = typeArguments.length > 1 ? typeArguments[0] : null;
            declaredElementType = typeArguments[typeArguments.length - 1];
            keyType = ReflectionUtils.resolveType((Class)entityViewClass, (Type)declaredKeyType);
            elementType = ReflectionUtils.resolveType((Class)entityViewClass, (Type)declaredElementType);
        } else {
            declaredType = parameterType;
            declaredKeyType = null;
            declaredElementType = null;
            keyType = null;
            elementType = null;
        }
        Map<Class<?>, String> typeMappings = this.resolveInheritanceSubtypeMappings(parameterAnnotations, type);
        Map<Class<?>, String> keyTypeMappings = this.resolveKeyInheritanceSubtypeMappings(parameterAnnotations, keyType);
        Map<Class<?>, String> elementTypeMappings = this.resolveElementInheritanceSubtypeMappings(parameterAnnotations, elementType);
        ParameterAttributeMapping parameterMapping = new ParameterAttributeMapping(viewMapping, mapping, this.context, constructorMapping, index, isCollection, type, keyType, elementType, declaredType, declaredKeyType, declaredElementType, typeMappings, keyTypeMappings, elementTypeMappings);
        CollectionMapping collectionMapping = (CollectionMapping)parameterAnnotations.get(CollectionMapping.class);
        this.applyCollectionMapping(parameterMapping, collectionMapping);
        BatchFetch batchFetch = (BatchFetch)parameterAnnotations.get(BatchFetch.class);
        if (batchFetch != null) {
            parameterMapping.setDefaultBatchSize(batchFetch.size());
        }
        return parameterMapping;
    }

    private Map<Class<?>, String> resolveInheritanceSubtypeMappings(Map<Class<?>, Annotation> parameterAnnotations, Class<?> type) {
        MappingInheritance inheritance = (MappingInheritance)parameterAnnotations.get(MappingInheritance.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = type;
            }
            return this.resolveInheritanceSubtypeMappings(parameterAnnotations, baseType, inheritance.value());
        }
        return this.resolveInheritanceSubtypeMappings(parameterAnnotations, null, null);
    }

    private Map<Class<?>, String> resolveKeyInheritanceSubtypeMappings(Map<Class<?>, Annotation> parameterAnnotations, Class<?> keyType) {
        MappingInheritanceMapKey inheritance = (MappingInheritanceMapKey)parameterAnnotations.get(MappingInheritanceMapKey.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = keyType;
            }
            return this.resolveInheritanceSubtypeMappings(parameterAnnotations, baseType, inheritance.value());
        }
        return null;
    }

    private Map<Class<?>, String> resolveElementInheritanceSubtypeMappings(Map<Class<?>, Annotation> parameterAnnotations, Class<?> elementType) {
        MappingInheritance inheritance = (MappingInheritance)parameterAnnotations.get(MappingInheritance.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = elementType;
            }
            return this.resolveInheritanceSubtypeMappings(parameterAnnotations, baseType, inheritance.value());
        }
        return this.resolveInheritanceSubtypeMappings(parameterAnnotations, null, null);
    }

    private Map<Class<?>, String> resolveInheritanceSubtypeMappings(Map<Class<?>, Annotation> parameterAnnotations, Class<?> baseType, MappingInheritanceSubtype[] subtypes) {
        if (subtypes == null) {
            MappingInheritanceSubtype subtype = (MappingInheritanceSubtype)parameterAnnotations.get(MappingInheritanceSubtype.class);
            if (subtype == null) {
                return null;
            }
            subtypes = new MappingInheritanceSubtype[]{subtype};
        }
        HashMap mappings = new HashMap(subtypes.length);
        if (baseType != null) {
            mappings.put(baseType, null);
        }
        for (MappingInheritanceSubtype subtype : subtypes) {
            String mapping = subtype.mapping();
            if (mapping.isEmpty()) {
                mapping = null;
            }
            mappings.put(subtype.value(), mapping);
        }
        return mappings;
    }
}

