/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConstrainedAttribute<T extends AbstractAttribute<?, ?>> {
    private final T attribute;
    private final List<Entry<T>> selectionConstrainedAttributes;
    private final Map<ManagedViewType<?>, T> subAttributes;

    public ConstrainedAttribute(String constraint, int[] subtypeIndexes, T attribute) {
        this.attribute = attribute;
        this.selectionConstrainedAttributes = new ArrayList<Entry<T>>();
        this.subAttributes = new HashMap();
        this.addSelectionConstraint(constraint, subtypeIndexes, attribute);
    }

    public T getAttribute() {
        return this.attribute;
    }

    public boolean requiresCaseWhen() {
        return this.selectionConstrainedAttributes.size() > 1;
    }

    public Collection<Entry<T>> getSelectionConstrainedAttributes() {
        return this.selectionConstrainedAttributes;
    }

    public T getSubAttribute(ManagedViewType<?> viewType) {
        AbstractAttribute attribute = (AbstractAttribute)this.subAttributes.get(((ManagedViewTypeImplementor)viewType).getRealType());
        if (attribute == null) {
            return this.attribute;
        }
        return (T)attribute;
    }

    public void addSelectionConstraint(String constraint, int[] subtypeIndexes, T attribute) {
        this.selectionConstrainedAttributes.add(new Entry<T>(constraint, subtypeIndexes, attribute));
    }

    public void addSubAttribute(ManagedViewType<?> viewType, T attribute) {
        this.subAttributes.put(((ManagedViewTypeImplementor)viewType).getRealType(), attribute);
    }

    public static class Entry<T> {
        private final String constraint;
        private final int[] subtypeIndexes;
        private final T attribute;

        public Entry(String constraint, int[] subtypeIndexes, T attribute) {
            this.constraint = constraint;
            this.subtypeIndexes = subtypeIndexes;
            this.attribute = attribute;
        }

        public String getConstraint() {
            return this.constraint;
        }

        public int getSubtypeIndex() {
            return this.subtypeIndexes[0];
        }

        public int[] getSubtypeIndexes() {
            return this.subtypeIndexes;
        }

        public T getAttribute() {
            return this.attribute;
        }
    }
}

