/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.FlatViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.metamodel.FlatViewType;
import com.blazebit.persistence.view.metamodel.Type;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;
import javax.persistence.metamodel.ManagedType;

public class FlatViewTypeImpl<X>
extends ManagedViewTypeImpl<X>
implements FlatViewTypeImplementor<X> {
    private static final Logger LOG = Logger.getLogger(FlatViewTypeImpl.class.getName());
    private final boolean supportsInterfaceEquals;

    public FlatViewTypeImpl(ViewMapping viewMapping, ManagedType<?> managedType, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        super(viewMapping, managedType, context, embeddableMapping);
        boolean supportsInterfaceEquals = true;
        for (AbstractMethodAttribute abstractMethodAttribute : this.getAttributes()) {
            Method javaMethod = abstractMethodAttribute.getJavaMethod();
            if (Modifier.isPublic(javaMethod.getModifiers()) || this.getJavaType().getPackage().getName().equals(javaMethod.getDeclaringClass().getPackage().getName())) continue;
            supportsInterfaceEquals = false;
            LOG.warning("The method for the " + abstractMethodAttribute.getLocation() + " is non-public and declared in a different package " + javaMethod.getDeclaringClass().getPackage().getName() + " than the view type " + this.getJavaType().getName() + " which makes it impossible to allow checking for equality with user provided implementations of the view type. If you don't need that, you can ignore this warning.");
        }
        this.supportsInterfaceEquals = supportsInterfaceEquals;
        context.finishViewType(this);
    }

    @Override
    public FlatViewTypeImplementor<X> getRealType() {
        return this;
    }

    @Override
    protected boolean hasId() {
        return false;
    }

    @Override
    public boolean supportsInterfaceEquals() {
        return this.supportsInterfaceEquals;
    }

    public Type.MappingType getMappingType() {
        return Type.MappingType.FLAT_VIEW;
    }

    public int hashCode() {
        return this.getJavaType().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FlatViewType && this.getJavaType().equals(((FlatViewType)obj).getJavaType());
    }
}

