/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.view.CTEProvider;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.FlushMode;
import com.blazebit.persistence.view.FlushStrategy;
import com.blazebit.persistence.view.LockMode;
import com.blazebit.persistence.view.ViewTransition;
import com.blazebit.persistence.view.impl.PrefixingQueryGenerator;
import com.blazebit.persistence.view.impl.SimpleCTEProviderFactory;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.ConstrainedAttribute;
import com.blazebit.persistence.view.impl.metamodel.ConstructorMapping;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.InheritanceViewMapping;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingConstructorImpl;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.MethodAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ParametersKey;
import com.blazebit.persistence.view.impl.metamodel.SetView;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImpl;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingConstructor;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javax.persistence.EntityManager;
import javax.persistence.PrePersist;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.BasicType;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;

public abstract class ManagedViewTypeImpl<X>
implements ManagedViewTypeImplementor<X> {
    private final Class<X> javaType;
    private final ManagedType<?> jpaManagedType;
    private final Method postCreateMethod;
    private final Method postConvertMethod;
    private final Method prePersistMethod;
    private final Method postPersistMethod;
    private final Method preUpdateMethod;
    private final Method postUpdateMethod;
    private final Method preRemoveMethod;
    private final Method postRemoveMethod;
    private final Method postRollbackMethod;
    private final Method postCommitMethod;
    private final Set<ViewTransition> postRollbackTransitions;
    private final Set<ViewTransition> postCommitTransitions;
    private final List<Method> specialMethods;
    private final boolean creatable;
    private final boolean updatable;
    private final boolean validatePersistability;
    private final LockMode lockMode;
    private final Set<String> excludedEntityAttributes;
    private final FlushMode flushMode;
    private final FlushStrategy flushStrategy;
    private final int defaultBatchSize;
    private final Map<String, AbstractMethodAttribute<? super X, ?>> attributes;
    private final NavigableMap<String, AbstractMethodAttribute<? super X, ?>> recursiveAttributes;
    private final NavigableMap<String, AbstractMethodAttribute<? super X, ?>> recursiveSubviewAttributes;
    private final Set<AbstractMethodAttribute<? super X, ?>> updateMappableAttributes;
    private final AbstractMethodAttribute<? super X, ?>[] mutableAttributes;
    private final Map<ParametersKey, MappingConstructorImpl<X>> constructors;
    private final Map<String, MappingConstructorImpl<X>> constructorIndex;
    private final String inheritanceMapping;
    private final InheritanceSubtypeConfiguration<X> defaultInheritanceSubtypeConfiguration;
    private final InheritanceSubtypeConfiguration<X> overallInheritanceSubtypeConfiguration;
    private final Map<Map<ManagedViewTypeImplementor<? extends X>, String>, InheritanceSubtypeConfiguration<X>> inheritanceSubtypeConfigurations;
    private final boolean hasJoinFetchedCollections;
    private final Set<CTEProvider> cteProviders = new LinkedHashSet<CTEProvider>();

    public ManagedViewTypeImpl(ViewMapping viewMapping, ManagedType<?> managedType, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        Set<String> mappedColumns;
        Set<String> requiredUpdatableAttributes;
        Integer batchSize;
        boolean embeddable;
        context.addManagedViewType(viewMapping, embeddableMapping, this);
        this.javaType = viewMapping.getEntityViewClass();
        this.jpaManagedType = managedType;
        this.postCreateMethod = viewMapping.getPostCreateMethod();
        this.postConvertMethod = viewMapping.getPostConvertMethod();
        this.prePersistMethod = viewMapping.getPrePersistMethod();
        this.postPersistMethod = viewMapping.getPostPersistMethod();
        this.preUpdateMethod = viewMapping.getPreUpdateMethod();
        this.postUpdateMethod = viewMapping.getPostUpdateMethod();
        this.preRemoveMethod = viewMapping.getPreRemoveMethod();
        this.postRemoveMethod = viewMapping.getPostRemoveMethod();
        this.postRollbackMethod = viewMapping.getPostRollbackMethod();
        this.postCommitMethod = viewMapping.getPostCommitMethod();
        EnumSet<ViewTransition> postRollbackTransitions = EnumSet.noneOf(ViewTransition.class);
        if (viewMapping.getPostRollbackTransitions() != null) {
            Collections.addAll(postRollbackTransitions, viewMapping.getPostRollbackTransitions());
        }
        this.postRollbackTransitions = Collections.unmodifiableSet(postRollbackTransitions);
        EnumSet<ViewTransition> postCommitTransitions = EnumSet.noneOf(ViewTransition.class);
        if (viewMapping.getPostCommitTransitions() != null) {
            Collections.addAll(postCommitTransitions, viewMapping.getPostCommitTransitions());
        }
        this.postCommitTransitions = Collections.unmodifiableSet(postCommitTransitions);
        this.specialMethods = viewMapping.getSpecialMethods();
        this.validateMethods(context);
        this.updatable = viewMapping.isUpdatable();
        this.flushMode = context.getFlushMode(this.javaType, viewMapping.getFlushMode());
        this.flushStrategy = context.getFlushStrategy(this.javaType, viewMapping.getFlushStrategy());
        this.lockMode = viewMapping.getResolvedLockMode();
        ExtendedManagedType extendedManagedType = (ExtendedManagedType)context.getEntityMetamodel().getManagedType(ExtendedManagedType.class, this.jpaManagedType);
        boolean bl = embeddable = !(this.jpaManagedType instanceof EntityType);
        if (viewMapping.isCreatable(context)) {
            this.creatable = true;
            this.validatePersistability = viewMapping.isValidatePersistability();
            this.excludedEntityAttributes = this.validatePersistability ? Collections.unmodifiableSet(new HashSet<String>(viewMapping.getExcludedAttributes())) : Collections.emptySet();
        } else if (this.updatable && embeddable) {
            this.creatable = true;
            this.validatePersistability = true;
            this.excludedEntityAttributes = Collections.emptySet();
        } else {
            this.creatable = false;
            this.validatePersistability = false;
            this.excludedEntityAttributes = Collections.emptySet();
        }
        if (!this.javaType.isInterface() && !Modifier.isAbstract(this.javaType.getModifiers())) {
            context.addError("Only interfaces or abstract classes are allowed as entity views. '" + this.javaType.getName() + "' is neither of those.");
        }
        if ((batchSize = viewMapping.getDefaultBatchSize()) == null || batchSize == -1) {
            this.defaultBatchSize = -1;
        } else if (batchSize < 1) {
            context.addError("Illegal batch fetch size defined at '" + this.javaType.getName() + "'! Use a value greater than 0 or -1!");
            this.defaultBatchSize = Integer.MIN_VALUE;
        } else {
            this.defaultBatchSize = batchSize;
        }
        TreeMap attributes = new TreeMap();
        LinkedHashSet<AbstractMethodAttribute> updateMappableAttributes = new LinkedHashSet<AbstractMethodAttribute>(attributes.size());
        ArrayList mutableAttributes = new ArrayList(attributes.size());
        boolean hasJoinFetchedCollections = false;
        int index = viewMapping.getIdAttribute() == null ? 0 : 1;
        int dirtyStateIndex = 0;
        if (this.creatable && this.validatePersistability) {
            requiredUpdatableAttributes = new HashSet();
            mappedColumns = new HashSet();
            block2: for (Map.Entry entry : extendedManagedType.getOwnedSingularAttributes().entrySet()) {
                ExtendedAttribute extendedAttribute = (ExtendedAttribute)entry.getValue();
                SingularAttribute singularAttribute = (SingularAttribute)extendedAttribute.getAttribute();
                if (singularAttribute.isVersion() || singularAttribute.isOptional() || extendedAttribute.getElementClass().isPrimitive()) continue;
                if ((singularAttribute.getType() instanceof BasicType || singularAttribute.getType() instanceof EmbeddableType) && extendedAttribute.getAttributePath().size() > 1) {
                    List attributePath = extendedAttribute.getAttributePath();
                    for (int i = attributePath.size() - 2; i >= 0; --i) {
                        SingularAttribute superAttribute = (SingularAttribute)attributePath.get(i);
                        if (!(superAttribute.getType() instanceof EntityType)) continue;
                        if (!superAttribute.isOptional()) break;
                        continue block2;
                    }
                }
                requiredUpdatableAttributes.add((String)entry.getKey());
            }
        } else {
            requiredUpdatableAttributes = Collections.emptySet();
            mappedColumns = Collections.emptySet();
        }
        for (String string : this.excludedEntityAttributes) {
            ManagedViewTypeImpl.removeRequiredUpdatableAttribute(requiredUpdatableAttributes, mappedColumns, extendedManagedType, string);
        }
        for (MethodAttributeMapping methodAttributeMapping : viewMapping.getMethodAttributes().values()) {
            AbstractMethodAttribute attribute;
            if (methodAttributeMapping.isId() || methodAttributeMapping.isVersion()) {
                if (methodAttributeMapping.isId()) {
                    attribute = methodAttributeMapping.getMethodAttribute(this, 0, -1, context, embeddableMapping);
                    --index;
                } else {
                    attribute = methodAttributeMapping.getMethodAttribute(this, index, -1, context, embeddableMapping);
                }
                if (!requiredUpdatableAttributes.isEmpty()) {
                    ManagedViewTypeImpl.removeRequiredUpdatableAttribute(requiredUpdatableAttributes, mappedColumns, extendedManagedType, attribute);
                }
            } else {
                attribute = methodAttributeMapping.getMethodAttribute(this, index, dirtyStateIndex, context, embeddableMapping);
                if (attribute.getDirtyStateIndex() != -1) {
                    mutableAttributes.add(attribute);
                    ++dirtyStateIndex;
                }
            }
            if (!requiredUpdatableAttributes.isEmpty() && attribute.isUpdatable() && attribute.getUpdateMappableAttribute() != null) {
                ManagedViewTypeImpl.removeRequiredUpdatableAttribute(requiredUpdatableAttributes, mappedColumns, extendedManagedType, attribute);
            }
            hasJoinFetchedCollections = hasJoinFetchedCollections || attribute.hasJoinFetchedCollections();
            attributes.put(methodAttributeMapping.getName(), attribute);
            ++index;
        }
        this.attributes = Collections.unmodifiableMap(attributes);
        for (AbstractMethodAttribute abstractMethodAttribute : attributes.values()) {
            if (!abstractMethodAttribute.isUpdatable() && !abstractMethodAttribute.isUpdateMappable()) continue;
            updateMappableAttributes.add(abstractMethodAttribute);
        }
        this.mutableAttributes = mutableAttributes.toArray(new AbstractMethodAttribute[mutableAttributes.size()]);
        this.updateMappableAttributes = Collections.unmodifiableSet(updateMappableAttributes);
        HashMap<Map, InheritanceSubtypeConfiguration<X>> inheritanceSubtypeConfigurations = new HashMap<Map, InheritanceSubtypeConfiguration<X>>();
        HashMap<ViewMapping, String> hashMap = new HashMap<ViewMapping, String>();
        for (InheritanceViewMapping inheritanceViewMapping : viewMapping.getInheritanceViewMappings()) {
            hashMap.putAll(inheritanceViewMapping.getInheritanceSubtypeMappings());
        }
        this.overallInheritanceSubtypeConfiguration = new InheritanceSubtypeConfiguration(this, viewMapping, -1, new InheritanceViewMapping(hashMap), context, embeddableMapping);
        this.defaultInheritanceSubtypeConfiguration = new InheritanceSubtypeConfiguration<X>(this, viewMapping, 0, viewMapping.getDefaultInheritanceViewMapping(), context, embeddableMapping, this.overallInheritanceSubtypeConfiguration);
        inheritanceSubtypeConfigurations.put(((InheritanceSubtypeConfiguration)this.defaultInheritanceSubtypeConfiguration).inheritanceSubtypeConfiguration, this.defaultInheritanceSubtypeConfiguration);
        int configurationIndex = 1;
        for (InheritanceViewMapping inheritanceViewMapping : viewMapping.getInheritanceViewMappings()) {
            if (inheritanceViewMapping == viewMapping.getDefaultInheritanceViewMapping()) continue;
            InheritanceSubtypeConfiguration<X> subtypeConfiguration = new InheritanceSubtypeConfiguration<X>(this, viewMapping, configurationIndex, inheritanceViewMapping, context, embeddableMapping, this.overallInheritanceSubtypeConfiguration);
            inheritanceSubtypeConfigurations.put(((InheritanceSubtypeConfiguration)subtypeConfiguration).inheritanceSubtypeConfiguration, subtypeConfiguration);
            ++configurationIndex;
        }
        this.inheritanceSubtypeConfigurations = Collections.unmodifiableMap(inheritanceSubtypeConfigurations);
        TreeMap treeMap = new TreeMap();
        TreeMap recursiveSubviewAttributes = new TreeMap();
        for (Map.Entry<AttributeKey, ConstrainedAttribute<AbstractMethodAttribute<X, ?>>> entry : this.defaultInheritanceSubtypeConfiguration.getAttributesClosure().entrySet()) {
            AbstractMethodAttribute<X, ?> attribute = entry.getValue().getAttribute();
            if (attribute.getKeyType() instanceof ManagedViewTypeImplementor) {
                ManagedViewTypeImplementor managedViewTypeImplementor = (ManagedViewTypeImplementor)attribute.getKeyType();
                context.onViewTypeFinished(managedViewTypeImplementor, new KeyTypeSubviewAttributeCollector(attribute, treeMap, recursiveSubviewAttributes, managedViewTypeImplementor, context));
            }
            if (attribute.getElementType() instanceof ManagedViewTypeImplementor) {
                ManagedViewTypeImplementor managedViewTypeImplementor = (ManagedViewTypeImplementor)attribute.getElementType();
                recursiveSubviewAttributes.put(attribute.getName(), attribute);
                context.onViewTypeFinished(managedViewTypeImplementor, new ElementTypeSubviewAttributeCollector(attribute, treeMap, recursiveSubviewAttributes, managedViewTypeImplementor, context));
                continue;
            }
            treeMap.put(attribute.getName(), attribute);
        }
        this.recursiveAttributes = treeMap;
        this.recursiveSubviewAttributes = recursiveSubviewAttributes;
        HashMap constructors = new HashMap();
        TreeMap constructorIndex = new TreeMap();
        for (Map.Entry entry : viewMapping.getConstructorMappings().entrySet()) {
            ConstructorMapping constructor = (ConstructorMapping)entry.getValue();
            String constructorName = constructor.getName();
            if (constructorIndex.containsKey(constructorName)) {
                constructorName = constructorName + constructorIndex.size();
            }
            MappingConstructorImpl mappingConstructor = new MappingConstructorImpl(this, constructorName, constructor, context, embeddableMapping);
            constructors.put(entry.getKey(), mappingConstructor);
            constructorIndex.put(constructorName, mappingConstructor);
        }
        this.constructors = Collections.unmodifiableMap(constructors);
        this.constructorIndex = Collections.unmodifiableMap(constructorIndex);
        this.inheritanceMapping = viewMapping.determineInheritanceMapping(context);
        this.hasJoinFetchedCollections = hasJoinFetchedCollections;
        if (viewMapping.getInheritanceSupertypes().isEmpty()) {
            if (this.inheritanceMapping != null) {
                context.addError("Entity view type '" + this.javaType.getName() + "' has a @EntityViewInheritanceMapping but is never used as subtype which is not allowed!");
            }
        } else if (this.inheritanceMapping == null || this.inheritanceMapping.isEmpty()) {
            ArrayList<Class> classes = new ArrayList<Class>();
            for (ViewMapping mapping : viewMapping.getInheritanceSupertypes()) {
                classes.add(mapping.getEntityViewClass());
            }
            context.addError("Entity view type '" + this.javaType.getName() + "' has no @EntityViewInheritanceMapping but is used as inheritance subtype in: " + classes);
        }
        if (!requiredUpdatableAttributes.isEmpty()) {
            this.removeIfSetByDefault(extendedManagedType, requiredUpdatableAttributes);
            Iterator<String> iterator = requiredUpdatableAttributes.iterator();
            while (iterator.hasNext()) {
                ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedManagedType.getAttributes().get(iterator.next());
                if (extendedAttribute != null && !mappedColumns.containsAll(Arrays.asList(extendedAttribute.getColumnNames()))) continue;
                iterator.remove();
            }
            if (!requiredUpdatableAttributes.isEmpty()) {
                if (this.jpaManagedType instanceof IdentifiableType && ((IdentifiableType)this.jpaManagedType).hasVersionAttribute()) {
                    iterator = requiredUpdatableAttributes.iterator();
                    while (iterator.hasNext()) {
                        ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedManagedType.getAttributes().get(iterator.next());
                        try {
                            SingularAttribute version = ((IdentifiableType)this.jpaManagedType).getVersion(extendedAttribute.getElementClass());
                            if (!extendedAttribute.getAttributePathString().equals(version.getName())) continue;
                            iterator.remove();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
                if (!requiredUpdatableAttributes.isEmpty()) {
                    context.addError("Entity view type '" + this.javaType.getName() + "' might not be persistable because it is missing updatable attribute definitions for non-optional entity attributes: " + requiredUpdatableAttributes + ". Add attributes, disable validation or exclude attributes if you know values are set via the entity constructor!");
                }
            }
        }
        context.onViewTypeFinished(this, new CTEProviderCollector(this, context, viewMapping));
    }

    private void removeIfSetByDefault(ExtendedManagedType<?> extendedManagedType, Set<String> requiredUpdatableAttributes) {
        try {
            HashMap<String, String> fieldNameToAttribute = new HashMap<String, String>(requiredUpdatableAttributes.size());
            HashMap<String, String> setterNameToAttribute = new HashMap<String, String>(requiredUpdatableAttributes.size());
            HashMap<String, String> fields = new HashMap<String, String>(requiredUpdatableAttributes.size());
            HashMap<String, String> setters = new HashMap<String, String>(requiredUpdatableAttributes.size());
            HashMap<String, String> getters = new HashMap<String, String>(requiredUpdatableAttributes.size());
            Class javaType = this.jpaManagedType.getJavaType();
            ClassPool pool = new ClassPool(true);
            pool.appendClassPath((ClassPath)new LoaderClassPath(javaType.getClassLoader()));
            CtClass ctClass = pool.get(javaType.getName());
            for (String attribute : requiredUpdatableAttributes) {
                Method setter;
                ExtendedAttribute extendedAttribute = extendedManagedType.getAttribute(attribute);
                Attribute attr = (Attribute)extendedAttribute.getAttributePath().get(0);
                Class type = JpaMetamodelUtils.resolveFieldClass((Class)this.jpaManagedType.getJavaType(), (Attribute)attr);
                Member javaMember = attr.getJavaMember();
                if (javaMember instanceof Method) {
                    String fieldName;
                    Method getter = null;
                    String suffix = null;
                    if (javaMember.getName().startsWith("get")) {
                        getter = ReflectionUtils.getMethod((Class)javaType, (String)javaMember.getName(), (Class[])new Class[0]);
                        suffix = javaMember.getName().substring(3);
                    } else if (javaMember.getName().startsWith("is")) {
                        getter = ReflectionUtils.getMethod((Class)javaType, (String)javaMember.getName(), (Class[])new Class[0]);
                        suffix = javaMember.getName().substring(2);
                    } else if (javaMember.getName().startsWith("set")) {
                        suffix = javaMember.getName().substring(3);
                        getter = ReflectionUtils.getMethod((Class)javaType, (String)("get" + suffix), (Class[])new Class[0]);
                        if (getter == null && ((Method)javaMember).getParameterTypes().length == 1 && ((Method)javaMember).getParameterTypes()[0] == Boolean.TYPE) {
                            getter = ReflectionUtils.getMethod((Class)javaType, (String)("is" + suffix), (Class[])new Class[0]);
                        }
                    }
                    Method method = setter = suffix != null ? ReflectionUtils.getMethod((Class)javaType, (String)("set" + suffix), (Class[])new Class[]{type}) : null;
                    if (getter != null && (fieldName = ManagedViewTypeImpl.getSimpleGetterFieldName(ManagedViewTypeImpl.findMethod(ctClass, getter.getName()))) != null) {
                        if (setter == null) {
                            getters.put(attribute, getter.getName());
                            fields.put(attribute, fieldName);
                            fieldNameToAttribute.put(fieldName, attribute);
                            continue;
                        }
                        if (!fieldName.equals(ManagedViewTypeImpl.getSimpleSetterFieldName(ManagedViewTypeImpl.findMethod(ctClass, setter.getName())))) continue;
                        getters.put(attribute, getter.getName());
                        setters.put(attribute, setter.getName());
                        setterNameToAttribute.put(attribute, setter.getName());
                        fields.put(attribute, fieldName);
                        fieldNameToAttribute.put(fieldName, attribute);
                        continue;
                    }
                    if (setter == null || (fieldName = ManagedViewTypeImpl.getSimpleSetterFieldName(ManagedViewTypeImpl.findMethod(ctClass, setter.getName()))) == null) continue;
                    setters.put(attribute, setter.getName());
                    setterNameToAttribute.put(attribute, setter.getName());
                    fields.put(attribute, fieldName);
                    fieldNameToAttribute.put(fieldName, attribute);
                    continue;
                }
                fields.put(attribute, javaMember.getName());
                fieldNameToAttribute.put(javaMember.getName(), attribute);
                String suffix = Character.toUpperCase(javaMember.getName().charAt(0)) + javaMember.getName().substring(1);
                Method getter = ReflectionUtils.getMethod((Class)javaType, (String)("get" + suffix), (Class[])new Class[0]);
                if (getter == null && ((Field)javaMember).getType() == Boolean.TYPE) {
                    getter = ReflectionUtils.getMethod((Class)javaType, (String)("is" + suffix), (Class[])new Class[0]);
                }
                setter = ReflectionUtils.getMethod((Class)javaType, (String)("set" + suffix), (Class[])new Class[]{type});
                if (getter != null && javaMember.getName().equals(ManagedViewTypeImpl.getSimpleGetterFieldName(ManagedViewTypeImpl.findMethod(ctClass, getter.getName())))) {
                    if (setter == null) {
                        getters.put(attribute, getter.getName());
                    } else if (javaMember.getName().equals(ManagedViewTypeImpl.getSimpleSetterFieldName(ManagedViewTypeImpl.findMethod(ctClass, setter.getName())))) {
                        getters.put(attribute, getter.getName());
                        setters.put(attribute, setter.getName());
                        setterNameToAttribute.put(attribute, setter.getName());
                    }
                }
                if (setter == null || !javaMember.getName().equals(ManagedViewTypeImpl.getSimpleSetterFieldName(ManagedViewTypeImpl.findMethod(ctClass, setter.getName())))) continue;
                setters.put(attribute, setter.getName());
                setterNameToAttribute.put(attribute, setter.getName());
            }
            CtClass c = ctClass;
            CtClass[] constructorParams = new CtClass[]{};
            ArrayList<CtClass> superClasses = new ArrayList<CtClass>(2);
            superClasses.add(c);
            while (c.getSuperclass() != null) {
                c = c.getSuperclass();
                superClasses.add(c);
            }
            c = ctClass;
            do {
                CtConstructor entityConstructor = c.getDeclaredConstructor(constructorParams);
                while (!entityConstructor.callsSuper() && entityConstructor.getDeclaringClass().getSuperclass() != null) {
                    entityConstructor = c.getDeclaredConstructor(ManagedViewTypeImpl.findCalledConstructor((CtBehavior)entityConstructor));
                }
                constructorParams = ManagedViewTypeImpl.removeAssignedAttributes(superClasses, (CtBehavior)entityConstructor, fieldNameToAttribute, setterNameToAttribute, requiredUpdatableAttributes);
                if (requiredUpdatableAttributes.isEmpty()) continue;
                for (CtMethod declaredMethod : c.getDeclaredMethods()) {
                    if (!declaredMethod.hasAnnotation(PrePersist.class)) continue;
                    ManagedViewTypeImpl.removeAssignedAttributes(superClasses, (CtBehavior)declaredMethod, fieldNameToAttribute, setterNameToAttribute, requiredUpdatableAttributes);
                }
            } while (!requiredUpdatableAttributes.isEmpty() && (c = c.getSuperclass()) != null);
        }
        catch (Exception ex) {
            Logger.getLogger(ManagedViewTypeImpl.class.getName()).log(Level.WARNING, "Bytecode analysis failed. Please report this issue!", ex);
        }
    }

    private static CtMethod findMethod(CtClass ctClass, String methodName) {
        try {
            return ctClass.getDeclaredMethod(methodName);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private static String getSimpleGetterFieldName(CtMethod method) throws Exception {
        if (method == null) {
            return null;
        }
        String fieldName = null;
        CodeIterator ci = method.getMethodInfo().getCodeAttribute().iterator();
        block4: while (ci.hasNext()) {
            int index = ci.next();
            int op = ci.byteAt(index);
            switch (op) {
                case 180: {
                    ConstPool cp = method.getMethodInfo().getConstPool();
                    int cpIndex = ci.u16bitAt(index + 1);
                    if (cp.getFieldrefClass(ci.u16bitAt(index + 1)) != cp.getThisClassInfo()) break;
                    fieldName = cp.getFieldrefName(cpIndex);
                }
                case 25: 
                case 42: 
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 192: {
                    continue block4;
                }
            }
            return null;
        }
        return fieldName;
    }

    private static String getSimpleSetterFieldName(CtMethod method) throws Exception {
        if (method == null) {
            return null;
        }
        String fieldName = null;
        CodeIterator ci = method.getMethodInfo().getCodeAttribute().iterator();
        block4: while (ci.hasNext()) {
            int index = ci.next();
            int op = ci.byteAt(index);
            switch (op) {
                case 181: {
                    ConstPool cp = method.getMethodInfo().getConstPool();
                    int cpIndex = ci.u16bitAt(index + 1);
                    if (cp.getFieldrefClass(cpIndex) != cp.getThisClassInfo()) break;
                    fieldName = cp.getFieldrefName(cpIndex);
                }
                case 25: 
                case 27: 
                case 31: 
                case 35: 
                case 39: 
                case 42: 
                case 43: 
                case 169: 
                case 177: 
                case 192: {
                    continue block4;
                }
            }
            return null;
        }
        return fieldName;
    }

    private static CtClass[] removeAssignedAttributes(List<CtClass> superClasses, CtBehavior method, Map<String, String> fieldNameToAttribute, Map<String, String> setterNameToAttribute, Set<String> requiredUpdatableAttributes) throws Exception {
        CtClass[] params = new CtClass[]{};
        ConstPool cp = method.getMethodInfo().getConstPool();
        CodeIterator ci = method.getMethodInfo().getCodeAttribute().iterator();
        block6: while (ci.hasNext()) {
            String attributeName;
            boolean isInterfaceMethod;
            String methodName;
            String methodClassName;
            int index = ci.next();
            int op = ci.byteAt(index);
            switch (op) {
                case 181: {
                    String attribute;
                    int cpIndex = ci.u16bitAt(index + 1);
                    if (cp.getFieldrefClass(cpIndex) != cp.getThisClassInfo()) {
                        String fieldrefClassName = cp.getFieldrefClassName(cpIndex);
                        boolean fromSuper = false;
                        for (CtClass ctClass : superClasses) {
                            if (!fieldrefClassName.equals(ctClass.getName())) continue;
                            fromSuper = true;
                            break;
                        }
                        if (!fromSuper) continue block6;
                    }
                    if ((attribute = fieldNameToAttribute.get(cp.getFieldrefName(cpIndex))) == null) continue block6;
                    requiredUpdatableAttributes.remove(attribute);
                    if (!requiredUpdatableAttributes.isEmpty()) continue block6;
                    return null;
                }
                case 185: {
                    int methodCpIdx = ci.u16bitAt(index + 1);
                    methodClassName = cp.getInterfaceMethodrefClassName(methodCpIdx);
                    methodName = cp.getInterfaceMethodrefName(methodCpIdx);
                    isInterfaceMethod = true;
                    break;
                }
                case 182: {
                    int methodCpIdx = ci.u16bitAt(index + 1);
                    methodClassName = cp.getMethodrefClassName(methodCpIdx);
                    methodName = cp.getMethodrefName(methodCpIdx);
                    isInterfaceMethod = false;
                    break;
                }
                case 183: {
                    int methodCpIdx = ci.u16bitAt(index + 1);
                    methodClassName = cp.getMethodrefClassName(methodCpIdx);
                    methodName = cp.getMethodrefName(methodCpIdx);
                    isInterfaceMethod = false;
                    if (!"<init>".equals(methodName)) break;
                    if (!method.getDeclaringClass().getSuperclass().getName().equals(methodClassName)) continue block6;
                    params = Descriptor.getParameterTypes((String)cp.getMethodrefType(methodCpIdx), (ClassPool)method.getDeclaringClass().getClassPool());
                    continue block6;
                }
                default: {
                    continue block6;
                }
            }
            if ((attributeName = setterNameToAttribute.get(methodName)) == null) continue;
            boolean fromSuper = false;
            for (CtClass ctClass : superClasses) {
                if (!methodClassName.equals(ctClass.getName())) continue;
                fromSuper = true;
                break;
            }
            if (fromSuper) {
                requiredUpdatableAttributes.remove(attributeName);
                if (!requiredUpdatableAttributes.isEmpty()) continue;
                return null;
            }
            if (!isInterfaceMethod) continue;
            ArrayList<CtClass> interfaces = new ArrayList<CtClass>(superClasses);
            while (!interfaces.isEmpty()) {
                CtClass ctClass;
                ctClass = (CtClass)interfaces.remove(interfaces.size() - 1);
                if (methodClassName.equals(ctClass.getName())) {
                    fromSuper = true;
                    break;
                }
                for (CtClass ctClassInterface : ctClass.getInterfaces()) {
                    interfaces.add(ctClassInterface);
                }
            }
            if (!fromSuper) continue;
            requiredUpdatableAttributes.remove(attributeName);
            if (!requiredUpdatableAttributes.isEmpty()) continue;
            return null;
        }
        return params;
    }

    private static CtClass[] findCalledConstructor(CtBehavior method) throws Exception {
        ConstPool cp = method.getMethodInfo().getConstPool();
        CodeIterator ci = method.getMethodInfo().getCodeAttribute().iterator();
        while (ci.hasNext()) {
            int methodCpIdx;
            int index = ci.next();
            if (ci.byteAt(index) != 183 || cp.getMethodrefClass(methodCpIdx = ci.u16bitAt(index + 1)) != cp.getThisClassInfo() || !"<init>".equals(cp.getMethodrefName(methodCpIdx))) continue;
            return Descriptor.getParameterTypes((String)cp.getMethodrefType(methodCpIdx), (ClassPool)method.getDeclaringClass().getClassPool());
        }
        return new CtClass[0];
    }

    private static void removeRequiredUpdatableAttribute(Set<String> requiredUpdatableAttributes, Set<String> mappedColumns, ExtendedManagedType<?> extendedManagedType, AbstractMethodAttribute<?, ?> attribute) {
        ManagedViewTypeImpl.removeRequiredUpdatableAttribute(requiredUpdatableAttributes, mappedColumns, extendedManagedType, attribute.getMapping());
    }

    private static void removeRequiredUpdatableAttribute(Set<String> requiredUpdatableAttributes, Set<String> mappedColumns, ExtendedManagedType<?> extendedManagedType, String mapping) {
        requiredUpdatableAttributes.remove(mapping);
        ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedManagedType.getAttributes().get(mapping);
        if (!requiredUpdatableAttributes.isEmpty() && extendedAttribute != null) {
            SingularAttribute singularAttribute;
            mappedColumns.addAll(Arrays.asList(extendedAttribute.getColumnNames()));
            for (ExtendedAttribute columnEquivalentAttribute : extendedAttribute.getColumnEquivalentAttributes()) {
                requiredUpdatableAttributes.remove(columnEquivalentAttribute.getAttributePathString());
                if (!requiredUpdatableAttributes.isEmpty()) continue;
                return;
            }
            if (extendedAttribute.getAttribute() instanceof SingularAttribute && (singularAttribute = (SingularAttribute)extendedAttribute.getAttribute()).getType() instanceof EmbeddableType) {
                for (String embeddedPropertyName : JpaMetamodelUtils.getEmbeddedPropertyNames((EmbeddableType)((EmbeddableType)singularAttribute.getType()))) {
                    ManagedViewTypeImpl.removeRequiredUpdatableAttribute(requiredUpdatableAttributes, mappedColumns, extendedManagedType, mapping + "." + embeddedPropertyName);
                }
            }
        }
    }

    private void validateMethods(MetamodelBuildingContext context) {
        Class<?>[] parameterTypes;
        Set<Class<?>> superTypes = null;
        List<Class<Class<?>>> allowedParameterTypes = null;
        List<Class> managerTypes = Arrays.asList(EntityViewManager.class, EntityManager.class);
        if (this.postCreateMethod != null) {
            parameterTypes = this.postCreateMethod.getParameterTypes();
            if (!Void.TYPE.equals(this.postCreateMethod.getReturnType()) || parameterTypes.length > 1 || parameterTypes.length == 1 && !EntityViewManager.class.equals(parameterTypes[0])) {
                context.addError("Invalid signature for post create method at '" + this.javaType.getName() + "." + this.postCreateMethod.getName() + "'! A method annotated with @PostCreate must return void and accept no or a single EntityViewManager argument!");
            }
        }
        if (this.postConvertMethod != null) {
            parameterTypes = this.postConvertMethod.getParameterTypes();
            if (!Void.TYPE.equals(this.postConvertMethod.getReturnType()) || parameterTypes.length > 2 || !Arrays.asList(EntityViewManager.class, Object.class).containsAll(Arrays.asList(parameterTypes))) {
                context.addError("Invalid signature for post convert method at '" + this.javaType.getName() + "." + this.postConvertMethod.getName() + "'! A method annotated with @PostConvert must return void and accept at most 2 arguments, an EntityViewManager and the source entity view argument of type Object!");
            }
        }
        if (this.prePersistMethod != null) {
            superTypes = this.jpaManagedSuperTypes(superTypes);
            allowedParameterTypes = this.allowedParameterTypes(allowedParameterTypes, superTypes);
            parameterTypes = this.prePersistMethod.getParameterTypes();
            if (!Void.TYPE.equals(this.prePersistMethod.getReturnType()) || parameterTypes.length > 3 || !allowedParameterTypes.containsAll(Arrays.asList(parameterTypes))) {
                context.addError("Invalid signature for pre persist method at '" + this.javaType.getName() + "." + this.prePersistMethod.getName() + "'! A method annotated with @PrePersist must return void and accept at most 3 arguments, an EntityViewManager, an EntityManager and one of the compatible entity types: " + superTypes);
            }
        }
        if (this.postPersistMethod != null) {
            superTypes = this.jpaManagedSuperTypes(superTypes);
            allowedParameterTypes = this.allowedParameterTypes(allowedParameterTypes, superTypes);
            parameterTypes = this.postPersistMethod.getParameterTypes();
            if (!Void.TYPE.equals(this.postPersistMethod.getReturnType()) || parameterTypes.length > 3 || !allowedParameterTypes.containsAll(Arrays.asList(parameterTypes))) {
                context.addError("Invalid signature for post persist method at '" + this.javaType.getName() + "." + this.postPersistMethod.getName() + "'! A method annotated with @PostPersist must return void and accept at most 3 arguments, an EntityViewManager, an EntityManager and one of the compatible entity types: " + superTypes);
            }
        }
        if (this.preUpdateMethod != null) {
            parameterTypes = this.preUpdateMethod.getParameterTypes();
            if (!Void.TYPE.equals(this.preUpdateMethod.getReturnType()) || parameterTypes.length > 2 || !managerTypes.containsAll(Arrays.asList(parameterTypes))) {
                context.addError("Invalid signature for pre update method at '" + this.javaType.getName() + "." + this.preUpdateMethod.getName() + "'! A method annotated with @PreUpdate must return void and accept at most 2 arguments, an EntityViewManager and an EntityManager!");
            }
        }
        if (this.postUpdateMethod != null) {
            parameterTypes = this.postUpdateMethod.getParameterTypes();
            if (!Void.TYPE.equals(this.postUpdateMethod.getReturnType()) || parameterTypes.length > 2 || !managerTypes.containsAll(Arrays.asList(parameterTypes))) {
                context.addError("Invalid signature for post update method at '" + this.javaType.getName() + "." + this.postUpdateMethod.getName() + "'! A method annotated with @PostUpdate must return void and accept at most 2 arguments, an EntityViewManager and an EntityManager!");
            }
        }
        if (this.preRemoveMethod != null) {
            parameterTypes = this.preRemoveMethod.getParameterTypes();
            if (!Void.TYPE.equals(this.preRemoveMethod.getReturnType()) && !Boolean.TYPE.equals(this.preRemoveMethod.getReturnType()) || parameterTypes.length > 2 || !managerTypes.containsAll(Arrays.asList(parameterTypes))) {
                context.addError("Invalid signature for pre remove method at '" + this.javaType.getName() + "." + this.preRemoveMethod.getName() + "'! A method annotated with @PreRemove must return void or boolean and accept at most 2 arguments, an EntityViewManager and an EntityManager!");
            }
        }
        if (this.postRemoveMethod != null) {
            parameterTypes = this.postRemoveMethod.getParameterTypes();
            if (!Void.TYPE.equals(this.postRemoveMethod.getReturnType()) || parameterTypes.length > 2 || !managerTypes.containsAll(Arrays.asList(parameterTypes))) {
                context.addError("Invalid signature for post remove method at '" + this.javaType.getName() + "." + this.postRemoveMethod.getName() + "'! A method annotated with @PostRemove must return void and accept at most 2 arguments, an EntityViewManager and an EntityManager!");
            }
        }
        if (this.postCommitMethod != null) {
            parameterTypes = this.postCommitMethod.getParameterTypes();
            if (!Void.TYPE.equals(this.postCommitMethod.getReturnType()) || parameterTypes.length > 2 || !managerTypes.containsAll(Arrays.asList(parameterTypes))) {
                context.addError("Invalid signature for post commit method at '" + this.javaType.getName() + "." + this.postCommitMethod.getName() + "'! A method annotated with @PostCommit must return void and accept at most 2 arguments, an EntityViewManager and an EntityManager!");
            }
        }
        if (this.postRollbackMethod != null) {
            parameterTypes = this.postRollbackMethod.getParameterTypes();
            if (!Void.TYPE.equals(this.postRollbackMethod.getReturnType()) || parameterTypes.length > 2 || !managerTypes.containsAll(Arrays.asList(parameterTypes))) {
                context.addError("Invalid signature for post rollback method at '" + this.javaType.getName() + "." + this.postRollbackMethod.getName() + "'! A method annotated with @PostRollback must return void and accept at most 2 arguments, an EntityViewManager and an EntityManager!");
            }
        }
    }

    private Set<Class<?>> jpaManagedSuperTypes(Set<Class<?>> superTypes) {
        if (superTypes == null) {
            superTypes = ReflectionUtils.getSuperTypes((Class)this.jpaManagedType.getJavaType());
        }
        return superTypes;
    }

    private List<Class<?>> allowedParameterTypes(List<Class<?>> allowedParameterTypes, Set<Class<?>> superTypes) {
        if (allowedParameterTypes == null) {
            allowedParameterTypes = new ArrayList(superTypes.size() + 2);
            allowedParameterTypes.add(EntityViewManager.class);
            allowedParameterTypes.add(EntityManager.class);
            allowedParameterTypes.addAll(superTypes);
        }
        return allowedParameterTypes;
    }

    @Override
    public void checkAttributes(MetamodelBuildingContext context) {
        HashMap<String, List<String>> collectionMappings = new HashMap<String, List<String>>();
        HashMap<String, List<String>> collectionMappingSingulars = new HashMap<String, List<String>>();
        for (AbstractMethodAttribute<X, ?> abstractMethodAttribute : this.attributes.values()) {
            abstractMethodAttribute.checkAttribute(this.jpaManagedType, context);
            for (Map.Entry<String, Boolean> entry : abstractMethodAttribute.getCollectionJoinMappings(this.jpaManagedType, context).entrySet()) {
                List<String> locations;
                if (entry.getValue().booleanValue()) {
                    locations = (ArrayList<String>)collectionMappingSingulars.get(entry.getKey());
                    if (locations == null) {
                        locations = new ArrayList<String>(2);
                        collectionMappingSingulars.put(entry.getKey(), locations);
                    }
                    locations.add("Attribute '" + abstractMethodAttribute.getName() + "' in entity view '" + this.javaType.getName() + "'");
                    continue;
                }
                locations = (List)collectionMappings.get(entry.getKey());
                if (locations == null) {
                    locations = new ArrayList(2);
                    collectionMappings.put(entry.getKey(), locations);
                }
                locations.add("Attribute '" + abstractMethodAttribute.getName() + "' in entity view '" + this.javaType.getName() + "'");
            }
        }
        if (!this.constructorIndex.isEmpty()) {
            for (MappingConstructorImpl mappingConstructorImpl : this.constructorIndex.values()) {
                HashMap<String, List<String>> constructorCollectionMappings = new HashMap<String, List<String>>();
                for (Map.Entry entry : collectionMappings.entrySet()) {
                    constructorCollectionMappings.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
                }
                mappingConstructorImpl.checkParameters(this.jpaManagedType, constructorCollectionMappings, collectionMappingSingulars, context);
                ManagedViewTypeImpl.reportCollectionMappingErrors(context, collectionMappings, collectionMappingSingulars);
            }
        } else {
            ManagedViewTypeImpl.reportCollectionMappingErrors(context, collectionMappings, collectionMappingSingulars);
        }
    }

    private static void reportCollectionMappingErrors(MetamodelBuildingContext context, Map<String, List<String>> collectionMappings, Map<String, List<String>> collectionMappingSingulars) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> locationsEntry : collectionMappings.entrySet()) {
            List<String> locations = locationsEntry.getValue();
            List<String> singularLocations = null;
            if (locations.size() <= 1 && (singularLocations = collectionMappingSingulars.get(locationsEntry.getKey())) == null) continue;
            sb.setLength(0);
            sb.append("Invalid multiple JOIN fetch usages of the plural mapping '" + locationsEntry.getKey() + "'. Consider mapping the plural attribute only once as a subview or use a different fetch strategy. Problematic uses");
            for (String location : locations) {
                sb.append("\n - ");
                sb.append(location);
            }
            if (singularLocations != null) {
                for (String location : singularLocations) {
                    sb.append("\n - ");
                    sb.append(location);
                }
            }
            context.addError(sb.toString());
        }
    }

    @Override
    public void checkNestedAttributes(List<AbstractAttribute<?, ?>> parents, MetamodelBuildingContext context) {
        for (AbstractMethodAttribute<X, ?> abstractMethodAttribute : this.attributes.values()) {
            abstractMethodAttribute.checkNestedAttribute(parents, this.jpaManagedType, context);
        }
        if (!this.constructorIndex.isEmpty()) {
            for (MappingConstructorImpl mappingConstructorImpl : this.constructorIndex.values()) {
                mappingConstructorImpl.checkNestedParameters(parents, this.jpaManagedType, context);
            }
        }
    }

    protected abstract boolean hasId();

    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public LockMode getLockMode() {
        return this.lockMode;
    }

    public boolean isCreatable() {
        return this.creatable;
    }

    public Method getPostCreateMethod() {
        return this.postCreateMethod;
    }

    public Method getPostConvertMethod() {
        return this.postConvertMethod;
    }

    public Method getPrePersistMethod() {
        return this.prePersistMethod;
    }

    public Method getPostPersistMethod() {
        return this.postPersistMethod;
    }

    public Method getPreUpdateMethod() {
        return this.preUpdateMethod;
    }

    public Method getPostUpdateMethod() {
        return this.postUpdateMethod;
    }

    public Method getPreRemoveMethod() {
        return this.preRemoveMethod;
    }

    public Method getPostRemoveMethod() {
        return this.postRemoveMethod;
    }

    public Method getPostRollbackMethod() {
        return this.postRollbackMethod;
    }

    public Method getPostCommitMethod() {
        return this.postCommitMethod;
    }

    public Set<ViewTransition> getPostRollbackTransitions() {
        return this.postRollbackTransitions;
    }

    public Set<ViewTransition> getPostCommitTransitions() {
        return this.postCommitTransitions;
    }

    @Override
    public List<Method> getSpecialMethods() {
        return this.specialMethods;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    public FlushStrategy getFlushStrategy() {
        return this.flushStrategy;
    }

    public boolean isPersistabilityValidationEnabled() {
        return this.validatePersistability;
    }

    public Set<String> getPersistabilityValidationExcludedEntityAttributes() {
        return this.excludedEntityAttributes;
    }

    public Class<X> getJavaType() {
        return this.javaType;
    }

    public Type getConvertedType() {
        return null;
    }

    public TypeConverter<?, X> getConverter() {
        return null;
    }

    public Class<?> getEntityClass() {
        return this.jpaManagedType.getJavaType();
    }

    @Override
    public ManagedType<?> getJpaManagedType() {
        return this.jpaManagedType;
    }

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public Set<MethodAttribute<? super X, ?>> getAttributes() {
        return new SetView(this.attributes.values());
    }

    @Override
    public Set<AbstractMethodAttribute<? super X, ?>> getUpdateMappableAttributes() {
        return this.updateMappableAttributes;
    }

    public MethodAttribute<? super X, ?> getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Set<MappingConstructor<X>> getConstructors() {
        return new SetView<MappingConstructor<X>>(this.constructorIndex.values());
    }

    public MappingConstructor<X> getConstructor(Class<?> ... parameterTypes) {
        return this.constructors.get(new ParametersKey(parameterTypes));
    }

    public Set<String> getConstructorNames() {
        return this.constructorIndex.keySet();
    }

    public MappingConstructorImpl<X> getConstructor(String name) {
        if (name == null) {
            return null;
        }
        return this.constructorIndex.get(name);
    }

    @Override
    public NavigableMap<String, AbstractMethodAttribute<? super X, ?>> getRecursiveAttributes() {
        return this.recursiveAttributes;
    }

    @Override
    public NavigableMap<String, AbstractMethodAttribute<? super X, ?>> getRecursiveSubviewAttributes() {
        return this.recursiveSubviewAttributes;
    }

    public String getInheritanceMapping() {
        return this.inheritanceMapping;
    }

    public Set<ManagedViewType<? extends X>> getInheritanceSubtypes() {
        return ((InheritanceSubtypeConfiguration)this.defaultInheritanceSubtypeConfiguration).inheritanceSubtypes;
    }

    @Override
    public Map<ManagedViewTypeImplementor<? extends X>, String> getInheritanceSubtypeConfiguration() {
        return ((InheritanceSubtypeConfiguration)this.defaultInheritanceSubtypeConfiguration).inheritanceSubtypeConfiguration;
    }

    @Override
    public boolean hasEmptyConstructor() {
        if (this.javaType.isInterface() || this.constructors.isEmpty()) {
            return true;
        }
        for (MappingConstructorImpl<X> c : this.constructors.values()) {
            if (!c.getParameterAttributes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasJoinFetchedCollections() {
        return this.hasJoinFetchedCollections;
    }

    @Override
    public boolean hasSubtypes() {
        return ((InheritanceSubtypeConfiguration)this.defaultInheritanceSubtypeConfiguration).inheritanceSubtypes.size() > 1 || !((InheritanceSubtypeConfiguration)this.defaultInheritanceSubtypeConfiguration).inheritanceSubtypes.contains(this);
    }

    @Override
    public int getSubtypeIndex(ManagedViewTypeImplementor<? super X> inheritanceBase) {
        ManagedViewType subtype;
        int subtypeIndex = 0;
        Iterator<ManagedViewTypeImplementor<X>> iterator = inheritanceBase.getOverallInheritanceSubtypeConfiguration().getInheritanceSubtypes().iterator();
        while (iterator.hasNext() && (subtype = (ManagedViewType)iterator.next()) != this) {
            ++subtypeIndex;
        }
        return subtypeIndex;
    }

    @Override
    public InheritanceSubtypeConfiguration<X> getInheritanceSubtypeConfiguration(Map<ManagedViewTypeImplementor<? extends X>, String> inheritanceSubtypeMapping) {
        if (inheritanceSubtypeMapping == null || inheritanceSubtypeMapping.isEmpty() || this.defaultInheritanceSubtypeConfiguration.getInheritanceSubtypeConfiguration() == inheritanceSubtypeMapping) {
            return this.defaultInheritanceSubtypeConfiguration;
        }
        return this.inheritanceSubtypeConfigurations.get(inheritanceSubtypeMapping);
    }

    @Override
    public InheritanceSubtypeConfiguration<X> getOverallInheritanceSubtypeConfiguration() {
        return this.overallInheritanceSubtypeConfiguration;
    }

    @Override
    public InheritanceSubtypeConfiguration<X> getDefaultInheritanceSubtypeConfiguration() {
        return this.defaultInheritanceSubtypeConfiguration;
    }

    @Override
    public Map<Map<ManagedViewTypeImplementor<? extends X>, String>, InheritanceSubtypeConfiguration<X>> getInheritanceSubtypeConfigurations() {
        return this.inheritanceSubtypeConfigurations;
    }

    @Override
    public AbstractMethodAttribute<?, ?> getMutableAttribute(int i) {
        return this.mutableAttributes[i];
    }

    @Override
    public int getMutableAttributeCount() {
        return this.mutableAttributes.length;
    }

    public String getTypeConstraintMapping() {
        if (this.jpaManagedType instanceof EntityType) {
            return "TYPE(this) = " + ((EntityType)this.jpaManagedType).getName();
        }
        return null;
    }

    public Set<CTEProvider> getCteProviders() {
        return this.cteProviders;
    }

    public static class InheritanceSubtypeConfiguration<X> {
        private final ManagedViewTypeImpl<X> baseType;
        private final int configurationIndex;
        private final Map<ManagedViewTypeImplementor<? extends X>, String> inheritanceSubtypeConfiguration;
        private final Set<ManagedViewTypeImplementor<? extends X>> inheritanceSubtypes;
        private final String inheritanceDiscriminatorMapping;
        private final Map<AttributeKey, ConstrainedAttribute<AbstractMethodAttribute<? super X, ?>>> attributesClosure;
        private final Map<ManagedViewTypeImplementor<? extends X>, int[]> overallPositionAssignments;

        public InheritanceSubtypeConfiguration(ManagedViewTypeImpl<X> baseType, ViewMapping baseTypeViewMapping, int configurationIndex, InheritanceViewMapping inheritanceViewMapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
            this(baseType, baseTypeViewMapping, configurationIndex, inheritanceViewMapping, context, embeddableMapping, null);
        }

        public InheritanceSubtypeConfiguration(ManagedViewTypeImpl<X> baseType, ViewMapping baseTypeViewMapping, int configurationIndex, InheritanceViewMapping inheritanceViewMapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping, InheritanceSubtypeConfiguration<X> overallConfiguration) {
            this.baseType = baseType;
            this.configurationIndex = configurationIndex;
            ManagedViewTypeImpl<X>[] orderedInheritanceSubtypes = this.createOrderedSubtypes(inheritanceViewMapping, context, embeddableMapping);
            this.inheritanceSubtypeConfiguration = this.createInheritanceSubtypeConfiguration(inheritanceViewMapping, context, embeddableMapping);
            this.inheritanceSubtypes = Collections.unmodifiableSet(this.inheritanceSubtypeConfiguration.keySet());
            this.inheritanceDiscriminatorMapping = this.createInheritanceDiscriminatorMapping(orderedInheritanceSubtypes);
            this.attributesClosure = this.createSubtypeAttributesClosure(orderedInheritanceSubtypes);
            HashMap<ManagedViewTypeImpl<X>, int[]> positionAssignments = new HashMap<ManagedViewTypeImpl<X>, int[]>();
            Map<AttributeKey, ConstrainedAttribute<AbstractMethodAttribute<X, ?>>> overallAttributesClosure = overallConfiguration == null ? this.attributesClosure : overallConfiguration.attributesClosure;
            HashMap<String, Integer> overallPositionMap = new HashMap<String, Integer>(overallAttributesClosure.size());
            int index = 0;
            String idName = null;
            if (baseType instanceof ViewTypeImpl) {
                idName = baseTypeViewMapping.getIdAttribute().getName();
                overallPositionMap.put(idName, index);
                ++index;
            }
            for (AttributeKey attributeKey : overallAttributesClosure.keySet()) {
                if (attributeKey.attributeName.equals(idName)) continue;
                overallPositionMap.put(attributeKey.attributeName, index);
                ++index;
            }
            for (ManagedViewTypeImpl<X> subtype : orderedInheritanceSubtypes) {
                int[] positionAssignment = new int[overallPositionMap.size()];
                Arrays.fill(positionAssignment, -1);
                index = 0;
                if (idName != null) {
                    positionAssignment[index] = index;
                    ++index;
                }
                for (AttributeKey attributeKey : this.attributesClosure.keySet()) {
                    Integer position;
                    if (attributeKey.attributeName.equals(idName)) continue;
                    if (subtype.getAttribute(attributeKey.getAttributeName()) != null && (position = (Integer)overallPositionMap.get(attributeKey.attributeName)) != null) {
                        positionAssignment[position.intValue()] = index;
                    }
                    ++index;
                }
                positionAssignments.put(subtype, positionAssignment);
            }
            this.overallPositionAssignments = Collections.unmodifiableMap(positionAssignments);
        }

        public ManagedViewTypeImplementor<X> getBaseType() {
            return this.baseType;
        }

        public int getConfigurationIndex() {
            return this.configurationIndex;
        }

        public Set<ManagedViewTypeImplementor<? extends X>> getInheritanceSubtypes() {
            return this.inheritanceSubtypes;
        }

        public Map<ManagedViewTypeImplementor<? extends X>, String> getInheritanceSubtypeConfiguration() {
            return this.inheritanceSubtypeConfiguration;
        }

        public String getInheritanceDiscriminatorMapping() {
            return this.inheritanceDiscriminatorMapping;
        }

        public Map<AttributeKey, ConstrainedAttribute<AbstractMethodAttribute<? super X, ?>>> getAttributesClosure() {
            return this.attributesClosure;
        }

        public int[] getOverallPositionAssignment(ManagedViewTypeImplementor<? extends X> subtype) {
            return this.overallPositionAssignments.get(subtype);
        }

        private ManagedViewTypeImpl<? extends X>[] createOrderedSubtypes(InheritanceViewMapping inheritanceViewMapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
            ManagedViewTypeImpl[] orderedSubtypes = new ManagedViewTypeImpl[inheritanceViewMapping.getInheritanceSubtypeMappings().size()];
            int i = 0;
            for (ViewMapping mapping : inheritanceViewMapping.getInheritanceSubtypeMappings().keySet()) {
                if (mapping.getEntityViewClass() == ((ManagedViewTypeImpl)this.baseType).javaType) {
                    orderedSubtypes[i++] = this.baseType;
                    continue;
                }
                orderedSubtypes[i++] = (ManagedViewTypeImpl)context.getManagedViewType(mapping, embeddableMapping);
            }
            return orderedSubtypes;
        }

        private Map<ManagedViewTypeImplementor<? extends X>, String> createInheritanceSubtypeConfiguration(InheritanceViewMapping inheritanceViewMapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
            LinkedHashMap<ManagedViewTypeImplementor<X>, String> configuration = new LinkedHashMap<ManagedViewTypeImplementor<X>, String>(inheritanceViewMapping.getInheritanceSubtypeMappings().size());
            for (Map.Entry<ViewMapping, String> mappingEntry : inheritanceViewMapping.getInheritanceSubtypeMappings().entrySet()) {
                String mapping = mappingEntry.getValue();
                if (mapping == null && (mapping = mappingEntry.getKey().determineInheritanceMapping(context)) == null) {
                    mapping = "";
                }
                if (mappingEntry.getKey().getEntityViewClass() == ((ManagedViewTypeImpl)this.baseType).javaType) {
                    configuration.put(this.baseType, mapping);
                    continue;
                }
                configuration.put(context.getManagedViewType(mappingEntry.getKey(), embeddableMapping), mapping);
            }
            return configuration;
        }

        public boolean hasSubtypes() {
            return this.inheritanceDiscriminatorMapping != null;
        }

        private String createInheritanceDiscriminatorMapping(ManagedViewTypeImpl<? extends X>[] subtypes) {
            if (subtypes.length == 1 && subtypes[0] == this.baseType) {
                return null;
            }
            TreeMap<ManagedViewTypeImpl<? extends X>, Integer> concreteToGeneralViewToDiscriminatorMap = new TreeMap<ManagedViewTypeImpl<? extends X>, Integer>(new Comparator<ManagedViewTypeImplementor<? extends X>>(){

                @Override
                public int compare(ManagedViewTypeImplementor<? extends X> o1, ManagedViewTypeImplementor<? extends X> o2) {
                    Class j2;
                    Class j1 = o1.getJavaType();
                    if (j1 == (j2 = o2.getJavaType())) {
                        return 0;
                    }
                    if (j1.isAssignableFrom(j2)) {
                        return 1;
                    }
                    if (j2.isAssignableFrom(j1)) {
                        return -1;
                    }
                    return j1.getName().compareTo(j2.getName());
                }
            });
            int subtypeIndex = 0;
            for (ManagedViewTypeImpl<? extends X> managedViewTypeImpl : subtypes) {
                concreteToGeneralViewToDiscriminatorMap.put(managedViewTypeImpl, subtypeIndex++);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("CASE");
            for (Map.Entry entry : concreteToGeneralViewToDiscriminatorMap.entrySet()) {
                String inheritanceMapping;
                ManagedViewTypeImplementor managedViewTypeImplementor = (ManagedViewTypeImplementor)entry.getKey();
                subtypeIndex = (Integer)entry.getValue();
                if (managedViewTypeImplementor == this.baseType || (inheritanceMapping = this.inheritanceSubtypeConfiguration.get(managedViewTypeImplementor)) == null || inheritanceMapping.isEmpty()) continue;
                sb.append(" WHEN ");
                sb.append(inheritanceMapping);
                for (int i = subtypeIndex - 1; i >= 0; --i) {
                    inheritanceMapping = this.inheritanceSubtypeConfiguration.get(subtypes[i]);
                    if (!((ManagedViewTypeImpl)subtypes[i]).javaType.isAssignableFrom(managedViewTypeImplementor.getJavaType()) || inheritanceMapping == null || inheritanceMapping.isEmpty() || subtypes[i].getJpaManagedType() != managedViewTypeImplementor.getJpaManagedType() && inheritanceMapping.equals(subtypes[i].getTypeConstraintMapping())) continue;
                    sb.append(" AND ").append(inheritanceMapping);
                }
                sb.append(" THEN ");
                sb.append(subtypeIndex);
            }
            String defaultMapping = this.inheritanceSubtypeConfiguration.get(this.baseType);
            if (defaultMapping != null) {
                if (defaultMapping.isEmpty()) {
                    sb.append(" ELSE 0");
                } else {
                    sb.append(" WHEN ").append(defaultMapping).append(" THEN 0");
                }
            }
            sb.append(" END");
            return sb.toString();
        }

        private Map<AttributeKey, ConstrainedAttribute<AbstractMethodAttribute<? super X, ?>>> createSubtypeAttributesClosure(ManagedViewTypeImpl<? extends X>[] subtypes) {
            int subtypeIndex = 0;
            LinkedHashMap subtypesAttributesClosure = new LinkedHashMap();
            TreeSet<Integer> subtypeIndexes = new TreeSet<Integer>();
            for (int i = 0; i < subtypes.length; ++i) {
                subtypeIndexes.add(i);
            }
            int[] subtypeIndexArray = new int[subtypeIndexes.size()];
            int j = 0;
            for (Integer idx : subtypeIndexes) {
                subtypeIndexArray[j++] = idx;
            }
            for (AbstractMethodAttribute attribute : ((ManagedViewTypeImpl)this.baseType).attributes.values()) {
                subtypesAttributesClosure.put(new AttributeKey(0, attribute.getName()), new ConstrainedAttribute<AbstractMethodAttribute>(null, subtypeIndexArray, attribute));
            }
            if (subtypes.length > 0) {
                for (int i = 0; i < subtypes.length; ++i) {
                    int j2;
                    ManagedViewTypeImpl<X> subtype = subtypes[i];
                    subtypeIndexes.clear();
                    for (j2 = i; j2 < subtypes.length; ++j2) {
                        if (!subtype.getJavaType().isAssignableFrom(subtypes[j2].getJavaType())) continue;
                        subtypeIndexes.add(j2);
                    }
                    subtypeIndexArray = new int[subtypeIndexes.size()];
                    j2 = 0;
                    for (Integer idx : subtypeIndexes) {
                        subtypeIndexArray[j2++] = idx;
                    }
                    for (AbstractMethodAttribute attribute : ((ManagedViewTypeImpl)subtype).attributes.values()) {
                        ConstrainedAttribute<AbstractMethodAttribute<X, X>> superTypeAttribute = this.findAttribute(subtypesAttributesClosure, subtypes, subtypeIndex, attribute.getName());
                        if (superTypeAttribute != null) {
                            if (attribute.getJavaMethod().equals(superTypeAttribute.getAttribute().getJavaMethod())) {
                                superTypeAttribute.addSubAttribute(subtype, attribute);
                                continue;
                            }
                            superTypeAttribute.addSelectionConstraint(this.inheritanceSubtypeConfiguration.get(subtype), subtypeIndexArray, attribute);
                            continue;
                        }
                        subtypesAttributesClosure.put(new AttributeKey(subtypeIndex, attribute.getName()), new ConstrainedAttribute<AbstractMethodAttribute>(this.inheritanceSubtypeConfiguration.get(subtype), subtypeIndexArray, attribute));
                    }
                    ++subtypeIndex;
                }
            }
            return subtypesAttributesClosure;
        }

        private ConstrainedAttribute<AbstractMethodAttribute<? super X, ?>> findAttribute(Map<AttributeKey, ConstrainedAttribute<AbstractMethodAttribute<? super X, ?>>> subtypesAttributesClosure, ManagedViewTypeImpl<?>[] subtypes, int subtypeIndex, String name) {
            for (int i = subtypeIndex; i >= 0; --i) {
                ConstrainedAttribute<AbstractMethodAttribute<? super X, ?>> attribute;
                if (!((ManagedViewTypeImpl)subtypes[i]).javaType.isAssignableFrom(((ManagedViewTypeImpl)subtypes[i]).javaType) || subtypes[i].getAttribute(name) == null || (attribute = subtypesAttributesClosure.get(new AttributeKey(i, name))) == null) continue;
                return attribute;
            }
            return null;
        }
    }

    public static final class AttributeKey {
        final int subtypeIndex;
        final String attributeName;

        public AttributeKey(int subtypeIndex, String attributeName) {
            this.subtypeIndex = subtypeIndex;
            this.attributeName = attributeName;
        }

        public int getSubtypeIndex() {
            return this.subtypeIndex;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AttributeKey)) {
                return false;
            }
            AttributeKey that = (AttributeKey)o;
            if (this.subtypeIndex != -1 && that.subtypeIndex != -1 && this.subtypeIndex != that.subtypeIndex) {
                return false;
            }
            return this.attributeName.equals(that.attributeName);
        }

        public int hashCode() {
            return this.attributeName.hashCode();
        }
    }

    private static final class KeyTypeSubviewAttributeCollector<X>
    implements Runnable {
        private final AbstractMethodAttribute<? super X, ?> attribute;
        private final NavigableMap<String, AbstractMethodAttribute<? super X, ?>> recursiveAttributes;
        private final NavigableMap<String, AbstractMethodAttribute<? super X, ?>> recursiveSubviewAttributes;
        private final ManagedViewTypeImplementor<Object> keyType;
        private final MetamodelBuildingContext context;

        private KeyTypeSubviewAttributeCollector(AbstractMethodAttribute<? super X, ?> attribute, NavigableMap<String, AbstractMethodAttribute<? super X, ?>> recursiveAttributes, NavigableMap<String, AbstractMethodAttribute<? super X, ?>> recursiveSubviewAttributes, ManagedViewTypeImplementor<Object> keyType, MetamodelBuildingContext context) {
            this.attribute = attribute;
            this.recursiveAttributes = recursiveAttributes;
            this.recursiveSubviewAttributes = recursiveSubviewAttributes;
            this.keyType = keyType;
            this.context = context;
        }

        @Override
        public void run() {
            if (this.keyType.getRecursiveSubviewAttributes() != null) {
                for (Map.Entry subEntry : this.keyType.getRecursiveSubviewAttributes().entrySet()) {
                    this.recursiveSubviewAttributes.put("KEY(" + PrefixingQueryGenerator.prefix(this.context.getExpressionFactory(), (String)subEntry.getKey(), this.attribute.getName()) + ")", (AbstractMethodAttribute<X, ?>)subEntry.getValue());
                }
            }
            if (this.keyType.getRecursiveAttributes() != null) {
                for (Map.Entry subEntry : this.keyType.getRecursiveAttributes().entrySet()) {
                    this.recursiveAttributes.put("KEY(" + PrefixingQueryGenerator.prefix(this.context.getExpressionFactory(), (String)subEntry.getKey(), this.attribute.getName()) + ")", (AbstractMethodAttribute<X, ?>)subEntry.getValue());
                }
            }
        }
    }

    private static final class ElementTypeSubviewAttributeCollector<X>
    implements Runnable {
        private final AbstractMethodAttribute<? super X, ?> attribute;
        private final NavigableMap<String, AbstractMethodAttribute<? super X, ?>> recursiveAttributes;
        private final NavigableMap<String, AbstractMethodAttribute<? super X, ?>> recursiveSubviewAttributes;
        private final ManagedViewTypeImplementor<Object> elementType;
        private final MetamodelBuildingContext context;

        private ElementTypeSubviewAttributeCollector(AbstractMethodAttribute<? super X, ?> attribute, NavigableMap<String, AbstractMethodAttribute<? super X, ?>> recursiveAttributes, NavigableMap<String, AbstractMethodAttribute<? super X, ?>> recursiveSubviewAttributes, ManagedViewTypeImplementor<Object> elementType, MetamodelBuildingContext context) {
            this.attribute = attribute;
            this.recursiveAttributes = recursiveAttributes;
            this.recursiveSubviewAttributes = recursiveSubviewAttributes;
            this.elementType = elementType;
            this.context = context;
        }

        @Override
        public void run() {
            if (this.elementType.getRecursiveSubviewAttributes() != null) {
                for (Map.Entry subEntry : this.elementType.getRecursiveSubviewAttributes().entrySet()) {
                    this.recursiveSubviewAttributes.put(PrefixingQueryGenerator.prefix(this.context.getExpressionFactory(), (String)subEntry.getKey(), this.attribute.getName()), (AbstractMethodAttribute<X, ?>)subEntry.getValue());
                }
            }
            if (this.elementType.getRecursiveAttributes() != null) {
                for (Map.Entry subEntry : this.elementType.getRecursiveAttributes().entrySet()) {
                    this.recursiveAttributes.put(PrefixingQueryGenerator.prefix(this.context.getExpressionFactory(), (String)subEntry.getKey(), this.attribute.getName()), (AbstractMethodAttribute<X, ?>)subEntry.getValue());
                }
            }
        }
    }

    private static final class CTEProviderCollector
    implements Runnable {
        private final ManagedViewTypeImpl<?> viewType;
        private final MetamodelBuildingContext context;
        private final ViewMapping viewMapping;

        private CTEProviderCollector(ManagedViewTypeImpl<?> viewType, MetamodelBuildingContext context, ViewMapping viewMapping) {
            this.viewType = viewType;
            this.viewMapping = viewMapping;
            this.context = context;
        }

        @Override
        public void run() {
            Set<Class<? extends CTEProvider>> rootProviders = this.viewMapping.getCteProviders();
            if (rootProviders != null) {
                Map<Class<?>, CTEProvider> providers = this.context.getCteProviders();
                for (Class<? extends CTEProvider> clazz : rootProviders) {
                    CTEProvider provider = providers.get(clazz);
                    if (provider == null) {
                        provider = new SimpleCTEProviderFactory(clazz).create();
                        providers.put(clazz, provider);
                    }
                    ((ManagedViewTypeImpl)this.viewType).cteProviders.add(provider);
                }
            }
            for (AbstractMethodAttribute attribute : ((ManagedViewTypeImpl)this.viewType).recursiveSubviewAttributes.values()) {
                com.blazebit.persistence.view.metamodel.Type<?> elementType = attribute.getElementType();
                if (!(elementType instanceof ManagedViewTypeImpl)) continue;
                ManagedViewType viewType = (ManagedViewType)attribute.getElementType();
                ((ManagedViewTypeImpl)this.viewType).cteProviders.addAll(viewType.getCteProviders());
            }
        }
    }
}

