/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.AbstractParameterAttribute;
import com.blazebit.persistence.view.impl.metamodel.ConstructorMapping;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.ParameterAttributeMapping;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingConstructor;
import com.blazebit.persistence.view.metamodel.ParameterAttribute;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.ManagedType;

public class MappingConstructorImpl<X>
implements MappingConstructor<X> {
    private final String name;
    private final ManagedViewTypeImplementor<X> declaringType;
    private final Constructor<X> javaConstructor;
    private final List<AbstractParameterAttribute<? super X, ?>> parameters;
    private final InheritanceSubtypeConstructorConfiguration<X> defaultInheritanceParametersAttributesClosureConfiguration;
    private final InheritanceSubtypeConstructorConfiguration<X> overallInheritanceParametersAttributesClosureConfiguration;
    private final Map<Map<ManagedViewTypeImplementor<? extends X>, String>, InheritanceSubtypeConstructorConfiguration<X>> inheritanceSubtypeParameterAttributesClosureConfigurations;
    private final boolean hasJoinFetchedCollections;

    public MappingConstructorImpl(ManagedViewTypeImplementor<X> viewType, String name, ConstructorMapping mapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        this.name = name;
        this.declaringType = viewType;
        this.javaConstructor = mapping.getConstructor();
        List<ParameterAttributeMapping> parameterMappings = mapping.getParameterMappings();
        int parameterCount = parameterMappings.size();
        ArrayList parameters = new ArrayList(parameterCount);
        ArrayList overallParameters = new ArrayList(parameterCount + 10);
        boolean hasJoinFetchedCollections = false;
        for (int i = 0; i < parameterCount; ++i) {
            AbstractParameterAttribute abstractParameterAttribute = parameterMappings.get(i).getParameterAttribute(this, context, embeddableMapping);
            hasJoinFetchedCollections = hasJoinFetchedCollections || abstractParameterAttribute.hasJoinFetchedCollections();
            parameters.add(abstractParameterAttribute);
            overallParameters.add(abstractParameterAttribute);
        }
        this.parameters = Collections.unmodifiableList(parameters);
        for (ManagedViewType managedViewType : viewType.getOverallInheritanceSubtypeConfiguration().getInheritanceSubtypes()) {
            MappingConstructorImpl mappingConstructorImpl;
            if (managedViewType == this.declaringType || (mappingConstructorImpl = (MappingConstructorImpl)managedViewType.getConstructor(name)) == null) continue;
            overallParameters.addAll(mappingConstructorImpl.getParameterAttributes());
        }
        this.overallInheritanceParametersAttributesClosureConfiguration = new InheritanceSubtypeConstructorConfiguration(overallParameters);
        this.defaultInheritanceParametersAttributesClosureConfiguration = new InheritanceSubtypeConstructorConfiguration(this.createParameterAttributesClosure(viewType.getDefaultInheritanceSubtypeConfiguration().getInheritanceSubtypeConfiguration(), context), this.overallInheritanceParametersAttributesClosureConfiguration);
        HashMap inheritanceSubtypeParameterAttributesClosureConfigurations = new HashMap();
        for (Map<ManagedViewTypeImplementor<? extends X>, String> map : viewType.getInheritanceSubtypeConfigurations().keySet()) {
            if (map == viewType.getDefaultInheritanceSubtypeConfiguration()) {
                inheritanceSubtypeParameterAttributesClosureConfigurations.put(map, this.defaultInheritanceParametersAttributesClosureConfiguration);
                continue;
            }
            inheritanceSubtypeParameterAttributesClosureConfigurations.put(map, new InheritanceSubtypeConstructorConfiguration(this.createParameterAttributesClosure(map, context), this.overallInheritanceParametersAttributesClosureConfiguration));
        }
        this.inheritanceSubtypeParameterAttributesClosureConfigurations = Collections.unmodifiableMap(inheritanceSubtypeParameterAttributesClosureConfigurations);
        this.hasJoinFetchedCollections = hasJoinFetchedCollections;
    }

    private List<AbstractParameterAttribute<? super X, ?>> createParameterAttributesClosure(Map<ManagedViewTypeImplementor<? extends X>, String> subtypes, MetamodelBuildingContext context) {
        ArrayList parametersAttributeClosure = new ArrayList(this.parameters.size());
        parametersAttributeClosure.addAll(this.parameters);
        for (ManagedViewType managedViewType : subtypes.keySet()) {
            if (managedViewType == this.declaringType) continue;
            MappingConstructorImpl constructor = (MappingConstructorImpl)managedViewType.getConstructor(this.name);
            if (constructor == null) {
                context.addError("Could not find required mapping constructor with name '" + this.name + "' in inheritance subtype '" + managedViewType.getJavaType().getName() + "'!");
                continue;
            }
            parametersAttributeClosure.addAll(constructor.getParameterAttributes());
        }
        return parametersAttributeClosure;
    }

    public InheritanceSubtypeConstructorConfiguration<X> getSubtypeConstructorConfiguration(Map<ManagedViewTypeImplementor<? extends X>, String> inheritanceSubtypeMappings) {
        if (inheritanceSubtypeMappings == null || inheritanceSubtypeMappings.isEmpty() || this.declaringType.getDefaultInheritanceSubtypeConfiguration().getInheritanceSubtypeConfiguration() == inheritanceSubtypeMappings) {
            return this.defaultInheritanceParametersAttributesClosureConfiguration;
        }
        return this.inheritanceSubtypeParameterAttributesClosureConfigurations.get(inheritanceSubtypeMappings);
    }

    public InheritanceSubtypeConstructorConfiguration<X> getDefaultInheritanceParametersAttributesClosureConfiguration() {
        return this.defaultInheritanceParametersAttributesClosureConfiguration;
    }

    public InheritanceSubtypeConstructorConfiguration<X> getOverallInheritanceParametersAttributesClosureConfiguration() {
        return this.overallInheritanceParametersAttributesClosureConfiguration;
    }

    public Map<Map<ManagedViewTypeImplementor<? extends X>, String>, InheritanceSubtypeConstructorConfiguration<X>> getInheritanceSubtypeParameterAttributesClosureConfigurations() {
        return this.inheritanceSubtypeParameterAttributesClosureConfigurations;
    }

    public void checkParameters(ManagedType<?> managedType, Map<String, List<String>> collectionMappings, Map<String, List<String>> collectionMappingSingulars, MetamodelBuildingContext context) {
        for (AbstractParameterAttribute<X, ?> parameter : this.parameters) {
            parameter.checkAttribute(managedType, context);
            for (Map.Entry<String, Boolean> entry : parameter.getCollectionJoinMappings(managedType, context).entrySet()) {
                List<String> locations;
                if (entry.getValue().booleanValue()) {
                    locations = collectionMappingSingulars.get(entry.getKey());
                    if (locations == null) {
                        locations = new ArrayList<String>(2);
                        collectionMappingSingulars.put(entry.getKey(), locations);
                    }
                    locations.add("Parameter with the index '" + parameter.getIndex() + "' of the constructor '" + parameter.getDeclaringConstructor().getJavaConstructor() + "'");
                    continue;
                }
                locations = collectionMappings.get(entry.getKey());
                if (locations == null) {
                    locations = new ArrayList<String>(2);
                    collectionMappings.put(entry.getKey(), locations);
                }
                locations.add("Parameter with the index '" + parameter.getIndex() + "' of the constructor '" + parameter.getDeclaringConstructor().getJavaConstructor() + "'");
            }
        }
    }

    public void checkNestedParameters(List<AbstractAttribute<?, ?>> parents, ManagedType<?> managedType, MetamodelBuildingContext context) {
        for (AbstractParameterAttribute<X, ?> parameter : this.parameters) {
            parameter.checkNestedAttribute(parents, managedType, context);
        }
    }

    public String getName() {
        return this.name;
    }

    public ManagedViewTypeImplementor<X> getDeclaringType() {
        return this.declaringType;
    }

    public Constructor<X> getJavaConstructor() {
        return this.javaConstructor;
    }

    public List<ParameterAttribute<? super X, ?>> getParameterAttributes() {
        return this.parameters;
    }

    public ParameterAttribute<? super X, ?> getParameterAttribute(int index) {
        return this.parameters.get(index);
    }

    public boolean hasJoinFetchedCollections() {
        return this.hasJoinFetchedCollections;
    }

    public static class InheritanceSubtypeConstructorConfiguration<X> {
        private final List<AbstractParameterAttribute<? super X, ?>> parameterAttributesClosure;
        private final int[] overallPositionAssignment;

        public InheritanceSubtypeConstructorConfiguration(List<AbstractParameterAttribute<? super X, ?>> parameterAttributesClosure) {
            this(parameterAttributesClosure, null);
        }

        public InheritanceSubtypeConstructorConfiguration(List<AbstractParameterAttribute<? super X, ?>> parameterAttributesClosure, InheritanceSubtypeConstructorConfiguration<X> overallConfiguration) {
            int[] positionAssignment;
            this.parameterAttributesClosure = Collections.unmodifiableList(parameterAttributesClosure);
            if (overallConfiguration == null) {
                positionAssignment = new int[parameterAttributesClosure.size()];
                int index = 0;
                for (AbstractParameterAttribute<X, ?> abstractParameterAttribute : parameterAttributesClosure) {
                    positionAssignment[index] = index;
                    ++index;
                }
            } else {
                IdentityHashMap positionMap = new IdentityHashMap(parameterAttributesClosure.size());
                int index = 0;
                for (AbstractParameterAttribute<X, ?> abstractParameterAttribute : parameterAttributesClosure) {
                    positionMap.put(abstractParameterAttribute, index);
                    ++index;
                }
                positionAssignment = new int[overallConfiguration.parameterAttributesClosure.size()];
                index = 0;
                for (AbstractParameterAttribute<? super X, ?> abstractParameterAttribute : overallConfiguration.parameterAttributesClosure) {
                    Integer position = (Integer)positionMap.get(abstractParameterAttribute);
                    positionAssignment[index] = position == null ? -1 : position;
                    ++index;
                }
            }
            this.overallPositionAssignment = positionAssignment;
        }

        public List<AbstractParameterAttribute<? super X, ?>> getParameterAttributesClosure() {
            return this.parameterAttributesClosure;
        }

        public int[] getOverallPositionAssignment() {
            return this.overallPositionAssignment;
        }
    }
}

