/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.parser.AliasReplacementVisitor;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.AbstractCachingExpressionFactory;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.MacroConfiguration;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlMacro;
import com.blazebit.persistence.view.CTEProvider;
import com.blazebit.persistence.view.FlushMode;
import com.blazebit.persistence.view.FlushStrategy;
import com.blazebit.persistence.view.IdMapping;
import com.blazebit.persistence.view.Mapping;
import com.blazebit.persistence.view.MappingCorrelated;
import com.blazebit.persistence.view.MappingCorrelatedSimple;
import com.blazebit.persistence.view.MappingSubquery;
import com.blazebit.persistence.view.impl.JpqlMacroAdapter;
import com.blazebit.persistence.view.impl.MacroConfigurationExpressionFactory;
import com.blazebit.persistence.view.impl.ScalarTargetResolvingExpressionVisitor;
import com.blazebit.persistence.view.impl.macro.DefaultViewRootJpqlMacro;
import com.blazebit.persistence.view.impl.macro.MutableEmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.impl.macro.TypeValidationEmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.impl.macro.TypeValidationViewRootJpqlMacro;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.BasicTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.impl.proxy.ProxyFactory;
import com.blazebit.persistence.view.impl.type.BasicUserTypeRegistry;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.metamodel.ManagedType;

public class MetamodelBuildingContextImpl
implements MetamodelBuildingContext {
    private static final Comparator<Class<?>> CLASS_NAME_COMPARATOR = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final Map<TypeRegistryKey, com.blazebit.persistence.view.metamodel.Type<?>> basicTypeRegistry = new HashMap();
    private final Map<TypeRegistryKey, Map<Class<?>, com.blazebit.persistence.view.metamodel.Type<?>>> convertedTypeRegistry = new HashMap();
    private final BasicUserTypeRegistry basicUserTypeRegistry;
    private final EntityMetamodel entityMetamodel;
    private final JpaProvider jpaProvider;
    private final Map<String, JpqlFunction> jpqlFunctions;
    private final ExpressionFactory expressionFactory;
    private final MacroConfigurationExpressionFactory typeValidationExpressionFactory;
    private final ProxyFactory proxyFactory;
    private final Map<Class<?>, ViewMapping> viewMappings;
    private final Map<ViewMappingInitializationKey, ManagedViewTypeImplementor<?>> initializingManagedViews;
    private final Map<ManagedViewTypeImplementor<?>, List<Runnable>> managedViewFinishListeners;
    private final Set<String> errors;
    private final boolean disallowOwnedUpdatableSubview;
    private final boolean strictCascadingCheck;
    private final boolean errorOnInvalidPluralSetter;
    private final FlushMode flushModeOverride;
    private final Map<String, FlushMode> flushModeOverrides;
    private final FlushStrategy flushStrategyOverride;
    private final Map<String, FlushStrategy> flushStrategyOverrides;
    private final Map<Class<?>, CTEProvider> cteProviders = new LinkedHashMap();

    public MetamodelBuildingContextImpl(Properties properties, BasicUserTypeRegistry basicUserTypeRegistry, EntityMetamodel entityMetamodel, JpaProvider jpaProvider, Map<String, JpqlFunction> jpqlFunctions, ExpressionFactory expressionFactory, ProxyFactory proxyFactory, Map<Class<?>, ViewMapping> viewMappings, Set<String> errors) {
        this.basicUserTypeRegistry = basicUserTypeRegistry;
        this.entityMetamodel = entityMetamodel;
        this.jpaProvider = jpaProvider;
        this.jpqlFunctions = jpqlFunctions;
        this.expressionFactory = expressionFactory;
        this.typeValidationExpressionFactory = this.createTypeValidationExpressionFactory();
        this.proxyFactory = proxyFactory;
        this.viewMappings = viewMappings;
        this.initializingManagedViews = new HashMap();
        this.managedViewFinishListeners = new HashMap();
        this.errors = errors;
        this.disallowOwnedUpdatableSubview = "true".equals(properties.getProperty("com.blazebit.persistence.view.updater.disallow_owned_updatable_subview"));
        this.strictCascadingCheck = Boolean.valueOf(String.valueOf(properties.getProperty("com.blazebit.persistence.view.updater.strict_cascading_check")));
        this.errorOnInvalidPluralSetter = Boolean.valueOf(String.valueOf(properties.getProperty("com.blazebit.persistence.view.updater.error_on_invalid_plural_setter")));
        this.flushModeOverride = this.getFlushMode(properties.getProperty("com.blazebit.persistence.view.updater.flush_mode"), "global property 'com.blazebit.persistence.view.updater.flush_mode'");
        this.flushModeOverrides = this.getFlushModeOverrides(properties);
        this.flushStrategyOverride = this.getFlushStrategy(properties.getProperty("com.blazebit.persistence.view.updater.flush_strategy"), "global property 'com.blazebit.persistence.view.updater.flush_strategy'");
        this.flushStrategyOverrides = this.getFlushStrategyOverrides(properties);
    }

    private FlushMode getFlushMode(String property, String location) {
        if (property == null || property.isEmpty()) {
            return null;
        }
        if ("partial".equals(property)) {
            return FlushMode.PARTIAL;
        }
        if ("lazy".equals(property)) {
            return FlushMode.LAZY;
        }
        if ("full".equals(property)) {
            return FlushMode.FULL;
        }
        throw new IllegalArgumentException("Invalid flush mode defined for " + location + ": " + property);
    }

    private Map<String, FlushMode> getFlushModeOverrides(Properties properties) {
        String prefix = "com.blazebit.persistence.view.updater.flush_mode.";
        HashMap<String, FlushMode> flushModes = new HashMap<String, FlushMode>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix) || entry.getValue() == null) continue;
            Object value = entry.getValue();
            FlushMode mode = value instanceof FlushMode ? (FlushMode)value : this.getFlushMode(entry.getValue().toString(), "property '" + key + "'");
            flushModes.put(key.substring(prefix.length()), mode);
        }
        return flushModes;
    }

    private FlushStrategy getFlushStrategy(String property, String location) {
        if (property == null || property.isEmpty()) {
            return null;
        }
        if ("query".equalsIgnoreCase(property)) {
            return FlushStrategy.QUERY;
        }
        if ("entity".equalsIgnoreCase(property)) {
            return FlushStrategy.ENTITY;
        }
        throw new IllegalArgumentException("Invalid flush strategy defined for " + location + ": " + property);
    }

    private Map<String, FlushStrategy> getFlushStrategyOverrides(Properties properties) {
        String prefix = "com.blazebit.persistence.view.updater.flush_strategy.";
        HashMap<String, FlushStrategy> flushStrategies = new HashMap<String, FlushStrategy>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix) || entry.getValue() == null) continue;
            Object value = entry.getValue();
            FlushStrategy strategy = value instanceof FlushStrategy ? (FlushStrategy)value : this.getFlushStrategy(entry.getValue().toString(), "property '" + key + "'");
            flushStrategies.put(key.substring(prefix.length()), strategy);
        }
        return flushStrategies;
    }

    @Override
    public Collection<ViewMapping> getViewMappings() {
        return this.viewMappings.values();
    }

    @Override
    public void addManagedViewType(ViewMapping viewMapping, EmbeddableOwner embeddableMapping, ManagedViewTypeImplementor<?> managedViewType) {
        ViewMappingInitializationKey key = new ViewMappingInitializationKey(viewMapping, embeddableMapping);
        if (this.initializingManagedViews.get(key) == null) {
            this.initializingManagedViews.put(key, managedViewType);
        }
    }

    @Override
    public ManagedViewTypeImplementor<?> getManagedViewType(ViewMapping viewMapping, EmbeddableOwner embeddableMapping) {
        ViewMappingInitializationKey key = new ViewMappingInitializationKey(viewMapping, embeddableMapping);
        ManagedViewTypeImplementor<?> managedViewTypeImplementor = this.initializingManagedViews.get(key);
        if (managedViewTypeImplementor == null) {
            return viewMapping.getManagedViewType(this, embeddableMapping);
        }
        return managedViewTypeImplementor;
    }

    @Override
    public void finishViewType(ManagedViewTypeImplementor<?> managedViewType) {
        List<Runnable> finishListeners = this.managedViewFinishListeners.get(managedViewType);
        if (finishListeners == null) {
            this.managedViewFinishListeners.put(managedViewType, Collections.emptyList());
        } else {
            for (Runnable finishListener : finishListeners) {
                finishListener.run();
            }
            finishListeners.clear();
        }
    }

    @Override
    public void onViewTypeFinished(ManagedViewTypeImplementor<?> managedViewType, Runnable listener) {
        List<Runnable> finishListeners = this.managedViewFinishListeners.get(managedViewType);
        if (finishListeners == null) {
            finishListeners = new ArrayList<Runnable>();
            finishListeners.add(listener);
            this.managedViewFinishListeners.put(managedViewType, finishListeners);
        } else if (finishListeners.isEmpty()) {
            listener.run();
        } else {
            finishListeners.add(listener);
        }
    }

    @Override
    public ViewMapping getViewMapping(Class<?> entityViewClass) {
        return this.viewMappings.get(entityViewClass);
    }

    @Override
    public <X> Map<Class<?>, TypeConverter<?, X>> getTypeConverter(Class<X> type) {
        return this.basicUserTypeRegistry.getTypeConverter(type);
    }

    @Override
    public List<ScalarTargetResolvingExpressionVisitor.TargetType> getPossibleTargetTypes(Class<?> entityClass, Annotation mapping) {
        String expression;
        ManagedType managedType = this.entityMetamodel.getManagedType(entityClass);
        if (mapping instanceof Mapping) {
            expression = ((Mapping)mapping).value();
        } else if (mapping instanceof IdMapping) {
            expression = ((IdMapping)mapping).value();
        } else if (mapping instanceof MappingCorrelatedSimple) {
            MappingCorrelatedSimple m = (MappingCorrelatedSimple)mapping;
            managedType = this.entityMetamodel.getManagedType(m.correlated());
            expression = m.correlationResult();
            if (expression.isEmpty()) {
                return Collections.singletonList(new ScalarTargetResolvingExpressionVisitor.TargetTypeImpl(false, null, managedType.getJavaType(), null, null));
            }
        } else {
            if (mapping instanceof MappingCorrelated) {
                return Collections.emptyList();
            }
            if (mapping instanceof MappingSubquery) {
                MappingSubquery mappingSubquery = (MappingSubquery)mapping;
                if (!mappingSubquery.expression().isEmpty()) {
                    Expression simpleExpression = this.typeValidationExpressionFactory.createSimpleExpression(((MappingSubquery)mapping).expression(), true);
                    AliasReplacementVisitor aliasReplacementVisitor = new AliasReplacementVisitor((Expression)NullExpression.INSTANCE, mappingSubquery.subqueryAlias());
                    simpleExpression.accept((Expression.ResultVisitor)aliasReplacementVisitor);
                    ScalarTargetResolvingExpressionVisitor visitor = new ScalarTargetResolvingExpressionVisitor(this.entityMetamodel.getManagedType(entityClass), this.entityMetamodel, this.jpqlFunctions);
                    simpleExpression.accept((Expression.Visitor)visitor);
                    return visitor.getPossibleTargetTypes();
                }
                return Collections.emptyList();
            }
            return Collections.emptyList();
        }
        if (expression.isEmpty() || managedType == null) {
            return Collections.emptyList();
        }
        if ((expression = AbstractAttribute.stripThisFromMapping(expression)).isEmpty()) {
            return Collections.singletonList(new ScalarTargetResolvingExpressionVisitor.TargetTypeImpl(false, null, managedType.getJavaType(), null, null));
        }
        Expression simpleExpression = this.typeValidationExpressionFactory.createSimpleExpression(expression, false, true, true);
        ScalarTargetResolvingExpressionVisitor visitor = new ScalarTargetResolvingExpressionVisitor(managedType, this.entityMetamodel, this.jpqlFunctions);
        simpleExpression.accept((Expression.Visitor)visitor);
        return visitor.getPossibleTargetTypes();
    }

    @Override
    public <X> com.blazebit.persistence.view.metamodel.Type<X> getBasicType(ViewMapping viewMapping, Type type, Class<?> classType, Set<Class<?>> possibleTypes) {
        if (type == null) {
            return null;
        }
        TypeRegistryKey key = new TypeRegistryKey(type, possibleTypes);
        Object t = this.basicTypeRegistry.get(key);
        if (t == null) {
            Map<Class<?>, TypeConverter<?, ?>> typeConverterMap = this.basicUserTypeRegistry.getTypeConverter(classType);
            TypeConverter<?, ?> typeConverter = null;
            Class<Object> convertedType = null;
            Map<Class<?>, com.blazebit.persistence.view.metamodel.Type<?>> convertedTypeMap = null;
            Iterator<Class<?>> iterator = possibleTypes.iterator();
            if (iterator.hasNext()) {
                Class<Object> entityModelType = iterator.next();
                if (entityModelType != null && !typeConverterMap.isEmpty()) {
                    convertedTypeMap = this.convertedTypeRegistry.get(key);
                    if (convertedTypeMap != null) {
                        t = convertedTypeMap.get(ReflectionUtils.getObjectClassOfPrimitve(entityModelType));
                        if (t != null) {
                            return t;
                        }
                        if (entityModelType.isPrimitive() && (t = convertedTypeMap.get(entityModelType)) != null) {
                            return t;
                        }
                        t = convertedTypeMap.get(classType);
                        if (t != null) {
                            return t;
                        }
                        t = convertedTypeMap.get(Object.class);
                        if (t != null) {
                            return t;
                        }
                    }
                    if ((typeConverter = typeConverterMap.get(ReflectionUtils.getObjectClassOfPrimitve(entityModelType))) == null) {
                        if (entityModelType.isPrimitive()) {
                            typeConverter = typeConverterMap.get(entityModelType);
                        }
                        if (typeConverter == null) {
                            typeConverter = typeConverterMap.get(classType);
                            if (typeConverter == null) {
                                typeConverter = typeConverterMap.get(Object.class);
                                if (typeConverter != null) {
                                    convertedType = Object.class;
                                }
                            } else {
                                convertedType = classType;
                            }
                        } else {
                            convertedType = entityModelType;
                        }
                    } else {
                        convertedType = ReflectionUtils.getObjectClassOfPrimitve(entityModelType);
                    }
                }
                if (typeConverter != null) {
                    classType = typeConverter.getUnderlyingType(viewMapping.getEntityViewClass(), type);
                    BasicUserType userType = this.basicUserTypeRegistry.getBasicUserType(ReflectionUtils.resolveType((Class)viewMapping.getEntityViewClass(), (Type)type));
                    ManagedType managedType = this.entityMetamodel.getManagedType((Class)classType);
                    t = new BasicTypeImpl(classType, managedType, userType, type, typeConverter);
                    if (convertedTypeMap == null) {
                        convertedTypeMap = new HashMap();
                        this.convertedTypeRegistry.put(key, convertedTypeMap);
                    }
                    convertedTypeMap.put(convertedType, (com.blazebit.persistence.view.metamodel.Type<?>)t);
                    return t;
                }
                BasicUserType<?> userType = this.basicUserTypeRegistry.getBasicUserType(classType);
                ManagedType managedType = this.entityMetamodel.getManagedType((Class)classType);
                t = new BasicTypeImpl(classType, managedType, userType);
                this.basicTypeRegistry.put(key, (com.blazebit.persistence.view.metamodel.Type<?>)t);
                return t;
            }
        }
        return t;
    }

    @Override
    public Map<String, JpqlFunction> getJpqlFunctions() {
        return this.jpqlFunctions;
    }

    @Override
    public EntityMetamodel getEntityMetamodel() {
        return this.entityMetamodel;
    }

    @Override
    public JpaProvider getJpaProvider() {
        return this.jpaProvider;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public MacroConfigurationExpressionFactory getTypeValidationExpressionFactory() {
        return this.typeValidationExpressionFactory;
    }

    @Override
    public MacroConfigurationExpressionFactory createMacroAwareExpressionFactory() {
        return this.createMacroAwareExpressionFactory("syntax_checking_placeholder");
    }

    @Override
    public MacroConfigurationExpressionFactory createMacroAwareExpressionFactory(String viewRoot) {
        MacroConfiguration originalMacroConfiguration = this.expressionFactory.getDefaultMacroConfiguration();
        ExpressionFactory cachingExpressionFactory = this.expressionFactory.unwrap(AbstractCachingExpressionFactory.class);
        HashMap<String, JpqlMacroAdapter> macros = new HashMap<String, JpqlMacroAdapter>();
        macros.put("view_root", new JpqlMacroAdapter((JpqlMacro)new DefaultViewRootJpqlMacro(viewRoot), cachingExpressionFactory));
        macros.put("embedding_view", new JpqlMacroAdapter((JpqlMacro)new MutableEmbeddingViewJpqlMacro(), cachingExpressionFactory));
        MacroConfiguration macroConfiguration = originalMacroConfiguration.with(macros);
        return new MacroConfigurationExpressionFactory(cachingExpressionFactory, macroConfiguration);
    }

    private MacroConfigurationExpressionFactory createTypeValidationExpressionFactory() {
        MacroConfiguration originalMacroConfiguration = this.expressionFactory.getDefaultMacroConfiguration();
        ExpressionFactory cachingExpressionFactory = this.expressionFactory.unwrap(AbstractCachingExpressionFactory.class);
        HashMap<String, JpqlMacroAdapter> macros = new HashMap<String, JpqlMacroAdapter>();
        macros.put("view_root", new JpqlMacroAdapter(new TypeValidationViewRootJpqlMacro(), cachingExpressionFactory));
        macros.put("embedding_view", new JpqlMacroAdapter(new TypeValidationEmbeddingViewJpqlMacro(), cachingExpressionFactory));
        MacroConfiguration macroConfiguration = originalMacroConfiguration.with(macros);
        return new MacroConfigurationExpressionFactory(cachingExpressionFactory, macroConfiguration);
    }

    @Override
    public boolean isDisallowOwnedUpdatableSubview() {
        return this.disallowOwnedUpdatableSubview;
    }

    @Override
    public boolean isStrictCascadingCheck() {
        return this.strictCascadingCheck;
    }

    @Override
    public boolean isErrorOnInvalidPluralSetter() {
        return this.errorOnInvalidPluralSetter;
    }

    @Override
    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    @Override
    public FlushMode getFlushMode(Class<?> clazz, FlushMode defaultValue) {
        if (this.flushModeOverride != null) {
            return this.flushModeOverride;
        }
        FlushMode mode = this.flushModeOverrides.get(clazz.getName());
        if (mode != null) {
            return mode;
        }
        return defaultValue;
    }

    @Override
    public FlushStrategy getFlushStrategy(Class<?> clazz, FlushStrategy defaultValue) {
        if (this.flushStrategyOverride != null) {
            return this.flushStrategyOverride;
        }
        FlushStrategy mode = this.flushStrategyOverrides.get(clazz.getName());
        if (mode != null) {
            return mode;
        }
        return defaultValue;
    }

    @Override
    public void addError(String error) {
        this.errors.add(error);
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public boolean isEntityView(Class<?> clazz) {
        return this.viewMappings.containsKey(clazz);
    }

    @Override
    public Set<Class<?>> findSubtypes(Class<?> entityViewClass) {
        TreeSet subtypes = new TreeSet(CLASS_NAME_COMPARATOR);
        for (Class<?> clazz : this.viewMappings.keySet()) {
            if (!entityViewClass.isAssignableFrom(clazz) || entityViewClass == clazz) continue;
            subtypes.add(clazz);
        }
        return subtypes;
    }

    @Override
    public Set<Class<?>> findSupertypes(Class<?> entityViewClass) {
        TreeSet supertypes = new TreeSet(CLASS_NAME_COMPARATOR);
        for (Class<?> clazz : this.viewMappings.keySet()) {
            if (!clazz.isAssignableFrom(entityViewClass) || entityViewClass == clazz) continue;
            supertypes.add(clazz);
        }
        return supertypes;
    }

    @Override
    public Map<Class<?>, CTEProvider> getCteProviders() {
        return this.cteProviders;
    }

    private static class ViewMappingInitializationKey {
        private final ViewMapping viewMapping;
        private final EmbeddableOwner embeddableOwner;

        public ViewMappingInitializationKey(ViewMapping viewMapping, EmbeddableOwner embeddableOwner) {
            this.viewMapping = viewMapping;
            this.embeddableOwner = viewMapping.getIdAttribute() == null ? embeddableOwner : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ViewMappingInitializationKey)) {
                return false;
            }
            ViewMappingInitializationKey that = (ViewMappingInitializationKey)o;
            if (!this.viewMapping.equals(that.viewMapping)) {
                return false;
            }
            return this.embeddableOwner != null ? this.embeddableOwner.equals(that.embeddableOwner) : that.embeddableOwner == null;
        }

        public int hashCode() {
            int result = this.viewMapping.hashCode();
            result = 31 * result + (this.embeddableOwner != null ? this.embeddableOwner.hashCode() : 0);
            return result;
        }
    }

    private static final class TypeRegistryKey {
        private final Type type;
        private final Set<Class<?>> possibleTypes;

        private TypeRegistryKey(Type type, Set<Class<?>> possibleTypes) {
            this.type = type;
            this.possibleTypes = possibleTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeRegistryKey that = (TypeRegistryKey)o;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
                return false;
            }
            return this.possibleTypes != null ? this.possibleTypes.equals(that.possibleTypes) : that.possibleTypes == null;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.possibleTypes != null ? this.possibleTypes.hashCode() : 0);
            return result;
        }
    }
}

