/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.spi.AttributePath;
import com.blazebit.persistence.view.CascadeType;
import com.blazebit.persistence.view.InverseRemoveStrategy;
import com.blazebit.persistence.view.Mapping;
import com.blazebit.persistence.view.MappingCorrelated;
import com.blazebit.persistence.view.MappingCorrelatedSimple;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.MappingSubquery;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.AttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingLiteral;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.impl.metamodel.attribute.CorrelatedMethodCollectionAttribute;
import com.blazebit.persistence.view.impl.metamodel.attribute.CorrelatedMethodListAttribute;
import com.blazebit.persistence.view.impl.metamodel.attribute.CorrelatedMethodSetAttribute;
import com.blazebit.persistence.view.impl.metamodel.attribute.CorrelatedMethodSingularAttribute;
import com.blazebit.persistence.view.impl.metamodel.attribute.MappingMethodCollectionAttribute;
import com.blazebit.persistence.view.impl.metamodel.attribute.MappingMethodListAttribute;
import com.blazebit.persistence.view.impl.metamodel.attribute.MappingMethodMapAttribute;
import com.blazebit.persistence.view.impl.metamodel.attribute.MappingMethodSetAttribute;
import com.blazebit.persistence.view.impl.metamodel.attribute.MappingMethodSingularAttribute;
import com.blazebit.persistence.view.impl.metamodel.attribute.SubqueryMethodSingularAttribute;
import com.blazebit.persistence.view.spi.EntityViewMethodAttributeMapping;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;

public class MethodAttributeMapping
extends AttributeMapping
implements EntityViewMethodAttributeMapping {
    private final String attributeName;
    private final Method method;
    private Boolean isUpdatable;
    private Boolean isOrphanRemoval;
    private Boolean isOptimisticLockProtected;
    private String mappedBy;
    private Map<EmbeddableOwner, String> embeddableMappedByMap;
    private InverseRemoveStrategy inverseRemoveStrategy;
    private Set<CascadeType> cascadeTypes = Collections.singleton(CascadeType.AUTO);
    private Set<Class<?>> cascadeSubtypeClasses;
    private Set<Class<?>> cascadePersistSubtypeClasses;
    private Set<Class<?>> cascadeUpdateSubtypeClasses;
    private Map<ViewMapping, Boolean> readOnlySubtypeMappings;
    private Map<ViewMapping, Boolean> cascadeSubtypeMappings;
    private Map<ViewMapping, Boolean> cascadePersistSubtypeMappings;
    private Map<ViewMapping, Boolean> cascadeUpdateSubtypeMappings;
    private Set<ManagedViewTypeImplementor<?>> readOnlySubtypes;
    private Set<ManagedViewTypeImplementor<?>> cascadeSubtypes;
    private Set<ManagedViewTypeImplementor<?>> cascadePersistSubtypes;
    private Set<ManagedViewTypeImplementor<?>> cascadeUpdateSubtypes;
    private Map<EmbeddableOwner, Set<ManagedViewTypeImplementor<?>>> embeddableReadOnlySubtypesMap;
    private Map<EmbeddableOwner, Set<ManagedViewTypeImplementor<?>>> embeddableCascadeSubtypesMap;
    private Map<EmbeddableOwner, Set<ManagedViewTypeImplementor<?>>> embeddableCascadePersistSubtypesMap;
    private Map<EmbeddableOwner, Set<ManagedViewTypeImplementor<?>>> embeddableCascadeUpdateSubtypesMap;

    public MethodAttributeMapping(ViewMapping viewMapping, Annotation mapping, MetamodelBootContext context, String attributeName, Method method, boolean isCollection, Class<?> declaredTypeClass, Class<?> declaredKeyTypeClass, Class declaredElementTypeClass, Type type, Type keyType, Type elementType, Map<Class<?>, String> inheritanceSubtypeClassMappings, Map<Class<?>, String> keyInheritanceSubtypeClassMappings, Map<Class<?>, String> elementInheritanceSubtypeClassMappings) {
        super(viewMapping, mapping, context, isCollection, declaredTypeClass, declaredKeyTypeClass, declaredElementTypeClass, type, keyType, elementType, inheritanceSubtypeClassMappings, keyInheritanceSubtypeClassMappings, elementInheritanceSubtypeClassMappings);
        this.attributeName = attributeName;
        this.method = method;
    }

    public ViewMapping getDeclaringView() {
        return this.viewMapping;
    }

    public String getName() {
        return this.attributeName;
    }

    public Method getMethod() {
        return this.method;
    }

    public Boolean getUpdatable() {
        return this.isUpdatable;
    }

    public Boolean getOrphanRemoval() {
        return this.isOrphanRemoval;
    }

    public Boolean getOptimisticLockProtected() {
        return this.isOptimisticLockProtected;
    }

    @Override
    public boolean isId() {
        return this.viewMapping.getIdAttribute() == this;
    }

    @Override
    public boolean isVersion() {
        return this.viewMapping.getVersionAttribute() == this;
    }

    public Set<CascadeType> getCascadeTypes() {
        return this.cascadeTypes;
    }

    public void setUpdatable(boolean updatable, boolean orphanRemoval, CascadeType[] cascadeTypes, Class<?>[] subtypes, Class<?>[] persistSubtypes, Class<?>[] updateSubtypes) {
        this.isUpdatable = updatable;
        this.isOrphanRemoval = orphanRemoval;
        this.cascadeTypes = new HashSet<CascadeType>(Arrays.asList(cascadeTypes));
        this.cascadeSubtypeClasses = new HashSet(Arrays.asList(subtypes));
        this.cascadePersistSubtypeClasses = new HashSet(Arrays.asList(persistSubtypes));
        this.cascadeUpdateSubtypeClasses = new HashSet(Arrays.asList(updateSubtypes));
    }

    public void setOptimisticLockProtected(Boolean optimisticLockProtected) {
        this.isOptimisticLockProtected = optimisticLockProtected;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    @Override
    public InverseRemoveStrategy getInverseRemoveStrategy() {
        return this.inverseRemoveStrategy;
    }

    public void setInverseRemoveStrategy(InverseRemoveStrategy inverseRemoveStrategy) {
        if (inverseRemoveStrategy == null) {
            throw new IllegalArgumentException("Invalid null remove strategy!");
        }
        this.inverseRemoveStrategy = inverseRemoveStrategy;
    }

    public Set<ManagedViewTypeImplementor<?>> getReadOnlySubtypes(MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        Set<Object> subtypes;
        Set<ManagedViewTypeImplementor<?>> readOnlySubtypes;
        if (embeddableMapping == null) {
            readOnlySubtypes = this.readOnlySubtypes;
        } else {
            if (this.embeddableReadOnlySubtypesMap == null) {
                this.embeddableReadOnlySubtypesMap = new HashMap(1);
            }
            readOnlySubtypes = this.embeddableReadOnlySubtypesMap.get(embeddableMapping);
        }
        if (readOnlySubtypes != null) {
            return readOnlySubtypes;
        }
        com.blazebit.persistence.view.metamodel.Type<?> elementType = this.getElementType(context, embeddableMapping);
        if (elementType == null) {
            elementType = this.getType(context, embeddableMapping);
        }
        if (this.readOnlySubtypeMappings == null || this.readOnlySubtypeMappings.isEmpty()) {
            subtypes = elementType instanceof ManagedViewTypeImplementor ? Collections.singleton((ManagedViewTypeImplementor)elementType) : Collections.emptySet();
        } else {
            subtypes = this.initializeReadOnlyCascadeSubtypes(this.readOnlySubtypeMappings, context, embeddableMapping);
            if (elementType instanceof ManagedViewTypeImplementor) {
                subtypes.add((ManagedViewTypeImplementor)elementType);
            }
        }
        if (embeddableMapping == null) {
            this.readOnlySubtypes = subtypes;
        } else {
            this.embeddableReadOnlySubtypesMap.put(embeddableMapping, subtypes);
        }
        return subtypes;
    }

    public Set<ManagedViewTypeImplementor<?>> getCascadeSubtypes(MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        Set<ManagedViewTypeImplementor<?>> cascadeSubtypes;
        if (embeddableMapping == null) {
            if (this.cascadeSubtypes != null) {
                return this.cascadeSubtypes;
            }
            this.cascadeSubtypes = this.initializeCascadeSubtypes(this.cascadeSubtypeMappings, context, embeddableMapping);
            return this.cascadeSubtypes;
        }
        if (this.embeddableCascadeSubtypesMap == null) {
            this.embeddableCascadeSubtypesMap = new HashMap(1);
        }
        if ((cascadeSubtypes = this.embeddableCascadeSubtypesMap.get(embeddableMapping)) != null) {
            return cascadeSubtypes;
        }
        cascadeSubtypes = this.initializeCascadeSubtypes(this.cascadeSubtypeMappings, context, embeddableMapping);
        this.embeddableCascadeSubtypesMap.put(embeddableMapping, cascadeSubtypes);
        return cascadeSubtypes;
    }

    public Set<ManagedViewTypeImplementor<?>> getCascadePersistSubtypes(MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        Set<ManagedViewTypeImplementor<?>> cascadePersistSubtypes;
        if (embeddableMapping == null) {
            if (this.cascadePersistSubtypes != null) {
                return this.cascadePersistSubtypes;
            }
            this.cascadePersistSubtypes = this.initializeCascadeSubtypes(this.cascadePersistSubtypeMappings, context, embeddableMapping);
            return this.cascadePersistSubtypes;
        }
        if (this.embeddableCascadePersistSubtypesMap == null) {
            this.embeddableCascadePersistSubtypesMap = new HashMap(1);
        }
        if ((cascadePersistSubtypes = this.embeddableCascadePersistSubtypesMap.get(embeddableMapping)) != null) {
            return cascadePersistSubtypes;
        }
        cascadePersistSubtypes = this.initializeCascadeSubtypes(this.cascadePersistSubtypeMappings, context, embeddableMapping);
        this.embeddableCascadePersistSubtypesMap.put(embeddableMapping, cascadePersistSubtypes);
        return cascadePersistSubtypes;
    }

    public Set<ManagedViewTypeImplementor<?>> getCascadeUpdateSubtypes(MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        Set<ManagedViewTypeImplementor<?>> cascadeUpdateSubtypes;
        if (embeddableMapping == null) {
            if (this.cascadeUpdateSubtypes != null) {
                return this.cascadeUpdateSubtypes;
            }
            this.cascadeUpdateSubtypes = this.initializeCascadeSubtypes(this.cascadeUpdateSubtypeMappings, context, embeddableMapping);
            return this.cascadeUpdateSubtypes;
        }
        if (this.embeddableCascadeUpdateSubtypesMap == null) {
            this.embeddableCascadeUpdateSubtypesMap = new HashMap(1);
        }
        if ((cascadeUpdateSubtypes = this.embeddableCascadeUpdateSubtypesMap.get(embeddableMapping)) != null) {
            return cascadeUpdateSubtypes;
        }
        cascadeUpdateSubtypes = this.initializeCascadeSubtypes(this.cascadeUpdateSubtypeMappings, context, embeddableMapping);
        this.embeddableCascadeUpdateSubtypesMap.put(embeddableMapping, cascadeUpdateSubtypes);
        return cascadeUpdateSubtypes;
    }

    private Set<ManagedViewTypeImplementor<?>> initializeReadOnlyCascadeSubtypes(Map<ViewMapping, Boolean> subtypeMappings, final MetamodelBuildingContext context, final EmbeddableOwner embeddableMapping) {
        if (subtypeMappings == null || subtypeMappings.isEmpty()) {
            return Collections.emptySet();
        }
        final Set<ManagedViewTypeImplementor<?>> subtypes = Collections.newSetFromMap(new ConcurrentHashMap(subtypeMappings.size()));
        for (final ViewMapping mapping : subtypeMappings.keySet()) {
            mapping.onInitializeViewMappingsFinished(new Runnable(){

                @Override
                public void run() {
                    subtypes.add(context.getManagedViewType(mapping, embeddableMapping));
                }
            });
        }
        return subtypes;
    }

    private Set<ManagedViewTypeImplementor<?>> initializeCascadeSubtypes(Map<ViewMapping, Boolean> subtypeMappings, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        if (subtypeMappings == null || subtypeMappings.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet subtypes = new HashSet(subtypeMappings.size());
        for (ViewMapping mapping : subtypeMappings.keySet()) {
            subtypes.add(context.getManagedViewType(mapping, embeddableMapping));
        }
        return subtypes;
    }

    @Override
    public String getErrorLocation() {
        return MethodAttributeMapping.getLocation(this.attributeName, this.method);
    }

    public static String getLocation(String attributeName, Method method) {
        return "attribute " + attributeName + "[" + MethodAttributeMapping.methodReference(method) + "]";
    }

    public boolean hasExplicitCascades() {
        return !MethodAttributeMapping.isEmpty(this.cascadeSubtypeClasses) || !MethodAttributeMapping.isEmpty(this.cascadePersistSubtypeClasses) || !MethodAttributeMapping.isEmpty(this.cascadeUpdateSubtypeClasses);
    }

    @Override
    public void initializeViewMappings(MetamodelBuildingContext context) {
        super.initializeViewMappings(context);
        if (this.mapping.annotationType() == MappingParameter.class) {
            return;
        }
        if (MethodAttributeMapping.isEmpty(this.cascadeSubtypeClasses) && MethodAttributeMapping.isEmpty(this.cascadePersistSubtypeClasses) && MethodAttributeMapping.isEmpty(this.cascadeUpdateSubtypeClasses)) {
            ViewMapping attributeViewMapping;
            Method setter = ReflectionUtils.getSetter((Class)this.getDeclaringView().getEntityViewClass(), (String)this.getName());
            boolean hasSetter = setter != null && (setter.getModifiers() & 0x400) != 0;
            boolean isCollection = false;
            if (this.elementViewMapping == null) {
                attributeViewMapping = this.typeMapping;
            } else {
                attributeViewMapping = this.elementViewMapping;
                isCollection = true;
            }
            this.readOnlySubtypeMappings = Collections.emptyMap();
            this.cascadeSubtypeMappings = Collections.emptyMap();
            this.cascadePersistSubtypeMappings = Collections.emptyMap();
            this.cascadeUpdateSubtypeMappings = Collections.emptyMap();
            if (attributeViewMapping != null) {
                boolean allowCreatable;
                ManagedType<?> managedType = attributeViewMapping.getManagedType(context);
                boolean allowMultiParent = managedType != null && managedType.getPersistenceType() == Type.PersistenceType.EMBEDDABLE;
                boolean bl = allowCreatable = attributeViewMapping.isCreatable(context) || this.cascadeTypes.contains(CascadeType.PERSIST) || this.cascadeTypes.contains(CascadeType.AUTO) && hasSetter && allowMultiParent;
                if (this.isUpdatable != Boolean.FALSE && this.getDeclaringView().isUpdatable()) {
                    boolean allowUpdatable;
                    boolean bl2 = allowUpdatable = attributeViewMapping.isUpdatable() || this.cascadeTypes.contains(CascadeType.UPDATE) || this.cascadeTypes.contains(CascadeType.AUTO) && hasSetter && allowMultiParent;
                    if (hasSetter || isCollection) {
                        this.readOnlySubtypeMappings = this.initializeDependentSubtypeMappingsAuto(context, attributeViewMapping.getEntityViewClass(), true, !allowUpdatable, !allowCreatable, false);
                    }
                    if (hasSetter || isCollection && allowCreatable) {
                        this.cascadeSubtypeMappings = this.initializeDependentSubtypeMappingsAuto(context, attributeViewMapping.getEntityViewClass(), true, allowUpdatable, allowCreatable, true);
                    }
                } else if (this.getDeclaringView().isCreatable(context)) {
                    if (hasSetter || isCollection) {
                        this.readOnlySubtypeMappings = this.initializeDependentSubtypeMappingsAuto(context, attributeViewMapping.getEntityViewClass(), true, true, !allowCreatable, false);
                    }
                    if (hasSetter || isCollection && allowCreatable) {
                        this.cascadePersistSubtypeMappings = this.initializeDependentSubtypeMappingsAuto(context, attributeViewMapping.getEntityViewClass(), false, false, allowCreatable, true);
                    }
                }
            }
        } else if (this.isUpdatable == Boolean.TRUE) {
            this.readOnlySubtypeMappings = this.initializeDependentSubtypeMappings(context, this.cascadeSubtypeClasses, true);
            this.cascadeSubtypeMappings = this.initializeDependentSubtypeMappings(context, this.cascadeSubtypeClasses, false);
            this.cascadePersistSubtypeMappings = this.initializeDependentSubtypeMappings(context, this.cascadePersistSubtypeClasses, false);
            this.cascadeUpdateSubtypeMappings = this.initializeDependentSubtypeMappings(context, this.cascadeUpdateSubtypeClasses, false);
        }
    }

    private static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    @Override
    public boolean validateDependencies(MetamodelBuildingContext context, Set<Class<?>> dependencies, boolean reportError) {
        if (this.mapping.annotationType() == MappingParameter.class) {
            return false;
        }
        boolean error = super.validateDependencies(context, dependencies, reportError);
        if (error && !reportError) {
            return true;
        }
        if ((error |= this.validateCascadeSubtypeMappings(context, dependencies, this.cascadeSubtypeMappings, reportError)) && !reportError) {
            return true;
        }
        if ((error |= this.validateCascadeSubtypeMappings(context, dependencies, this.cascadePersistSubtypeMappings, reportError)) && !reportError) {
            return true;
        }
        if ((error |= this.validateCascadeSubtypeMappings(context, dependencies, this.cascadeUpdateSubtypeMappings, reportError)) && !reportError) {
            return true;
        }
        return error;
    }

    @Override
    public boolean determineDisallowOwnedUpdatableSubview(MetamodelBuildingContext context, EmbeddableOwner embeddableMapping, Attribute<?, ?> updateMappableAttribute) {
        String mappedBy;
        if (this.disallowOwnedUpdatableSubview != null) {
            return this.disallowOwnedUpdatableSubview;
        }
        if (embeddableMapping == null) {
            mappedBy = this.mappedBy;
        } else {
            if (this.embeddableMappedByMap == null) {
                this.embeddableMappedByMap = new HashMap<EmbeddableOwner, String>(1);
            }
            mappedBy = this.embeddableMappedByMap.get(embeddableMapping);
        }
        this.disallowOwnedUpdatableSubview = this.isCollection || mappedBy != null && !mappedBy.isEmpty() || updateMappableAttribute != null && updateMappableAttribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
        return this.disallowOwnedUpdatableSubview;
    }

    @Override
    public String determineMappedBy(ManagedType<?> managedType, String mapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        String mappedBy;
        if (embeddableMapping == null) {
            mappedBy = this.mappedBy;
        } else {
            if (this.embeddableMappedByMap == null) {
                this.embeddableMappedByMap = new HashMap<EmbeddableOwner, String>(1);
            }
            mappedBy = this.embeddableMappedByMap.get(embeddableMapping);
        }
        if (mappedBy != null) {
            if (mappedBy.isEmpty()) {
                return null;
            }
            return mappedBy;
        }
        if (embeddableMapping == null) {
            this.mappedBy = "";
        } else {
            this.embeddableMappedByMap.put(embeddableMapping, "");
        }
        if (mapping == null || mapping.isEmpty()) {
            return null;
        }
        if (!(managedType instanceof EntityType)) {
            return null;
        }
        try {
            AttributePath basicAttributePath = context.getJpaProvider().getJpaMetamodelAccessor().getAttributePath((Metamodel)context.getEntityMetamodel(), managedType, mapping);
            List attributes = basicAttributePath.getAttributes();
            for (int i = 1; i < attributes.size(); ++i) {
                if (((Attribute)attributes.get(i)).getDeclaringType().getPersistenceType() == Type.PersistenceType.EMBEDDABLE) continue;
                return null;
            }
            mappedBy = context.getJpaProvider().getMappedBy((EntityType)managedType, mapping);
            if (embeddableMapping == null) {
                this.mappedBy = mappedBy;
            } else {
                this.embeddableMappedByMap.put(embeddableMapping, mappedBy);
            }
            return mappedBy;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Override
    public Map<String, String> determineWritableMappedByMappings(ManagedType<?> managedType, String mappedBy, MetamodelBuildingContext context) {
        Class<?> declaredElementType;
        ViewMapping elementViewMapping = this.getElementViewMapping();
        EntityType elementType = elementViewMapping != null ? context.getEntityMetamodel().getEntity(elementViewMapping.getEntityClass()) : ((declaredElementType = this.getDeclaredElementType()) != null ? context.getEntityMetamodel().getEntity(declaredElementType) : context.getEntityMetamodel().getEntity(this.getDeclaredType()));
        if (elementType == null) {
            return null;
        }
        EntityType entityType = (EntityType)managedType;
        try {
            Map writableMappedByMappings = context.getJpaProvider().getWritableMappedByMappings(entityType, elementType, mappedBy, ((Mapping)this.mapping).value());
            if (writableMappedByMappings == null) {
                return null;
            }
            return Collections.unmodifiableMap(writableMappedByMappings);
        }
        catch (RuntimeException ex) {
            context.addError("Couldn't determine writable mappings for the mapped by mapping '" + mappedBy + "' on the entity '" + elementType.getName() + "' declared by the entity '" + entityType.getName() + "' through a entity view mapping at the " + this.getErrorLocation());
            return null;
        }
    }

    private boolean validateCascadeSubtypeMappings(MetamodelBuildingContext context, Set<Class<?>> dependencies, Map<ViewMapping, Boolean> mappings, boolean reportError) {
        if (mappings == null || mappings.isEmpty()) {
            return false;
        }
        boolean error = false;
        Iterator<Map.Entry<ViewMapping, Boolean>> iterator = mappings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ViewMapping, Boolean> entry = iterator.next();
            ViewMapping mapping = entry.getKey();
            if (!mapping.validateDependencies(context, dependencies, this, null, entry.getValue() == Boolean.TRUE)) continue;
            iterator.remove();
            if (entry.getValue() != Boolean.TRUE) continue;
            error = true;
            if (reportError) continue;
            return true;
        }
        return error;
    }

    private Map<ViewMapping, Boolean> initializeDependentSubtypeMappings(MetamodelBuildingContext context, Set<Class<?>> subtypes, boolean readOnly) {
        if (subtypes.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<ViewMapping, Boolean> subtypeMappings = new HashMap<ViewMapping, Boolean>(subtypes.size());
        for (Class<?> type : subtypes) {
            ViewMapping subtypeMapping = context.getViewMapping(type);
            if (subtypeMapping == null) {
                this.unknownSubviewType(type);
                continue;
            }
            if (readOnly && (subtypeMapping.isUpdatable() || subtypeMapping.isCreatable(context))) continue;
            subtypeMapping.initializeViewMappings(context, null);
            subtypeMappings.put(subtypeMapping, Boolean.TRUE);
        }
        return subtypeMappings;
    }

    private Map<ViewMapping, Boolean> initializeDependentSubtypeMappingsAuto(final MetamodelBuildingContext context, final Class<?> clazz, boolean allowReadOnly, boolean allowUpdatable, boolean allowCreatable, final boolean removeCycles) {
        Set<Class<?>> subtypes = context.findSubtypes(clazz);
        if (subtypes.size() == 0) {
            return Collections.emptyMap();
        }
        final HashMap<ViewMapping, Boolean> subtypeMappings = new HashMap<ViewMapping, Boolean>(subtypes.size());
        for (Class<?> type : subtypes) {
            final ViewMapping subtypeMapping = context.getViewMapping(type);
            if (subtypeMapping == null) {
                this.unknownSubviewType(type);
                continue;
            }
            if (!MethodAttributeMapping.allowSubtype(context, subtypeMapping, allowReadOnly, allowUpdatable, allowCreatable)) continue;
            this.viewMapping.onInitializeViewMappingsFinished(new Runnable(){

                @Override
                public void run() {
                    subtypeMapping.onInitializeViewMappingsFinished(new Runnable(){

                        @Override
                        public void run() {
                            HashSet dependencies = new HashSet();
                            dependencies.add(MethodAttributeMapping.this.getDeclaringView().getEntityViewClass());
                            dependencies.add(clazz);
                            if (!removeCycles || !subtypeMapping.validateDependencies(context, dependencies, MethodAttributeMapping.this, clazz, false)) {
                                subtypeMappings.put(subtypeMapping, Boolean.FALSE);
                            }
                        }
                    });
                }
            });
        }
        return subtypeMappings;
    }

    private static boolean allowSubtype(MetamodelBuildingContext context, ViewMapping subtypeMapping, boolean allowReadOnly, boolean allowUpdatable, boolean allowCreatable) {
        if (allowUpdatable && subtypeMapping.isUpdatable() && allowCreatable == subtypeMapping.isCreatable(context)) {
            return true;
        }
        if (allowCreatable && subtypeMapping.isCreatable(context)) {
            return true;
        }
        return allowReadOnly && !subtypeMapping.isUpdatable() && !subtypeMapping.isCreatable(context);
    }

    public MethodAttributeMapping handleReplacement(AttributeMapping original) {
        if (original == null) {
            return this;
        }
        if (!(original instanceof MethodAttributeMapping)) {
            throw new IllegalStateException("Tried to replace attribute [" + original + "] with method attribute: " + this);
        }
        MethodAttributeMapping originalAttribute = (MethodAttributeMapping)original;
        if (this.mapping.equals(originalAttribute.getMapping())) {
            return originalAttribute;
        }
        if (this.method.getDeclaringClass() != originalAttribute.getMethod().getDeclaringClass() && this.method.getDeclaringClass().isAssignableFrom(originalAttribute.getMethod().getDeclaringClass())) {
            return originalAttribute;
        }
        if (originalAttribute.getMapping() instanceof MappingLiteral) {
            return this;
        }
        this.context.addError("Conflicting attribute mapping for attribute '" + this.attributeName + "' at the methods [" + MethodAttributeMapping.methodReference(this.method) + ", " + MethodAttributeMapping.methodReference(originalAttribute.getMethod()) + "] for managed view type '" + this.viewMapping.getEntityViewClass().getName() + "'");
        return originalAttribute;
    }

    private static String methodReference(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    public <X> AbstractMethodAttribute<? super X, ?> getMethodAttribute(ManagedViewTypeImplementor<X> viewType, int attributeIndex, int dirtyStateIndex, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        AbstractMethodAttribute attribute;
        if (embeddableMapping == null) {
            attribute = this.attribute;
        } else {
            if (this.embeddableAttributeMap == null) {
                this.embeddableAttributeMap = new HashMap(1);
            }
            attribute = (AbstractAttribute)this.embeddableAttributeMap.get(embeddableMapping);
        }
        if (attribute == null) {
            boolean correlated;
            if (this.mapping instanceof MappingParameter) {
                if (embeddableMapping == null) {
                    this.mappedBy = "";
                } else {
                    if (this.embeddableMappedByMap == null) {
                        this.embeddableMappedByMap = new HashMap<EmbeddableOwner, String>(1);
                    }
                    this.embeddableMappedByMap.put(embeddableMapping, "");
                }
                attribute = new MappingMethodSingularAttribute(viewType, this, context, attributeIndex, dirtyStateIndex, embeddableMapping);
                return attribute;
            }
            boolean bl = correlated = this.mapping instanceof MappingCorrelated || this.mapping instanceof MappingCorrelatedSimple;
            if (this.isCollection) {
                if (Collection.class == this.declaredTypeClass) {
                    attribute = correlated ? new CorrelatedMethodCollectionAttribute(viewType, this, context, attributeIndex, dirtyStateIndex, embeddableMapping) : new MappingMethodCollectionAttribute(viewType, this, context, attributeIndex, dirtyStateIndex, embeddableMapping);
                } else if (List.class == this.declaredTypeClass) {
                    attribute = correlated ? new CorrelatedMethodListAttribute(viewType, this, context, attributeIndex, dirtyStateIndex, embeddableMapping) : new MappingMethodListAttribute(viewType, this, context, attributeIndex, dirtyStateIndex, embeddableMapping);
                } else if (Set.class == this.declaredTypeClass || SortedSet.class == this.declaredTypeClass || NavigableSet.class == this.declaredTypeClass) {
                    attribute = correlated ? new CorrelatedMethodSetAttribute(viewType, this, context, attributeIndex, dirtyStateIndex, embeddableMapping) : new MappingMethodSetAttribute(viewType, this, context, attributeIndex, dirtyStateIndex, embeddableMapping);
                } else if (Map.class == this.declaredTypeClass || SortedMap.class == this.declaredTypeClass || NavigableMap.class == this.declaredTypeClass) {
                    if (correlated) {
                        context.addError("The mapping defined on method '" + viewType.getJavaType().getName() + "." + this.method.getName() + "' uses a Map type with a correlated mapping which is unsupported!");
                        attribute = null;
                    } else {
                        attribute = new MappingMethodMapAttribute(viewType, this, context, attributeIndex, dirtyStateIndex, embeddableMapping);
                    }
                } else {
                    context.addError("The mapping defined on method '" + viewType.getJavaType().getName() + "." + this.method.getName() + "' uses a an unknown collection type: " + this.declaredTypeClass);
                }
            } else {
                attribute = this.mapping instanceof MappingSubquery ? new SubqueryMethodSingularAttribute(viewType, this, context, attributeIndex, dirtyStateIndex) : (correlated ? new CorrelatedMethodSingularAttribute(viewType, this, context, attributeIndex, dirtyStateIndex, embeddableMapping) : new MappingMethodSingularAttribute(viewType, this, context, attributeIndex, dirtyStateIndex, embeddableMapping));
            }
        } else if (dirtyStateIndex != -1) {
            throw new IllegalStateException("Already constructed attribute with dirtyStateIndex " + ((AbstractMethodAttribute)attribute).getDirtyStateIndex() + " but now a different index " + dirtyStateIndex + " is requested!");
        }
        if (embeddableMapping == null) {
            this.attribute = attribute;
        } else {
            this.embeddableAttributeMap.put(embeddableMapping, attribute);
        }
        return attribute;
    }
}

