/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import com.blazebit.persistence.CTEBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.view.CTEProvider;
import com.blazebit.persistence.view.impl.objectbuilder.ViewTypeObjectBuilderTemplate;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.TupleElementMapper;
import com.blazebit.persistence.view.impl.proxy.ObjectInstantiator;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewTypeObjectBuilder<T>
implements ObjectBuilder<T> {
    final boolean hasId;
    final boolean nullIfEmpty;
    private final ObjectInstantiator<T> objectInstantiator;
    private final TupleElementMapper[] mappers;
    private final ParameterHolder<?> parameterHolder;
    private final Map<String, Object> optionalParameters;
    private final EmbeddingViewJpqlMacro embeddingViewJpqlMacro;
    private final Set<String> fetches;
    private final Set<CTEProvider> cteProviders;

    public ViewTypeObjectBuilder(ViewTypeObjectBuilderTemplate<T> template, ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, EmbeddingViewJpqlMacro embeddingViewJpqlMacro, Set<String> fetches, boolean nullIfEmpty) {
        this.hasId = template.hasId();
        this.objectInstantiator = template.getObjectInstantiator();
        this.mappers = template.getMappers();
        this.parameterHolder = parameterHolder;
        this.optionalParameters = optionalParameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(optionalParameters);
        this.embeddingViewJpqlMacro = embeddingViewJpqlMacro;
        this.fetches = fetches;
        this.nullIfEmpty = nullIfEmpty;
        this.cteProviders = template.getViewRoot().getCteProviders();
    }

    public T build(Object[] tuple) {
        if (this.hasId) {
            if (tuple[0] == null) {
                return null;
            }
        } else if (this.nullIfEmpty) {
            for (int i = 0; i < tuple.length; ++i) {
                if (tuple[i] == null) continue;
                return this.objectInstantiator.newInstance(tuple);
            }
            return null;
        }
        return this.objectInstantiator.newInstance(tuple);
    }

    public List<T> buildList(List<T> list) {
        return list;
    }

    public <X extends SelectBuilder<X>> void applySelects(X queryBuilder) {
        if (this.cteProviders != null && queryBuilder instanceof CTEBuilder) {
            CTEBuilder cteBuilder = (CTEBuilder)queryBuilder;
            for (CTEProvider cteProvider : this.cteProviders) {
                cteProvider.applyCtes(cteBuilder, this.optionalParameters);
            }
        }
        if (this.fetches.isEmpty()) {
            for (int i = 0; i < this.mappers.length; ++i) {
                this.mappers[i].applyMapping(queryBuilder, this.parameterHolder, this.optionalParameters, this.embeddingViewJpqlMacro);
            }
        } else {
            for (int i = 0; i < this.mappers.length; ++i) {
                TupleElementMapper mapper = this.mappers[i];
                if (this.fetches.contains(mapper.getAttributePath())) {
                    mapper.applyMapping(queryBuilder, this.parameterHolder, this.optionalParameters, this.embeddingViewJpqlMacro);
                    continue;
                }
                queryBuilder.select("NULL");
            }
        }
    }
}

