/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.mapper;

import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.view.impl.CorrelationProviderHelper;
import com.blazebit.persistence.view.impl.PrefixingQueryGenerator;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.AliasedTupleElementMapper;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import java.util.Collections;

public abstract class AbstractCorrelationJoinTupleElementMapper
implements AliasedTupleElementMapper {
    protected final String correlationBasis;
    protected final String correlationResult;
    protected final String correlationAlias;
    protected final String joinBase;
    protected final String alias;
    protected final String attributePath;
    protected final String embeddingViewPath;
    protected final String[] fetches;

    public AbstractCorrelationJoinTupleElementMapper(ExpressionFactory ef, String joinBase, String correlationBasis, String correlationResult, String alias, String attributePath, String embeddingViewPath, String[] fetches) {
        this.correlationBasis = correlationBasis.intern();
        this.alias = alias;
        this.attributePath = attributePath;
        this.embeddingViewPath = embeddingViewPath;
        this.fetches = fetches;
        this.joinBase = joinBase.intern();
        this.correlationAlias = CorrelationProviderHelper.getDefaultCorrelationAlias(attributePath);
        if (correlationResult.isEmpty()) {
            this.correlationResult = this.correlationAlias;
        } else {
            StringBuilder sb = new StringBuilder(this.correlationAlias.length() + correlationResult.length() + 1);
            EmbeddingViewJpqlMacro embeddingViewJpqlMacro = (EmbeddingViewJpqlMacro)ef.getDefaultMacroConfiguration().get("EMBEDDING_VIEW").getState()[0];
            String oldEmbeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
            embeddingViewJpqlMacro.setEmbeddingViewPath(embeddingViewPath);
            Expression expr = ef.createSimpleExpression(correlationResult, false, false, true);
            embeddingViewJpqlMacro.setEmbeddingViewPath(oldEmbeddingViewPath);
            PrefixingQueryGenerator generator = new PrefixingQueryGenerator(Collections.singletonList(this.correlationAlias), joinBase, null, null);
            generator.setQueryBuffer(sb);
            expr.accept((Expression.Visitor)generator);
            this.correlationResult = sb.toString().intern();
        }
    }

    @Override
    public String getAttributePath() {
        return this.attributePath;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }
}

