/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.mapper;

import com.blazebit.persistence.FetchBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.TupleElementMapper;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import java.util.Map;

public class ExpressionTupleElementMapper
implements TupleElementMapper {
    private static final String[] EMPTY = new String[0];
    protected final String expression;
    protected final String attributePath;
    protected final String embeddingViewPath;
    protected final String[] fetches;

    public ExpressionTupleElementMapper(String expression, String attributePath, String embeddingViewPath) {
        this.expression = expression.intern();
        this.attributePath = attributePath;
        this.embeddingViewPath = embeddingViewPath;
        this.fetches = EMPTY;
    }

    public ExpressionTupleElementMapper(String expression, String attributePath, String embeddingViewPath, String[] fetches) {
        this.expression = expression.intern();
        this.attributePath = attributePath;
        this.embeddingViewPath = embeddingViewPath;
        this.fetches = fetches;
    }

    @Override
    public void applyMapping(SelectBuilder<?> queryBuilder, ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, EmbeddingViewJpqlMacro embeddingViewJpqlMacro) {
        String oldEmbeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
        embeddingViewJpqlMacro.setEmbeddingViewPath(this.embeddingViewPath);
        queryBuilder.select(this.expression);
        if (this.fetches.length != 0) {
            FetchBuilder fetchBuilder = (FetchBuilder)queryBuilder;
            for (int i = 0; i < this.fetches.length; ++i) {
                fetchBuilder.fetch(this.fetches[i]);
            }
        }
        embeddingViewJpqlMacro.setEmbeddingViewPath(oldEmbeddingViewPath);
    }

    @Override
    public String getAttributePath() {
        return this.attributePath;
    }
}

