/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.mapper;

import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.view.impl.PrefixingQueryGenerator;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.ExpressionTupleElementMapper;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.TupleElementMapper;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformatorFactory;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformerFactory;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformerFactory;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.ParameterAttribute;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;

public class TupleElementMapperBuilder {
    private static final ExpressionTupleElementMapper NULL_MAPPER = new ExpressionTupleElementMapper("NULL", null, null, new String[0]);
    private final int mapperIndex;
    private final String aliasPrefix;
    private final String mappingPrefix;
    private final String idPrefix;
    private final EntityType<?> treatType;
    private final EntityMetamodel metamodel;
    private final ExpressionFactory ef;
    private final String constraint;
    private final Integer subtypeIndex;
    private final List<TupleElementMapper> mappers;
    private final List<String> parameterMappings;
    private final TupleTransformatorFactory tupleTransformatorFactory;

    public TupleElementMapperBuilder(int mapperIndex, String constraint, Integer subtypeIndex, String aliasPrefix, String mappingPrefix, String idPrefix, EntityType<?> treatType, EntityMetamodel metamodel, ExpressionFactory ef) {
        this(mapperIndex, constraint, subtypeIndex, aliasPrefix, mappingPrefix, idPrefix, treatType, metamodel, ef, new ArrayList<TupleElementMapper>(), new ArrayList<String>(), new TupleTransformatorFactory());
    }

    public TupleElementMapperBuilder(int mapperIndex, String constraint, Integer subtypeIndex, String aliasPrefix, String mappingPrefix, String idPrefix, EntityType<?> treatType, EntityMetamodel metamodel, ExpressionFactory ef, List<TupleElementMapper> mappers, List<String> parameterMappings, TupleTransformatorFactory tupleTransformatorFactory) {
        this.mapperIndex = mapperIndex;
        this.constraint = constraint;
        this.subtypeIndex = subtypeIndex;
        this.aliasPrefix = aliasPrefix;
        this.mappingPrefix = treatType != null ? "TREAT(" + mappingPrefix + " AS " + treatType.getName() + ")" : mappingPrefix;
        this.idPrefix = idPrefix;
        this.treatType = treatType;
        this.metamodel = metamodel;
        this.ef = ef;
        this.mappers = mappers;
        this.parameterMappings = parameterMappings;
        this.tupleTransformatorFactory = tupleTransformatorFactory;
    }

    public String constraint() {
        return this.constraint;
    }

    public int mapperIndex() {
        return this.mapperIndex + this.mappers.size();
    }

    public void addMapper(TupleElementMapper mapper) {
        this.mappers.add(mapper);
        this.parameterMappings.add(null);
    }

    public void addMappers(TupleElementMapper[] mappers) {
        Collections.addAll(this.mappers, mappers);
        for (int i = 0; i < mappers.length; ++i) {
            this.parameterMappings.add(null);
        }
    }

    public List<TupleElementMapper> getMappers() {
        return this.mappers;
    }

    public void addQueryParam(String paramName) {
        this.mappers.add(NULL_MAPPER);
        this.parameterMappings.add(paramName);
    }

    public String getAlias(String attributeName) {
        return this.getAlias(this.aliasPrefix, attributeName);
    }

    private String getAlias(String prefix, String attributeName) {
        if (prefix == null) {
            return attributeName.intern();
        }
        return (prefix + "_" + attributeName).intern();
    }

    public String getAlias(Attribute<?, ?> attribute, boolean isKey) {
        return this.getAlias(this.aliasPrefix, attribute, isKey);
    }

    private String getAlias(String prefix, Attribute<?, ?> attribute, boolean isKey) {
        if (isKey) {
            prefix = prefix + "_key";
        }
        if (attribute instanceof MethodAttribute) {
            return this.getAlias(prefix, ((MethodAttribute)attribute).getName());
        }
        return this.getAlias(prefix, "$" + ((ParameterAttribute)attribute).getIndex());
    }

    public String getMapping(String mapping, Class<?> expressionType) {
        return this.getMapping(this.mappingPrefix, mapping, expressionType);
    }

    private String getMapping(String prefixParts, String mapping, Class<?> expressionType) {
        Set idAttributes;
        if (expressionType == null) {
            return this.getMapping(prefixParts, mapping);
        }
        ManagedType managedType = this.metamodel.getManagedType(expressionType);
        if (managedType == null || !JpaMetamodelUtils.isIdentifiable((ManagedType)managedType) || (idAttributes = JpaMetamodelUtils.getIdAttributes((IdentifiableType)((IdentifiableType)managedType))).size() > 1) {
            return this.getMapping(prefixParts, mapping);
        }
        SingularAttribute idAttr = (SingularAttribute)idAttributes.iterator().next();
        if (mapping.isEmpty()) {
            return this.getMapping(prefixParts, idAttr.getName());
        }
        return this.getMapping(prefixParts, mapping + '.' + idAttr.getName());
    }

    public String getMapping(String mapping) {
        return this.getMapping(this.mappingPrefix, mapping);
    }

    public String getMappingWithSkipAlias(String mapping, String skippedAlias) {
        StringBuilder sb = new StringBuilder();
        this.applyMapping(sb, this.mappingPrefix, mapping, skippedAlias);
        return sb.toString().intern();
    }

    private String getMapping(String prefixParts, String mapping) {
        StringBuilder sb = new StringBuilder();
        this.applyMapping(sb, prefixParts, mapping, null);
        return sb.toString().intern();
    }

    private void applyMapping(StringBuilder sb, String prefixParts, String mapping, String skippedAlias) {
        if (mapping.isEmpty()) {
            if (prefixParts != null && !prefixParts.isEmpty()) {
                sb.append(AbstractAttribute.stripThisFromMapping(prefixParts));
            }
            return;
        }
        if (prefixParts != null && !prefixParts.isEmpty()) {
            Expression expr = this.ef.createSimpleExpression(mapping, false, false, true);
            EmbeddingViewJpqlMacro embeddingViewJpqlMacro = (EmbeddingViewJpqlMacro)this.ef.getDefaultMacroConfiguration().get("EMBEDDING_VIEW").getState()[0];
            PrefixingQueryGenerator generator = new PrefixingQueryGenerator(Collections.singletonList(prefixParts), embeddingViewJpqlMacro.getEmbeddingViewPath(), "correlationEmbeddingViewAlias_", skippedAlias);
            generator.setQueryBuffer(sb);
            expr.accept((Expression.Visitor)generator);
        } else {
            sb.append(mapping);
        }
    }

    public String getMapping(MappingAttribute<?, ?> mappingAttribute) {
        return this.getMapping(this.mappingPrefix, mappingAttribute);
    }

    private String getMapping(String prefixParts, MappingAttribute<?, ?> mappingAttribute) {
        return this.getMapping(prefixParts, AbstractAttribute.stripThisFromMapping(mappingAttribute.getMapping()));
    }

    public String getIdMapping(MappingAttribute<?, ?> mappingAttribute, boolean isKey) {
        return this.getMapping(this.idPrefix, mappingAttribute, isKey);
    }

    public String getMapping(MappingAttribute<?, ?> mappingAttribute, boolean isKey) {
        return this.getMapping(this.mappingPrefix, mappingAttribute, isKey);
    }

    private String getMapping(String prefixParts, MappingAttribute<?, ?> mappingAttribute, boolean isKey) {
        StringBuilder sb = new StringBuilder();
        String mapping = AbstractAttribute.stripThisFromMapping(mappingAttribute.getMapping());
        if (isKey) {
            sb.append("KEY(");
        }
        this.applyMapping(sb, prefixParts, mapping, null);
        if (isKey) {
            sb.append(')');
        }
        return sb.toString().intern();
    }

    public String getJoinCorrelationAttributePath(String attributePath) {
        if (this.subtypeIndex == null) {
            return attributePath;
        }
        return attributePath + '_' + this.subtypeIndex;
    }

    public TupleTransformatorFactory getTupleTransformatorFactory() {
        return this.tupleTransformatorFactory;
    }

    public void setTupleListTransformer(TupleListTransformer tupleListTransformer) {
        this.tupleTransformatorFactory.add(tupleListTransformer);
    }

    public void setTupleListTransformerFactory(TupleListTransformerFactory tupleListTransformerFactory) {
        this.tupleTransformatorFactory.add(tupleListTransformerFactory);
    }

    public void addTupleTransformerFactory(TupleTransformerFactory tupleTransformerFactory) {
        this.tupleTransformatorFactory.add(tupleTransformerFactory);
    }

    public void addTupleTransformatorFactory(TupleTransformatorFactory tupleTransformatorFactory) {
        this.tupleTransformatorFactory.add(tupleTransformatorFactory);
    }
}

