/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformator;

import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.objectbuilder.ConstrainedTupleList;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformator;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformatorFactoryLevel;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformatorLevel;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.UpdatableViewMap;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformerFactory;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TupleTransformatorFactory {
    private final List<TupleTransformatorFactoryLevel> transformatorLevels = new ArrayList<TupleTransformatorFactoryLevel>();
    private int currentLevel = 0;

    public TupleTransformatorFactory() {
        this.transformatorLevels.add(new TupleTransformatorFactoryLevel());
    }

    public boolean hasTransformers() {
        return this.transformatorLevels.get((int)0).tupleListTransformer != null || this.transformatorLevels.get((int)0).tupleListTransformerFactory != null || this.transformatorLevels.get((int)0).tupleTransformerFactories.size() > 0;
    }

    public void add(TupleTransformatorFactory tupleTransformator) {
        if (!tupleTransformator.hasTransformers()) {
            return;
        }
        for (int i = 0; i < tupleTransformator.transformatorLevels.size(); ++i) {
            if (i != 0) {
                this.incrementLevel();
            }
            TupleTransformatorFactoryLevel thisLevel = this.transformatorLevels.get(this.currentLevel);
            TupleTransformatorFactoryLevel otherLevel = tupleTransformator.transformatorLevels.get(i);
            thisLevel.tupleTransformerFactories.addAll(otherLevel.tupleTransformerFactories);
            thisLevel.tupleListTransformer = otherLevel.tupleListTransformer;
            thisLevel.tupleListTransformerFactory = otherLevel.tupleListTransformerFactory;
        }
    }

    public void add(Map<Integer, Object> consumableIndexes, int classMappingIndex, int[] subtypeIndexes, TupleTransformatorFactory tupleTransformator) {
        if (!tupleTransformator.hasTransformers()) {
            return;
        }
        for (int i = 0; i < tupleTransformator.transformatorLevels.size(); ++i) {
            if (i != 0) {
                this.incrementLevel();
            }
            TupleTransformatorFactoryLevel thisLevel = this.transformatorLevels.get(this.currentLevel);
            TupleTransformatorFactoryLevel otherLevel = tupleTransformator.transformatorLevels.get(i);
            for (TupleTransformerFactory tupleTransformerFactory : otherLevel.tupleTransformerFactories) {
                int consumeEndIndex = tupleTransformerFactory.getConsumeEndIndex();
                for (int j = tupleTransformerFactory.getConsumeStartIndex(); j < consumeEndIndex; ++j) {
                    consumableIndexes.put(j, j);
                }
                thisLevel.tupleTransformerFactories.add(new ConstrainedTupleTransformerFactory(classMappingIndex, subtypeIndexes, tupleTransformerFactory));
            }
            if (otherLevel.tupleListTransformer != null) {
                thisLevel.tupleListTransformer = new ConstrainedTupleListTransformer(classMappingIndex, subtypeIndexes, otherLevel.tupleListTransformer);
                consumableIndexes.put(otherLevel.tupleListTransformer.getConsumableIndex(), otherLevel.tupleListTransformer);
            }
            if (otherLevel.tupleListTransformerFactory == null) continue;
            thisLevel.tupleListTransformerFactory = new ConstrainedTupleListTransformerFactory(classMappingIndex, subtypeIndexes, otherLevel.tupleListTransformerFactory);
            consumableIndexes.put(otherLevel.tupleListTransformerFactory.getConsumableIndex(), otherLevel.tupleListTransformerFactory);
        }
    }

    private void incrementLevel() {
        ++this.currentLevel;
        this.transformatorLevels.add(new TupleTransformatorFactoryLevel());
    }

    public void add(TupleListTransformer tupleListTransformer) {
        this.transformatorLevels.get((int)this.currentLevel).tupleListTransformer = tupleListTransformer;
        this.incrementLevel();
    }

    public void add(TupleListTransformerFactory tupleListTransformerFactory) {
        this.transformatorLevels.get((int)this.currentLevel).tupleListTransformerFactory = tupleListTransformerFactory;
        this.incrementLevel();
    }

    public void add(TupleTransformerFactory tupleTransformerFactory) {
        this.transformatorLevels.get((int)this.currentLevel).tupleTransformerFactories.add(tupleTransformerFactory);
    }

    public TupleTransformator create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, EntityViewConfiguration entityViewConfiguration) {
        ArrayList<TupleTransformatorLevel> newTransformatorLevels = new ArrayList<TupleTransformatorLevel>(this.transformatorLevels.size());
        for (TupleTransformatorFactoryLevel thisLevel : this.transformatorLevels) {
            List<TupleTransformerFactory> tupleTransformerFactories = thisLevel.tupleTransformerFactories;
            TupleTransformer[] tupleTransformers = new TupleTransformer[tupleTransformerFactories.size()];
            TupleListTransformer tupleListTransformer = thisLevel.tupleListTransformerFactory != null ? thisLevel.tupleListTransformerFactory.create(optionalParameters, entityViewConfiguration) : thisLevel.tupleListTransformer;
            for (int i = tupleTransformerFactories.size() - 1; i >= 0; --i) {
                TupleTransformerFactory tupleTransformerFactory = tupleTransformerFactories.get(i);
                tupleTransformers[i] = tupleTransformerFactory.create(parameterHolder, optionalParameters, entityViewConfiguration);
            }
            newTransformatorLevels.add(new TupleTransformatorLevel(tupleTransformers, tupleListTransformer));
        }
        return new TupleTransformator(newTransformatorLevels);
    }

    private static class ConstrainedTupleListTransformerFactory
    implements TupleListTransformerFactory {
        private final int classMappingIndex;
        private final int[] subtypeIndexes;
        private final TupleListTransformerFactory delegate;

        public ConstrainedTupleListTransformerFactory(int classMappingIndex, int[] subtypeIndexes, TupleListTransformerFactory delegate) {
            this.classMappingIndex = classMappingIndex;
            this.subtypeIndexes = subtypeIndexes;
            this.delegate = delegate;
        }

        @Override
        public int getConsumableIndex() {
            return this.delegate.getConsumableIndex();
        }

        @Override
        public TupleListTransformer create(Map<String, Object> optionalParameters, EntityViewConfiguration entityViewConfiguration) {
            return new ConstrainedTupleListTransformer(this.classMappingIndex, this.subtypeIndexes, this.delegate.create(optionalParameters, entityViewConfiguration));
        }
    }

    private static class ConstrainedTupleListTransformer
    extends TupleListTransformer {
        private final int classMappingIndex;
        private final int[] subtypeIndexes;
        private final TupleListTransformer delegate;

        public ConstrainedTupleListTransformer(int classMappingIndex, int[] subtypeIndexes, TupleListTransformer delegate) {
            super(-1);
            this.classMappingIndex = classMappingIndex;
            this.subtypeIndexes = subtypeIndexes;
            this.delegate = delegate;
        }

        @Override
        public int getConsumableIndex() {
            return this.delegate.getConsumableIndex();
        }

        @Override
        public List<Object[]> transform(List<Object[]> tuples) {
            ConstrainedTupleList tupleList = new ConstrainedTupleList(this.classMappingIndex, this.subtypeIndexes, tuples);
            if (!tupleList.isEmpty()) {
                this.delegate.transform(tupleList);
            }
            return tuples;
        }
    }

    private static class ConstrainedTupleTransformerFactory
    implements TupleTransformerFactory {
        private final int classMappingIndex;
        private final int[] subtypeIndexes;
        private final TupleTransformerFactory delegate;

        public ConstrainedTupleTransformerFactory(int classMappingIndex, int[] subtypeIndexes, TupleTransformerFactory delegate) {
            this.classMappingIndex = classMappingIndex;
            this.subtypeIndexes = subtypeIndexes;
            this.delegate = delegate;
        }

        @Override
        public int getConsumeStartIndex() {
            return this.delegate.getConsumeStartIndex();
        }

        @Override
        public int getConsumeEndIndex() {
            return this.delegate.getConsumeEndIndex();
        }

        @Override
        public TupleTransformer create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, EntityViewConfiguration entityViewConfiguration) {
            return new ConstrainedTupleTransformer(this.classMappingIndex, this.subtypeIndexes, this.delegate.create(parameterHolder, optionalParameters, entityViewConfiguration));
        }
    }

    private static class ConstrainedTupleTransformer
    implements TupleTransformer {
        private final int classMappingIndex;
        private final int[] subtypeIndexes;
        private final TupleTransformer delegate;

        public ConstrainedTupleTransformer(int classMappingIndex, int[] subtypeIndexes, TupleTransformer delegate) {
            this.classMappingIndex = classMappingIndex;
            this.subtypeIndexes = subtypeIndexes;
            this.delegate = delegate;
        }

        @Override
        public int getConsumeStartIndex() {
            return this.delegate.getConsumeStartIndex();
        }

        @Override
        public int getConsumeEndIndex() {
            return this.delegate.getConsumeEndIndex();
        }

        @Override
        public Object[] transform(Object[] tuple, UpdatableViewMap updatableViewMap) {
            if (Arrays.binarySearch(this.subtypeIndexes, ((Number)tuple[this.classMappingIndex]).intValue()) >= 0) {
                return this.delegate.transform(tuple, updatableViewMap);
            }
            return tuple;
        }
    }
}

