/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.view.impl.objectbuilder.TupleId;
import com.blazebit.persistence.view.impl.objectbuilder.TupleIndexValue;
import com.blazebit.persistence.view.impl.objectbuilder.TupleReuse;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractIndexedTupleListTransformer<C, K>
extends TupleListTransformer {
    private final int[] parentIdPositions;
    private final int valueStartIndex;
    private final int valueOffset;
    private final TypeConverter<Object, Object> keyConverter;
    private final TypeConverter<Object, Object> valueConverter;

    public AbstractIndexedTupleListTransformer(int[] parentIdPositions, int startIndex, int valueStartIndex, TypeConverter<Object, Object> keyConverter, TypeConverter<Object, Object> valueConverter) {
        super(startIndex);
        this.parentIdPositions = parentIdPositions;
        this.valueStartIndex = valueStartIndex;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
        this.valueOffset = valueStartIndex - startIndex;
    }

    @Override
    public int getConsumableIndex() {
        return this.valueStartIndex;
    }

    @Override
    public List<Object[]> transform(List<Object[]> tuples) {
        HashMap<TupleId, TupleIndexValue> tupleIndex = new HashMap<TupleId, TupleIndexValue>(tuples.size());
        Iterator<Object[]> tupleListIter = tuples.iterator();
        while (tupleListIter.hasNext()) {
            Object key;
            Object collection;
            Object[] tuple = tupleListIter.next();
            TupleId id = new TupleId(this.parentIdPositions, tuple);
            if (id.isEmpty()) continue;
            TupleIndexValue tupleIndexValue = (TupleIndexValue)tupleIndex.get(id);
            if (tupleIndexValue == null) {
                collection = this.createCollection();
                tupleIndexValue = new TupleIndexValue(collection, tuple, this.startIndex, this.valueOffset + 1);
                key = tuple[this.startIndex];
                this.add(collection, key, tuple[this.valueStartIndex]);
                tuple[this.startIndex] = collection;
                tuple[this.valueStartIndex] = TupleReuse.CONSUMED;
                tupleIndex.put(id, tupleIndexValue);
                continue;
            }
            if (tupleIndexValue.addRestTuple(tuple, this.startIndex, this.valueOffset + 1)) {
                collection = tupleIndexValue.getTupleValue();
                key = tuple[this.startIndex];
                this.add(collection, key, tuple[this.valueStartIndex]);
                tuple[this.startIndex] = collection;
                tuple[this.valueStartIndex] = TupleReuse.CONSUMED;
                if (!tupleIndexValue.containsRestTuple(tuple, this.startIndex, this.valueOffset + 1)) continue;
                tupleListIter.remove();
                continue;
            }
            Object key2 = tuple[this.startIndex];
            this.add(tupleIndexValue.getTupleValue(), key2, tuple[this.valueStartIndex]);
            tuple[this.valueStartIndex] = TupleReuse.CONSUMED;
            tupleListIter.remove();
        }
        return tuples;
    }

    protected abstract Object createCollection();

    protected void add(Object collection, Object key, Object value) {
        if (this.keyConverter != null) {
            key = this.keyConverter.convertToViewType(key);
        }
        if (key != null) {
            if (this.valueConverter != null) {
                value = this.valueConverter.convertToViewType(value);
            }
            this.addToCollection(collection, key, value);
        }
    }

    protected abstract void addToCollection(C var1, K var2, Object var3);
}

