/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.view.impl.objectbuilder.TupleId;
import com.blazebit.persistence.view.impl.objectbuilder.TupleIndexValue;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractNonIndexedTupleListTransformer<C>
extends TupleListTransformer {
    private final int[] parentIdPositions;
    private final TypeConverter<Object, Object> elementConverter;

    public AbstractNonIndexedTupleListTransformer(int[] parentIdPositions, int startIndex, TypeConverter<Object, Object> elementConverter) {
        super(startIndex);
        this.parentIdPositions = parentIdPositions;
        this.elementConverter = elementConverter;
    }

    @Override
    public int getConsumableIndex() {
        return -1;
    }

    @Override
    public List<Object[]> transform(List<Object[]> tuples) {
        HashMap<TupleId, TupleIndexValue> tupleIndex = new HashMap<TupleId, TupleIndexValue>(tuples.size());
        Iterator<Object[]> tupleListIter = tuples.iterator();
        while (tupleListIter.hasNext()) {
            Object collection;
            Object[] tuple = tupleListIter.next();
            TupleId id = new TupleId(this.parentIdPositions, tuple);
            if (id.isEmpty()) continue;
            TupleIndexValue tupleIndexValue = (TupleIndexValue)tupleIndex.get(id);
            if (tupleIndexValue == null) {
                collection = this.createCollection();
                tupleIndexValue = new TupleIndexValue(collection, tuple, this.startIndex, 1);
                this.add(collection, tuple[this.startIndex]);
                tuple[this.startIndex] = collection;
                tupleIndex.put(id, tupleIndexValue);
                continue;
            }
            if (tupleIndexValue.addRestTuple(tuple, this.startIndex, 1)) {
                collection = tupleIndexValue.getTupleValue();
                this.add(collection, tuple[this.startIndex]);
                tuple[this.startIndex] = collection;
                if (!tupleIndexValue.containsRestTuple(tuple, this.startIndex, 1)) continue;
                tupleListIter.remove();
                continue;
            }
            this.add(tupleIndexValue.getTupleValue(), tuple[this.startIndex]);
            tupleListIter.remove();
        }
        return tuples;
    }

    protected abstract Object createCollection();

    protected void add(Object collection, Object value) {
        if (this.elementConverter != null) {
            value = this.elementConverter.convertToViewType(value);
        }
        if (value != null) {
            this.addToCollection(collection, value);
        }
    }

    protected abstract void addToCollection(C var1, Object var2);
}

