/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.view.impl.collection.CollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.AbstractNonIndexedTupleListTransformer;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;

public class CollectionTupleListTransformer
extends AbstractNonIndexedTupleListTransformer<Collection<Object>> {
    private final CollectionInstantiator collectionInstantiator;
    private final boolean dirtyTracking;

    public CollectionTupleListTransformer(int[] parentIdPositions, int startIndex, CollectionInstantiator collectionInstantiator, boolean dirtyTracking, TypeConverter<Object, Object> elementConverter) {
        super(parentIdPositions, startIndex, elementConverter);
        this.collectionInstantiator = collectionInstantiator;
        this.dirtyTracking = dirtyTracking;
    }

    @Override
    public List<Object[]> transform(List<Object[]> tuples) {
        tuples = super.transform(tuples);
        if (this.collectionInstantiator.requiresPostConstruct()) {
            IdentityHashMap<Collection, Boolean> handledCollections = new IdentityHashMap<Collection, Boolean>(tuples.size());
            for (Object[] tuple : tuples) {
                Collection collection = (Collection)tuple[this.startIndex];
                if (handledCollections.put(collection, Boolean.TRUE) != null) continue;
                this.collectionInstantiator.postConstruct(collection);
            }
        }
        return tuples;
    }

    @Override
    protected Object createCollection() {
        if (this.dirtyTracking) {
            return this.collectionInstantiator.createRecordingCollection(0);
        }
        return this.collectionInstantiator.createCollection(0);
    }

    @Override
    protected void addToCollection(Collection<Object> collection, Object value) {
        if (this.dirtyTracking) {
            ((RecordingCollection)collection).getDelegate().add((Object)value);
        } else {
            collection.add(value);
        }
    }
}

