/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.view.impl.collection.CollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.RecordingList;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.AbstractIndexedTupleListTransformer;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.List;

public class IndexedListTupleListTransformer
extends AbstractIndexedTupleListTransformer<List<Object>, Integer> {
    private final CollectionInstantiator collectionInstantiator;
    private final boolean dirtyTracking;

    public IndexedListTupleListTransformer(int[] parentIdPositions, int startIndex, CollectionInstantiator collectionInstantiator, boolean dirtyTracking, TypeConverter<Object, Object> valueConverter) {
        super(parentIdPositions, startIndex, startIndex + 1, null, valueConverter);
        this.collectionInstantiator = collectionInstantiator;
        this.dirtyTracking = dirtyTracking;
    }

    @Override
    protected Object createCollection() {
        if (this.dirtyTracking) {
            return this.collectionInstantiator.createRecordingCollection(0);
        }
        return this.collectionInstantiator.createCollection(0);
    }

    @Override
    protected void addToCollection(List<Object> collection, Integer index, Object value) {
        List list = this.dirtyTracking ? (List)((RecordingList)collection).getDelegate() : collection;
        int size = list.size();
        if (index < size) {
            list.set(index, value);
        } else if (index > size) {
            for (int i = size; i < index; ++i) {
                list.add(null);
            }
            list.add(index, value);
        } else {
            list.add(index, value);
        }
    }
}

