/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.CTEBuilder;
import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.spi.JpqlMacro;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.BatchCorrelationMode;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.macro.CorrelatedSubqueryEmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.impl.macro.CorrelatedSubqueryViewRootJpqlMacro;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.AbstractCorrelatedTupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.Correlator;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.SubqueryCorrelationBuilder;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.ViewType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.Query;

public abstract class AbstractCorrelatedBatchTupleListTransformer
extends AbstractCorrelatedTupleListTransformer {
    public static final String CORRELATION_KEY_ALIAS = "correlationKey";
    private static final String CORRELATION_PARAM_PREFIX = "correlationParam_";
    protected final int batchSize;
    protected final boolean correlatesThis;
    protected final BatchCorrelationMode expectBatchCorrelationMode;
    protected final int valueIndex;
    protected final int keyIndex;
    protected String correlationParamName;
    protected String correlationSelectExpression;
    protected CriteriaBuilder<?> criteriaBuilder;
    protected CorrelatedSubqueryViewRootJpqlMacro viewRootJpqlMacro;
    protected CorrelatedSubqueryEmbeddingViewJpqlMacro embeddingViewJpqlMacro;
    protected Query query;

    public AbstractCorrelatedBatchTupleListTransformer(ExpressionFactory ef, Correlator correlator, ManagedViewType<?> viewRootType, ManagedViewType<?> embeddingViewType, String correlationResult, CorrelationProviderFactory correlationProviderFactory, String attributePath, String[] fetches, boolean correlatesThis, int viewRootIndex, int embeddingViewIndex, int tupleIndex, int defaultBatchSize, Class<?> correlationBasisType, Class<?> correlationBasisEntity, EntityViewConfiguration entityViewConfiguration) {
        super(ef, correlator, viewRootType, embeddingViewType, correlationResult, correlationProviderFactory, attributePath, fetches, viewRootIndex, embeddingViewIndex, tupleIndex, correlationBasisType, correlationBasisEntity, entityViewConfiguration);
        this.batchSize = entityViewConfiguration.getBatchSize(attributePath, defaultBatchSize);
        this.correlatesThis = correlatesThis;
        this.expectBatchCorrelationMode = entityViewConfiguration.getExpectBatchCorrelationValues(attributePath);
        this.valueIndex = correlator.getElementOffset();
        this.keyIndex = this.valueIndex + 1;
    }

    private String generateCorrelationParamName() {
        String paramName;
        FullQueryBuilder<?, ?> queryBuilder = this.entityViewConfiguration.getCriteriaBuilder();
        Map<String, Object> optionalParameters = this.entityViewConfiguration.getOptionalParameters();
        int paramNumber = 0;
        while (true) {
            if (queryBuilder.getParameter(paramName = CORRELATION_PARAM_PREFIX + paramNumber) != null) {
                ++paramNumber;
                continue;
            }
            if (!optionalParameters.containsKey(paramName)) break;
            ++paramNumber;
        }
        return paramName;
    }

    private String applyAndGetCorrelationRoot(BatchCorrelationMode batchCorrelationMode) {
        String correlationKeyExpression;
        String embeddingViewExpression;
        String viewRootExpression;
        Class correlationBasisEntityType;
        Class viewRootEntityClass = this.viewRootType.getEntityClass();
        Class embeddingViewEntityClass = this.embeddingViewType.getEntityClass();
        String viewRootIdAttributePath = this.getEntityIdName(viewRootEntityClass);
        String embeddingViewIdAttributePath = this.getEntityIdName(embeddingViewEntityClass);
        FullQueryBuilder<?, ?> queryBuilder = this.entityViewConfiguration.getCriteriaBuilder();
        Map<String, Object> optionalParameters = this.entityViewConfiguration.getOptionalParameters();
        boolean batchedIdValues = false;
        if (batchCorrelationMode == BatchCorrelationMode.VALUES) {
            correlationBasisEntityType = this.correlationBasisEntity;
            viewRootExpression = null;
            batchedIdValues = this.correlatesThis && this.correlationBasisEntity == null;
            embeddingViewExpression = this.correlatesThis ? CORRELATION_KEY_ALIAS : null;
        } else if (batchCorrelationMode == BatchCorrelationMode.VIEW_ROOTS) {
            correlationBasisEntityType = viewRootEntityClass;
            viewRootExpression = CORRELATION_KEY_ALIAS;
            embeddingViewExpression = null;
        } else {
            correlationBasisEntityType = embeddingViewEntityClass;
            viewRootExpression = null;
            embeddingViewExpression = CORRELATION_KEY_ALIAS;
        }
        this.criteriaBuilder = queryBuilder.getCriteriaBuilderFactory().create(queryBuilder.getEntityManager(), Object[].class);
        if (queryBuilder instanceof CTEBuilder) {
            this.criteriaBuilder.withCtesFrom((CTEBuilder)queryBuilder);
        }
        this.viewRootJpqlMacro = new CorrelatedSubqueryViewRootJpqlMacro((FullQueryBuilder<?, ?>)this.criteriaBuilder, optionalParameters, viewRootExpression != null, viewRootEntityClass, viewRootIdAttributePath, viewRootExpression);
        this.embeddingViewJpqlMacro = new CorrelatedSubqueryEmbeddingViewJpqlMacro((FullQueryBuilder<?, ?>)this.criteriaBuilder, optionalParameters, embeddingViewExpression != null, embeddingViewEntityClass, embeddingViewIdAttributePath, embeddingViewExpression, batchedIdValues, this.viewRootJpqlMacro);
        this.criteriaBuilder.registerMacro("view_root", (JpqlMacro)this.viewRootJpqlMacro);
        this.criteriaBuilder.registerMacro("embedding_view", (JpqlMacro)this.embeddingViewJpqlMacro);
        String joinBase = CORRELATION_KEY_ALIAS;
        SubqueryCorrelationBuilder correlationBuilder = new SubqueryCorrelationBuilder((FullQueryBuilder<?, ?>)this.criteriaBuilder, this.correlationAlias, this.correlationResult, this.correlationBasisType, correlationBasisEntityType, CORRELATION_KEY_ALIAS, joinBase, this.batchSize, false, this.attributePath);
        CorrelationProvider provider = this.correlationProviderFactory.create(this.entityViewConfiguration.getCriteriaBuilder(), this.entityViewConfiguration.getOptionalParameters());
        if (this.batchSize > 1) {
            this.correlationParamName = batchCorrelationMode == BatchCorrelationMode.VALUES ? CORRELATION_KEY_ALIAS : this.generateCorrelationParamName();
            if (correlationBasisEntityType != null) {
                correlationKeyExpression = CORRELATION_KEY_ALIAS;
                this.correlationSelectExpression = batchCorrelationMode == BatchCorrelationMode.VALUES ? "correlationKey." + this.getEntityIdName(correlationBasisEntityType) : "correlationKey." + viewRootIdAttributePath;
            } else {
                correlationKeyExpression = CORRELATION_KEY_ALIAS;
                this.correlationSelectExpression = CORRELATION_KEY_ALIAS;
            }
        } else {
            this.correlationParamName = this.generateCorrelationParamName();
            correlationKeyExpression = null;
            this.correlationSelectExpression = null;
        }
        int originalFirstResult = this.criteriaBuilder.getFirstResult();
        int originalMaxResults = this.criteriaBuilder.getMaxResults();
        if (this.batchSize > 1 && batchCorrelationMode == BatchCorrelationMode.VALUES) {
            provider.applyCorrelation((CorrelationBuilder)correlationBuilder, correlationKeyExpression);
        } else {
            provider.applyCorrelation((CorrelationBuilder)correlationBuilder, ':' + this.correlationParamName);
        }
        if (this.batchSize > 1 && (originalFirstResult != this.criteriaBuilder.getFirstResult() || originalMaxResults != this.criteriaBuilder.getMaxResults())) {
            throw new IllegalArgumentException("Correlation provider '" + provider + "' wrongly uses setFirstResult() or setMaxResults() on the query builder which might lead to wrong results. Use SELECT fetching with batch size 1 or reformulate the correlation provider to use the limit/offset in a subquery!");
        }
        if (this.fetches.length != 0) {
            for (int i = 0; i < this.fetches.length; ++i) {
                this.criteriaBuilder.fetch(correlationBuilder.getCorrelationAlias() + "." + this.fetches[i]);
            }
        }
        return correlationBuilder.getCorrelationRoot();
    }

    @Override
    public List<Object[]> transform(List<Object[]> tuples) {
        AbstractCorrelatedTupleListTransformer.FixedArrayList correlationParams = new AbstractCorrelatedTupleListTransformer.FixedArrayList(this.batchSize);
        int tupleOffset = this.batchSize > 1 ? 1 : 0;
        String correlationRoot = this.applyAndGetCorrelationRoot(this.expectBatchCorrelationMode);
        this.correlator.finish((FullQueryBuilder<?, ?>)this.criteriaBuilder, this.entityViewConfiguration, tupleOffset, correlationRoot, this.embeddingViewJpqlMacro, true);
        if (this.batchSize > 1) {
            this.criteriaBuilder.select(this.correlationSelectExpression);
        }
        if (this.embeddingViewJpqlMacro.usesViewMacroNonId() || !this.correlatesThis && this.embeddingViewJpqlMacro.usesViewMacro()) {
            if (!(this.embeddingViewType instanceof ViewType)) {
                throw new IllegalStateException("The use of EMBEDDING_VIEW in the correlation for '" + this.embeddingViewType.getJavaType().getName() + "." + this.attributePath.substring(this.attributePath.lastIndexOf(46) + 1) + "' is illegal because the embedding view type '" + this.embeddingViewType.getJavaType().getName() + "' does not declare a @IdMapping!");
            }
            this.transformViewMacroAware(tuples, correlationParams, tupleOffset, correlationRoot, this.embeddingViewJpqlMacro, BatchCorrelationMode.EMBEDDING_VIEWS, this.embeddingViewType, this.embeddingViewIndex);
        } else if (this.viewRootJpqlMacro.usesViewMacro()) {
            if (!(this.viewRootType instanceof ViewType)) {
                throw new IllegalStateException("The use of VIEW_ROOT in the correlation for '" + this.embeddingViewType.getJavaType().getName() + "." + this.attributePath.substring(this.attributePath.lastIndexOf(46) + 1) + "' is illegal because the view root type '" + this.viewRootType.getJavaType().getName() + "' does not declare a @IdMapping!");
            }
            this.transformViewMacroAware(tuples, correlationParams, tupleOffset, correlationRoot, this.viewRootJpqlMacro, BatchCorrelationMode.VIEW_ROOTS, this.viewRootType, this.viewRootIndex);
        } else {
            EntityManager em = this.criteriaBuilder.getEntityManager();
            Iterator<Object[]> tupleListIter = tuples.iterator();
            if (this.batchSize > 1 && this.expectBatchCorrelationMode != BatchCorrelationMode.VALUES) {
                this.applyAndGetCorrelationRoot(BatchCorrelationMode.VALUES);
                this.correlator.finish((FullQueryBuilder<?, ?>)this.criteriaBuilder, this.entityViewConfiguration, tupleOffset, correlationRoot, this.embeddingViewJpqlMacro, true);
                this.criteriaBuilder.select(this.correlationSelectExpression);
            }
            this.populateParameters((FullQueryBuilder<?, ?>)this.criteriaBuilder);
            this.query = this.criteriaBuilder.getQuery();
            HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> correlationValues = new HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>(tuples.size());
            while (tupleListIter.hasNext()) {
                Object[] tuple = tupleListIter.next();
                Object correlationValue = tuple[this.startIndex];
                AbstractCorrelatedTupleListTransformer.TuplePromise tupleIndexValue = (AbstractCorrelatedTupleListTransformer.TuplePromise)correlationValues.get(correlationValue);
                if (tupleIndexValue == null) {
                    tupleIndexValue = new AbstractCorrelatedTupleListTransformer.TuplePromise(this.startIndex);
                    tupleIndexValue.add(tuple);
                    correlationValues.put(correlationValue, tupleIndexValue);
                    if (correlationValue == null) continue;
                    if (this.correlationBasisEntity != null) {
                        correlationParams.add(em.getReference(this.correlationBasisEntity, correlationValue));
                    } else {
                        correlationParams.add(correlationValue);
                    }
                    if (this.batchSize != correlationParams.realSize()) continue;
                    Object defaultKey = this.correlationBasisEntity != null ? this.jpaProvider.getIdentifier(correlationParams.get(0)) : correlationParams.get(0);
                    this.batchLoad(correlationValues, correlationParams, null, defaultKey, this.viewRootJpqlMacro, BatchCorrelationMode.VALUES);
                    continue;
                }
                tupleIndexValue.add(tuple);
            }
            if (correlationParams.realSize() > 0) {
                this.batchLoad(correlationValues, correlationParams, null, null, this.viewRootJpqlMacro, BatchCorrelationMode.VALUES);
            }
            this.fillDefaultValues(Collections.singletonMap(null, correlationValues));
        }
        return tuples;
    }

    @Override
    protected void populateParameters(FullQueryBuilder<?, ?> queryBuilder) {
        FullQueryBuilder<?, ?> mainBuilder = this.entityViewConfiguration.getCriteriaBuilder();
        for (Parameter parameter : mainBuilder.getParameters()) {
            if (parameter.getName().equals(this.correlationParamName) || !queryBuilder.containsParameter(parameter.getName()) || queryBuilder.isParameterSet(parameter.getName())) continue;
            queryBuilder.setParameter(parameter.getName(), mainBuilder.getParameterValue(parameter.getName()));
        }
        for (Map.Entry entry : this.entityViewConfiguration.getOptionalParameters().entrySet()) {
            if (((String)entry.getKey()).equals(this.correlationParamName) || !queryBuilder.containsParameter((String)entry.getKey()) || queryBuilder.isParameterSet((String)entry.getKey())) continue;
            queryBuilder.setParameter((String)entry.getKey(), entry.getValue());
        }
    }

    private void transformViewMacroAware(List<Object[]> tuples, AbstractCorrelatedTupleListTransformer.FixedArrayList correlationParams, int tupleOffset, String correlationRoot, CorrelatedSubqueryViewRootJpqlMacro macro, BatchCorrelationMode correlationMode, ManagedViewType<?> viewType, int viewIndex) {
        Map batchValues;
        EntityManager em = this.criteriaBuilder.getEntityManager();
        Iterator<Object[]> tupleListIter = tuples.iterator();
        int totalSize = tuples.size();
        HashMap<Object, Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>> viewRoots = new HashMap<Object, Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>>(totalSize);
        HashMap<Object, Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>> correlationValues = new HashMap<Object, Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>>(totalSize);
        while (tupleListIter.hasNext()) {
            AbstractCorrelatedTupleListTransformer.TuplePromise correlationValuePromise;
            AbstractCorrelatedTupleListTransformer.TuplePromise viewRootPromise;
            Object[] tuple = tupleListIter.next();
            Object viewRootKey = tuple[viewIndex];
            Object correlationValueKey = tuple[this.startIndex];
            if (viewRootKey == null || correlationValueKey == null) continue;
            HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> viewRootCorrelationValues = (HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>)viewRoots.get(viewRootKey);
            if (viewRootCorrelationValues == null) {
                viewRootCorrelationValues = new HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>();
                viewRoots.put(viewRootKey, viewRootCorrelationValues);
            }
            if ((viewRootPromise = (AbstractCorrelatedTupleListTransformer.TuplePromise)viewRootCorrelationValues.get(correlationValueKey)) == null) {
                viewRootPromise = new AbstractCorrelatedTupleListTransformer.TuplePromise(this.startIndex);
                viewRootCorrelationValues.put(correlationValueKey, viewRootPromise);
            }
            viewRootPromise.add(tuple);
            HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> correlationValueViewRoots = (HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>)correlationValues.get(correlationValueKey);
            if (correlationValueViewRoots == null) {
                correlationValueViewRoots = new HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>();
                correlationValues.put(correlationValueKey, correlationValueViewRoots);
            }
            if ((correlationValuePromise = (AbstractCorrelatedTupleListTransformer.TuplePromise)correlationValueViewRoots.get(viewRootKey)) == null) {
                correlationValuePromise = new AbstractCorrelatedTupleListTransformer.TuplePromise(this.startIndex);
                correlationValueViewRoots.put(viewRootKey, correlationValuePromise);
            }
            correlationValuePromise.add(tuple);
        }
        boolean batchCorrelationValues = !macro.usesViewMacro() && viewRoots.size() <= correlationValues.size();
        AbstractCorrelatedTupleListTransformer.FixedArrayList viewRootIds = new AbstractCorrelatedTupleListTransformer.FixedArrayList(this.batchSize);
        if (batchCorrelationValues) {
            if (this.batchSize > 1) {
                if (this.expectBatchCorrelationMode != BatchCorrelationMode.VALUES) {
                    this.applyAndGetCorrelationRoot(BatchCorrelationMode.VALUES);
                    macro = BatchCorrelationMode.VIEW_ROOTS == correlationMode ? this.viewRootJpqlMacro : this.embeddingViewJpqlMacro;
                    this.correlator.finish((FullQueryBuilder<?, ?>)this.criteriaBuilder, this.entityViewConfiguration, tupleOffset, correlationRoot, this.embeddingViewJpqlMacro, true);
                    this.criteriaBuilder.select(this.correlationSelectExpression);
                }
                macro.addBatchPredicate((FullQueryBuilder<?, ?>)this.criteriaBuilder);
            } else {
                macro.addIdParamPredicate((FullQueryBuilder<?, ?>)this.criteriaBuilder);
            }
            this.populateParameters((FullQueryBuilder<?, ?>)this.criteriaBuilder);
            this.query = this.criteriaBuilder.getQuery();
            for (Map.Entry batchEntry : viewRoots.entrySet()) {
                batchValues = (Map)batchEntry.getValue();
                for (Map.Entry batchValueEntry : batchValues.entrySet()) {
                    if (this.correlationBasisEntity != null) {
                        correlationParams.add(em.getReference(this.correlationBasisEntity, batchValueEntry.getKey()));
                    } else {
                        correlationParams.add(batchValueEntry.getKey());
                    }
                    if (this.batchSize != correlationParams.realSize()) continue;
                    viewRootIds.add(batchEntry.getKey());
                    Object defaultKey = this.correlationBasisEntity != null ? this.jpaProvider.getIdentifier(correlationParams.get(0)) : correlationParams.get(0);
                    this.batchLoad(batchValues, correlationParams, viewRootIds, defaultKey, macro, correlationMode);
                }
                if (correlationParams.realSize() <= 0) continue;
                viewRootIds.add(batchEntry.getKey());
                this.batchLoad(batchValues, correlationParams, viewRootIds, null, macro, correlationMode);
            }
            this.fillDefaultValues(viewRoots);
        } else {
            if (this.batchSize > 1) {
                if (this.expectBatchCorrelationMode != correlationMode) {
                    this.applyAndGetCorrelationRoot(correlationMode);
                    macro = BatchCorrelationMode.VIEW_ROOTS == correlationMode ? this.viewRootJpqlMacro : this.embeddingViewJpqlMacro;
                    this.correlator.finish((FullQueryBuilder<?, ?>)this.criteriaBuilder, this.entityViewConfiguration, tupleOffset, correlationRoot, this.embeddingViewJpqlMacro, true);
                    this.criteriaBuilder.select(this.correlationSelectExpression);
                }
                macro.addBatchPredicate((FullQueryBuilder<?, ?>)this.criteriaBuilder);
            } else {
                macro.addIdParamPredicate((FullQueryBuilder<?, ?>)this.criteriaBuilder);
            }
            this.populateParameters((FullQueryBuilder<?, ?>)this.criteriaBuilder);
            this.query = this.criteriaBuilder.getQuery();
            for (Map.Entry batchEntry : correlationValues.entrySet()) {
                batchValues = (Map)batchEntry.getValue();
                for (Map.Entry batchValueEntry : batchValues.entrySet()) {
                    viewRootIds.add(batchValueEntry.getKey());
                    if (this.batchSize != viewRootIds.realSize()) continue;
                    if (this.correlationBasisEntity != null) {
                        correlationParams.add(em.getReference(this.correlationBasisEntity, batchEntry.getKey()));
                    } else {
                        correlationParams.add(batchEntry.getKey());
                    }
                    Object defaultKey = viewRootIds.get(0);
                    this.batchLoad(batchValues, correlationParams, viewRootIds, defaultKey, macro, correlationMode);
                }
                if (viewRootIds.realSize() <= 0) continue;
                if (this.correlationBasisEntity != null) {
                    correlationParams.add(em.getReference(this.correlationBasisEntity, batchEntry.getKey()));
                } else {
                    correlationParams.add(batchEntry.getKey());
                }
                this.batchLoad(batchValues, correlationParams, viewRootIds, null, macro, correlationMode);
            }
            this.fillDefaultValues(correlationValues);
        }
    }

    private void batchLoad(Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> correlationValues, AbstractCorrelatedTupleListTransformer.FixedArrayList batchParameters, AbstractCorrelatedTupleListTransformer.FixedArrayList viewRootIds, Object defaultKey, CorrelatedSubqueryViewRootJpqlMacro macro, BatchCorrelationMode batchCorrelationMode) {
        batchParameters.clearRest();
        if (this.criteriaBuilder.containsParameter(this.correlationParamName)) {
            if (this.batchSize > 1 && batchCorrelationMode == BatchCorrelationMode.VALUES) {
                this.criteriaBuilder.setParameter(this.correlationParamName, (Object)batchParameters);
                this.query.setParameter(this.correlationParamName, (Object)batchParameters);
            } else {
                this.criteriaBuilder.setParameter(this.correlationParamName, batchParameters.get(0));
                this.query.setParameter(this.correlationParamName, batchParameters.get(0));
            }
        }
        if (viewRootIds != null) {
            viewRootIds.clearRest();
            if (viewRootIds.size() == 1) {
                macro.setParameters((FullQueryBuilder<?, ?>)this.criteriaBuilder, this.query, viewRootIds.get(0));
            } else {
                macro.setParameters((FullQueryBuilder<?, ?>)this.criteriaBuilder, this.query, viewRootIds);
            }
        }
        this.populateResult(correlationValues, defaultKey, this.query.getResultList());
        batchParameters.reset();
        if (viewRootIds != null) {
            viewRootIds.reset();
        }
    }

    protected abstract void populateResult(Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> var1, Object var2, List<Object> var3);
}

