/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.LimitBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.spi.JpqlMacro;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.macro.CorrelatedSubqueryViewRootJpqlMacro;
import com.blazebit.persistence.view.impl.macro.MutableEmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.objectbuilder.LateAdditionalObjectBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.AbstractCorrelatedTupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.Correlator;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.SubqueryCorrelationBuilder;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCorrelatedSubselectTupleListTransformer
extends AbstractCorrelatedTupleListTransformer {
    protected final EntityViewManagerImpl evm;
    protected final String viewRootAlias;
    protected final String viewRootIdExpression;
    protected final int viewRootIdMapperCount;
    protected final String embeddingViewPath;
    protected final String embeddingViewIdExpression;
    protected final int embeddingViewIdMapperCount;
    protected final int maximumViewMapperCount;
    protected final String correlationBasisExpression;
    protected final String correlationKeyExpression;
    protected final int valueIndex;
    protected int viewIndex;
    protected int keyIndex;
    protected FullQueryBuilder<?, ?> criteriaBuilder;
    protected CorrelatedSubqueryViewRootJpqlMacro viewRootJpqlMacro;
    protected MutableEmbeddingViewJpqlMacro embeddingViewJpqlMacro;

    public AbstractCorrelatedSubselectTupleListTransformer(ExpressionFactory ef, Correlator correlator, EntityViewManagerImpl evm, ManagedViewType<?> viewRootType, String viewRootAlias, ManagedViewType<?> embeddingViewType, String embeddingViewPath, String correlationResult, String correlationBasisExpression, String correlationKeyExpression, CorrelationProviderFactory correlationProviderFactory, String attributePath, String[] fetches, int viewRootIndex, int embeddingViewIndex, int tupleIndex, Class<?> correlationBasisType, Class<?> correlationBasisEntity, EntityViewConfiguration entityViewConfiguration) {
        super(ef, correlator, viewRootType, embeddingViewType, correlationResult, correlationProviderFactory, attributePath, fetches, viewRootIndex, embeddingViewIndex, tupleIndex, correlationBasisType, correlationBasisEntity, entityViewConfiguration);
        this.evm = evm;
        this.viewRootAlias = viewRootAlias;
        String viewRootAliasPrefix = viewRootAlias + ".";
        this.viewRootIdExpression = viewRootAliasPrefix + this.getEntityIdName(viewRootType.getEntityClass());
        this.viewRootIdMapperCount = AbstractCorrelatedSubselectTupleListTransformer.viewIdMapperCount(viewRootType);
        this.embeddingViewPath = embeddingViewPath;
        this.embeddingViewIdExpression = viewRootAlias.equals(embeddingViewPath) ? viewRootAliasPrefix + this.getEntityIdName(embeddingViewType.getEntityClass()) : embeddingViewPath + "." + this.getEntityIdName(embeddingViewType.getEntityClass());
        this.embeddingViewIdMapperCount = AbstractCorrelatedSubselectTupleListTransformer.viewIdMapperCount(embeddingViewType);
        this.maximumViewMapperCount = Math.max(1, Math.max(this.viewRootIdMapperCount, this.embeddingViewIdMapperCount));
        this.correlationBasisExpression = correlationBasisExpression;
        this.correlationKeyExpression = correlationKeyExpression;
        this.valueIndex = correlator.getElementOffset();
    }

    private static int viewIdMapperCount(ManagedViewType<?> viewRootType) {
        MethodAttribute idAttribute;
        if (viewRootType instanceof ViewType && (idAttribute = ((ViewType)viewRootType).getIdAttribute()).isSubview()) {
            return AbstractCorrelatedSubselectTupleListTransformer.viewIdMapperCount(idAttribute);
        }
        return 0;
    }

    private static int viewIdMapperCount(MethodAttribute<?, ?> attribute) {
        if (attribute.isSubview()) {
            ManagedViewType viewType = (ManagedViewType)((SingularAttribute)attribute).getType();
            int count = 0;
            for (MethodAttribute methodAttribute : viewType.getAttributes()) {
                count += AbstractCorrelatedSubselectTupleListTransformer.viewIdMapperCount(methodAttribute);
            }
            return count;
        }
        return 1;
    }

    private ObjectBuilder<Object[]> createViewAwareObjectBuilder(ManagedViewType<?> viewType, EntityViewConfiguration configuration, String viewRoot) {
        MethodAttribute idAttribute;
        if (!(viewType instanceof ViewType) || !(idAttribute = ((ViewType)viewType).getIdAttribute()).isSubview()) {
            return null;
        }
        ManagedViewType idViewType = (ManagedViewType)((SingularAttribute)idAttribute).getType();
        return this.evm.createObjectBuilder((ManagedViewTypeImplementor)idViewType, null, viewRoot, "", this.criteriaBuilder, configuration, 1, 1, false);
    }

    @Override
    public List<Object[]> transform(List<Object[]> tuples) {
        ExpressionFactory ef;
        int maximumSlotsFilled;
        Class viewRootEntityClass = this.viewRootType.getEntityClass();
        String idAttributePath = this.getEntityIdName(viewRootEntityClass);
        FullQueryBuilder<?, ?> queryBuilder = this.entityViewConfiguration.getCriteriaBuilder();
        Map<String, Object> optionalParameters = this.entityViewConfiguration.getOptionalParameters();
        Class correlationBasisEntityType = this.correlationBasisEntity;
        String viewRootExpression = this.viewRootAlias;
        EmbeddingViewJpqlMacro embeddingViewJpqlMacro = this.entityViewConfiguration.getEmbeddingViewJpqlMacro();
        this.criteriaBuilder = queryBuilder.copy(Object[].class);
        int originalFirstResult = -1;
        int originalMaxResults = -1;
        if (this.criteriaBuilder instanceof LimitBuilder) {
            LimitBuilder limitBuilder = (LimitBuilder)this.criteriaBuilder;
            originalFirstResult = 0;
            limitBuilder.setFirstResult(0);
            originalMaxResults = Integer.MAX_VALUE;
            limitBuilder.setMaxResults(Integer.MAX_VALUE);
        }
        this.viewRootJpqlMacro = new CorrelatedSubqueryViewRootJpqlMacro(this.criteriaBuilder, optionalParameters, false, viewRootEntityClass, idAttributePath, viewRootExpression);
        this.criteriaBuilder.registerMacro("view_root", (JpqlMacro)this.viewRootJpqlMacro);
        this.criteriaBuilder.registerMacro("embedding_view", (JpqlMacro)embeddingViewJpqlMacro);
        String oldEmbeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
        embeddingViewJpqlMacro.setEmbeddingViewPath(this.embeddingViewPath);
        String joinBase = this.embeddingViewPath;
        SubqueryCorrelationBuilder correlationBuilder = new SubqueryCorrelationBuilder(this.criteriaBuilder, this.correlationAlias, this.correlationResult, this.correlationBasisType, correlationBasisEntityType, null, joinBase, 1, true, this.attributePath);
        CorrelationProvider provider = this.correlationProviderFactory.create(this.entityViewConfiguration.getCriteriaBuilder(), this.entityViewConfiguration.getOptionalParameters());
        provider.applyCorrelation((CorrelationBuilder)correlationBuilder, this.correlationBasisExpression);
        if (this.criteriaBuilder instanceof LimitBuilder && (originalFirstResult != ((LimitBuilder)this.criteriaBuilder).getFirstResult() || originalMaxResults != ((LimitBuilder)this.criteriaBuilder).getMaxResults())) {
            throw new IllegalArgumentException("Correlation provider '" + provider + "' wrongly uses setFirstResult() or setMaxResults() on the query builder which might lead to wrong results. Use SELECT fetching with batch size 1 or reformulate the correlation provider to use the limit/offset in a subquery!");
        }
        if (this.fetches.length != 0) {
            for (int i = 0; i < this.fetches.length; ++i) {
                this.criteriaBuilder.fetch(correlationBuilder.getCorrelationAlias() + "." + this.fetches[i]);
            }
        }
        String correlationRoot = correlationBuilder.getCorrelationRoot();
        ObjectBuilder<?> objectBuilder = this.correlator.finish(this.criteriaBuilder, this.entityViewConfiguration, this.maximumViewMapperCount + 1, correlationRoot, embeddingViewJpqlMacro, true);
        boolean usesViewRoot = this.viewRootJpqlMacro.usesViewMacro();
        boolean usesEmbeddingView = embeddingViewJpqlMacro.usesEmbeddingView();
        if (usesEmbeddingView && !(this.embeddingViewType instanceof ViewType)) {
            throw new IllegalStateException("The use of EMBEDDING_VIEW in the correlation for '" + this.embeddingViewType.getJavaType().getName() + "." + this.attributePath.substring(this.attributePath.lastIndexOf(46) + 1) + "' is illegal because the embedding view type '" + this.embeddingViewType.getJavaType().getName() + "' does not declare a @IdMapping!");
        }
        if (usesViewRoot && !(this.viewRootType instanceof ViewType)) {
            throw new IllegalStateException("The use of VIEW_ROOT in the correlation for '" + this.embeddingViewType.getJavaType().getName() + "." + this.attributePath.substring(this.attributePath.lastIndexOf(46) + 1) + "' is illegal because the view root type '" + this.viewRootType.getJavaType().getName() + "' does not declare a @IdMapping!");
        }
        int totalSize = tuples.size();
        HashMap<Object, Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>> viewRoots = new HashMap<Object, Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>>(totalSize);
        if (usesEmbeddingView) {
            maximumSlotsFilled = this.embeddingViewIdMapperCount == 0 ? 1 : this.embeddingViewIdMapperCount;
            this.keyIndex = this.maximumViewMapperCount - maximumSlotsFilled + 2 + this.valueIndex;
            this.viewIndex = this.maximumViewMapperCount - maximumSlotsFilled + 1 + this.valueIndex;
        } else if (usesViewRoot) {
            maximumSlotsFilled = this.viewRootIdMapperCount == 0 ? 1 : this.viewRootIdMapperCount;
            this.keyIndex = this.maximumViewMapperCount - maximumSlotsFilled + 2 + this.valueIndex;
            this.viewIndex = this.maximumViewMapperCount - maximumSlotsFilled + 1 + this.valueIndex;
        } else {
            maximumSlotsFilled = 0;
            this.keyIndex = this.maximumViewMapperCount + 1 + this.valueIndex;
            this.viewIndex = 1 + this.valueIndex;
        }
        for (int i = maximumSlotsFilled; i < this.maximumViewMapperCount; ++i) {
            this.criteriaBuilder.select("NULL");
        }
        if (usesEmbeddingView) {
            ef = (ExpressionFactory)this.criteriaBuilder.getService(ExpressionFactory.class);
            EntityViewConfiguration configuration = new EntityViewConfiguration(this.criteriaBuilder, ef, (EmbeddingViewJpqlMacro)new MutableEmbeddingViewJpqlMacro(), Collections.emptyMap(), Collections.emptyMap(), this.entityViewConfiguration.getFetches(), this.attributePath);
            ObjectBuilder<Object[]> embeddingViewObjectBuilder = this.createViewAwareObjectBuilder(this.embeddingViewType, configuration, this.embeddingViewIdExpression);
            if (embeddingViewObjectBuilder == null) {
                this.criteriaBuilder.select(this.embeddingViewIdExpression);
            } else {
                this.criteriaBuilder.selectNew((ObjectBuilder)new LateAdditionalObjectBuilder(objectBuilder, embeddingViewObjectBuilder));
            }
            for (Object[] tuple : tuples) {
                AbstractCorrelatedTupleListTransformer.TuplePromise viewRootPromise;
                Object embeddingViewKey = tuple[this.embeddingViewIndex];
                Object correlationValueKey = tuple[this.startIndex];
                if (embeddingViewKey == null || correlationValueKey == null) continue;
                HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> viewRootCorrelationValues = (HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>)viewRoots.get(embeddingViewKey);
                if (viewRootCorrelationValues == null) {
                    viewRootCorrelationValues = new HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>();
                    viewRoots.put(embeddingViewKey, viewRootCorrelationValues);
                }
                if ((viewRootPromise = (AbstractCorrelatedTupleListTransformer.TuplePromise)viewRootCorrelationValues.get(correlationValueKey)) == null) {
                    viewRootPromise = new AbstractCorrelatedTupleListTransformer.TuplePromise(this.startIndex);
                    viewRootCorrelationValues.put(correlationValueKey, viewRootPromise);
                }
                viewRootPromise.add(tuple);
            }
        } else if (usesViewRoot) {
            ef = (ExpressionFactory)this.criteriaBuilder.getService(ExpressionFactory.class);
            EntityViewConfiguration configuration = new EntityViewConfiguration(this.criteriaBuilder, ef, (EmbeddingViewJpqlMacro)new MutableEmbeddingViewJpqlMacro(), Collections.emptyMap(), Collections.emptyMap(), this.entityViewConfiguration.getFetches(), this.attributePath);
            ObjectBuilder<Object[]> viewRootObjectBuilder = this.createViewAwareObjectBuilder(this.viewRootType, configuration, this.viewRootIdExpression);
            if (viewRootObjectBuilder == null) {
                this.criteriaBuilder.select(this.viewRootIdExpression);
            } else {
                this.criteriaBuilder.selectNew((ObjectBuilder)new LateAdditionalObjectBuilder(objectBuilder, viewRootObjectBuilder));
            }
            for (Object[] tuple : tuples) {
                AbstractCorrelatedTupleListTransformer.TuplePromise viewRootPromise;
                Object viewRootKey = tuple[this.viewRootIndex];
                Object correlationValueKey = tuple[this.startIndex];
                if (viewRootKey == null || correlationValueKey == null) continue;
                HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> viewRootCorrelationValues = (HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>)viewRoots.get(viewRootKey);
                if (viewRootCorrelationValues == null) {
                    viewRootCorrelationValues = new HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>();
                    viewRoots.put(viewRootKey, viewRootCorrelationValues);
                }
                if ((viewRootPromise = (AbstractCorrelatedTupleListTransformer.TuplePromise)viewRootCorrelationValues.get(correlationValueKey)) == null) {
                    viewRootPromise = new AbstractCorrelatedTupleListTransformer.TuplePromise(this.startIndex);
                    viewRootCorrelationValues.put(correlationValueKey, viewRootPromise);
                }
                viewRootPromise.add(tuple);
            }
        } else {
            HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> viewRootCorrelationValues = new HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>(tuples.size());
            viewRoots.put(null, viewRootCorrelationValues);
            for (Object[] tuple : tuples) {
                Object correlationValueKey = tuple[this.startIndex];
                if (correlationValueKey == null) continue;
                AbstractCorrelatedTupleListTransformer.TuplePromise viewRootPromise = (AbstractCorrelatedTupleListTransformer.TuplePromise)viewRootCorrelationValues.get(correlationValueKey);
                if (viewRootPromise == null) {
                    viewRootPromise = new AbstractCorrelatedTupleListTransformer.TuplePromise(this.startIndex);
                    viewRootCorrelationValues.put(correlationValueKey, viewRootPromise);
                }
                viewRootPromise.add(tuple);
            }
        }
        this.criteriaBuilder.select(this.correlationKeyExpression);
        this.populateParameters(this.criteriaBuilder);
        embeddingViewJpqlMacro.setEmbeddingViewPath(oldEmbeddingViewPath);
        List resultList = this.criteriaBuilder.getResultList();
        this.populateResult(viewRoots, resultList);
        this.fillDefaultValues(viewRoots);
        return tuples;
    }

    protected abstract void populateResult(Map<Object, Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>> var1, List<Object[]> var2);
}

