/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.CorrelationProviderHelper;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.PrefixingQueryGenerator;
import com.blazebit.persistence.view.impl.collection.CollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.Correlator;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.TupleResultCopier;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.persistence.Parameter;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;

public abstract class AbstractCorrelatedTupleListTransformer
extends TupleListTransformer
implements TupleResultCopier {
    protected final JpaProvider jpaProvider;
    protected final Correlator correlator;
    protected final ManagedViewType<?> viewRootType;
    protected final ManagedViewType<?> embeddingViewType;
    protected final int viewRootIndex;
    protected final int embeddingViewIndex;
    protected final String correlationAlias;
    protected final String correlationResult;
    protected final CorrelationProviderFactory correlationProviderFactory;
    protected final Class<?> correlationBasisType;
    protected final Class<?> correlationBasisEntity;
    protected final String attributePath;
    protected final String[] fetches;
    protected final EntityViewConfiguration entityViewConfiguration;

    public AbstractCorrelatedTupleListTransformer(ExpressionFactory ef, Correlator correlator, ManagedViewType<?> viewRootType, ManagedViewType<?> embeddingViewType, String correlationResult, CorrelationProviderFactory correlationProviderFactory, String attributePath, String[] fetches, int viewRootIndex, int embeddingViewIndex, int tupleIndex, Class<?> correlationBasisType, Class<?> correlationBasisEntity, EntityViewConfiguration entityViewConfiguration) {
        super(tupleIndex);
        this.jpaProvider = (JpaProvider)entityViewConfiguration.getCriteriaBuilder().getService(JpaProvider.class);
        this.correlator = correlator;
        this.viewRootType = viewRootType;
        this.embeddingViewType = embeddingViewType;
        this.correlationProviderFactory = correlationProviderFactory;
        this.viewRootIndex = viewRootIndex;
        this.embeddingViewIndex = embeddingViewIndex;
        this.correlationBasisType = correlationBasisType;
        this.correlationBasisEntity = correlationBasisEntity;
        this.attributePath = attributePath;
        this.fetches = fetches;
        this.entityViewConfiguration = entityViewConfiguration;
        this.correlationAlias = CorrelationProviderHelper.getDefaultCorrelationAlias(attributePath);
        this.correlationResult = correlationResult.isEmpty() ? this.correlationAlias : PrefixingQueryGenerator.prefix(ef, correlationResult, this.correlationAlias);
    }

    protected String getEntityIdName(Class<?> entityClass) {
        ManagedType managedType = this.entityViewConfiguration.getCriteriaBuilder().getMetamodel().managedType(entityClass);
        if (JpaMetamodelUtils.isIdentifiable((ManagedType)managedType)) {
            return JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)((IdentifiableType)managedType)).getName();
        }
        return null;
    }

    protected void fillDefaultValues(Map<Object, Map<Object, TuplePromise>> promiseMap) {
        for (Map.Entry<Object, Map<Object, TuplePromise>> entry : promiseMap.entrySet()) {
            for (Map.Entry<Object, TuplePromise> promiseEntry : entry.getValue().entrySet()) {
                TuplePromise promise = promiseEntry.getValue();
                if (promise.hasResult()) continue;
                promise.onResult(this.createDefaultResult(), this);
            }
        }
    }

    @Override
    public int getConsumableIndex() {
        return -1;
    }

    protected boolean isRecording() {
        return false;
    }

    protected boolean isFilterNulls() {
        return false;
    }

    protected CollectionInstantiator getCollectionInstantiator() {
        return null;
    }

    protected Collection<Object> postConstruct(Collection<Object> value) {
        this.getCollectionInstantiator().postConstruct(value);
        return value;
    }

    protected Object createDefaultResult() {
        if (this.isRecording()) {
            return this.getCollectionInstantiator().createRecordingCollection(0);
        }
        return this.getCollectionInstantiator().createCollection(0);
    }

    protected Collection<Object> createCollection(Collection<? extends Object> list) {
        Collection<Object> result;
        Collection<?> collection;
        if (this.isRecording()) {
            RecordingCollection<?, ?> recordingCollection = this.getCollectionInstantiator().createRecordingCollection(list.size());
            collection = recordingCollection.getDelegate();
            result = recordingCollection;
        } else {
            collection = this.getCollectionInstantiator().createCollection(list.size());
            result = collection;
        }
        if (this.isFilterNulls()) {
            for (Object object : list) {
                if (object == null) continue;
                collection.add(object);
            }
        } else {
            collection.addAll(list);
        }
        return result;
    }

    protected void populateParameters(FullQueryBuilder<?, ?> queryBuilder) {
        FullQueryBuilder<?, ?> mainBuilder = this.entityViewConfiguration.getCriteriaBuilder();
        for (Parameter parameter : mainBuilder.getParameters()) {
            if (!queryBuilder.containsParameter(parameter.getName()) || queryBuilder.isParameterSet(parameter.getName())) continue;
            queryBuilder.setParameter(parameter.getName(), mainBuilder.getParameterValue(parameter.getName()));
        }
        for (Map.Entry entry : this.entityViewConfiguration.getOptionalParameters().entrySet()) {
            if (!queryBuilder.containsParameter((String)entry.getKey()) || queryBuilder.isParameterSet((String)entry.getKey())) continue;
            queryBuilder.setParameter((String)entry.getKey(), entry.getValue());
        }
    }

    protected static final class FixedArrayList
    implements List<Object> {
        private final Object[] array;
        private int size;

        public FixedArrayList(int size) {
            this.array = new Object[size];
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }

        @Override
        public Object set(int index, Object value) {
            this.array[index] = value;
            return null;
        }

        @Override
        public boolean add(Object value) {
            this.array[this.size++] = value;
            return true;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        public int realSize() {
            return this.size;
        }

        public void reset() {
            this.size = 0;
        }

        public void clearRest() {
            for (int i = this.size; i < this.array.length; ++i) {
                this.array[i] = null;
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.listIterator();
        }

        @Override
        public Object[] toArray() {
            return this.array;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            for (int i = 0; i < this.array.length; ++i) {
                if (!o.equals(this.array[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            for (int i = this.array.length - 1; i > -1; --i) {
                if (!o.equals(this.array[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ListIterator<Object> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<Object> listIterator(final int index) {
            return new ListIterator<Object>(){
                private int cursor;
                {
                    this.cursor = index;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor < FixedArrayList.this.array.length;
                }

                @Override
                public Object next() {
                    return FixedArrayList.this.array[this.cursor++];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor > 0;
                }

                @Override
                public Object previous() {
                    return FixedArrayList.this.array[--this.cursor];
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(Object o) {
                    ((FixedArrayList)FixedArrayList.this).array[this.cursor - 1] = 0;
                }

                @Override
                public void add(Object o) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public List<Object> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }

    protected static class TuplePromise {
        private final int index;
        private Object result;
        private TupleResultCopier copier;
        private boolean hasResult;
        private List<Object[]> tuples = new ArrayList<Object[]>();

        public TuplePromise(int index) {
            this.index = index;
        }

        public void add(Object[] tuple) {
            if (this.hasResult) {
                tuple[this.index] = this.copier.copy(this.result);
            } else {
                this.tuples.add(tuple);
            }
        }

        public void onResult(Object result, TupleResultCopier copier) {
            this.hasResult = true;
            this.result = result;
            this.copier = copier;
            this.tuples.get((int)0)[this.index] = result;
            for (int i = 1; i < this.tuples.size(); ++i) {
                this.tuples.get((int)i)[this.index] = copier.copy(result);
            }
        }

        public boolean hasResult() {
            return this.hasResult;
        }
    }
}

