/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.collection.CollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.AbstractCorrelatedBatchTupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.AbstractCorrelatedTupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.Correlator;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CorrelatedCollectionBatchTupleListTransformer
extends AbstractCorrelatedBatchTupleListTransformer {
    private final CollectionInstantiator collectionInstantiator;
    private final boolean filterNulls;
    private final boolean recording;

    public CorrelatedCollectionBatchTupleListTransformer(ExpressionFactory ef, Correlator correlator, ManagedViewType<?> viewRootType, ManagedViewType<?> embeddingViewType, String correlationResult, CorrelationProviderFactory correlationProviderFactory, String attributePath, String[] fetches, boolean correlatesThis, int viewRootIndex, int embeddingViewIndex, int tupleIndex, int batchSize, Class<?> correlationBasisType, Class<?> correlationBasisEntity, EntityViewConfiguration entityViewConfiguration, CollectionInstantiator collectionInstantiator, boolean filterNulls, boolean recording) {
        super(ef, correlator, viewRootType, embeddingViewType, correlationResult, correlationProviderFactory, attributePath, fetches, correlatesThis, viewRootIndex, embeddingViewIndex, tupleIndex, batchSize, correlationBasisType, correlationBasisEntity, entityViewConfiguration);
        this.collectionInstantiator = collectionInstantiator;
        this.filterNulls = filterNulls;
        this.recording = recording;
    }

    @Override
    protected void populateResult(Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> correlationValues, Object defaultKey, List<Object> list) {
        if (this.batchSize == 1) {
            correlationValues.get(defaultKey).onResult(this.createCollection(list), this);
            return;
        }
        HashMap<Object, Collection> collections = new HashMap<Object, Collection>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object[] element = (Object[])list.get(i);
            Collection result = (Collection)collections.get(element[this.keyIndex]);
            if (result == null) {
                result = (Collection)this.createDefaultResult();
                collections.put(element[this.keyIndex], result);
            }
            if (element[this.valueIndex] == null) continue;
            this.add(result, element[this.valueIndex]);
        }
        for (Map.Entry entry : collections.entrySet()) {
            correlationValues.get(entry.getKey()).onResult(this.postConstruct((Collection)entry.getValue()), this);
        }
    }

    private void add(Collection<Object> result, Object o) {
        if (this.recording) {
            ((RecordingCollection)result).getDelegate().add((Object)o);
        } else {
            result.add(o);
        }
    }

    @Override
    public Object copy(Object o) {
        return this.createCollection((Collection)o);
    }

    @Override
    protected boolean isRecording() {
        return this.recording;
    }

    @Override
    protected boolean isFilterNulls() {
        return this.filterNulls;
    }

    @Override
    protected CollectionInstantiator getCollectionInstantiator() {
        return this.collectionInstantiator;
    }
}

