/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.LimitBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.CorrelationProviderHelper;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.objectbuilder.ViewTypeObjectBuilderTemplate;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformerFactory;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.CorrelatedSubviewJoinTupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.JoinCorrelationBuilder;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import java.util.Map;

public class CorrelatedSubviewJoinTupleTransformerFactory
implements TupleTransformerFactory {
    private final ViewTypeObjectBuilderTemplate<Object[]> template;
    private final CorrelationProviderFactory correlationProviderFactory;
    private final String correlationBasis;
    private final String correlationAlias;
    private final String correlationResult;
    private final String joinBase;
    private final String embeddingViewPath;
    private final String[] fetches;

    public CorrelatedSubviewJoinTupleTransformerFactory(ViewTypeObjectBuilderTemplate<Object[]> template, CorrelationProviderFactory correlationProviderFactory, String joinBase, String correlationBasis, String correlationResult, String attributePath, String embeddingViewPath, String[] fetches) {
        this.template = template;
        this.correlationProviderFactory = correlationProviderFactory;
        this.correlationBasis = correlationBasis;
        this.correlationAlias = CorrelationProviderHelper.getDefaultCorrelationAlias(attributePath);
        this.correlationResult = correlationResult;
        this.joinBase = joinBase;
        this.embeddingViewPath = embeddingViewPath;
        this.fetches = fetches;
    }

    @Override
    public int getConsumeStartIndex() {
        return -1;
    }

    @Override
    public int getConsumeEndIndex() {
        return -1;
    }

    @Override
    public TupleTransformer create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, EntityViewConfiguration entityViewConfiguration) {
        if (parameterHolder instanceof FullQueryBuilder) {
            FullQueryBuilder queryBuilder = (FullQueryBuilder)parameterHolder;
            CorrelationProvider provider = this.correlationProviderFactory.create(parameterHolder, optionalParameters);
            JoinCorrelationBuilder correlationBuilder = new JoinCorrelationBuilder((SelectBuilder<?>)queryBuilder, (FullQueryBuilder<?, ?>)queryBuilder, this.joinBase, this.correlationAlias, this.correlationResult, null);
            int originalFirstResult = -1;
            int originalMaxResults = -1;
            if (queryBuilder instanceof LimitBuilder) {
                originalFirstResult = ((LimitBuilder)queryBuilder).getFirstResult();
                originalMaxResults = ((LimitBuilder)queryBuilder).getMaxResults();
            }
            EmbeddingViewJpqlMacro embeddingViewJpqlMacro = entityViewConfiguration.getEmbeddingViewJpqlMacro();
            String oldEmbeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
            embeddingViewJpqlMacro.setEmbeddingViewPath(this.embeddingViewPath);
            provider.applyCorrelation((CorrelationBuilder)correlationBuilder, this.correlationBasis);
            embeddingViewJpqlMacro.setEmbeddingViewPath(oldEmbeddingViewPath);
            if (queryBuilder instanceof LimitBuilder && (originalFirstResult != ((LimitBuilder)queryBuilder).getFirstResult() || originalMaxResults != ((LimitBuilder)queryBuilder).getMaxResults())) {
                throw new IllegalArgumentException("Correlation provider '" + provider + "' wrongly uses setFirstResult() or setMaxResults() on the query builder which might lead to wrong results. Use SELECT fetching with batch size 1 or reformulate the correlation provider to use the limit/offset in a subquery!");
            }
            if (this.fetches.length != 0) {
                for (int i = 0; i < this.fetches.length; ++i) {
                    queryBuilder.fetch(correlationBuilder.getCorrelationAlias() + "." + this.fetches[i]);
                }
            }
            ObjectBuilder<Object[]> objectBuilder = this.template.createObjectBuilder(parameterHolder, optionalParameters, entityViewConfiguration, 0, true, false);
            return new CorrelatedSubviewJoinTupleTransformer(this.template, objectBuilder);
        }
        throw new UnsupportedOperationException("Converting views with correlated attributes isn't supported!");
    }
}

