/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.CorrelationQueryBuilder;
import com.blazebit.persistence.FromProvider;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.view.CorrelationBuilder;
import javax.persistence.metamodel.EntityType;

public class JoinCorrelationBuilder
implements CorrelationBuilder {
    private final SelectBuilder<?> selectBuilder;
    private final FullQueryBuilder<?, ?> criteriaBuilder;
    private final String joinBase;
    private final String selectAlias;
    private final String correlationAlias;
    private final String correlationResult;
    private boolean correlated;

    public JoinCorrelationBuilder(SelectBuilder<?> selectBuilder, FullQueryBuilder<?, ?> criteriaBuilder, String joinBase, String correlationAlias, String correlationResult, String selectAlias) {
        this.selectBuilder = selectBuilder;
        this.criteriaBuilder = criteriaBuilder;
        this.joinBase = joinBase;
        this.correlationAlias = correlationAlias;
        this.correlationResult = correlationResult;
        this.selectAlias = selectAlias;
    }

    public <T> T getService(Class<T> serviceClass) {
        return (T)this.criteriaBuilder.getService(serviceClass);
    }

    public FromProvider getCorrelationFromProvider() {
        return this.criteriaBuilder;
    }

    public String getCorrelationAlias() {
        return this.correlationAlias;
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(Class<?> entityClass) {
        if (this.correlated) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        if (this.selectAlias != null) {
            this.selectBuilder.select(this.correlationResult, this.selectAlias);
        }
        this.correlated = true;
        return this.criteriaBuilder.leftJoinOn(this.joinBase, entityClass, this.correlationAlias);
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(EntityType<?> entityType) {
        if (this.correlated) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        if (this.selectAlias != null) {
            this.selectBuilder.select(this.correlationResult, this.selectAlias);
        }
        this.correlated = true;
        return this.criteriaBuilder.leftJoinOn(this.joinBase, entityType, this.correlationAlias);
    }
}

