/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.CorrelationQueryBuilder;
import com.blazebit.persistence.FromProvider;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.view.CorrelationBuilder;
import javax.persistence.metamodel.EntityType;

public class SubqueryCorrelationBuilder
implements CorrelationBuilder {
    private final FullQueryBuilder<?, ?> criteriaBuilder;
    private final String correlationAlias;
    private final String correlationResult;
    private final Class<?> correlationBasisType;
    private final Class<?> correlationBasisEntity;
    private final String correlationKeyAlias;
    private final String correlationJoinBase;
    private final int batchSize;
    private final boolean innerJoin;
    private String correlationRoot;

    public SubqueryCorrelationBuilder(FullQueryBuilder<?, ?> criteriaBuilder, String correlationAlias, String correlationResult, Class<?> correlationBasisType, Class<?> correlationBasisEntity, String correlationKeyAlias, String correlationJoinBase, int batchSize, boolean innerJoin, String attributePath) {
        this.criteriaBuilder = criteriaBuilder;
        this.correlationAlias = correlationAlias;
        this.correlationResult = correlationResult;
        this.correlationBasisType = correlationBasisType;
        this.correlationBasisEntity = correlationBasisEntity;
        this.correlationKeyAlias = correlationKeyAlias;
        this.correlationJoinBase = correlationJoinBase;
        this.batchSize = batchSize;
        this.innerJoin = innerJoin;
    }

    public <T> T getService(Class<T> serviceClass) {
        return (T)this.criteriaBuilder.getService(serviceClass);
    }

    public FromProvider getCorrelationFromProvider() {
        return this.criteriaBuilder;
    }

    public String getCorrelationAlias() {
        return this.correlationAlias;
    }

    public String getCorrelationRoot() {
        return this.correlationRoot;
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(Class<?> entityClass) {
        JoinOnBuilder correlationBuilder;
        if (this.correlationRoot != null) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        if (this.batchSize > 1) {
            if (this.correlationBasisEntity != null) {
                this.criteriaBuilder.fromIdentifiableValues(this.correlationBasisEntity, this.correlationKeyAlias, this.batchSize);
            } else {
                this.criteriaBuilder.fromValues(this.correlationBasisType, this.correlationKeyAlias, this.batchSize);
            }
            correlationBuilder = this.criteriaBuilder.innerJoinOn(this.correlationJoinBase, entityClass, this.correlationAlias);
        } else if (this.innerJoin) {
            correlationBuilder = this.criteriaBuilder.innerJoinOn(this.correlationJoinBase, entityClass, this.correlationAlias);
        } else {
            this.criteriaBuilder.from(entityClass, this.correlationAlias);
            correlationBuilder = (JoinOnBuilder)this.criteriaBuilder.getService(JoinOnBuilder.class);
        }
        this.correlationRoot = this.correlationResult;
        return correlationBuilder;
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(EntityType<?> entityType) {
        JoinOnBuilder correlationBuilder;
        if (this.correlationRoot != null) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        if (this.batchSize > 1) {
            if (this.correlationBasisEntity != null) {
                this.criteriaBuilder.fromIdentifiableValues(this.correlationBasisEntity, this.correlationKeyAlias, this.batchSize);
            } else {
                this.criteriaBuilder.fromValues(this.correlationBasisType, this.correlationKeyAlias, this.batchSize);
            }
            correlationBuilder = this.criteriaBuilder.innerJoinOn(entityType, this.correlationAlias);
        } else if (this.innerJoin) {
            correlationBuilder = this.criteriaBuilder.innerJoinOn(entityType, this.correlationAlias);
        } else {
            this.criteriaBuilder.from(entityType, this.correlationAlias);
            correlationBuilder = (JoinOnBuilder)this.criteriaBuilder.getService(JoinOnBuilder.class);
        }
        this.correlationRoot = this.correlationResult;
        return correlationBuilder;
    }
}

