/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.proxy;

import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.proxy.AbstractReflectionInstantiator;
import com.blazebit.persistence.view.impl.proxy.ProxyFactory;
import com.blazebit.persistence.view.metamodel.MappingConstructor;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;

public class ConstructorReflectionInstantiator<T>
extends AbstractReflectionInstantiator<T> {
    private final Constructor<T> constructor;

    public ConstructorReflectionInstantiator(MappingConstructor<T> mappingConstructor, ProxyFactory proxyFactory, ManagedViewTypeImplementor<T> viewType, ManagedViewTypeImplementor<T> viewTypeBase, Class<?>[] parameterTypes, EntityViewManager entityViewManager, List<AbstractReflectionInstantiator.MutableBasicUserTypeEntry> mutableBasicUserTypes, List<AbstractReflectionInstantiator.TypeConverterEntry> typeConverterEntries) {
        super(mutableBasicUserTypes, typeConverterEntries, parameterTypes);
        Constructor<T> javaConstructor;
        Class<T> proxyClazz = this.getProxyClass(entityViewManager, proxyFactory, viewType, viewTypeBase);
        try {
            javaConstructor = proxyClazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalArgumentException("The given mapping constructor '" + mappingConstructor + "' does not map to a constructor of the proxy class: " + proxyClazz.getName(), ex);
        }
        if (javaConstructor == null) {
            throw new IllegalArgumentException("The given mapping constructor '" + mappingConstructor + "' does not map to a constructor of the proxy class: " + proxyClazz.getName());
        }
        this.constructor = javaConstructor;
    }

    @Override
    public T newInstance(Object[] tuple) {
        try {
            this.prepareTuple(tuple);
            T instance = this.constructor.newInstance(tuple);
            this.finalizeInstance(instance);
            return instance;
        }
        catch (Exception ex) {
            Object[] types = new String[tuple.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = tuple[i] == null ? null : tuple[i].getClass().getName();
            }
            throw new RuntimeException("Could not invoke the proxy constructor '" + this.constructor + "' with the given tuple: " + Arrays.toString(tuple) + " with the types: " + Arrays.toString(types), ex);
        }
    }

    @Override
    protected Class<T> getProxyClass(EntityViewManager entityViewManager, ProxyFactory proxyFactory, ManagedViewTypeImplementor<T> viewType, ManagedViewTypeImplementor<T> viewTypeBase) {
        return proxyFactory.getProxy(entityViewManager, viewType, viewTypeBase);
    }
}

