/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.proxy;

import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.proxy.AbstractReflectionInstantiator;
import com.blazebit.persistence.view.impl.proxy.DirtyStateTrackable;
import com.blazebit.persistence.view.impl.proxy.ObjectInstantiator;
import com.blazebit.persistence.view.impl.proxy.ProxyFactory;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;

public class ConvertReflectionInstantiator<T>
implements ObjectInstantiator<T> {
    private final boolean resetInitialState;
    private final Constructor<T> constructor;
    private final AbstractReflectionInstantiator.TypeConverterEntry[] typeConverterEntries;

    public ConvertReflectionInstantiator(ProxyFactory proxyFactory, ManagedViewType<T> viewType, Class<?>[] parameterTypes, boolean resetInitialState, EntityViewManager entityViewManager) {
        Constructor javaConstructor;
        Class proxyClazz = proxyFactory.getProxy(entityViewManager, (ManagedViewTypeImplementor)viewType, null);
        try {
            javaConstructor = proxyClazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalArgumentException("Couldn't find expected constructor of the proxy class: " + proxyClazz.getName(), ex);
        }
        this.resetInitialState = resetInitialState && DirtyStateTrackable.class.isAssignableFrom(proxyClazz);
        this.constructor = javaConstructor;
        this.typeConverterEntries = AbstractReflectionInstantiator.withPrimitiveConverters(Collections.emptyList(), parameterTypes);
    }

    @Override
    public T newInstance(Object[] tuple) {
        try {
            for (int i = 0; i < this.typeConverterEntries.length; ++i) {
                AbstractReflectionInstantiator.TypeConverterEntry entry = this.typeConverterEntries[i];
                tuple[entry.index] = entry.typeConverter.convertToViewType(tuple[entry.index]);
            }
            T t = this.constructor.newInstance(tuple);
            if (this.resetInitialState) {
                Object[] initialState = ((DirtyStateTrackable)t).$$_getInitialState();
                for (int i = 0; i < initialState.length; ++i) {
                    initialState[i] = null;
                }
            }
            return t;
        }
        catch (Exception ex) {
            Object[] types = new String[tuple.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = tuple[i] == null ? null : tuple[i].getClass().getName();
            }
            throw new RuntimeException("Could not invoke the proxy constructor '" + this.constructor + "' with the given tuple: " + Arrays.toString(tuple) + " with the types: " + Arrays.toString(types), ex);
        }
    }
}

