/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.proxy;

import com.blazebit.lang.StringUtils;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.PackageOpener;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.CorrelationProviderProxyBase;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingList;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import com.blazebit.persistence.view.impl.collection.RecordingNavigableMap;
import com.blazebit.persistence.view.impl.collection.RecordingNavigableSet;
import com.blazebit.persistence.view.impl.collection.RecordingSet;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodPluralAttribute;
import com.blazebit.persistence.view.impl.metamodel.AbstractParameterAttribute;
import com.blazebit.persistence.view.impl.metamodel.BasicTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.ConstrainedAttribute;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingConstructorImpl;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImplementor;
import com.blazebit.persistence.view.impl.proxy.DirtyStateTrackable;
import com.blazebit.persistence.view.impl.proxy.DirtyTracker;
import com.blazebit.persistence.view.impl.proxy.MutableStateTrackable;
import com.blazebit.persistence.view.impl.proxy.UnsafeHelper;
import com.blazebit.persistence.view.metamodel.BasicType;
import com.blazebit.persistence.view.metamodel.FlatViewType;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MapAttribute;
import com.blazebit.persistence.view.metamodel.MappingConstructor;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.type.BasicDirtyTracker;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.reflection.ReflectionUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.StackMap;
import javassist.bytecode.StackMapTable;
import javassist.compiler.CompileError;
import javassist.compiler.JvstCodeGen;
import javassist.compiler.Lex;
import javassist.compiler.Parser;
import javassist.compiler.SymbolTable;
import javassist.compiler.ast.Stmnt;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;

public class ProxyFactory {
    private static final Logger LOG = Logger.getLogger(ProxyFactory.class.getName());
    private static final ConcurrentMap<Class<?>, AtomicInteger> CORRELATION_PROVIDER_CLASS_COUNT = new ConcurrentHashMap();
    private static final Path DEBUG_DUMP_DIRECTORY;
    private final ConcurrentMap<Class<?>, Class<?>> baseClasses = new ConcurrentHashMap();
    private final ConcurrentMap<ProxyClassKey, Class<?>> proxyClasses = new ConcurrentHashMap();
    private final ConcurrentMap<ProxyClassKey, Class<?>> unsafeProxyClasses = new ConcurrentHashMap();
    private final Object proxyLock = new Object();
    private final ClassPool pool = new ClassPool(ClassPool.getDefault());
    private final boolean unsafeDisabled;
    private final boolean strictCascadingCheck;
    private final PackageOpener packageOpener;

    public ProxyFactory(boolean unsafeDisabled, boolean strictCascadingCheck, PackageOpener packageOpener) {
        this.unsafeDisabled = unsafeDisabled;
        this.strictCascadingCheck = strictCascadingCheck;
        this.packageOpener = packageOpener;
    }

    public <T> Class<? extends T> getProxy(EntityViewManager entityViewManager, ManagedViewTypeImplementor<T> viewType, ManagedViewTypeImplementor<? super T> inheritanceBase) {
        if (viewType.getConstructors().isEmpty() || this.unsafeDisabled) {
            return this.getProxy(entityViewManager, viewType, inheritanceBase, false);
        }
        return this.getProxy(entityViewManager, viewType, inheritanceBase, true);
    }

    public Class<? extends CorrelationProvider> getCorrelationProviderProxy(Class<?> correlated, String correlationKeyAlias, String correlationExpression) {
        AtomicInteger oldCounter;
        AtomicInteger counter = (AtomicInteger)CORRELATION_PROVIDER_CLASS_COUNT.get(correlated);
        if (counter == null && (oldCounter = CORRELATION_PROVIDER_CLASS_COUNT.putIfAbsent(correlated, counter = new AtomicInteger(0))) != null) {
            counter = oldCounter;
        }
        int value = counter.getAndIncrement();
        String proxyClassName = correlated.getName() + "CorrelationProvider_$$_javassist_entityview_" + value;
        ClassClassPath classPath = new ClassClassPath(CorrelationProviderProxyBase.class);
        this.pool.insertClassPath((ClassPath)classPath);
        try {
            CtClass cc = this.pool.getAndRename(CorrelationProviderProxyBase.class.getName(), proxyClassName);
            CtConstructor otherConstructor = cc.getDeclaredConstructors()[0];
            CtClass[] emptyParamTypes = new CtClass[]{};
            CtConstructor newConstructor = new CtConstructor(emptyParamTypes, cc);
            newConstructor.setModifiers(1);
            ConstPool constPool = cc.getClassFile().getConstPool();
            Bytecode bytecode = new Bytecode(constPool, 4, 1);
            int correlatedIndex = constPool.addClassInfo(correlated.getName());
            int correlationKeyAliasIndex = constPool.addStringInfo(correlationKeyAlias);
            int correlationExpressionIndex = constPool.addStringInfo(correlationExpression);
            bytecode.addAload(0);
            bytecode.addLdc(correlatedIndex);
            bytecode.addLdc(correlationKeyAliasIndex);
            bytecode.addLdc(correlationExpressionIndex);
            bytecode.addInvokespecial(cc, "<init>", Descriptor.ofConstructor((CtClass[])otherConstructor.getParameterTypes()));
            bytecode.add(177);
            newConstructor.getMethodInfo().setCodeAttribute(bytecode.toCodeAttribute());
            cc.addConstructor(newConstructor);
            Class clazz = cc.toClass(correlated.getClassLoader(), null);
            return clazz;
        }
        catch (Exception ex) {
            throw new RuntimeException("Probably we did something wrong, please contact us if you see this message.", ex);
        }
        finally {
            this.pool.removeClassPath((ClassPath)classPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Class<? extends T> getProxy(EntityViewManager entityViewManager, ManagedViewTypeImplementor<T> viewType, ManagedViewTypeImplementor<? super T> inheritanceBase, boolean unsafe) {
        Class baseClazz;
        Class clazz;
        ProxyClassKey key;
        ConcurrentMap<ProxyClassKey, Class<?>> classes = unsafe ? this.unsafeProxyClasses : this.proxyClasses;
        Class<? super T> proxyClass = (Class<? super T>)classes.get(key = new ProxyClassKey(clazz = viewType.getJavaType(), baseClazz = inheritanceBase == null ? null : inheritanceBase.getJavaType()));
        if (proxyClass == null) {
            Object object = this.proxyLock;
            synchronized (object) {
                proxyClass = (Class)classes.get(key);
                if (proxyClass == null) {
                    proxyClass = this.createProxyClass(entityViewManager, viewType, inheritanceBase, unsafe);
                    classes.put(key, proxyClass);
                }
            }
        }
        return proxyClass;
    }

    private Class<?> getProxyBase(Class<?> baseClass) {
        if (baseClass.isInterface() || !java.lang.reflect.Modifier.isAbstract(baseClass.getSuperclass().getModifiers())) {
            return baseClass;
        }
        Class<?> proxyBaseClass = (Class<?>)this.baseClasses.get(baseClass);
        if (proxyBaseClass == null) {
            proxyBaseClass = this.createProxyBaseClass(baseClass);
            this.baseClasses.put(baseClass, proxyBaseClass);
        }
        return proxyBaseClass;
    }

    private Class<?> createProxyBaseClass(Class<?> baseClass) {
        String packageName = baseClass.getPackage().getName();
        LinkedHashMap classesToBaseProxy = new LinkedHashMap();
        for (Class<?> c = baseClass.getSuperclass(); c != Object.class; c = c.getSuperclass()) {
            if (!java.lang.reflect.Modifier.isAbstract(c.getModifiers()) || packageName.equals(c.getPackage().getName())) continue;
            classesToBaseProxy.put(c.getName(), c);
        }
        if (classesToBaseProxy.isEmpty()) {
            return baseClass;
        }
        ClassClassPath classPath = new ClassClassPath(baseClass);
        this.pool.insertClassPath((ClassPath)classPath);
        try {
            Class<Object> proxyClass = baseClass;
            for (Class classOfPackage : classesToBaseProxy.values()) {
                CtClass superCc = this.pool.get(proxyClass.getName());
                CtClass cc = this.pool.makeClass(classOfPackage.getName() + "_$$_javassist_proxybase_" + baseClass.getName().replace('.', '_'));
                cc.setSuperclass(superCc);
                String genericSignature = this.pool.get(classOfPackage.getName()).getGenericSignature();
                if (genericSignature != null) {
                    cc.setGenericSignature(genericSignature);
                }
                TreeMap<String, MethodInfo> methods = new TreeMap<String, MethodInfo>();
                HashMap<String, String> classNameMapping = new HashMap<String, String>();
                CtClass ctClass = this.pool.get(classOfPackage.getName());
                classNameMapping.put(classOfPackage.getName(), cc.getName());
                for (CtMethod method : ctClass.getDeclaredMethods()) {
                    if (!java.lang.reflect.Modifier.isAbstract(method.getModifiers()) || java.lang.reflect.Modifier.isPublic(method.getModifiers()) || java.lang.reflect.Modifier.isPrivate(method.getModifiers())) continue;
                    methods.put(method.getName() + " " + method.getMethodInfo().getDescriptor(), method.getMethodInfo());
                }
                for (MethodInfo value : methods.values()) {
                    MethodInfo methodInfo = new MethodInfo(cc.getClassFile().getConstPool(), value.getName(), value.getDescriptor());
                    if (value.getExceptionsAttribute() != null) {
                        methodInfo.setExceptionsAttribute((ExceptionsAttribute)value.getExceptionsAttribute().copy(cc.getClassFile().getConstPool(), classNameMapping));
                    }
                    for (AttributeInfo attribute : value.getAttributes()) {
                        methodInfo.addAttribute(attribute.copy(cc.getClassFile().getConstPool(), classNameMapping));
                    }
                    methodInfo.setAccessFlags(Modifier.setPublic((int)value.getAccessFlags()));
                    cc.addMethod(CtMethod.make((MethodInfo)methodInfo, (CtClass)cc));
                }
                proxyClass = this.defineOrGetClass(proxyClass, cc);
            }
            Class<?> clazz = proxyClass;
            return clazz;
        }
        catch (Exception ex) {
            throw new RuntimeException("Probably we did something wrong, please contact us if you see this message.", ex);
        }
        finally {
            this.pool.removeClassPath((ClassPath)classPath);
        }
    }

    private <T> Class<? extends T> createProxyClass(EntityViewManager entityViewManager, ManagedViewTypeImplementor<T> managedViewType, ManagedViewTypeImplementor<? super T> inheritanceBase, boolean unsafe) {
        String baseName;
        ViewType viewType = managedViewType instanceof ViewType ? (ViewType)managedViewType : null;
        Class clazz = managedViewType.getJavaType();
        String suffix = unsafe ? "unsafe_" : "";
        int subtypeIndex = 0;
        if (inheritanceBase == null) {
            baseName = clazz.getName();
        } else {
            subtypeIndex = managedViewType.getSubtypeIndex(inheritanceBase);
            baseName = inheritanceBase.getJavaType().getName();
            baseName = baseName + "_" + managedViewType.getJavaType().getSimpleName();
        }
        String proxyClassName = baseName + "_$$_javassist_entityview_" + suffix;
        CtClass cc = this.pool.makeClass(proxyClassName);
        ClassClassPath classPath = new ClassClassPath(clazz);
        this.pool.insertClassPath((ClassPath)classPath);
        try {
            CtClass superCc = this.pool.get(this.getProxyBase(clazz).getName());
            if (clazz.isInterface()) {
                cc.addInterface(superCc);
            } else {
                cc.setSuperclass(superCc);
            }
            boolean dirtyChecking = false;
            CtField dirtyField = null;
            CtField readOnlyParentsField = null;
            CtField parentField = null;
            CtField parentIndexField = null;
            CtField initialStateField = null;
            CtField mutableStateField = null;
            CtMethod markDirtyStub = null;
            cc.addInterface(this.pool.get(EntityViewProxy.class.getName()));
            this.addGetJpaManagedClass(cc, managedViewType.getEntityClass());
            this.addGetJpaManagedBaseClass(cc, this.getJpaManagedBaseClass(managedViewType));
            this.addGetEntityViewClass(cc, clazz);
            this.addIsNewMembers(managedViewType, cc, clazz);
            CtField evmField = new CtField(this.pool.get(EntityViewManager.class.getName()), "$$_evm", cc);
            evmField.setModifiers(73);
            cc.addField(evmField);
            if (managedViewType.isUpdatable() || managedViewType.isCreatable()) {
                cc.addInterface(this.pool.get(DirtyStateTrackable.class.getName()));
                initialStateField = new CtField(this.pool.get(Object[].class.getName()), "$$_initialState", cc);
                initialStateField.setModifiers(this.getModifiers(false));
                cc.addField(initialStateField);
                this.addGetter(cc, initialStateField, "$$_getInitialState");
                cc.addInterface(this.pool.get(MutableStateTrackable.class.getName()));
                cc.addInterface(this.pool.get(DirtyTracker.class.getName()));
                mutableStateField = new CtField(this.pool.get(Object[].class.getName()), "$$_mutableState", cc);
                mutableStateField.setModifiers(this.getModifiers(false));
                cc.addField(mutableStateField);
                CtField initializedField = new CtField(CtClass.booleanType, "$$_initialized", cc);
                initializedField.setModifiers(this.getModifiers(false));
                cc.addField(initializedField);
                readOnlyParentsField = new CtField(this.pool.get(List.class.getName()), "$$_readOnlyParents", cc);
                readOnlyParentsField.setModifiers(this.getModifiers(true));
                readOnlyParentsField.setGenericSignature(Descriptor.of((String)List.class.getName()) + "<" + Descriptor.of((String)Object.class.getName()) + ">;");
                cc.addField(readOnlyParentsField);
                parentField = new CtField(this.pool.get(DirtyTracker.class.getName()), "$$_parent", cc);
                parentField.setModifiers(this.getModifiers(true));
                cc.addField(parentField);
                parentIndexField = new CtField(CtClass.intType, "$$_parentIndex", cc);
                parentIndexField.setModifiers(this.getModifiers(true));
                cc.addField(parentIndexField);
                dirtyChecking = true;
                this.addGetter(cc, mutableStateField, "$$_getMutableState");
                this.addGetter(cc, readOnlyParentsField, "$$_getReadOnlyParents");
                this.addGetter(cc, parentField, "$$_getParent");
                this.addGetter(cc, parentIndexField, "$$_getParentIndex");
                this.addAddReadOnlyParent(cc, readOnlyParentsField, parentField);
                this.addRemoveReadOnlyParent(cc, readOnlyParentsField);
                this.addSetParent(cc, parentField, parentIndexField);
                this.addHasParent(cc, parentField);
                this.addUnsetParent(cc, parentField, parentIndexField, readOnlyParentsField);
                markDirtyStub = this.addMarkDirtyStub(cc);
            }
            LinkedHashSet attributes = new LinkedHashSet(managedViewType.getAttributes());
            CtField[] attributeFields = new CtField[attributes.size()];
            CtClass[] attributeTypes = new CtClass[attributes.size()];
            HashMap<String, CtField> fieldMap = new HashMap<String, CtField>(attributes.size());
            int i = 0;
            AbstractMethodAttribute idAttribute = null;
            CtField idField = null;
            AbstractMethodAttribute versionAttribute = null;
            if (viewType != null) {
                idAttribute = (AbstractMethodAttribute)viewType.getIdAttribute();
                versionAttribute = (AbstractMethodAttribute)viewType.getVersionAttribute();
                idField = this.addMembersForAttribute(idAttribute, clazz, cc, null, false, true, mutableStateField != null);
                fieldMap.put(idAttribute.getName(), idField);
                attributeFields[0] = idField;
                attributeTypes[0] = idField.getType();
                attributes.remove(idAttribute);
                i = 1;
                if (mutableStateField != null) {
                    this.addSetId(cc, idField);
                }
            } else if (mutableStateField != null) {
                this.addSetId(cc, null);
            }
            this.addGetter(cc, idField, "$$_getId", Object.class);
            AbstractMethodAttribute[] methodAttributes = new AbstractMethodAttribute[attributeFields.length];
            int mutableAttributeCount = 0;
            for (MethodAttribute attribute : attributes) {
                AbstractMethodAttribute methodAttribute = (AbstractMethodAttribute)attribute;
                boolean forceMutable = mutableStateField != null && methodAttribute == versionAttribute;
                CtField attributeField = this.addMembersForAttribute(methodAttribute, clazz, cc, mutableStateField, dirtyChecking, false, forceMutable);
                fieldMap.put(attribute.getName(), attributeField);
                attributeFields[i] = attributeField;
                attributeTypes[i] = attributeField.getType();
                methodAttributes[i] = methodAttribute;
                if (methodAttribute.hasDirtyStateIndex()) {
                    ++mutableAttributeCount;
                }
                ++i;
            }
            if (mutableStateField != null) {
                if (versionAttribute != null) {
                    CtField versionField = (CtField)fieldMap.get(versionAttribute.getName());
                    this.addGetter(cc, versionField, "$$_getVersion", Object.class);
                    this.addSetVersion(cc, versionField);
                } else {
                    this.addGetter(cc, null, "$$_getVersion", Object.class);
                    this.addSetVersion(cc, null);
                }
            } else {
                this.addGetter(cc, null, "$$_getVersion", Object.class);
            }
            if (dirtyChecking) {
                this.addReplaceAttribute(cc, methodAttributes);
                cc.removeMethod(markDirtyStub);
                if (mutableAttributeCount > 64) {
                    throw new IllegalArgumentException("Support for more than 64 mutable attributes per view is not yet implemented! " + viewType.getJavaType().getName() + " has " + mutableAttributeCount);
                }
                dirtyField = new CtField(CtClass.longType, "$$_dirty", cc);
                dirtyField.setModifiers(this.getModifiers(true));
                cc.addField(dirtyField);
                boolean allSupportDirtyTracking = true;
                boolean[] supportsDirtyTracking = new boolean[mutableAttributeCount];
                int mutableAttributeIndex = 0;
                for (int j = 0; j < methodAttributes.length; ++j) {
                    if (methodAttributes[j] == null || !methodAttributes[j].hasDirtyStateIndex()) continue;
                    if (this.supportsDirtyTracking(methodAttributes[j])) {
                        supportsDirtyTracking[mutableAttributeIndex++] = true;
                        continue;
                    }
                    allSupportDirtyTracking = false;
                    supportsDirtyTracking[mutableAttributeIndex++] = false;
                }
                this.addIsDirty(cc, dirtyField, allSupportDirtyTracking);
                this.addIsDirtyAttribute(cc, dirtyField, supportsDirtyTracking, allSupportDirtyTracking);
                this.addMarkDirty(cc, dirtyField);
                this.addUnmarkDirty(cc, dirtyField);
                this.addSetDirty(cc, dirtyField);
                this.addResetDirty(cc, dirtyField, supportsDirtyTracking, allSupportDirtyTracking);
                this.addGetDirty(cc, dirtyField, supportsDirtyTracking, allSupportDirtyTracking);
                this.addGetSimpleDirty(cc, dirtyField, supportsDirtyTracking, allSupportDirtyTracking);
                this.addCopyDirty(cc, dirtyField, supportsDirtyTracking, allSupportDirtyTracking);
            }
            this.createEqualsHashCodeMethods(viewType, managedViewType, cc, superCc, attributeFields, idField);
            cc.addMethod(this.createToString(managedViewType, cc, viewType != null, attributeFields));
            this.createSpecialMethods(managedViewType, cc);
            Set constructors = managedViewType.getConstructors();
            boolean hasEmptyConstructor = managedViewType.hasEmptyConstructor();
            if (hasEmptyConstructor) {
                cc.addConstructor(this.createCreateConstructor(entityViewManager, managedViewType, cc, attributeFields, attributeTypes, idField, initialStateField, mutableStateField, methodAttributes, mutableAttributeCount, unsafe));
            }
            boolean addedReferenceConstructor = false;
            if (idField != null && hasEmptyConstructor) {
                cc.addConstructor(this.createReferenceConstructor(entityViewManager, managedViewType, cc, attributeFields, idField, initialStateField, mutableStateField, methodAttributes, mutableAttributeCount, unsafe));
                addedReferenceConstructor = true;
            }
            if (inheritanceBase == null) {
                if (this.shouldAddDefaultConstructor(hasEmptyConstructor, addedReferenceConstructor, attributeFields)) {
                    cc.addConstructor(this.createNormalConstructor(entityViewManager, managedViewType, cc, attributeFields, attributeTypes, initialStateField, mutableStateField, methodAttributes, mutableAttributeCount, unsafe));
                }
                for (MappingConstructorImpl constructor : constructors) {
                    int constructorParameterCount = attributeFields.length + constructor.getParameterAttributes().size();
                    if (constructor.getParameterAttributes().size() == 0) continue;
                    CtClass[] constructorAttributeTypes = new CtClass[constructorParameterCount];
                    System.arraycopy(attributeTypes, 0, constructorAttributeTypes, 0, attributeFields.length);
                    CtConstructor superConstructor = this.findConstructor(superCc, constructor);
                    System.arraycopy(superConstructor.getParameterTypes(), 0, constructorAttributeTypes, attributeFields.length, superConstructor.getParameterTypes().length);
                    cc.addConstructor(this.createNormalConstructor(entityViewManager, managedViewType, cc, attributeFields, constructorAttributeTypes, initialStateField, mutableStateField, methodAttributes, mutableAttributeCount, unsafe));
                }
            } else {
                this.createInheritanceConstructors(entityViewManager, constructors, inheritanceBase, managedViewType, subtypeIndex, addedReferenceConstructor, unsafe, cc, initialStateField, mutableStateField, fieldMap);
            }
            Class<T> clazz2 = this.defineOrGetClass(entityViewManager, unsafe, clazz, cc);
            return clazz2;
        }
        catch (Exception ex) {
            throw new RuntimeException("Probably we did something wrong, please contact us if you see this message.", ex);
        }
        finally {
            this.pool.removeClassPath((ClassPath)classPath);
        }
    }

    private Class<?> getJpaManagedBaseClass(ManagedViewTypeImplementor<?> managedViewType) {
        IdentifiableType jpaManagedType = managedViewType.getJpaManagedType();
        if (jpaManagedType instanceof EntityType) {
            EntityType entityType = (EntityType)jpaManagedType;
            while ((jpaManagedType = entityType.getSupertype()) instanceof EntityType) {
                entityType = (EntityType)jpaManagedType;
            }
            return entityType.getJavaType();
        }
        return managedViewType.getEntityClass();
    }

    private <T> Class<? extends T> defineOrGetClass(Class<?> clazz, CtClass cc) throws IOException, IllegalAccessException, NoSuchFieldException, CannotCompileException {
        return this.defineOrGetClass(null, false, clazz, cc);
    }

    private <T> Class<? extends T> defineOrGetClass(EntityViewManager entityViewManager, boolean unsafe, Class<?> clazz, CtClass cc) throws IOException, IllegalAccessException, NoSuchFieldException, CannotCompileException {
        try {
            this.packageOpener.openPackageIfNeeded(clazz, clazz.getPackage().getName(), ProxyFactory.class);
            if (DEBUG_DUMP_DIRECTORY != null) {
                cc.writeFile(DEBUG_DUMP_DIRECTORY.toString());
            }
            Class<?> c = unsafe ? UnsafeHelper.define(cc.getName(), cc.toBytecode(), clazz) : cc.toClass(clazz.getClassLoader(), null);
            if (entityViewManager != null) {
                c.getField("$$_evm").set(null, entityViewManager);
            }
            return c;
        }
        catch (LinkageError | CannotCompileException ex) {
            LinkageError error;
            if (ex instanceof LinkageError && (error = (LinkageError)ex) != null || ex.getCause() instanceof InvocationTargetException && ex.getCause().getCause() instanceof LinkageError && (error = (LinkageError)ex.getCause().getCause()) != null || ex.getCause() instanceof LinkageError && (error = (LinkageError)ex.getCause()) != null) {
                try {
                    return this.pool.getClassLoader().loadClass(cc.getName());
                }
                catch (ClassNotFoundException cnfe) {
                    throw error;
                }
            }
            throw ex;
        }
        catch (NullPointerException ex) {
            try {
                return this.pool.getClassLoader().loadClass(cc.getName());
            }
            catch (ClassNotFoundException cnfe) {
                throw ex;
            }
        }
    }

    private boolean shouldAddDefaultConstructor(boolean hasEmptyConstructor, boolean addedReferenceConstructor, CtField[] attributeFields) {
        return hasEmptyConstructor && (!addedReferenceConstructor && attributeFields.length > 0 || addedReferenceConstructor && attributeFields.length > 1);
    }

    /*
     * WARNING - void declaration
     */
    private <T> void createInheritanceConstructors(EntityViewManager entityViewManager, Set<MappingConstructorImpl<T>> constructors, ManagedViewTypeImplementor<? super T> inheritanceBase, ManagedViewTypeImplementor<T> managedView, int subtypeIndex, boolean addedReferenceConstructor, boolean unsafe, CtClass cc, CtField initialStateField, CtField mutableStateField, Map<String, CtField> fieldMap) throws NotFoundException, CannotCompileException, BadBytecode {
        Map<ManagedViewTypeImpl.AttributeKey, ConstrainedAttribute<AbstractMethodAttribute<T, ?>>> overallAttributesClosure = inheritanceBase.getOverallInheritanceSubtypeConfiguration().getAttributesClosure();
        CtClass[] overallParameterTypes = new CtClass[overallAttributesClosure.size()];
        HashMap<String, CtClass[]> overallConstructorParameterTypes = new HashMap<String, CtClass[]>();
        CtField[] fields = new CtField[overallAttributesClosure.size()];
        AbstractMethodAttribute[] subtypeAttributes = new AbstractMethodAttribute[overallAttributesClosure.size()];
        int subtypeMutableAttributeCount = 0;
        String idName = null;
        int j = 0;
        if (inheritanceBase instanceof ViewType) {
            CtField field;
            idName = ((ViewType)inheritanceBase).getIdAttribute().getName();
            fields[j] = field = fieldMap.get(idName);
            overallParameterTypes[j] = field.getType();
            ++j;
        }
        for (Map.Entry<ManagedViewTypeImpl.AttributeKey, ConstrainedAttribute<AbstractMethodAttribute<T, ?>>> entry : overallAttributesClosure.entrySet()) {
            CtField ctField;
            String string = entry.getKey().getAttributeName();
            if (string.equals(idName)) continue;
            AbstractMethodAttribute<T, ?> attribute = entry.getValue().getSubAttribute(managedView);
            if (((ConstrainedAttribute)entry.getValue()).getSelectionConstrainedAttributes().isEmpty()) {
                subtypeAttributes[j] = attribute;
                if (attribute.hasDirtyStateIndex()) {
                    ++subtypeMutableAttributeCount;
                }
            } else {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                if (((ConstrainedAttribute)entry.getValue()).getAttribute() != attribute) {
                    treeSet.add(subtypeIndex);
                }
                for (ConstrainedAttribute.Entry selectionConstrainedAttribute : ((ConstrainedAttribute)entry.getValue()).getSelectionConstrainedAttributes()) {
                    for (int index : selectionConstrainedAttribute.getSubtypeIndexes()) {
                        treeSet.add(index);
                    }
                }
                if (treeSet.contains(subtypeIndex)) {
                    subtypeAttributes[j] = attribute;
                    if (attribute.hasDirtyStateIndex()) {
                        ++subtypeMutableAttributeCount;
                    }
                }
            }
            CtClass type = (ctField = fieldMap.get(string)) == null ? this.getType(attribute) : ctField.getType();
            fields[j] = ctField;
            overallParameterTypes[j] = type;
            ++j;
        }
        boolean hasEmptyConstructor = managedView.hasEmptyConstructor();
        boolean addedDefaultConstructor = this.shouldAddDefaultConstructor(hasEmptyConstructor, addedReferenceConstructor, fields);
        if (addedDefaultConstructor) {
            cc.addConstructor(this.createNormalConstructor(entityViewManager, managedView, cc, fields, overallParameterTypes, initialStateField, mutableStateField, subtypeAttributes, subtypeMutableAttributeCount, unsafe));
        }
        for (MappingConstructorImpl mappingConstructorImpl : constructors) {
            if (mappingConstructorImpl.getParameterAttributes().isEmpty()) continue;
            MappingConstructorImpl baseConstructor = (MappingConstructorImpl)inheritanceBase.getConstructor(mappingConstructorImpl.getName());
            MappingConstructorImpl.InheritanceSubtypeConstructorConfiguration inheritanceSubtypeConstructorConfiguration = baseConstructor.getOverallInheritanceParametersAttributesClosureConfiguration();
            List parameterAttributes = inheritanceSubtypeConstructorConfiguration.getParameterAttributesClosure();
            int constructorParameterCount = fields.length + parameterAttributes.size();
            CtClass[] constructorAttributeTypes = new CtClass[constructorParameterCount];
            System.arraycopy(overallParameterTypes, 0, constructorAttributeTypes, 0, overallParameterTypes.length);
            int constructorParameterStartPosition = fields.length;
            int i = 0;
            for (ManagedViewType managedViewType : inheritanceBase.getOverallInheritanceSubtypeConfiguration().getInheritanceSubtypes()) {
                if (i == subtypeIndex) break;
                constructorParameterStartPosition += managedViewType.getConstructor(mappingConstructorImpl.getName()).getParameterAttributes().size();
                ++i;
            }
            i = fields.length;
            for (AbstractParameterAttribute abstractParameterAttribute : parameterAttributes) {
                constructorAttributeTypes[i++] = this.getType(abstractParameterAttribute);
            }
            overallConstructorParameterTypes.put(mappingConstructorImpl.getName(), constructorAttributeTypes);
            int superConstructorParameterEndPosition = constructorParameterStartPosition + mappingConstructorImpl.getParameterAttributes().size();
            cc.addConstructor(this.createConstructor(entityViewManager, managedView, cc, constructorParameterStartPosition, superConstructorParameterEndPosition, fields, constructorAttributeTypes, initialStateField, mutableStateField, subtypeAttributes, subtypeMutableAttributeCount, ConstructorKind.NORMAL, null, unsafe));
        }
        Map<Map<ManagedViewTypeImplementor<T>, String>, ManagedViewTypeImpl.InheritanceSubtypeConfiguration<T>> inheritanceSubtypeConfigurationMap = inheritanceBase.getInheritanceSubtypeConfigurations();
        for (Map.Entry<Map<ManagedViewTypeImplementor<T>, String>, ManagedViewTypeImpl.InheritanceSubtypeConfiguration<T>> configurationEntry : inheritanceSubtypeConfigurationMap.entrySet()) {
            if (!configurationEntry.getKey().containsKey(managedView)) continue;
            ManagedViewTypeImpl.InheritanceSubtypeConfiguration<T> inheritanceSubtypeConfiguration = configurationEntry.getValue();
            Map<ManagedViewTypeImpl.AttributeKey, ConstrainedAttribute<AbstractMethodAttribute<T, ?>>> subtypeAttributesClosure = inheritanceSubtypeConfiguration.getAttributesClosure();
            CtClass[] parameterTypes = new CtClass[subtypeAttributesClosure.size()];
            String idName2 = null;
            int n = 0;
            if (inheritanceBase instanceof ViewType) {
                idName2 = ((ViewType)inheritanceBase).getIdAttribute().getName();
                CtField field = fieldMap.get(idName2);
                parameterTypes[n] = field.getType();
                ++n;
            }
            for (Map.Entry<ManagedViewTypeImpl.AttributeKey, ConstrainedAttribute<AbstractMethodAttribute<T, ?>>> entry : subtypeAttributesClosure.entrySet()) {
                void var23_30;
                CtClass type;
                String attributeName = entry.getKey().getAttributeName();
                if (attributeName.equals(idName2)) continue;
                CtField field = fieldMap.get(attributeName);
                if (field != null) {
                    type = field.getType();
                } else {
                    AbstractMethodAttribute<T, ?> attribute = entry.getValue().getSubAttribute(managedView);
                    type = this.getType(attribute);
                }
                parameterTypes[var23_30] = type;
                ++var23_30;
            }
            if (addedDefaultConstructor) {
                cc.addMethod(this.createStaticFactory(cc, inheritanceSubtypeConfiguration.getConfigurationIndex(), "", 0, inheritanceSubtypeConfiguration.getOverallPositionAssignment(managedView), parameterTypes, overallParameterTypes));
            }
            for (MappingConstructorImpl mappingConstructorImpl : constructors) {
                if (mappingConstructorImpl.getParameterAttributes().isEmpty()) continue;
                MappingConstructorImpl baseConstructor = (MappingConstructorImpl)inheritanceBase.getConstructor(mappingConstructorImpl.getName());
                MappingConstructorImpl.InheritanceSubtypeConstructorConfiguration subtypeConstructorConfiguration = baseConstructor.getSubtypeConstructorConfiguration(configurationEntry.getKey());
                List parameterAttributes = subtypeConstructorConfiguration.getParameterAttributesClosure();
                int constructorParameterCount = parameterTypes.length + parameterAttributes.size();
                CtClass[] constructorAttributeTypes = new CtClass[constructorParameterCount];
                System.arraycopy(parameterTypes, 0, constructorAttributeTypes, 0, parameterTypes.length);
                int i = parameterTypes.length;
                for (AbstractParameterAttribute abstractParameterAttribute : parameterAttributes) {
                    constructorAttributeTypes[i++] = this.getType(abstractParameterAttribute);
                }
                cc.addMethod(this.createStaticFactory(cc, inheritanceSubtypeConfiguration.getConfigurationIndex(), "_" + mappingConstructorImpl.getName(), parameterTypes.length, subtypeConstructorConfiguration.getOverallPositionAssignment(), constructorAttributeTypes, (CtClass[])overallConstructorParameterTypes.get(mappingConstructorImpl.getName())));
            }
        }
    }

    private CtMethod createStaticFactory(CtClass cc, int inheritanceConfigurationIndex, String suffix, int passThroughCount, int[] positionAssignments, CtClass[] parameterTypes, CtClass[] overallParameterTypes) throws CannotCompileException {
        int i;
        String descriptor = Descriptor.ofMethod((CtClass)cc, (CtClass[])parameterTypes);
        ConstPool cp = cc.getClassFile2().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "create" + inheritanceConfigurationIndex + suffix, descriptor);
        minfo.setAccessFlags(9);
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\treturn new ");
        sb.append(cc.getName()).append("(\n");
        for (i = 0; i < passThroughCount; ++i) {
            sb.append("\t\t");
            sb.append('$').append(positionAssignments[i] + 1);
            sb.append(",\n");
        }
        for (i = 0; i < positionAssignments.length; ++i) {
            sb.append("\t\t");
            if (positionAssignments[i] == -1) {
                sb.append(this.getDefaultValue(overallParameterTypes[i]));
            } else {
                sb.append('$').append(passThroughCount + positionAssignments[i] + 1);
            }
            sb.append(",\n");
        }
        sb.setLength(sb.length() - 2);
        sb.append("\n\t);\n");
        sb.append("}");
        method.setBody(sb.toString());
        return method;
    }

    private <T> void createEqualsHashCodeMethods(ViewType<T> viewType, ManagedViewTypeImplementor<T> managedViewType, CtClass cc, CtClass superCc, CtField[] attributeFields, CtField idField) throws NotFoundException, CannotCompileException {
        CtClass equalsDeclaringClass = superCc.getMethod("equals", this.getEqualsDesc()).getDeclaringClass();
        CtClass hashCodeDeclaringClass = superCc.getMethod("hashCode", this.getHashCodeDesc()).getDeclaringClass();
        boolean hasCustomEqualsHashCode = false;
        if (!"java.lang.Object".equals(equalsDeclaringClass.getName())) {
            hasCustomEqualsHashCode = true;
            LOG.warning("The class '" + equalsDeclaringClass.getName() + "' declares 'boolean equals(java.lang.Object)'! Hopefully you implemented it based on a unique key!");
        }
        if (!"java.lang.Object".equals(hashCodeDeclaringClass.getName())) {
            hasCustomEqualsHashCode = true;
            LOG.warning("The class '" + hashCodeDeclaringClass.getName() + "' declares 'int hashCode()'! Hopefully you implemented it based on a unique key!");
        }
        if (!hasCustomEqualsHashCode) {
            if (viewType != null) {
                cc.addMethod(this.createIdEquals(managedViewType, cc));
                cc.addMethod(this.createHashCode(cc, idField));
            } else {
                cc.addMethod(this.createEquals(managedViewType, cc, attributeFields));
                cc.addMethod(this.createHashCode(cc, attributeFields));
            }
        }
    }

    private void createSpecialMethods(ManagedViewTypeImplementor<?> viewType, CtClass cc) throws CannotCompileException {
        for (Method method : viewType.getSpecialMethods()) {
            if (method.getReturnType() == EntityViewManager.class) {
                this.addEntityViewManagerGetter(cc, method);
                continue;
            }
            throw new IllegalArgumentException("Unsupported special method: " + method);
        }
    }

    private void addEntityViewManagerGetter(CtClass cc, Method method) throws CannotCompileException {
        ConstPool cp = cc.getClassFile2().getConstPool();
        String desc = Descriptor.of((String)method.getReturnType().getName());
        MethodInfo minfo = new MethodInfo(cp, method.getName(), "()" + desc);
        minfo.setAccessFlags(1);
        Bytecode code = new Bytecode(cp, 1, 1);
        code.addGetstatic(cc, "$$_evm", desc);
        code.addOpcode(176);
        minfo.setCodeAttribute(code.toCodeAttribute());
        cc.addMethod(CtMethod.make((MethodInfo)minfo, (CtClass)cc));
    }

    private void addGetJpaManagedClass(CtClass cc, Class<?> entityClass) throws CannotCompileException {
        ConstPool cp = cc.getClassFile2().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_getJpaManagedClass", "()Ljava/lang/Class;");
        minfo.addAttribute((AttributeInfo)new SignatureAttribute(cp, "()Ljava/lang/Class<*>;"));
        minfo.setAccessFlags(1);
        Bytecode code = new Bytecode(cp, 1, 1);
        code.addLdc(cp.addClassInfo(entityClass.getName()));
        code.addOpcode(176);
        minfo.setCodeAttribute(code.toCodeAttribute());
        cc.addMethod(CtMethod.make((MethodInfo)minfo, (CtClass)cc));
    }

    private void addGetJpaManagedBaseClass(CtClass cc, Class<?> entityClass) throws CannotCompileException {
        ConstPool cp = cc.getClassFile2().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_getJpaManagedBaseClass", "()Ljava/lang/Class;");
        minfo.addAttribute((AttributeInfo)new SignatureAttribute(cp, "()Ljava/lang/Class<*>;"));
        minfo.setAccessFlags(1);
        Bytecode code = new Bytecode(cp, 1, 1);
        code.addLdc(cp.addClassInfo(entityClass.getName()));
        code.addOpcode(176);
        minfo.setCodeAttribute(code.toCodeAttribute());
        cc.addMethod(CtMethod.make((MethodInfo)minfo, (CtClass)cc));
    }

    private void addGetEntityViewClass(CtClass cc, Class<?> entityViewClass) throws CannotCompileException {
        ConstPool cp = cc.getClassFile2().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_getEntityViewClass", "()Ljava/lang/Class;");
        minfo.addAttribute((AttributeInfo)new SignatureAttribute(cp, "()Ljava/lang/Class<*>;"));
        minfo.setAccessFlags(1);
        Bytecode code = new Bytecode(cp, 1, 1);
        code.addLdc(cp.addClassInfo(entityViewClass.getName()));
        code.addOpcode(176);
        minfo.setCodeAttribute(code.toCodeAttribute());
        cc.addMethod(CtMethod.make((MethodInfo)minfo, (CtClass)cc));
    }

    private void addIsNewMembers(ManagedViewType<?> managedViewType, CtClass cc, Class<?> clazz) throws CannotCompileException, NotFoundException {
        if (managedViewType.isCreatable()) {
            CtField isNewField = new CtField(CtClass.booleanType, "$$_isNew", cc);
            isNewField.setModifiers(this.getModifiers(true));
            cc.addField(isNewField);
            this.addGetter(cc, isNewField, "$$_isNew");
            this.addSetter(null, cc, isNewField, "$$_setIsNew", null, false, false);
        } else {
            ClassPool classPool = cc.getClassPool();
            try {
                this.addEmptyIsNew(cc, classPool.get("boolean"));
                this.addEmptySetIsNew(cc, classPool.get("boolean"));
            }
            catch (NotFoundException e) {
                throw new CannotCompileException(e);
            }
        }
    }

    private CtMethod addGetter(CtClass cc, CtField field, String methodName) throws CannotCompileException {
        return this.addGetter(cc, field, methodName, field.getFieldInfo().getDescriptor(), false);
    }

    private CtMethod addGetter(CtClass cc, CtField field, String methodName, Class<?> returnType) throws CannotCompileException {
        if (returnType.isArray()) {
            return this.addGetter(cc, field, methodName, Descriptor.toJvmName((String)returnType.getName()), false);
        }
        try {
            return this.addGetter(cc, field, methodName, Descriptor.of((String)returnType.getName()), !returnType.isPrimitive() && field != null && field.getType().isPrimitive());
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CtMethod addGetter(CtClass cc, CtField field, String methodName, String returnTypeDescriptor, boolean autoBox) throws CannotCompileException {
        Bytecode code;
        MethodInfo minfo;
        block7: {
            block6: {
                ConstPool cp = cc.getClassFile2().getConstPool();
                minfo = new MethodInfo(cp, methodName, "()" + returnTypeDescriptor);
                minfo.setAccessFlags(1);
                code = new Bytecode(cp, this.needsTwoStackSlots(Descriptor.toClassName((String)returnTypeDescriptor)) ? 2 : 1, 1);
                if (field == null) break block6;
                code.addAload(0);
                code.addGetfield(cc, field.getName(), field.getFieldInfo().getDescriptor());
                if (autoBox) {
                    try {
                        this.autoBox(code, cc.getClassPool(), field.getType());
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Unsupported primitive type: " + Descriptor.toClassName((String)field.getFieldInfo().getDescriptor()), ex);
                    }
                    code.addOpcode(176);
                    break block7;
                } else {
                    try {
                        code.addReturn(field.getType());
                    }
                    catch (NotFoundException e) {
                        throw new CannotCompileException(e);
                    }
                }
            }
            code.addOpcode(1);
            code.add(176);
        }
        minfo.setCodeAttribute(code.toCodeAttribute());
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        cc.addMethod(method);
        return method;
    }

    private CtField addMembersForAttribute(AbstractMethodAttribute<?, ?> attribute, Class<?> clazz, CtClass cc, CtField mutableStateField, boolean dirtyChecking, boolean isId, boolean forceMutable) throws CannotCompileException, NotFoundException {
        Method getter = attribute.getJavaMethod();
        Method setter = ReflectionUtils.getSetter(clazz, (String)attribute.getName());
        CtField attributeField = new CtField(this.getType(attribute), attribute.getName(), cc);
        attributeField.setModifiers(this.getModifiers(forceMutable || setter != null));
        String genericSignature = this.getGenericSignature(attribute, attributeField);
        if (genericSignature != null) {
            this.setGenericSignature(attributeField, genericSignature);
        }
        cc.addField(attributeField);
        this.createGettersAndSetters(attribute, clazz, cc, getter, setter, mutableStateField, attributeField, dirtyChecking, isId);
        return attributeField;
    }

    private void createGettersAndSetters(AbstractMethodAttribute<?, ?> attribute, Class<?> clazz, CtClass cc, Method getter, Method setter, CtField mutableStateField, CtField attributeField, boolean dirtyChecking, boolean isId) throws CannotCompileException, NotFoundException {
        SignatureAttribute sa = (SignatureAttribute)attributeField.getFieldInfo2().getAttribute("Signature");
        String genericSignature = sa == null ? null : sa.getSignature();
        List<Method> bridgeGetters = this.getBridgeGetters(clazz, attribute, getter);
        CtMethod attributeGetter = this.addGetter(cc, attributeField, getter.getName());
        if (genericSignature != null) {
            String getterGenericSignature = "()" + genericSignature;
            this.setGenericSignature(attributeGetter, getterGenericSignature);
        }
        for (Method m : bridgeGetters) {
            CtMethod getterBridge = this.createGetterBridge(cc, m, attributeGetter);
            cc.addMethod(getterBridge);
        }
        if (setter != null) {
            CtMethod attributeSetter = this.addSetter(attribute, cc, attributeField, setter.getName(), mutableStateField, dirtyChecking, isId);
            List<Method> bridgeSetters = this.getBridgeSetters(clazz, attribute, setter);
            if (genericSignature != null) {
                String setterGenericSignature = "(" + genericSignature + ")V";
                this.setGenericSignature(attributeSetter, setterGenericSignature);
            }
            for (Method m : bridgeSetters) {
                CtMethod setterBridge = this.createSetterBridge(cc, m, attributeSetter);
                cc.addMethod(setterBridge);
            }
        }
    }

    private CtMethod addEmptyIsNew(CtClass cc, CtClass returnType) throws CannotCompileException {
        String desc = "()" + Descriptor.of((CtClass)returnType);
        ConstPool cp = cc.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_isNew", desc);
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        minfo.setAccessFlags(1);
        method.setBody("{ return false; }");
        cc.addMethod(method);
        return method;
    }

    private CtMethod addEmptySetIsNew(CtClass cc, CtClass argumentType) throws CannotCompileException {
        String desc = "(" + Descriptor.of((CtClass)argumentType) + ")V";
        ConstPool cp = cc.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_setIsNew", desc);
        minfo.setAccessFlags(1);
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody("{}");
        cc.addMethod(method);
        return method;
    }

    private CtMethod addIsDirty(CtClass cc, CtField dirtyField, boolean allSupportDirtyTracking) throws CannotCompileException {
        String desc = "()" + Descriptor.of((String)"boolean");
        ConstPool cp = cc.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_isDirty", desc);
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        minfo.setAccessFlags(1);
        if (allSupportDirtyTracking) {
            method.setBody("{ return $0." + dirtyField.getName() + " != 0; }");
        } else {
            method.setBody("{ return true; }");
        }
        cc.addMethod(method);
        return method;
    }

    private CtMethod addIsDirtyAttribute(CtClass cc, CtField dirtyField, boolean[] supportsDirtyTracking, boolean allSupportDirtyTracking) throws CannotCompileException {
        String desc = "(" + Descriptor.of((String)"int") + ")" + Descriptor.of((String)"boolean");
        ConstPool cp = cc.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_isDirty", desc);
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        minfo.setAccessFlags(1);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        if (!allSupportDirtyTracking) {
            sb.append("\tswitch ($1) {\n");
            for (int i = 0; i < supportsDirtyTracking.length; ++i) {
                if (supportsDirtyTracking[i]) continue;
                sb.append("\t\tcase ").append(i).append(": return true;\n");
            }
            sb.append("\t\tdefault : break;\n");
            sb.append("\t}\n");
        }
        sb.append("\treturn ($0.").append(dirtyField.getName()).append(" & (1L << $1)) != 0;\n");
        sb.append("}");
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addMarkDirtyStub(CtClass cc) throws CannotCompileException {
        String desc = "(" + Descriptor.of((String)"int") + ")V";
        ConstPool cp = cc.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_markDirty", desc);
        minfo.setAccessFlags(1);
        StringBuilder sb = new StringBuilder();
        sb.append("{}");
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addMarkDirty(CtClass cc, CtField dirtyField) throws CannotCompileException {
        FieldInfo dirtyFieldInfo = dirtyField.getFieldInfo2();
        String desc = "(" + Descriptor.of((String)"int") + ")V";
        ConstPool cp = dirtyFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_markDirty", desc);
        minfo.setAccessFlags(1);
        String dirtyFieldName = dirtyFieldInfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\t$0.").append(dirtyFieldName).append(" |= (1 << $1);\n");
        sb.append("\tif ($0.$$_parent != null) {\n");
        sb.append("\t$0.$$_parent.$$_markDirty($0.$$_parentIndex);\n");
        sb.append("\t}\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addSetDirty(CtClass cc, CtField dirtyField) throws CannotCompileException {
        FieldInfo dirtyFieldInfo = dirtyField.getFieldInfo2();
        String desc = "([" + Descriptor.of((String)"long") + ")V";
        ConstPool cp = dirtyFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_setDirty", desc);
        minfo.setAccessFlags(1);
        String dirtyFieldName = dirtyFieldInfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\t$0.").append(dirtyFieldName).append(" = $1[0];\n");
        sb.append("\tif ($0.").append(dirtyFieldName).append(" != 0 && $0.$$_parent != null) {\n");
        sb.append("\t\t$0.$$_parent.$$_markDirty($0.$$_parentIndex);\n");
        sb.append("\t}\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addUnmarkDirty(CtClass cc, CtField dirtyField) throws CannotCompileException {
        FieldInfo dirtyFieldInfo = dirtyField.getFieldInfo2();
        String desc = "()" + Descriptor.of((String)"void");
        ConstPool cp = dirtyFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_unmarkDirty", desc);
        minfo.setAccessFlags(1);
        String dirtyFieldName = dirtyFieldInfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\t$0.").append(dirtyFieldName).append(" = 0;\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addResetDirty(CtClass cc, CtField dirtyField, boolean[] supportsDirtyTracking, boolean allSupportDirtyTracking) throws CannotCompileException {
        FieldInfo dirtyFieldInfo = dirtyField.getFieldInfo2();
        String desc = "()[" + Descriptor.of((String)"long");
        ConstPool cp = dirtyFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_resetDirty", desc);
        minfo.setAccessFlags(1);
        String dirtyFieldName = dirtyFieldInfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\tlong[] dirty = new long[1];\n");
        sb.append("\tdirty[0] = $0.").append(dirtyFieldName);
        if (!allSupportDirtyTracking) {
            long mask = 0L;
            for (int i = 0; i < supportsDirtyTracking.length; ++i) {
                if (supportsDirtyTracking[i]) continue;
                mask |= (long)(1 << i);
            }
            sb.append(" | ").append(mask);
        }
        sb.append(";\n");
        sb.append("\t$0.").append(dirtyFieldName).append(" = 0;\n");
        sb.append("\treturn dirty;\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addGetDirty(CtClass cc, CtField dirtyField, boolean[] supportsDirtyTracking, boolean allSupportDirtyTracking) throws CannotCompileException {
        FieldInfo dirtyFieldInfo = dirtyField.getFieldInfo2();
        String desc = "()[" + Descriptor.of((String)"long");
        ConstPool cp = dirtyFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_getDirty", desc);
        minfo.setAccessFlags(1);
        String dirtyFieldName = dirtyFieldInfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\tlong[] dirty = new long[1];\n");
        sb.append("\tdirty[0] = $0.").append(dirtyFieldName);
        if (!allSupportDirtyTracking) {
            long mask = 0L;
            for (int i = 0; i < supportsDirtyTracking.length; ++i) {
                if (supportsDirtyTracking[i]) continue;
                mask |= (long)(1 << i);
            }
            sb.append(" | ").append(mask);
        }
        sb.append(";\n");
        sb.append("\treturn dirty;\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addGetSimpleDirty(CtClass cc, CtField dirtyField, boolean[] supportsDirtyTracking, boolean allSupportDirtyTracking) throws CannotCompileException {
        FieldInfo dirtyFieldInfo = dirtyField.getFieldInfo2();
        String desc = "()" + Descriptor.of((String)"long");
        ConstPool cp = dirtyFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_getSimpleDirty", desc);
        minfo.setAccessFlags(1);
        String dirtyFieldName = dirtyFieldInfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\treturn $0.").append(dirtyFieldName);
        if (!allSupportDirtyTracking) {
            long mask = 0L;
            for (int i = 0; i < supportsDirtyTracking.length; ++i) {
                if (supportsDirtyTracking[i]) continue;
                mask |= (long)(1 << i);
            }
            sb.append(" | ").append(mask);
        }
        sb.append(";\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addCopyDirty(CtClass cc, CtField dirtyField, boolean[] supportsDirtyTracking, boolean allSupportDirtyTracking) throws CannotCompileException {
        FieldInfo dirtyFieldInfo = dirtyField.getFieldInfo2();
        String desc = "([" + Descriptor.of((String)"java.lang.Object") + "[" + Descriptor.of((String)"java.lang.Object") + ")" + Descriptor.of((String)"boolean");
        ConstPool cp = dirtyFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_copyDirty", desc);
        minfo.addAttribute((AttributeInfo)new SignatureAttribute(minfo.getConstPool(), "<T:" + Descriptor.of((String)"java.lang.Object") + ">([TT;[TT;)" + Descriptor.of((String)"boolean")));
        minfo.setAccessFlags(1);
        String dirtyFieldName = dirtyFieldInfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\tlong dirty = $0.").append(dirtyFieldName).append(";\n");
        if (allSupportDirtyTracking) {
            sb.append("\tif (dirty == 0) {\n");
            sb.append("\t\treturn false;\n");
            sb.append("\t} else {\n");
        }
        for (int i = 0; i < supportsDirtyTracking.length; ++i) {
            long mask = 1 << i;
            if (supportsDirtyTracking[i]) {
                sb.append("\t\t$2[").append(i).append("] = (dirty & ").append(mask).append(") == 0 ? null : $1[").append(i).append("];\n");
                continue;
            }
            sb.append("\t\t$2[").append(i).append("] = $1[").append(i).append("];\n");
        }
        sb.append("\t\treturn true;\n");
        if (allSupportDirtyTracking) {
            sb.append("\t}\n");
        }
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private boolean supportsDirtyTracking(AbstractMethodAttribute<?, ?> mutableAttribute) {
        if (!mutableAttribute.isMutable() || mutableAttribute.isSubview()) {
            return true;
        }
        if (mutableAttribute instanceof com.blazebit.persistence.view.metamodel.SingularAttribute) {
            BasicType type = (BasicType)((com.blazebit.persistence.view.metamodel.SingularAttribute)mutableAttribute).getType();
            if (!type.getUserType().isMutable()) {
                return true;
            }
            return type.getUserType().supportsDirtyTracking();
        }
        BasicType type = (BasicType)((PluralAttribute)mutableAttribute).getElementType();
        if (!type.getUserType().isMutable()) {
            return true;
        }
        return type.getUserType().supportsDirtyTracking();
    }

    private CtMethod addAddReadOnlyParent(CtClass cc, CtField readOnlyParentField, CtField parentField) throws CannotCompileException {
        FieldInfo parentFieldInfo = readOnlyParentField.getFieldInfo2();
        String desc = "(" + Descriptor.of((String)DirtyTracker.class.getName()) + "I)V";
        ConstPool cp = parentFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_addReadOnlyParent", desc);
        minfo.setAccessFlags(1);
        String readOnlyParentFieldName = parentFieldInfo.getName();
        String parentFieldName = parentField.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        if (this.strictCascadingCheck) {
            sb.append("\tif ($0 != $1 && $0.").append(parentFieldName).append(" == null) {\n");
            sb.append("\t\tthrow new IllegalStateException(\"Can't set read only parent for object \" + $0.toString() + \" util it doesn't have a writable parent! First add the object to an attribute with proper cascading. If you just want to reference it convert the object with EntityViewManager.getReference() or EntityViewManager.convert()!\");\n");
            sb.append("\t}\n");
        }
        sb.append("\tif ($0.").append(readOnlyParentFieldName).append(" == null) {\n");
        sb.append("\t\t$0.").append(readOnlyParentFieldName).append(" = new java.util.ArrayList();\n");
        sb.append("\t}\n");
        sb.append("\t$0.").append(readOnlyParentFieldName).append(".add($1);\n");
        sb.append("\t$0.").append(readOnlyParentFieldName).append(".add(Integer#valueOf($2));\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addRemoveReadOnlyParent(CtClass cc, CtField readOnlyParentField) throws CannotCompileException {
        FieldInfo parentFieldInfo = readOnlyParentField.getFieldInfo2();
        String desc = "(" + Descriptor.of((String)DirtyTracker.class.getName()) + "I)V";
        ConstPool cp = parentFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_removeReadOnlyParent", desc);
        minfo.setAccessFlags(1);
        String readOnlyParentFieldName = parentFieldInfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\tif ($0.").append(readOnlyParentFieldName).append(" != null) {\n");
        sb.append("\t\tint size = $0.").append(readOnlyParentFieldName).append(".size();\n");
        sb.append("\t\tfor (int i = 0; i < size; i += 2) {\n");
        sb.append("\t\t\tif ($0.").append(readOnlyParentFieldName).append(".get(i) == $1 && ((Integer) $0.").append(readOnlyParentFieldName).append(".get(i + 1)).intValue() == $2) {\n");
        sb.append("\t\t\t\t$0.").append(readOnlyParentFieldName).append(".remove(i + 1);\n");
        sb.append("\t\t\t\t$0.").append(readOnlyParentFieldName).append(".remove(i);\n");
        sb.append("\t\t\t\tbreak;\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t}\n");
        sb.append("\t}\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addReplaceAttribute(CtClass cc, AbstractMethodAttribute[] attributes) throws CannotCompileException {
        String desc = "(" + Descriptor.of((String)Object.class.getName()) + "I" + Descriptor.of((String)Object.class.getName()) + ")V";
        ConstPool cp = cc.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_replaceAttribute", desc);
        minfo.setAccessFlags(1);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\tswitch ($2) {");
        for (int i = 0; i < attributes.length; ++i) {
            AbstractMethodAttribute attribute = attributes[i];
            if (attribute == null || !attribute.hasDirtyStateIndex()) continue;
            sb.append("\t\tcase ").append(attribute.getDirtyStateIndex()).append(": ");
            if (ReflectionUtils.getSetter((Class)attribute.getDeclaringType().getJavaType(), (String)attribute.getName()) != null) {
                sb.append("$0.set").append(Character.toUpperCase(attribute.getName().charAt(0))).append(attribute.getName(), 1, attribute.getName().length());
                sb.append('(');
                if (attribute.getConvertedJavaType().isPrimitive()) {
                    this.appendUnwrap(sb, attribute.getConvertedJavaType(), "$3");
                } else {
                    sb.append("(").append(attribute.getConvertedJavaType().getName()).append(") $3");
                }
                sb.append("); ");
            }
            sb.append("break;\n");
        }
        sb.append("\t\tdefault: throw new IllegalArgumentException(\"Invalid non-mutable attribute index: \" + $2);\n");
        sb.append("\t}\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addSetParent(CtClass cc, CtField parentField, CtField parentIndexField) throws CannotCompileException {
        FieldInfo parentFieldInfo = parentField.getFieldInfo2();
        FieldInfo parentIndexFieldInfo = parentIndexField.getFieldInfo2();
        String desc = "(" + Descriptor.of((String)BasicDirtyTracker.class.getName()) + parentIndexFieldInfo.getDescriptor() + ")V";
        ConstPool cp = parentFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_setParent", desc);
        minfo.setAccessFlags(1);
        String parentFieldName = parentFieldInfo.getName();
        String parentIndexFieldName = parentIndexFieldInfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\tif ($0.").append(parentFieldName).append(" != null) {\n");
        sb.append("\t\tthrow new IllegalStateException(\"Parent object for \" + $0.toString() + \" is already set to \" + $0.").append(parentFieldName).append(".toString() + \" and can't be set to:\" + $1.toString());\n");
        sb.append("\t}\n");
        sb.append("\t$0.").append(parentFieldName).append(" = $1;\n");
        sb.append("\t$0.").append(parentIndexFieldName).append(" = $2;\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addHasParent(CtClass cc, CtField parentField) throws CannotCompileException {
        FieldInfo parentFieldInfo = parentField.getFieldInfo2();
        String desc = "()" + Descriptor.of((String)"boolean");
        ConstPool cp = parentFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_hasParent", desc);
        minfo.setAccessFlags(1);
        String parentFieldName = parentFieldInfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\treturn $0.").append(parentFieldName).append(" != null;\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addUnsetParent(CtClass cc, CtField parentField, CtField parentIndexField, CtField readOnlyParentsField) throws CannotCompileException {
        FieldInfo parentFieldInfo = parentField.getFieldInfo2();
        FieldInfo parentIndexFieldInfo = parentIndexField.getFieldInfo2();
        String desc = "()V";
        ConstPool cp = parentFieldInfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_unsetParent", desc);
        minfo.setAccessFlags(1);
        String parentFieldName = parentFieldInfo.getName();
        String parentIndexFieldName = parentIndexFieldInfo.getName();
        String readOnlyParentsFieldName = readOnlyParentsField.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\tif ($0.").append(parentFieldName).append(" != null && $0.").append(readOnlyParentsFieldName).append(" != null && !$0.").append(readOnlyParentsFieldName).append(".isEmpty()) {\n");
        sb.append("\t\tthrow new IllegalStateException(\"Can't unset writable parent \" + $0.").append(parentFieldName).append(" + \" on object \" + $0.toString() + \" because it is still connected to read only parents: \" + $0.").append(readOnlyParentsFieldName).append(");\n");
        sb.append("\t}\n");
        sb.append("\t$0.").append(parentFieldName).append(" = null;\n");
        sb.append("\t$0.").append(parentIndexFieldName).append(" = 0;\n");
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private CtMethod addSetId(CtClass cc, CtField field) throws CannotCompileException, NotFoundException {
        String desc = "(" + Descriptor.of((String)Object.class.getName()) + ")V";
        ConstPool cp = cc.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_setId", desc);
        minfo.setAccessFlags(1);
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        if (field == null) {
            method.setBody("{\n\tthrow new UnsupportedOperationException(\"No id attribute available!\");\n}");
        } else {
            StringBuilder sb = new StringBuilder();
            this.appendObjectSetter(sb, field);
            method.setBody(sb.toString());
        }
        cc.addMethod(method);
        return method;
    }

    private CtMethod addSetVersion(CtClass cc, CtField field) throws CannotCompileException, NotFoundException {
        String desc = "(" + Descriptor.of((String)Object.class.getName()) + ")V";
        ConstPool cp = cc.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, "$$_setVersion", desc);
        minfo.setAccessFlags(1);
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        if (field == null) {
            method.setBody("{\n\tthrow new UnsupportedOperationException(\"No version attribute available!\");\n}");
        } else {
            StringBuilder sb = new StringBuilder();
            this.appendObjectSetter(sb, field);
            method.setBody(sb.toString());
        }
        cc.addMethod(method);
        return method;
    }

    private void appendObjectSetter(StringBuilder sb, CtField field) throws NotFoundException {
        sb.append("{\n");
        CtClass type = field.getType();
        if (type.isPrimitive()) {
            sb.append("\tif ($1 == null) {\n");
            String defaultValue = this.getDefaultValue(type);
            sb.append("\t\t$0.").append(field.getName()).append(" = ").append(defaultValue).append(";\n");
            sb.append("\t} else {\n");
            sb.append("\t\t$0.").append(field.getName()).append(" = ");
            this.appendUnwrap(sb, type, "$1");
            sb.append(";\n");
            sb.append("\t}\n");
        } else {
            sb.append("\t$0.").append(field.getName()).append(" = (").append(Descriptor.toClassName((String)field.getFieldInfo2().getDescriptor())).append(") $1;\n");
        }
        sb.append("}");
    }

    private void appendUnwrap(StringBuilder sb, CtClass type, String input) {
        if (type == CtClass.longType) {
            sb.append("((Long) ").append(input).append(").longValue()");
        } else if (type == CtClass.floatType) {
            sb.append("((Float) ").append(input).append(").floatValue()");
        } else if (type == CtClass.doubleType) {
            sb.append("((Double) ").append(input).append(").doubleValue()");
        } else if (type == CtClass.intType) {
            sb.append("((Integer) ").append(input).append(").intValue()");
        } else if (type == CtClass.shortType) {
            sb.append("((Short) ").append(input).append(").shortValue()");
        } else if (type == CtClass.byteType) {
            sb.append("((Byte) ").append(input).append(").byteValue()");
        } else if (type == CtClass.booleanType) {
            sb.append("((Boolean) ").append(input).append(").booleanValue()");
        } else if (type == CtClass.charType) {
            sb.append("((Character) ").append(input).append(").charValue()");
        } else {
            throw new UnsupportedOperationException("Unwrap not possible for type: " + type);
        }
    }

    private void appendUnwrap(StringBuilder sb, Class<?> type, String input) {
        if (type == Long.TYPE) {
            sb.append("((Long) ").append(input).append(").longValue()");
        } else if (type == Float.TYPE) {
            sb.append("((Float) ").append(input).append(").floatValue()");
        } else if (type == Double.TYPE) {
            sb.append("((Double) ").append(input).append(").doubleValue()");
        } else if (type == Integer.TYPE) {
            sb.append("((Integer) ").append(input).append(").intValue()");
        } else if (type == Short.TYPE) {
            sb.append("((Short) ").append(input).append(").shortValue()");
        } else if (type == Byte.TYPE) {
            sb.append("((Byte) ").append(input).append(").byteValue()");
        } else if (type == Boolean.TYPE) {
            sb.append("((Boolean) ").append(input).append(").booleanValue()");
        } else if (type == Character.TYPE) {
            sb.append("((Character) ").append(input).append(").charValue()");
        } else {
            throw new UnsupportedOperationException("Unwrap not possible for type: " + type);
        }
    }

    private CtMethod addSetter(AbstractMethodAttribute<?, ?> attribute, CtClass cc, CtField attributeField, String methodName, CtField mutableStateField, boolean dirtyChecking, boolean isId) throws CannotCompileException, NotFoundException {
        FieldInfo finfo = attributeField.getFieldInfo2();
        String fieldType = finfo.getDescriptor();
        String desc = "(" + fieldType + ")V";
        ConstPool cp = finfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, methodName, desc);
        minfo.setAccessFlags(1);
        String fieldName = finfo.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        boolean invalidSetter = false;
        if (isId) {
            if (attribute != null && attribute.getDeclaringType().isCreatable()) {
                sb.append("\tif (!$0.$$_isNew) {\n");
                sb.append("\t\tthrow new IllegalArgumentException(\"Updating the id attribute '").append(attribute.getName()).append("' is only allowed for new entity view objects created via EntityViewManager.create()!\");\n");
                sb.append("\t}\n");
            } else if (attribute != null && attribute.getDeclaringType().isUpdatable()) {
                sb.append("\tthrow new IllegalArgumentException(\"Updating the id attribute '").append(attribute.getName()).append("' is only allowed for new entity view objects created via EntityViewManager.create()!\");\n");
                invalidSetter = true;
            }
        }
        if (attribute != null && attribute.getDirtyStateIndex() != -1 && !attribute.isUpdatable() && (attribute.getDeclaringType().isCreatable() || attribute.getDeclaringType().isUpdatable())) {
            sb.append("\tObject tmp;\n");
            sb.append("\tif ($1 != $0.").append(fieldName);
            if (!attribute.isCollection()) {
                com.blazebit.persistence.view.metamodel.SingularAttribute singularAttribute = (com.blazebit.persistence.view.metamodel.SingularAttribute)attribute;
                Type type = singularAttribute.getType();
                if (attribute.isSubview()) {
                    if (!(type instanceof FlatViewType)) {
                        String idMethodName = ((ViewType)type).getIdAttribute().getJavaMethod().getName();
                        sb.append(" && ");
                        sb.append("($1 == null || (tmp = $1.");
                        sb.append(idMethodName);
                        sb.append("()) == null || !java.util.Objects.equals(tmp, $0.");
                        sb.append(fieldName);
                        sb.append('.').append(idMethodName);
                        sb.append("()))");
                    }
                } else {
                    BasicTypeImpl basicType = (BasicTypeImpl)type;
                    boolean jpaEntity = basicType.isJpaEntity();
                    if (jpaEntity) {
                        IdentifiableType identifiableType = (IdentifiableType)basicType.getManagedType();
                        for (SingularAttribute idAttribute : JpaMetamodelUtils.getIdAttributes((IdentifiableType)identifiableType)) {
                            Class idClass = JpaMetamodelUtils.resolveFieldClass(basicType.getJavaType(), (Attribute)idAttribute);
                            String idAccessor = this.addIdAccessor(cc, identifiableType, idAttribute, this.pool.get(idClass.getName()));
                            sb.append(" && ");
                            sb.append("($1 == null || (tmp = ");
                            sb.append(idAccessor);
                            sb.append("($1)) == null || !java.util.Objects.equals(tmp, ");
                            sb.append(idAccessor);
                            sb.append("($0.");
                            sb.append(fieldName);
                            sb.append(")))");
                        }
                    }
                }
            }
            sb.append(") {\n");
            sb.append("\t\tthrow new IllegalArgumentException(\"Updating the mutable-only attribute '").append(attribute.getName()).append("' with a value that has not the same identity is not allowed! Consider making the attribute updatable or update the value directly instead of replacing it!\");\n");
            sb.append("\t}\n");
        }
        if (attribute != null && attribute.isUpdatable() && dirtyChecking) {
            if (attribute.isCollection()) {
                if (this.strictCascadingCheck) {
                    boolean mutableElement;
                    boolean bl = mutableElement = !attribute.getUpdateCascadeAllowedSubtypes().isEmpty() || !attribute.getPersistCascadeAllowedSubtypes().isEmpty();
                    if (mutableElement && ((AbstractMethodPluralAttribute)attribute).getElementType().getMappingType() != Type.MappingType.BASIC) {
                        sb.append("\t\tthrow new IllegalArgumentException(\"Replacing a collection that PERSIST or UPDATE cascades is prohibited by default! Instead, replace the contents by doing clear() and addAll()!\");\n");
                    }
                }
            } else if (attribute.isSubview()) {
                String subtypeArray = this.addAllowedSubtypeField(cc, attribute);
                this.addParentRequiringUpdateSubtypesField(cc, attribute);
                this.addParentRequiringCreateSubtypesField(cc, attribute);
                sb.append("\tif ($1 != null) {\n");
                sb.append("\t\tClass c;\n");
                sb.append("\t\tboolean isNew;\n");
                sb.append("\t\tif ($1 instanceof ").append(EntityViewProxy.class.getName()).append(") {\n");
                sb.append("\t\t\tc = ((").append(EntityViewProxy.class.getName()).append(") $1).$$_getEntityViewClass();\n");
                sb.append("\t\t\tisNew = ((").append(EntityViewProxy.class.getName()).append(") $1).$$_isNew();\n");
                sb.append("\t\t} else {\n");
                sb.append("\t\t\tc = $1.getClass();\n");
                sb.append("\t\t\tisNew = false;\n");
                sb.append("\t\t}\n");
                sb.append("\t\tif (!").append(attributeField.getDeclaringClass().getName()).append('#').append(attribute.getName()).append("_$$_subtypes.contains(c)) {\n");
                sb.append("\t\t\tthrow new IllegalArgumentException(");
                sb.append("\"Allowed subtypes for attribute '").append(attribute.getName()).append("' are [").append(subtypeArray).append("] but got an instance of: \"");
                sb.append(".concat(c.getName())");
                sb.append(");\n");
                sb.append("\t\t}\n");
                if (this.strictCascadingCheck) {
                    sb.append("\t\tif ($0 != $1 && !isNew && ").append(attributeField.getDeclaringClass().getName()).append('#').append(attribute.getName()).append("_$$_parentRequiringUpdateSubtypes.contains(c) && !((").append(DirtyTracker.class.getName()).append(") $1).$$_hasParent()) {\n");
                    sb.append("\t\t\tthrow new IllegalArgumentException(");
                    sb.append("\"Setting instances of type [\" + c.getName() + \"] on attribute '").append(attribute.getName()).append("' is not allowed until they are assigned to an attribute that cascades the type! ");
                    sb.append("If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { UPDATE }). You can also turn off strict cascading checks by setting ConfigurationProperties.UPDATER_STRICT_CASCADING_CHECK to false\"");
                    sb.append(");\n");
                    sb.append("\t\t}\n");
                    sb.append("\t\tif ($0 != $1 && isNew && ").append(attributeField.getDeclaringClass().getName()).append('#').append(attribute.getName()).append("_$$_parentRequiringCreateSubtypes.contains(c) && !((").append(DirtyTracker.class.getName()).append(") $1).$$_hasParent()) {\n");
                    sb.append("\t\t\tthrow new IllegalArgumentException(");
                    sb.append("\"Setting instances of type [\" + c.getName() + \"] on attribute '").append(attribute.getName()).append("' is not allowed until they are assigned to an attribute that cascades the type! ");
                    sb.append("If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { PERSIST }). You can also turn off strict cascading checks by setting ConfigurationProperties.UPDATER_STRICT_CASCADING_CHECK to false\"");
                    sb.append(");\n");
                    sb.append("\t\t}\n");
                }
                sb.append("\t}\n");
            }
        }
        if (attribute != null && attribute.getDirtyStateIndex() != -1) {
            int mutableStateIndex = attribute.getDirtyStateIndex();
            if (attribute.isCollection()) {
                sb.append("\tif ($0.").append(fieldName).append(" != null && $0.").append(fieldName).append(" != $1) {\n");
                if (attribute instanceof MapAttribute) {
                    sb.append("\t\tif ($0.").append(fieldName).append(" instanceof ").append(RecordingMap.class.getName()).append(") {\n");
                    sb.append("\t\t\t((").append(RecordingMap.class.getName()).append(") $0.").append(fieldName).append(").$$_unsetParent();\n");
                    sb.append("\t\t}\n");
                } else {
                    sb.append("\t\tif ($0.").append(fieldName).append(" instanceof ").append(RecordingCollection.class.getName()).append(") {\n");
                    sb.append("\t\t\t((").append(RecordingCollection.class.getName()).append(") $0.").append(fieldName).append(").$$_unsetParent();\n");
                    sb.append("\t\t}\n");
                }
                sb.append("\t}\n");
            } else if (attribute.isSubview()) {
                if (attribute.isUpdatableOnly() && !attribute.isCorrelated()) {
                    sb.append("\tif ($0.").append(fieldName).append(" != $1 && $0.").append(fieldName).append(" instanceof ").append(MutableStateTrackable.class.getName()).append(") {\n");
                    sb.append("\t\t\t((").append(MutableStateTrackable.class.getName()).append(") $0.").append(fieldName).append(").$$_removeReadOnlyParent($0, ").append(mutableStateIndex).append(");\n");
                    sb.append("\t} else if ($0.").append(fieldName).append(" != $1 && $0.").append(fieldName).append(" instanceof ").append(BasicDirtyTracker.class.getName()).append(") {\n");
                    sb.append("\t\t\t((").append(BasicDirtyTracker.class.getName()).append(") $0.").append(fieldName).append(").$$_unsetParent();\n");
                } else {
                    sb.append("\tif ($0.").append(fieldName).append(" != $1 && $0.").append(fieldName).append(" instanceof ").append(BasicDirtyTracker.class.getName()).append(") {\n");
                    sb.append("\t\t((").append(BasicDirtyTracker.class.getName()).append(") $0.").append(fieldName).append(").$$_unsetParent();\n");
                }
                sb.append("\t}\n");
            }
            if (mutableStateField != null) {
                sb.append("\t$0.").append(mutableStateField.getName()).append("[").append(mutableStateIndex).append("] = ");
                this.renderValueForArray(sb, attributeField.getType(), 1);
            }
            if (dirtyChecking) {
                sb.append("\t$0.$$_markDirty(").append(mutableStateIndex).append(");\n");
                if (attribute.isCollection() || attribute.isSubview()) {
                    sb.append("\tif ($0.$$_initialized && $1 != null && $0.").append(fieldName).append(" != $1) {\n");
                    if (attribute.isCollection()) {
                        if (attribute instanceof MapAttribute) {
                            sb.append("\t\tif ($1 instanceof ").append(RecordingMap.class.getName()).append(") {\n");
                            sb.append("\t\t\t((").append(RecordingMap.class.getName()).append(") $1).$$_setParent($0, ").append(mutableStateIndex).append(");\n");
                            sb.append("\t\t}\n");
                        } else {
                            sb.append("\t\tif ($1 instanceof ").append(RecordingCollection.class.getName()).append(") {\n");
                            sb.append("\t\t\t((").append(RecordingCollection.class.getName()).append(") $1).$$_setParent($0, ").append(mutableStateIndex).append(");\n");
                            sb.append("\t\t}\n");
                        }
                    } else if (attribute.isSubview()) {
                        if (attribute.isUpdatableOnly() && !attribute.isCorrelated()) {
                            sb.append("\t\tif ($1 instanceof ").append(MutableStateTrackable.class.getName()).append(") {\n");
                            sb.append("\t\t\t((").append(MutableStateTrackable.class.getName()).append(") $1).$$_addReadOnlyParent($0, ").append(mutableStateIndex).append(");\n");
                            sb.append("\t\t} else if ($1 instanceof ").append(BasicDirtyTracker.class.getName()).append(") {\n");
                            sb.append("\t\t\t((").append(BasicDirtyTracker.class.getName()).append(") $1).$$_setParent($0, ").append(mutableStateIndex).append(");\n");
                        } else {
                            sb.append("\t\tif ($1 instanceof ").append(BasicDirtyTracker.class.getName()).append(") {\n");
                            sb.append("\t\t\t((").append(BasicDirtyTracker.class.getName()).append(") $1).$$_setParent($0, ").append(mutableStateIndex).append(");\n");
                        }
                        sb.append("\t\t}\n");
                    }
                    sb.append("\t}\n");
                }
            }
        }
        if (!invalidSetter) {
            sb.append("\t$0.").append(fieldName).append(" = $1;\n");
        }
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)cc);
        method.setBody(sb.toString());
        cc.addMethod(method);
        return method;
    }

    private List<Method> getBridgeGetters(Class<?> clazz, MethodAttribute<?, ?> attribute, Method getter) {
        ArrayList<Method> bridges = new ArrayList<Method>();
        String name = getter.getName();
        Class attributeType = attribute.getConvertedJavaType();
        for (Class c : ReflectionUtils.getSuperTypes(clazz)) {
            block1: for (Method m : c.getDeclaredMethods()) {
                if (!name.equals(m.getName()) || !m.getReturnType().isAssignableFrom(attributeType) || attributeType.equals(m.getReturnType())) continue;
                for (Method b : bridges) {
                    if (!b.getReturnType().equals(m.getReturnType())) continue;
                    continue block1;
                }
                bridges.add(m);
            }
        }
        return bridges;
    }

    private List<Method> getBridgeSetters(Class<?> clazz, MethodAttribute<?, ?> attribute, Method setter) {
        ArrayList<Method> bridges = new ArrayList<Method>();
        String name = setter.getName();
        Class attributeType = attribute.getConvertedJavaType();
        for (Class c : ReflectionUtils.getSuperTypes(clazz)) {
            block1: for (Method m : c.getDeclaredMethods()) {
                if (!name.equals(m.getName()) || !m.getParameterTypes()[0].isAssignableFrom(attributeType) || attributeType.equals(m.getParameterTypes()[0])) continue;
                for (Method b : bridges) {
                    if (!b.getParameterTypes()[0].equals(m.getParameterTypes()[0])) continue;
                    continue block1;
                }
                bridges.add(m);
            }
        }
        return bridges;
    }

    private void setGenericSignature(CtField field, String signature) {
        FieldInfo fieldInfo = field.getFieldInfo();
        fieldInfo.addAttribute((AttributeInfo)new SignatureAttribute(fieldInfo.getConstPool(), signature));
    }

    private void setGenericSignature(CtMethod method, String signature) {
        MethodInfo methodInfo = method.getMethodInfo();
        methodInfo.addAttribute((AttributeInfo)new SignatureAttribute(methodInfo.getConstPool(), signature));
    }

    private String getEqualsDesc() throws NotFoundException {
        CtClass returnType = CtClass.booleanType;
        return "(" + Descriptor.of((String)"java.lang.Object") + ")" + Descriptor.of((CtClass)returnType);
    }

    private CtMethod createEquals(ManagedViewTypeImplementor<?> managedViewType, CtClass cc, CtField ... fields) throws NotFoundException, CannotCompileException {
        return this.createEquals(managedViewType, cc, false, fields);
    }

    private CtMethod createIdEquals(ManagedViewTypeImplementor<?> managedViewType, CtClass cc) throws NotFoundException, CannotCompileException {
        return this.createEquals(managedViewType, cc, true, null);
    }

    private CtMethod createEquals(ManagedViewTypeImplementor<?> managedViewType, CtClass cc, boolean idBased, CtField[] fields) throws NotFoundException, CannotCompileException {
        ConstPool cp = cc.getClassFile2().getConstPool();
        MethodInfo method = new MethodInfo(cp, "equals", this.getEqualsDesc());
        method.setAccessFlags(1);
        CtMethod m = CtMethod.make((MethodInfo)method, (CtClass)cc);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("\tif ($0 == $1) { return true; }\n");
        Class viewClass = managedViewType.getJavaType();
        if (idBased) {
            sb.append("\tif ($1 == null || $0.$$_getId() == null) { return false; }\n");
            sb.append("\tif ($1 instanceof ").append(EntityViewProxy.class.getName()).append(") {\n");
            sb.append("\t\tif ($0.$$_getJpaManagedBaseClass() == ((").append(EntityViewProxy.class.getName()).append(") $1).$$_getJpaManagedBaseClass() && ");
            sb.append("$0.$$_getId().equals(((").append(EntityViewProxy.class.getName()).append(") $1).$$_getId())) {\n");
            sb.append("\t\t\treturn true;\n");
            sb.append("\t\t} else {\n");
            sb.append("\t\t\treturn false;\n");
            sb.append("\t\t}\n");
            sb.append("\t}\n");
            ViewTypeImplementor viewType = (ViewTypeImplementor)managedViewType;
            MethodAttribute idAttribute = viewType.getIdAttribute();
            if (viewType.supportsUserTypeEquals()) {
                Class javaType = idAttribute.getJavaType();
                String wrap = javaType.isPrimitive() ? (javaType == Long.TYPE ? "Long.valueOf" : (javaType == Float.TYPE ? "Float.valueOf" : (javaType == Double.TYPE ? "Double.valueOf" : (javaType == Short.TYPE ? "Short.valueOf" : (javaType == Byte.TYPE ? "Byte.valueOf" : (javaType == Boolean.TYPE ? "Boolean.valueOf" : (javaType == Character.TYPE ? "Character.valueOf" : "Integer.valueOf"))))))) : "";
                sb.append("\tif ($1 instanceof ").append(viewClass.getName()).append(" && $0.$$_getId().equals(").append(wrap).append("(((").append(viewClass.getName()).append(") $1).get");
                StringUtils.addFirstToUpper((StringBuilder)sb, (CharSequence)idAttribute.getName()).append("()))) {\n");
                sb.append("\t\t\treturn true;\n");
                sb.append("\t\t} else {\n");
                sb.append("\t\t\treturn false;\n");
                sb.append("\t\t}\n");
            } else if (viewType.supportsInterfaceEquals()) {
                sb.append("\t\tthrow new IllegalArgumentException(\"The view class ").append(viewClass.getName()).append(" is defined for an abstract or non-entity type which is why id-based equality can't be checked on the user provided instance: \" + $1);\n");
            } else {
                sb.append("\t\tthrow new IllegalArgumentException(\"A superclass of ").append(viewClass.getName()).append(" declares a protected or default attribute that is relevant for checking for state equality which can't be accessed on the user provided instance: \" + $1);\n");
            }
        } else {
            String name = managedViewType.supportsInterfaceEquals() ? viewClass.getName() : cc.getName();
            sb.append("\tif ($1 instanceof ").append(name).append(") {\n");
            sb.append("\t\tfinal ").append(name).append(" other = (").append(name).append(") $1;\n");
            for (CtField field : fields) {
                if (field.getType().isPrimitive()) {
                    if (CtClass.booleanType == field.getType() && managedViewType.getAttribute(field.getName()).getJavaMethod().getName().startsWith("is")) {
                        sb.append("\t\tif ($0.").append(field.getName()).append(" != other.is");
                        StringUtils.addFirstToUpper((StringBuilder)sb, (CharSequence)field.getName()).append("()");
                        sb.append(") {\n");
                    } else {
                        sb.append("\t\tif ($0.").append(field.getName()).append(" != other.get");
                        StringUtils.addFirstToUpper((StringBuilder)sb, (CharSequence)field.getName()).append("()");
                        sb.append(") {\n");
                    }
                } else if (Boolean.class.getName().equals(field.getType().getName()) && managedViewType.getAttribute(field.getName()).getJavaMethod().getName().startsWith("is")) {
                    sb.append("\t\tif ($0.").append(field.getName()).append(" != other.is");
                    StringUtils.addFirstToUpper((StringBuilder)sb, (CharSequence)field.getName()).append("()");
                    sb.append(" && ($0.").append(field.getName()).append(" == null");
                    sb.append(" || !$0.").append(field.getName()).append(".equals(other.is");
                    StringUtils.addFirstToUpper((StringBuilder)sb, (CharSequence)field.getName()).append("()");
                    sb.append("))) {\n");
                } else {
                    sb.append("\t\tif ($0.").append(field.getName()).append(" != other.get");
                    StringUtils.addFirstToUpper((StringBuilder)sb, (CharSequence)field.getName()).append("()");
                    sb.append(" && ($0.").append(field.getName()).append(" == null");
                    sb.append(" || !$0.").append(field.getName()).append(".equals(other.get");
                    StringUtils.addFirstToUpper((StringBuilder)sb, (CharSequence)field.getName()).append("()");
                    sb.append("))) {\n");
                }
                sb.append("\t\t\treturn false;\n\t\t}\n");
            }
            sb.append("\t} else {\n");
            if (managedViewType.supportsInterfaceEquals()) {
                sb.append("\t\treturn false;\n");
            } else {
                sb.append("\t\tif ($1 == null) { return false; }\n");
                sb.append("\t\tthrow new IllegalArgumentException(\"A superclass of ").append(viewClass.getName()).append(" declares a protected or default attribute that is relevant for checking for state equality which can't be accessed on the user provided instance: \" + $1);\n");
            }
            sb.append("\t}\n");
            sb.append("\treturn true;\n");
        }
        sb.append('}');
        m.setBody(sb.toString());
        return m;
    }

    private String getHashCodeDesc() throws NotFoundException {
        CtClass returnType = CtClass.intType;
        return "()" + Descriptor.of((CtClass)returnType);
    }

    private CtMethod createHashCode(CtClass cc, CtField ... fields) throws NotFoundException, CannotCompileException {
        ConstPool cp = cc.getClassFile2().getConstPool();
        CtClass returnType = CtClass.intType;
        String desc = "()" + Descriptor.of((CtClass)returnType);
        MethodInfo method = new MethodInfo(cp, "hashCode", desc);
        method.setAccessFlags(1);
        CtMethod m = CtMethod.make((MethodInfo)method, (CtClass)cc);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("\tint hash = 3;\n");
        for (CtField field : fields) {
            if (field.getType().isPrimitive()) {
                CtClass type = field.getType();
                if (CtClass.doubleType == type) {
                    sb.append("long bits = java.lang.Double.doubleToLongBits($0.").append(field.getName()).append(");");
                }
                sb.append("\thash = 83 * hash + ");
                if (CtClass.booleanType == type) {
                    sb.append("($0.").append(field.getName()).append(" ? 1231 : 1237").append(");\n");
                    continue;
                }
                if (CtClass.byteType == type || CtClass.shortType == type || CtClass.charType == type) {
                    sb.append("(int) $0.").append(field.getName()).append(";\n");
                    continue;
                }
                if (CtClass.intType == type) {
                    sb.append("$0.").append(field.getName()).append(";\n");
                    continue;
                }
                if (CtClass.longType == type) {
                    sb.append("(int)(");
                    sb.append("$0.").append(field.getName());
                    sb.append(" ^ (");
                    sb.append("$0.").append(field.getName());
                    sb.append(" >>> 32));\n");
                    continue;
                }
                if (CtClass.floatType == type) {
                    sb.append("java.lang.Float.floatToIntBits(");
                    sb.append("$0.").append(field.getName());
                    sb.append(");\n");
                    continue;
                }
                if (CtClass.doubleType == type) {
                    sb.append("(int)(bits ^ (bits >>> 32));\n");
                    continue;
                }
                throw new IllegalArgumentException("Unsupported primitive type: " + type.getName());
            }
            sb.append("\thash = 83 * hash + ($0.").append(field.getName()).append(" != null ? ");
            sb.append("$0.").append(field.getName()).append(".hashCode() : 0);\n");
        }
        sb.append("\treturn hash;\n");
        sb.append('}');
        m.setBody(sb.toString());
        return m;
    }

    private CtMethod createToString(ManagedViewTypeImplementor<?> managedViewType, CtClass cc, boolean idBased, CtField[] fields) throws NotFoundException, CannotCompileException {
        ConstPool cp = cc.getClassFile2().getConstPool();
        MethodInfo method = new MethodInfo(cp, "toString", "()" + Descriptor.of((String)"java.lang.String"));
        method.setAccessFlags(1);
        CtMethod m = CtMethod.make((MethodInfo)method, (CtClass)cc);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (idBased) {
            ViewTypeImplementor viewType = (ViewTypeImplementor)managedViewType;
            MethodAttribute idAttribute = viewType.getIdAttribute();
            sb.append("\treturn \"").append(managedViewType.getJavaType().getSimpleName()).append("(").append(idAttribute.getName()).append(" = \" + $0.").append(idAttribute.getName()).append(" + \")\";\n");
        } else {
            int i;
            int sizeEstimate = managedViewType.getJavaType().getSimpleName().length() + 2;
            for (i = 0; i < fields.length; ++i) {
                sizeEstimate += fields[i].getName().length() + 5 + 10;
            }
            sb.append("\tStringBuilder sb = new StringBuilder(").append(sizeEstimate).append(");\n");
            sb.append("\tsb.append(\"").append(managedViewType.getJavaType().getSimpleName()).append("(\");\n");
            if (fields.length != 0) {
                sb.append("\tsb.append(\"").append(fields[0].getName()).append(" = \").append($0.").append(fields[0].getName()).append(");\n");
                for (i = 1; i < fields.length; ++i) {
                    sb.append("\tsb.append(\", \");\n");
                    sb.append("\tsb.append(\"").append(fields[i].getName()).append(" = \").append($0.").append(fields[i].getName()).append(");\n");
                }
            }
            sb.append("\tsb.append(\")\");\n");
            sb.append("\treturn sb.toString();\n");
        }
        sb.append('}');
        m.setBody(sb.toString());
        return m;
    }

    private CtMethod createGetterBridge(CtClass cc, Method getter, CtMethod attributeGetter) throws NotFoundException, CannotCompileException {
        ConstPool cp = cc.getClassFile2().getConstPool();
        CtClass bridgeReturnType = this.pool.get(getter.getReturnType().getName());
        String desc = "()" + Descriptor.of((CtClass)bridgeReturnType);
        MethodInfo bridge = new MethodInfo(cp, getter.getName(), desc);
        bridge.setAccessFlags(4161);
        Bytecode code = new Bytecode(cp, this.needsTwoStackSlots(bridgeReturnType) ? 2 : 1, 1);
        code.addAload(0);
        code.addInvokevirtual(cc, getter.getName(), attributeGetter.getReturnType(), null);
        code.addReturn(bridgeReturnType);
        bridge.setCodeAttribute(code.toCodeAttribute());
        return CtMethod.make((MethodInfo)bridge, (CtClass)cc);
    }

    private CtMethod createSetterBridge(CtClass cc, Method setter, CtMethod attributeSetter) throws NotFoundException, CannotCompileException {
        ConstPool cp = cc.getClassFile2().getConstPool();
        CtClass bridgeParameterType = this.pool.get(setter.getParameterTypes()[0].getName());
        String desc = "(" + Descriptor.of((CtClass)bridgeParameterType) + ")V";
        MethodInfo bridge = new MethodInfo(cp, setter.getName(), desc);
        bridge.setAccessFlags(4161);
        Bytecode code = new Bytecode(cp, this.needsTwoStackSlots(bridgeParameterType) ? 4 : 2, 2);
        code.addAload(0);
        code.addAload(1);
        code.addCheckcast(attributeSetter.getParameterTypes()[0]);
        code.addInvokevirtual(cc, setter.getName(), CtClass.voidType, attributeSetter.getParameterTypes());
        code.addReturn(CtClass.voidType);
        bridge.setCodeAttribute(code.toCodeAttribute());
        return CtMethod.make((MethodInfo)bridge, (CtClass)cc);
    }

    private CtConstructor createNormalConstructor(EntityViewManager evm, ManagedViewType<?> managedViewType, CtClass cc, CtField[] attributeFields, CtClass[] attributeTypes, CtField initialStateField, CtField mutableStateField, AbstractMethodAttribute<?, ?>[] attributes, int mutableAttributeCount, boolean unsafe) throws CannotCompileException, NotFoundException, BadBytecode {
        int superConstructorStart = attributeFields.length;
        int superConstructorEnd = attributeTypes.length;
        return this.createConstructor(evm, managedViewType, cc, superConstructorStart, superConstructorEnd, attributeFields, attributeTypes, initialStateField, mutableStateField, attributes, mutableAttributeCount, ConstructorKind.NORMAL, null, unsafe);
    }

    private CtConstructor createCreateConstructor(EntityViewManager evm, ManagedViewType<?> managedViewType, CtClass cc, CtField[] attributeFields, CtClass[] attributeTypes, CtField idField, CtField initialStateField, CtField mutableStateField, AbstractMethodAttribute<?, ?>[] attributes, int mutableAttributeCount, boolean unsafe) throws CannotCompileException, NotFoundException, BadBytecode {
        return this.createConstructor(evm, managedViewType, cc, 0, 0, attributeFields, attributeTypes, initialStateField, mutableStateField, attributes, mutableAttributeCount, ConstructorKind.CREATE, idField, unsafe);
    }

    private CtConstructor createReferenceConstructor(EntityViewManager evm, ManagedViewType<?> managedViewType, CtClass cc, CtField[] attributeFields, CtField idField, CtField initialStateField, CtField mutableStateField, AbstractMethodAttribute<?, ?>[] attributes, int mutableAttributeCount, boolean unsafe) throws CannotCompileException, NotFoundException, BadBytecode {
        CtClass[] attributeTypes = new CtClass[]{idField.getType()};
        return this.createConstructor(evm, managedViewType, cc, 0, 0, attributeFields, attributeTypes, initialStateField, mutableStateField, attributes, mutableAttributeCount, ConstructorKind.REFERENCE, idField, unsafe);
    }

    private CtConstructor createConstructor(EntityViewManager evm, ManagedViewType<?> managedViewType, CtClass cc, int superConstructorStart, int superConstructorEnd, CtField[] attributeFields, CtClass[] attributeTypes, CtField initialStateField, CtField mutableStateField, AbstractMethodAttribute<?, ?>[] attributes, int mutableAttributeCount, ConstructorKind kind, CtField idField, boolean unsafe) throws CannotCompileException, NotFoundException, BadBytecode {
        CtClass[] parameterTypes = kind == ConstructorKind.CREATE ? new CtClass[]{} : attributeTypes;
        CtConstructor ctConstructor = new CtConstructor(parameterTypes, cc);
        ctConstructor.setModifiers(1);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        if (unsafe) {
            this.renderFieldInitialization(evm, managedViewType, attributeFields, initialStateField, mutableStateField, attributes, mutableAttributeCount, kind, sb, idField);
            this.renderSuperCall(cc, superConstructorStart, superConstructorEnd, sb);
        } else {
            this.renderSuperCall(cc, superConstructorStart, superConstructorEnd, sb);
            this.renderFieldInitialization(evm, managedViewType, attributeFields, initialStateField, mutableStateField, attributes, mutableAttributeCount, kind, sb, idField);
        }
        this.renderDirtyTrackerRegistration(attributeFields, mutableStateField, attributes, kind, sb);
        Method postCreateMethod = null;
        if (kind == ConstructorKind.CREATE && managedViewType.getPostCreateMethod() != null) {
            postCreateMethod = managedViewType.getPostCreateMethod();
            if (!managedViewType.getJavaType().isInterface()) {
                if (postCreateMethod.getParameterTypes().length == 1) {
                    sb.append("\t$0.").append(postCreateMethod.getName()).append("(").append(cc.getName()).append("#$$_evm);\n");
                } else {
                    sb.append("\t$0.").append(postCreateMethod.getName()).append("();\n");
                }
                postCreateMethod = null;
            }
        }
        sb.append("}");
        if (unsafe) {
            this.compileUnsafe(ctConstructor, sb.toString());
        } else {
            ctConstructor.setBody(sb.toString());
        }
        if (postCreateMethod != null) {
            String postCreateMethodDescriptor;
            CodeAttribute codeAttribute = ctConstructor.getMethodInfo().getCodeAttribute();
            Bytecode bc = new Bytecode(codeAttribute.getConstPool(), codeAttribute.getMaxStack(), codeAttribute.getMaxLocals());
            byte[] instructions = codeAttribute.getCode();
            for (int i = 0; i < codeAttribute.getCodeLength() - 1; ++i) {
                bc.add((int)instructions[i]);
            }
            bc.addAload(0);
            if (postCreateMethod.getParameterTypes().length == 1) {
                bc.addGetstatic(cc, "$$_evm", Descriptor.of((String)EntityViewManager.class.getName()));
                postCreateMethodDescriptor = "(L" + Descriptor.toJvmName((String)EntityViewManager.class.getName()) + ";)V";
            } else {
                postCreateMethodDescriptor = "()V";
            }
            bc.addInvokevirtual(cc, postCreateMethod.getName(), postCreateMethodDescriptor);
            bc.addReturn(null);
            CodeAttribute newCodeAttribute = bc.toCodeAttribute();
            StackMap stackMap = (StackMap)codeAttribute.getAttribute("StackMap");
            newCodeAttribute.setAttribute(stackMap);
            newCodeAttribute.setAttribute((StackMapTable)codeAttribute.getAttribute("StackMapTable"));
            ctConstructor.getMethodInfo().setCodeAttribute(bc.toCodeAttribute());
            if (stackMap == null) {
                ctConstructor.getMethodInfo().rebuildStackMap(cc.getClassPool());
            }
        }
        return ctConstructor;
    }

    private void compileUnsafe(CtConstructor ctConstructor, String src) throws CannotCompileException {
        CtClass cc = ctConstructor.getDeclaringClass();
        MethodInfo methodInfo = ctConstructor.getMethodInfo();
        try {
            Bytecode b = new Bytecode(cc.getClassFile2().getConstPool(), 0, 0);
            JvstCodeGen gen = new JvstCodeGen(b, cc, cc.getClassPool());
            SymbolTable stable = new SymbolTable();
            int mod = ctConstructor.getModifiers();
            gen.recordParams(ctConstructor.getParameterTypes(), Modifier.isStatic((int)mod), "$", "$args", "$$", stable);
            gen.recordType(CtClass.voidType);
            gen.recordReturnType(CtClass.voidType, "$r", null, stable);
            Parser p = new Parser(new Lex(src));
            SymbolTable stb = new SymbolTable(stable);
            Stmnt s = p.parseStatement(stb);
            if (p.hasMore()) {
                throw new CompileError("the method/constructor body must be surrounded by {}");
            }
            boolean callSuper = false;
            gen.atMethodBody(s, callSuper, true);
            methodInfo.setCodeAttribute(b.toCodeAttribute());
            methodInfo.setAccessFlags(methodInfo.getAccessFlags() & 0xFFFFFBFF);
            methodInfo.rebuildStackMapIf6(cc.getClassPool(), cc.getClassFile2());
            cc.rebuildClassFile();
        }
        catch (CompileError e) {
            throw new CannotCompileException(e);
        }
        catch (BadBytecode e) {
            throw new CannotCompileException((Throwable)e);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    private void renderFieldInitialization(EntityViewManager entityViewManager, ManagedViewType<?> managedViewType, CtField[] attributeFields, CtField initialStateField, CtField mutableStateField, AbstractMethodAttribute<?, ?>[] methodAttributes, int mutableAttributeCount, ConstructorKind kind, StringBuilder sb, CtField idField) throws NotFoundException, CannotCompileException {
        if (initialStateField != null) {
            sb.append("\tObject[] initialStateArr = new Object[").append(mutableAttributeCount).append("];\n");
        }
        if (mutableStateField != null) {
            sb.append("\tObject[] mutableStateArr = new Object[").append(mutableAttributeCount).append("];\n");
        }
        if (kind == ConstructorKind.CREATE && managedViewType.isCreatable()) {
            sb.append("\t$0.$$_isNew = true;\n");
        }
        for (int i = 0; i < attributeFields.length; ++i) {
            CtClass type;
            if (attributeFields[i] == null) continue;
            AbstractMethodAttribute<?, ?> methodAttribute = methodAttributes[i];
            sb.append("\t$0.").append(attributeFields[i].getName()).append(" = ");
            if (kind != ConstructorKind.CREATE && attributeFields[i] == idField) {
                sb.append('$').append(i + 1).append(";\n");
            } else if (kind != ConstructorKind.NORMAL) {
                com.blazebit.persistence.view.metamodel.SingularAttribute singularAttribute;
                PluralAttribute pluralAttribute;
                type = attributeFields[i].getType();
                if (type.isPrimitive()) {
                    sb.append(this.getDefaultValue(type)).append(";\n");
                    if (mutableStateField != null && methodAttribute != null && methodAttribute.hasDirtyStateIndex()) {
                        sb.append("\tmutableStateArr[").append(methodAttribute.getDirtyStateIndex()).append("] = ");
                        sb.append(this.getDefaultValueForObject(type)).append(";\n");
                    }
                } else if (methodAttribute != null && methodAttribute.hasDirtyStateIndex()) {
                    if (mutableStateField != null) {
                        sb.append("mutableStateArr[").append(methodAttribute.getDirtyStateIndex()).append("] = ");
                    }
                    if (kind == ConstructorKind.CREATE) {
                        if (methodAttribute instanceof PluralAttribute) {
                            pluralAttribute = (PluralAttribute)methodAttribute;
                            this.addAllowedSubtypeField(attributeFields[i].getDeclaringClass(), methodAttribute);
                            this.addParentRequiringUpdateSubtypesField(attributeFields[i].getDeclaringClass(), methodAttribute);
                            this.addParentRequiringCreateSubtypesField(attributeFields[i].getDeclaringClass(), methodAttribute);
                            switch (pluralAttribute.getCollectionType()) {
                                case MAP: {
                                    if (pluralAttribute.isSorted()) {
                                        sb.append("new ").append(RecordingNavigableMap.class.getName()).append('(');
                                        sb.append("(java.util.NavigableMap) new java.util.TreeMap(");
                                        if (pluralAttribute.getComparatorClass() != null) {
                                            sb.append("new ").append(pluralAttribute.getComparatorClass().getName()).append("()");
                                        }
                                        sb.append("),");
                                        break;
                                    }
                                    if (pluralAttribute.isOrdered()) {
                                        sb.append("new ").append(RecordingMap.class.getName()).append('(');
                                        sb.append("(java.util.Map) new java.util.LinkedHashMap(),true,");
                                        break;
                                    }
                                    sb.append("new ").append(RecordingMap.class.getName()).append('(');
                                    sb.append("(java.util.Map) new java.util.HashMap(),false,");
                                    break;
                                }
                                case SET: {
                                    if (pluralAttribute.isSorted()) {
                                        sb.append("new ").append(RecordingNavigableSet.class.getName()).append('(');
                                        sb.append("(java.util.NavigableSet) new java.util.TreeSet(");
                                        if (pluralAttribute.getComparatorClass() != null) {
                                            sb.append("new ").append(pluralAttribute.getComparatorClass().getName()).append("()");
                                        }
                                        sb.append("),");
                                        break;
                                    }
                                    if (pluralAttribute.isOrdered()) {
                                        sb.append("new ").append(RecordingSet.class.getName()).append('(');
                                        sb.append("(java.util.Set) new java.util.LinkedHashSet(),true,");
                                        break;
                                    }
                                    sb.append("new ").append(RecordingSet.class.getName()).append('(');
                                    sb.append("(java.util.Set) new java.util.HashSet(),false,");
                                    break;
                                }
                                case LIST: {
                                    sb.append("new ").append(RecordingList.class.getName()).append('(');
                                    sb.append("(java.util.List) new java.util.ArrayList(),");
                                    sb.append(pluralAttribute.isIndexed()).append(',');
                                    break;
                                }
                                default: {
                                    sb.append("new ").append(RecordingCollection.class.getName()).append('(');
                                    sb.append("(java.util.Collection) new java.util.ArrayList(),false,false,");
                                }
                            }
                            sb.append(attributeFields[i].getDeclaringClass().getName()).append('#');
                            sb.append(methodAttribute.getName()).append("_$$_subtypes").append(',');
                            sb.append(attributeFields[i].getDeclaringClass().getName()).append('#');
                            sb.append(methodAttribute.getName()).append("_$$_parentRequiringUpdateSubtypes").append(',');
                            sb.append(attributeFields[i].getDeclaringClass().getName()).append('#');
                            sb.append(methodAttribute.getName()).append("_$$_parentRequiringCreateSubtypes").append(',');
                            sb.append(methodAttribute.isUpdatable()).append(',');
                            sb.append(methodAttribute.isOptimizeCollectionActionsEnabled()).append(',');
                            sb.append(this.strictCascadingCheck);
                            sb.append(");\n");
                        } else {
                            singularAttribute = (com.blazebit.persistence.view.metamodel.SingularAttribute)methodAttribute;
                            if (singularAttribute.getType().getMappingType() == Type.MappingType.FLAT_VIEW) {
                                ManagedViewTypeImplementor attributeManagedViewType = (ManagedViewTypeImplementor)singularAttribute.getType();
                                sb.append("new ");
                                sb.append(this.getProxy(entityViewManager, attributeManagedViewType, null).getName());
                                sb.append("();\n");
                            } else {
                                sb.append("null;\n");
                            }
                        }
                    } else {
                        sb.append("null;\n");
                    }
                } else if (kind == ConstructorKind.CREATE) {
                    if (methodAttribute instanceof PluralAttribute) {
                        pluralAttribute = (PluralAttribute)methodAttribute;
                        switch (pluralAttribute.getCollectionType()) {
                            case MAP: {
                                if (pluralAttribute.isSorted()) {
                                    sb.append("new java.util.TreeMap()");
                                    if (pluralAttribute.getComparatorClass() != null) {
                                        sb.append("new ").append(pluralAttribute.getComparatorClass().getName()).append("()");
                                    }
                                    sb.append(")");
                                    break;
                                }
                                if (pluralAttribute.isOrdered()) {
                                    sb.append("new java.util.LinkedHashMap()");
                                    break;
                                }
                                sb.append("new java.util.HashMap()");
                                break;
                            }
                            case SET: {
                                if (pluralAttribute.isSorted()) {
                                    sb.append("new java.util.TreeSet(");
                                    if (pluralAttribute.getComparatorClass() != null) {
                                        sb.append("new ").append(pluralAttribute.getComparatorClass().getName()).append("()");
                                    }
                                    sb.append(")");
                                    break;
                                }
                                if (pluralAttribute.isOrdered()) {
                                    sb.append("new java.util.LinkedHashSet()");
                                    break;
                                }
                                sb.append("new java.util.HashSet()");
                                break;
                            }
                            case LIST: {
                                sb.append("new java.util.ArrayList()");
                                break;
                            }
                            default: {
                                sb.append("new java.util.ArrayList()");
                            }
                        }
                        sb.append(";\n");
                    } else {
                        MethodAttribute idAttribute;
                        singularAttribute = attributeFields[i] == idField && (idAttribute = ((ViewType)managedViewType).getIdAttribute()).isSubview() ? (com.blazebit.persistence.view.metamodel.SingularAttribute)idAttribute : (com.blazebit.persistence.view.metamodel.SingularAttribute)methodAttribute;
                        if (singularAttribute != null && singularAttribute.getType().getMappingType() == Type.MappingType.FLAT_VIEW) {
                            ManagedViewTypeImplementor attributeManagedViewType = (ManagedViewTypeImplementor)singularAttribute.getType();
                            sb.append("new ");
                            sb.append(this.getProxy(entityViewManager, attributeManagedViewType, null).getName());
                            sb.append("();\n");
                        } else {
                            sb.append("null;\n");
                        }
                    }
                } else {
                    sb.append("null;\n");
                }
            } else {
                sb.append('$').append(i + 1).append(";\n");
            }
            if (kind != ConstructorKind.NORMAL && (kind != ConstructorKind.CREATE || managedViewType.isCreatable()) || methodAttribute == null || !methodAttribute.hasDirtyStateIndex()) continue;
            type = attributeFields[i].getType();
            if (mutableStateField != null) {
                sb.append("\tmutableStateArr[").append(methodAttribute.getDirtyStateIndex()).append("] = ");
            }
            if (initialStateField != null) {
                sb.append("initialStateArr[").append(methodAttribute.getDirtyStateIndex()).append("] = ");
            }
            if (mutableStateField == null) continue;
            if (kind == ConstructorKind.NORMAL) {
                this.renderValueForArray(sb, type, i + 1);
                continue;
            }
            sb.append(this.getDefaultValueForObject(type)).append(";\n");
        }
        if (initialStateField != null) {
            sb.append("\t$0.").append(initialStateField.getName()).append(" = initialStateArr;\n");
        }
        if (mutableStateField != null) {
            sb.append("\t$0.").append(mutableStateField.getName()).append(" = mutableStateArr;\n");
        }
    }

    private String getDefaultValue(CtClass type) {
        if (type.isPrimitive()) {
            if (type == CtClass.longType) {
                return "0L";
            }
            if (type == CtClass.floatType) {
                return "0F";
            }
            if (type == CtClass.doubleType) {
                return "0D";
            }
            if (type == CtClass.charType) {
                return "'\\u0000'";
            }
            if (type == CtClass.booleanType) {
                return "false";
            }
            return "0";
        }
        return "(" + type.getName() + ") null";
    }

    private String getDefaultValueForObject(CtClass type) {
        if (type.isPrimitive()) {
            if (type == CtClass.longType) {
                return "Long.valueOf(0L)";
            }
            if (type == CtClass.floatType) {
                return "Float.valueOf(0F)";
            }
            if (type == CtClass.doubleType) {
                return "Double.valueOf(0D)";
            }
            if (type == CtClass.shortType) {
                return "Short.valueOf((short) 0)";
            }
            if (type == CtClass.byteType) {
                return "Byte.valueOf((byte) 0)";
            }
            if (type == CtClass.charType) {
                return "Character.valueOf('\\u0000')";
            }
            if (type == CtClass.booleanType) {
                return "Boolean#FALSE";
            }
            return "Integer.valueOf(0)";
        }
        return "(" + type.getName() + ") null";
    }

    private void renderValueForArray(StringBuilder sb, CtClass type, int index) {
        if (type.isPrimitive()) {
            if (type == CtClass.longType) {
                sb.append("Long.valueOf($").append(index).append(");\n");
            } else if (type == CtClass.floatType) {
                sb.append("Float.valueOf($").append(index).append(");\n");
            } else if (type == CtClass.doubleType) {
                sb.append("Double.valueOf($").append(index).append(");\n");
            } else if (type == CtClass.shortType) {
                sb.append("Short.valueOf($").append(index).append(");\n");
            } else if (type == CtClass.byteType) {
                sb.append("Byte.valueOf($").append(index).append(");\n");
            } else if (type == CtClass.booleanType) {
                sb.append("Boolean.valueOf($").append(index).append(");\n");
            } else if (type == CtClass.charType) {
                sb.append("Character.valueOf($").append(index).append(");\n");
            } else {
                sb.append("Integer.valueOf($").append(index).append(");\n");
            }
        } else {
            sb.append("$").append(index).append(";\n");
        }
    }

    private void renderDirtyTrackerRegistration(CtField[] attributeFields, CtField mutableStateField, AbstractMethodAttribute<?, ?>[] attributes, ConstructorKind kind, StringBuilder sb) throws NotFoundException, CannotCompileException {
        if (mutableStateField != null) {
            sb.append("\t$0.$$_initialized = true;\n");
        }
        if (kind != ConstructorKind.REFERENCE) {
            for (int i = 0; i < attributeFields.length; ++i) {
                AbstractMethodAttribute<?, ?> methodAttribute;
                if (attributeFields[i] == null || (methodAttribute = attributes[i]) == null || !methodAttribute.hasDirtyStateIndex() || methodAttribute.getConvertedJavaType().isPrimitive() || mutableStateField == null || !methodAttribute.isCollection() && !methodAttribute.isSubview()) continue;
                sb.append("\tif ($0.").append(attributeFields[i].getName()).append(" != null) {\n");
                if (methodAttribute.isCollection()) {
                    if (methodAttribute.getDirtyStateIndex() != -1) {
                        if (methodAttribute instanceof MapAttribute) {
                            sb.append("\t\t((").append(RecordingMap.class.getName()).append(") $0.").append(attributeFields[i].getName()).append(").$$_setParent($0, ").append(methodAttribute.getDirtyStateIndex()).append(");\n");
                        } else {
                            sb.append("\t\t((").append(RecordingCollection.class.getName()).append(") $0.").append(attributeFields[i].getName()).append(").$$_setParent($0, ").append(methodAttribute.getDirtyStateIndex()).append(");\n");
                        }
                    }
                } else if (methodAttribute.isSubview()) {
                    sb.append("\t\tif ($0.").append(attributeFields[i].getName()).append(" instanceof ").append(DirtyTracker.class.getName()).append(") {\n");
                    sb.append("\t\t\t((").append(DirtyTracker.class.getName()).append(") $0.").append(attributeFields[i].getName()).append(").$$_setParent($0, ").append(methodAttribute.getDirtyStateIndex()).append(");\n");
                    sb.append("\t\t}\n");
                }
                sb.append("\t}\n");
            }
        }
    }

    private String addAllowedSubtypeField(CtClass declaringClass, AbstractMethodAttribute<?, ?> attribute) throws CannotCompileException {
        return this.addClassSetField(declaringClass, "subtypes", attribute, attribute.getAllowedSubtypes());
    }

    private String addParentRequiringUpdateSubtypesField(CtClass declaringClass, AbstractMethodAttribute<?, ?> attribute) throws CannotCompileException {
        return this.addClassSetField(declaringClass, "parentRequiringUpdateSubtypes", attribute, attribute.getParentRequiringUpdateSubtypes());
    }

    private String addParentRequiringCreateSubtypesField(CtClass declaringClass, AbstractMethodAttribute<?, ?> attribute) throws CannotCompileException {
        return this.addClassSetField(declaringClass, "parentRequiringCreateSubtypes", attribute, attribute.getParentRequiringUpdateSubtypes());
    }

    private String addClassSetField(CtClass declaringClass, String fieldSuffix, AbstractMethodAttribute<?, ?> attribute, Set<Class<?>> classes) throws CannotCompileException {
        String subtypeArray;
        if (!classes.isEmpty()) {
            StringBuilder subtypeArrayBuilder = new StringBuilder();
            for (Class<?> c : classes) {
                subtypeArrayBuilder.append(c.getName());
                subtypeArrayBuilder.append(", ");
            }
            subtypeArrayBuilder.setLength(subtypeArrayBuilder.length() - 2);
            subtypeArray = subtypeArrayBuilder.toString();
        } else {
            subtypeArray = "";
        }
        try {
            declaringClass.getDeclaredField(attribute.getName() + "_$$_" + fieldSuffix);
            return subtypeArray;
        }
        catch (NotFoundException subtypeArrayBuilder) {
            StringBuilder fieldSb = new StringBuilder();
            fieldSb.append("private static final java.util.Set ");
            fieldSb.append(attribute.getName());
            fieldSb.append("_$$_").append(fieldSuffix).append(" = ");
            if (!classes.isEmpty()) {
                fieldSb.append("new java.util.HashSet(java.util.Arrays.asList(new java.lang.Class[]{ ");
                for (Class<?> c : classes) {
                    fieldSb.append(c.getName());
                    fieldSb.append(".class, ");
                }
                fieldSb.setLength(fieldSb.length() - 2);
                fieldSb.append(" }));");
            } else {
                fieldSb.append("java.util.Collections.emptySet();");
            }
            CtField allowedSubtypesField = CtField.make((String)fieldSb.toString(), (CtClass)declaringClass);
            declaringClass.addField(allowedSubtypesField);
            return subtypeArray;
        }
    }

    private String addEmptyObjectArray(CtClass declaringClass) throws NotFoundException, CannotCompileException {
        String name = "$$_empty_object_array";
        CtField[] fields = declaringClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName())) continue;
            return declaringClass.getName() + "#" + name;
        }
        CtField f = CtField.make((String)("private static final Object[] " + name + " = new Object[0];"), (CtClass)declaringClass);
        declaringClass.addField(f);
        return declaringClass.getName() + "#" + name;
    }

    private String addEmptyClassArray(CtClass declaringClass) throws NotFoundException, CannotCompileException {
        String name = "$$_empty_class_array";
        CtField[] fields = declaringClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName())) continue;
            return declaringClass.getName() + "#" + name;
        }
        CtField f = CtField.make((String)("private static final Class[] " + name + " = new Class[0];"), (CtClass)declaringClass);
        declaringClass.addField(f);
        return declaringClass.getName() + "#" + name;
    }

    private String addMakeFieldAccessible(CtClass declaringClass) throws NotFoundException, CannotCompileException {
        String name = "$$_make_field_accessible";
        CtMethod[] methods = declaringClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!name.equals(methods[i].getName())) continue;
            return declaringClass.getName() + "#" + name;
        }
        String desc = "(" + Descriptor.of((String)Field.class.getName()) + ")" + Descriptor.of((String)Field.class.getName());
        ConstPool cp = declaringClass.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, name, desc);
        minfo.setAccessFlags(10);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\t$1.setAccessible(true);\n");
        sb.append("\treturn $1;\n");
        sb.append("}");
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)declaringClass);
        method.setBody(sb.toString());
        declaringClass.addMethod(method);
        return declaringClass.getName() + "#" + name;
    }

    private String addMakeMethodAccessible(CtClass declaringClass) throws NotFoundException, CannotCompileException {
        String name = "$$_make_method_accessible";
        CtMethod[] methods = declaringClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!name.equals(methods[i].getName())) continue;
            return declaringClass.getName() + "#" + name;
        }
        String desc = "(" + Descriptor.of((String)Method.class.getName()) + ")" + Descriptor.of((String)Method.class.getName());
        ConstPool cp = declaringClass.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, name, desc);
        minfo.setAccessFlags(10);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("\t$1.setAccessible(true);\n");
        sb.append("\treturn $1;\n");
        sb.append("}");
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)declaringClass);
        method.setBody(sb.toString());
        declaringClass.addMethod(method);
        return declaringClass.getName() + "#" + name;
    }

    private String addIdAccessor(CtClass declaringClass, IdentifiableType<?> type, SingularAttribute<?, ?> jpaIdAttribute, CtClass idType) throws NotFoundException, CannotCompileException {
        StringBuilder fieldSb;
        String name = "$$_" + ((EntityType)type).getName() + "_" + jpaIdAttribute.getName();
        CtMethod[] methods = declaringClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!name.equals(methods[i].getName())) continue;
            return declaringClass.getName() + "#" + name;
        }
        ClassPool classPool = declaringClass.getClassPool();
        CtClass boxedType = this.autoBox(classPool, idType);
        String desc = "(" + Descriptor.of((String)type.getJavaType().getName()) + ")" + Descriptor.of((CtClass)boxedType);
        ConstPool cp = declaringClass.getClassFile().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, name, desc);
        minfo.setAccessFlags(10);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        String fieldName = name + "_accessor";
        if (jpaIdAttribute.getJavaMember() instanceof Field) {
            fieldSb = new StringBuilder();
            fieldSb.append(this.addMakeFieldAccessible(declaringClass));
            fieldSb.append('(');
            fieldSb.append(jpaIdAttribute.getJavaMember().getDeclaringClass());
            fieldSb.append(".class.getDeclaredField(\"");
            fieldSb.append(jpaIdAttribute.getJavaMember().getName());
            fieldSb.append("\"));");
            CtField field = new CtField(classPool.get("java.lang.reflect.Field"), fieldName, declaringClass);
            field.getFieldInfo().setAccessFlags(26);
            declaringClass.addField(field, CtField.Initializer.byExpr((String)fieldSb.toString()));
            sb.append("\treturn ");
            sb.append('(');
            sb.append(boxedType.getName());
            sb.append(") ");
            sb.append(declaringClass.getName());
            sb.append('#');
            sb.append(fieldName).append(".get((Object) $1);\n");
        } else {
            fieldSb = new StringBuilder();
            fieldSb.append(this.addMakeMethodAccessible(declaringClass));
            fieldSb.append('(');
            fieldSb.append(jpaIdAttribute.getJavaMember().getDeclaringClass().getName());
            fieldSb.append(".class.getDeclaredMethod(\"");
            fieldSb.append(jpaIdAttribute.getJavaMember().getName());
            fieldSb.append("\", ");
            fieldSb.append(this.addEmptyClassArray(declaringClass));
            fieldSb.append("));");
            CtField field = new CtField(classPool.get("java.lang.reflect.Method"), fieldName, declaringClass);
            field.getFieldInfo().setAccessFlags(26);
            declaringClass.addField(field, CtField.Initializer.byExpr((String)fieldSb.toString()));
            sb.append("\treturn ");
            sb.append('(');
            sb.append(boxedType.getName());
            sb.append(") ");
            sb.append(declaringClass.getName());
            sb.append('#');
            String emptyObjectArrayField = this.addEmptyObjectArray(declaringClass);
            sb.append(fieldName).append(".invoke((Object) $1, ").append(emptyObjectArrayField);
            sb.append(");\n");
        }
        sb.append('}');
        CtMethod method = CtMethod.make((MethodInfo)minfo, (CtClass)declaringClass);
        method.setBody(sb.toString());
        declaringClass.addMethod(method);
        return declaringClass.getName() + "#" + name;
    }

    private CtClass autoBox(ClassPool classPool, CtClass fieldType) {
        if (fieldType.isPrimitive()) {
            String typeName = fieldType.getName();
            try {
                Class type = ReflectionUtils.getWrapperClassOfPrimitve((Class)ReflectionUtils.getClass((String)typeName));
                return classPool.get(type.getName());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unsupported primitive type: " + typeName, ex);
            }
        }
        return fieldType;
    }

    private void autoBox(Bytecode code, ClassPool classPool, CtClass fieldType) {
        if (fieldType.isPrimitive()) {
            String typeName = fieldType.getName();
            try {
                Class type = ReflectionUtils.getWrapperClassOfPrimitve((Class)ReflectionUtils.getClass((String)typeName));
                CtClass wrapperType = classPool.get(type.getName());
                code.addInvokestatic(type.getName(), "valueOf", Descriptor.ofMethod((CtClass)wrapperType, (CtClass[])new CtClass[]{fieldType}));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unsupported primitive type: " + typeName, ex);
            }
        }
    }

    private boolean needsTwoStackSlots(CtClass c) {
        return this.needsTwoStackSlots(c.getName());
    }

    private boolean needsTwoStackSlots(String name) {
        return "long".equals(name) || "double".equals(name);
    }

    private void renderSuperCall(CtClass cc, int superStart, int superEnd, StringBuilder sb) throws NotFoundException {
        sb.append("\tsuper(");
        if (superStart < superEnd) {
            for (int i = superStart; i < superEnd; ++i) {
                sb.append('$').append(i + 1).append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
        } else {
            sb.append(')');
        }
        sb.append(";\n");
    }

    private <T> CtConstructor findConstructor(CtClass superCc, MappingConstructor<T> constructor) throws NotFoundException {
        List parameterAttributes = constructor.getParameterAttributes();
        CtClass[] parameterTypes = new CtClass[parameterAttributes.size()];
        for (int i = 0; i < parameterAttributes.size(); ++i) {
            parameterTypes[i] = this.getType((com.blazebit.persistence.view.metamodel.Attribute)parameterAttributes.get(i));
        }
        return superCc.getDeclaredConstructor(parameterTypes);
    }

    private CtClass getType(com.blazebit.persistence.view.metamodel.Attribute<?, ?> attribute) throws NotFoundException {
        return this.pool.get(attribute.getConvertedJavaType().getName());
    }

    private int getModifiers(boolean hasSetter) {
        if (hasSetter) {
            return 2;
        }
        return 18;
    }

    private String getGenericSignature(MethodAttribute<?, ?> attribute, CtField attributeField) throws NotFoundException {
        Class[] typeArguments = ReflectionUtils.getResolvedMethodReturnTypeArguments((Class)attribute.getDeclaringType().getJavaType(), (Method)attribute.getJavaMethod());
        if (typeArguments.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(typeArguments.length * 10);
        String simpleType = Descriptor.of((CtClass)attributeField.getType());
        sb.append(simpleType, 0, simpleType.length() - 1);
        sb.append('<');
        for (int i = 0; i < typeArguments.length; ++i) {
            if (typeArguments[i] == null) {
                throw new IllegalArgumentException("The type argument can not be resolved at index '" + i + "' for the attribute '" + attribute.getName() + "' of the class '" + attribute.getDeclaringType().getJavaType().getName() + "'!");
            }
            sb.append(Descriptor.of((String)typeArguments[i].getName()));
        }
        sb.append('>');
        sb.append(';');
        return sb.toString();
    }

    static {
        String property = System.getProperty("entityview.debugDumpDirectory");
        if (property == null) {
            DEBUG_DUMP_DIRECTORY = null;
        } else {
            Path p = Paths.get(property, new String[0]);
            if (Files.exists(p, new LinkOption[0])) {
                DEBUG_DUMP_DIRECTORY = p.toAbsolutePath();
            } else {
                DEBUG_DUMP_DIRECTORY = null;
                Logger.getLogger(ProxyFactory.class.getName()).severe("The given debug dump directory does not exist: " + p.toAbsolutePath());
            }
        }
    }

    private static enum ConstructorKind {
        CREATE,
        NORMAL,
        REFERENCE;

    }

    private static final class ProxyClassKey {
        private final Class<?> viewTypeClass;
        private final Class<?> inheritanceBaseClass;

        public ProxyClassKey(Class<?> viewTypeClass, Class<?> inheritanceBaseClass) {
            this.viewTypeClass = viewTypeClass;
            this.inheritanceBaseClass = inheritanceBaseClass;
        }

        public boolean equals(Object o) {
            ProxyClassKey that = (ProxyClassKey)o;
            if (!this.viewTypeClass.equals(that.viewTypeClass)) {
                return false;
            }
            return this.inheritanceBaseClass != null ? this.inheritanceBaseClass.equals(that.inheritanceBaseClass) : that.inheritanceBaseClass == null;
        }

        public int hashCode() {
            int result = this.viewTypeClass.hashCode();
            result = 31 * result + (this.inheritanceBaseClass != null ? this.inheritanceBaseClass.hashCode() : 0);
            return result;
        }
    }
}

