/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.tx;

import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionSupport;
import com.blazebit.reflection.ExpressionUtils;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.transaction.Synchronization;

public class Hibernate4TransactionSynchronizationStrategy
implements TransactionAccess,
TransactionSupport {
    private final EntityTransaction tx;
    private final Object synchronizationRegistry;
    private final Method registerSynchronization;

    public Hibernate4TransactionSynchronizationStrategy(EntityManager em) {
        try {
            this.tx = em.getTransaction();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Could not access entity transaction!", e);
        }
        try {
            Object s = em.unwrap(Class.forName("org.hibernate.Session"));
            this.synchronizationRegistry = ExpressionUtils.getNullSafeValue((Object)s, (String)"transactionCoordinator.synchronizationRegistry");
            this.registerSynchronization = ReflectionUtils.getMethod(this.synchronizationRegistry.getClass(), (String)"registerSynchronization", (Class[])new Class[]{Synchronization.class});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isActive() {
        return this.tx.isActive();
    }

    public void markRollbackOnly() {
        this.tx.setRollbackOnly();
    }

    public void registerSynchronization(Synchronization synchronization) {
        try {
            this.registerSynchronization.invoke(this.synchronizationRegistry, synchronization);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void transactional(Runnable runnable) {
        runnable.run();
    }
}

