/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.tx;

import com.blazebit.persistence.view.impl.tx.Hibernate5JtaPlatformTransactionSynchronizationStrategy;
import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionAccessFactory;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import javax.persistence.EntityManager;

public class Hibernate5JtaPlatformTransactionAccessFactory
implements TransactionAccessFactory {
    public TransactionAccess createTransactionAccess(EntityManager entityManager) {
        return new Hibernate5JtaPlatformTransactionSynchronizationStrategy(Hibernate5JtaPlatformTransactionAccessFactory.getHibernate5JtaPlatformPresent(entityManager));
    }

    public static Object getHibernate5JtaPlatformPresent(EntityManager em) {
        try {
            Object hibernateSession = em.unwrap(Class.forName("org.hibernate.Session"));
            Object hibernateSessionFactory = ReflectionUtils.getMethod(hibernateSession.getClass(), (String)"getSessionFactory", (Class[])new Class[0]).invoke(hibernateSession, new Object[0]);
            Object hibernateServiceRegistry = ReflectionUtils.getMethod(hibernateSessionFactory.getClass(), (String)"getServiceRegistry", (Class[])new Class[0]).invoke(hibernateSessionFactory, new Object[0]);
            return ReflectionUtils.getMethod(hibernateServiceRegistry.getClass(), (String)"getService", (Class[])new Class[]{Class.class}).invoke(hibernateServiceRegistry, Class.forName("org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform"));
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unexpected error when attempting to retrieve the Hibernate 5 JTA platform!", e);
        }
    }
}

