/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.tx;

import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionSupport;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.Synchronization;

public class Hibernate5JtaPlatformTransactionSynchronizationStrategy
implements TransactionAccess,
TransactionSupport {
    private final Object jtaPlatform;
    private final Object jtaTransactionManager;
    private final Method getCurrentStatusMethod;
    private final Method registerSynchronizationMethod;
    private final Method setRollbackOnlyMethod;

    public Hibernate5JtaPlatformTransactionSynchronizationStrategy(Object jtaPlatform) {
        this.jtaPlatform = jtaPlatform;
        try {
            this.jtaTransactionManager = ReflectionUtils.getMethod(jtaPlatform.getClass(), (String)"retrieveTransactionManager", (Class[])new Class[0]).invoke(jtaPlatform, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.getCurrentStatusMethod = ReflectionUtils.getMethod(jtaPlatform.getClass(), (String)"getCurrentStatus", (Class[])new Class[0]);
        this.registerSynchronizationMethod = ReflectionUtils.getMethod(jtaPlatform.getClass(), (String)"registerSynchronization", (Class[])new Class[]{Synchronization.class});
        this.setRollbackOnlyMethod = ReflectionUtils.getMethod(this.jtaTransactionManager.getClass(), (String)"setRollbackOnly", (Class[])new Class[0]);
    }

    public boolean isActive() {
        try {
            return (Integer)this.getCurrentStatusMethod.invoke(this.jtaPlatform, new Object[0]) == 0;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void markRollbackOnly() {
        try {
            this.setRollbackOnlyMethod.invoke(this.jtaTransactionManager, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerSynchronization(Synchronization synchronization) {
        try {
            this.registerSynchronizationMethod.invoke(this.jtaPlatform, synchronization);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void transactional(Runnable runnable) {
        runnable.run();
    }
}

