/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.tx;

import com.blazebit.persistence.view.impl.tx.Hibernate4TransactionAccessFactory;
import com.blazebit.persistence.view.impl.tx.Hibernate4TransactionSynchronizationStrategy;
import com.blazebit.persistence.view.impl.tx.Hibernate5EntityTransactionAccessFactory;
import com.blazebit.persistence.view.impl.tx.Hibernate5EntityTransactionSynchronizationStrategy;
import com.blazebit.persistence.view.impl.tx.Hibernate5JtaPlatformTransactionAccessFactory;
import com.blazebit.persistence.view.impl.tx.Hibernate5JtaPlatformTransactionSynchronizationStrategy;
import com.blazebit.persistence.view.impl.tx.JtaResources;
import com.blazebit.persistence.view.impl.tx.SynchronizationRegistry;
import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionAccessFactory;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;

public class TransactionHelper {
    private static final Logger LOG = Logger.getLogger(TransactionHelper.class.getName());
    private static volatile TransactionAccessFactory factory;

    private TransactionHelper() {
    }

    public static TransactionAccess getTransactionAccess(EntityManager em) {
        SynchronizationRegistry registry = SynchronizationRegistry.getRegistry();
        if (registry == null) {
            TransactionAccess transactionAccess = TransactionHelper.getTransactionAccessInternal(em);
            if (!transactionAccess.isActive()) {
                return transactionAccess;
            }
            registry = new SynchronizationRegistry(transactionAccess);
        }
        return registry;
    }

    private static TransactionAccess getTransactionAccessInternal(EntityManager em) {
        Object jtaResources;
        TransactionAccessFactory factory = TransactionHelper.factory;
        if (factory != null) {
            return factory.createTransactionAccess(em);
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (context != null && (jtaResources = JtaResources.getInstance()) != null) {
            TransactionHelper.factory = jtaResources;
            return ((JtaResources)jtaResources).createTransactionAccess(em);
        }
        for (TransactionAccessFactory transactionAccessFactory : ServiceLoader.load(TransactionAccessFactory.class)) {
            try {
                TransactionAccess transactionAccess = transactionAccessFactory.createTransactionAccess(em);
                if (transactionAccess == null) continue;
                TransactionHelper.factory = transactionAccessFactory;
                return transactionAccess;
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Error during creation of transaction access!", ex);
            }
        }
        try {
            String version = Class.forName("org.hibernate.Session").getPackage().getImplementationVersion();
            String[] versionParts = version.split("\\.");
            int major = Integer.parseInt(versionParts[0]);
            if (major >= 5) {
                Object jtaPlatform = Hibernate5JtaPlatformTransactionAccessFactory.getHibernate5JtaPlatformPresent(em);
                if (jtaPlatform == null || jtaPlatform.getClass() == Class.forName("org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform")) {
                    TransactionHelper.factory = new Hibernate5EntityTransactionAccessFactory();
                    return new Hibernate5EntityTransactionSynchronizationStrategy(em);
                }
                TransactionHelper.factory = new Hibernate5JtaPlatformTransactionAccessFactory();
                return new Hibernate5JtaPlatformTransactionSynchronizationStrategy(jtaPlatform);
            }
            TransactionHelper.factory = new Hibernate4TransactionAccessFactory();
            return new Hibernate4TransactionSynchronizationStrategy(em);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Unsupported jpa provider!", ex);
        }
    }
}

