/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update;

import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.PostCommitListener;
import com.blazebit.persistence.view.PostPersistEntityListener;
import com.blazebit.persistence.view.PostPersistListener;
import com.blazebit.persistence.view.PostRemoveListener;
import com.blazebit.persistence.view.PostRollbackListener;
import com.blazebit.persistence.view.PostUpdateListener;
import com.blazebit.persistence.view.PrePersistEntityListener;
import com.blazebit.persistence.view.PrePersistListener;
import com.blazebit.persistence.view.PreRemoveListener;
import com.blazebit.persistence.view.PreUpdateListener;
import com.blazebit.persistence.view.ViewTransition;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.listener.ViewInstancePreRemoveListener;
import com.blazebit.persistence.view.impl.update.listener.ViewPreRemoveListenerImpl;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;

public class Listeners {
    private final Class<?> entityClass;
    private final List<ListenerEntry<PrePersistListener<Object>>> prePersistListeners;
    private final List<ListenerEntry<PrePersistEntityListener<Object, Object>>> prePersistEntityListeners;
    private final List<ListenerEntry<PostPersistListener<Object>>> postPersistListeners;
    private final List<ListenerEntry<PostPersistEntityListener<Object, Object>>> postPersistEntityListeners;
    private final List<ListenerEntry<PreUpdateListener<Object>>> preUpdateListeners;
    private final List<ListenerEntry<PostUpdateListener<Object>>> postUpdateListeners;
    private final List<PreRemoveListenerEntry<Object>> preRemoveListeners;
    private final List<ListenerEntry<PostRemoveListener<Object>>> postRemoveListeners;
    private final List<ListenerTransitionEntry<PostCommitListener<Object>>> postCommitListeners;
    private final List<ListenerTransitionEntry<PostRollbackListener<Object>>> postRollbackListeners;

    public Listeners(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.prePersistListeners = new ArrayList<ListenerEntry<PrePersistListener<Object>>>();
        this.prePersistEntityListeners = new ArrayList<ListenerEntry<PrePersistEntityListener<Object, Object>>>();
        this.postPersistListeners = new ArrayList<ListenerEntry<PostPersistListener<Object>>>();
        this.postPersistEntityListeners = new ArrayList<ListenerEntry<PostPersistEntityListener<Object, Object>>>();
        this.preUpdateListeners = new ArrayList<ListenerEntry<PreUpdateListener<Object>>>();
        this.postUpdateListeners = new ArrayList<ListenerEntry<PostUpdateListener<Object>>>();
        this.preRemoveListeners = new ArrayList<PreRemoveListenerEntry<Object>>();
        this.postRemoveListeners = new ArrayList<ListenerEntry<PostRemoveListener<Object>>>();
        this.postCommitListeners = new ArrayList<ListenerTransitionEntry<PostCommitListener<Object>>>();
        this.postRollbackListeners = new ArrayList<ListenerTransitionEntry<PostRollbackListener<Object>>>();
    }

    public void invokePrePersist(UpdateContext context, Object updatableProxy, Object entity) {
        Object view;
        ListenerEntry<PrePersistListener<Object>> entry;
        int i;
        for (i = 0; i < this.prePersistListeners.size(); ++i) {
            entry = this.prePersistListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PrePersistListener)((ListenerEntry)entry).listener).prePersist((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), updatableProxy);
                continue;
            }
            view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, true, true);
            if (view == null) continue;
            ((PrePersistListener)((ListenerEntry)entry).listener).prePersist((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), view);
        }
        for (i = 0; i < this.prePersistEntityListeners.size(); ++i) {
            entry = this.prePersistEntityListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PrePersistEntityListener)((ListenerEntry)entry).listener).prePersist((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), updatableProxy, entity);
                continue;
            }
            view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, true, true);
            if (view == null) continue;
            ((PrePersistEntityListener)((ListenerEntry)entry).listener).prePersist((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), view, entity);
        }
    }

    public void invokePostPersist(UpdateContext context, Object updatableProxy, Object entity) {
        Object view;
        ListenerEntry<PostPersistListener<Object>> entry;
        int i;
        for (i = 0; i < this.postPersistListeners.size(); ++i) {
            entry = this.postPersistListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PostPersistListener)((ListenerEntry)entry).listener).postPersist((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), updatableProxy);
                continue;
            }
            view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, false, false);
            ((PostPersistListener)((ListenerEntry)entry).listener).postPersist((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), view);
        }
        for (i = 0; i < this.postPersistEntityListeners.size(); ++i) {
            entry = this.postPersistEntityListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PostPersistEntityListener)((ListenerEntry)entry).listener).postPersist((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), updatableProxy, entity);
                continue;
            }
            view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, false, false);
            ((PostPersistEntityListener)((ListenerEntry)entry).listener).postPersist((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), view, entity);
        }
    }

    public void invokePreUpdate(UpdateContext context, Object updatableProxy) {
        for (int i = 0; i < this.preUpdateListeners.size(); ++i) {
            ListenerEntry<PreUpdateListener<Object>> entry = this.preUpdateListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PreUpdateListener)((ListenerEntry)entry).listener).preUpdate((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), updatableProxy);
                continue;
            }
            Object view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, false, true);
            ((PreUpdateListener)((ListenerEntry)entry).listener).preUpdate((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), view);
        }
    }

    public void invokePostUpdate(UpdateContext context, Object updatableProxy) {
        for (int i = 0; i < this.postUpdateListeners.size(); ++i) {
            ListenerEntry<PostUpdateListener<Object>> entry = this.postUpdateListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PostUpdateListener)((ListenerEntry)entry).listener).postUpdate((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), updatableProxy);
                continue;
            }
            Object view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, false, false);
            ((PostUpdateListener)((ListenerEntry)entry).listener).postUpdate((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), view);
        }
    }

    public boolean invokePreRemove(UpdateContext context, Object entityView, Object entityId) {
        for (int i = 0; i < this.preRemoveListeners.size(); ++i) {
            PreRemoveListenerEntry<Object> entry = this.preRemoveListeners.get(i);
            if (((PreRemoveListenerEntry)entry).entityViewClass.isInstance(entityView)) {
                if (((PreRemoveListenerEntry)entry).listener.preRemove((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), entityView)) continue;
                return false;
            }
            Object view = context.getEntityView(((PreRemoveListenerEntry)entry).entityViewClass, this.entityClass, entityView == null ? entityId : entityView, false, true);
            if (((PreRemoveListenerEntry)entry).listener.preRemove((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), view)) continue;
            return false;
        }
        return true;
    }

    public void preparePostRemove(UpdateContext context, EntityViewProxy entityView, Object entityId) {
        Object entry;
        int i;
        for (i = 0; i < this.postRemoveListeners.size(); ++i) {
            entry = this.postRemoveListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(entityView)) continue;
            context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, entityView == null ? entityId : entityView, false, false);
        }
        for (i = 0; i < this.postCommitListeners.size(); ++i) {
            entry = this.postCommitListeners.get(i);
            if (!((ListenerTransitionEntry)entry).viewTransitions.contains(ViewTransition.REMOVE) || ((ListenerTransitionEntry)entry).entityViewClass.isInstance(entityView)) continue;
            context.getEntityView(((ListenerTransitionEntry)entry).entityViewClass, this.entityClass, entityView == null ? entityId : entityView, false, false);
        }
    }

    public void invokePostRemove(UpdateContext context, Object entityView, Object entityId) {
        for (int i = 0; i < this.postRemoveListeners.size(); ++i) {
            ListenerEntry<PostRemoveListener<Object>> entry = this.postRemoveListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(entityView)) {
                ((PostRemoveListener)((ListenerEntry)entry).listener).postRemove((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), entityView);
                continue;
            }
            Object view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, entityView == null ? entityId : entityView, false, false);
            ((PostRemoveListener)((ListenerEntry)entry).listener).postRemove((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), view);
        }
    }

    public void invokePostCommit(UpdateContext context, Object entityView, ViewTransition viewTransition) {
        for (int i = 0; i < this.postCommitListeners.size(); ++i) {
            ListenerTransitionEntry<PostCommitListener<Object>> entry = this.postCommitListeners.get(i);
            if (!((ListenerTransitionEntry)entry).viewTransitions.contains(viewTransition)) continue;
            if (((ListenerTransitionEntry)entry).entityViewClass.isInstance(entityView)) {
                ((PostCommitListener)((ListenerTransitionEntry)entry).listener).postCommit((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), entityView, viewTransition);
                continue;
            }
            Object view = context.getEntityView(((ListenerTransitionEntry)entry).entityViewClass, this.entityClass, entityView, false, false);
            ((PostCommitListener)((ListenerTransitionEntry)entry).listener).postCommit((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), view, viewTransition);
        }
    }

    public void invokePostRollback(UpdateContext context, Object entityView, ViewTransition viewTransition, EntityManager em) {
        for (int i = 0; i < this.postRollbackListeners.size(); ++i) {
            ListenerTransitionEntry<PostRollbackListener<Object>> entry = this.postRollbackListeners.get(i);
            if (!((ListenerTransitionEntry)entry).viewTransitions.contains(viewTransition)) continue;
            if (((ListenerTransitionEntry)entry).entityViewClass.isInstance(entityView)) {
                ((PostRollbackListener)((ListenerTransitionEntry)entry).listener).postRollback((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), entityView, viewTransition);
                continue;
            }
            if (viewTransition == ViewTransition.PERSIST) continue;
            Object view = context.getEntityView(((ListenerTransitionEntry)entry).entityViewClass, this.entityClass, entityView, false, false, em);
            ((PostRollbackListener)((ListenerTransitionEntry)entry).listener).postRollback((EntityViewManager)context.getEntityViewManager(), context.getEntityManager(), view, viewTransition);
        }
    }

    public void addPrePersistListener(Class<?> entityViewClass, PrePersistListener<?> listener) {
        this.prePersistListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPrePersistEntityListener(Class<?> entityViewClass, PrePersistEntityListener<?, ?> listener) {
        this.prePersistEntityListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPostPersistListener(Class<?> entityViewClass, PostPersistListener<?> listener) {
        this.postPersistListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPostPersistEntityListener(Class<?> entityViewClass, PostPersistEntityListener<?, ?> listener) {
        this.postPersistEntityListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPreUpdateListener(Class<?> entityViewClass, PreUpdateListener<?> listener) {
        this.preUpdateListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPostUpdateListener(Class<?> entityViewClass, PostUpdateListener<?> listener) {
        this.postUpdateListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPreRemoveListener(Class<?> entityViewClass, PreRemoveListener<?> listener) {
        this.preRemoveListeners.add(new PreRemoveListenerEntry(entityViewClass, listener));
    }

    public void addPostRemoveListener(Class<?> entityViewClass, PostRemoveListener<?> listener) {
        this.postRemoveListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPostCommitListener(Class<?> entityViewClass, PostCommitListener<?> listener, Set<ViewTransition> viewTransitions) {
        this.postCommitListeners.add(new ListenerTransitionEntry(entityViewClass, viewTransitions, listener));
    }

    public void addPostRollbackListener(Class<?> entityViewClass, PostRollbackListener<?> listener, Set<ViewTransition> viewTransitions) {
        this.postRollbackListeners.add(new ListenerTransitionEntry(entityViewClass, viewTransitions, listener));
    }

    public boolean hasPostCommitListeners() {
        return !this.postCommitListeners.isEmpty();
    }

    public boolean hasPostRollbackListeners() {
        return !this.postRollbackListeners.isEmpty();
    }

    public boolean hasRemoveListeners() {
        if (!this.preRemoveListeners.isEmpty() || !this.postRemoveListeners.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.postCommitListeners.size(); ++i) {
            if (!((ListenerTransitionEntry)this.postCommitListeners.get(i)).viewTransitions.contains(ViewTransition.REMOVE)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPossiblyCancellingRemoveListeners() {
        for (int i = 0; i < this.preRemoveListeners.size(); ++i) {
            if (!((PreRemoveListenerEntry)this.preRemoveListeners.get(i)).possiblyCancelling) continue;
            return true;
        }
        return false;
    }

    private static class ListenerTransitionEntry<T> {
        private final Class<?> entityViewClass;
        private final Set<ViewTransition> viewTransitions;
        private final T listener;

        public ListenerTransitionEntry(Class<?> entityViewClass, Set<ViewTransition> viewTransitions, T listener) {
            this.entityViewClass = entityViewClass;
            this.viewTransitions = viewTransitions;
            this.listener = listener;
        }
    }

    private static class PreRemoveListenerEntry<T> {
        private final Class<?> entityViewClass;
        private final boolean possiblyCancelling;
        private final PreRemoveListener<T> listener;

        public PreRemoveListenerEntry(Class<?> entityViewClass, PreRemoveListener<T> listener) {
            this.entityViewClass = entityViewClass;
            this.listener = listener;
            this.possiblyCancelling = listener instanceof ViewInstancePreRemoveListener ? ((ViewInstancePreRemoveListener)listener).isPossiblyCancelling() : !(listener instanceof ViewPreRemoveListenerImpl);
        }
    }

    private static class ListenerEntry<T> {
        private final Class<?> entityViewClass;
        private final T listener;

        public ListenerEntry(Class<?> entityViewClass, T listener) {
            this.entityViewClass = entityViewClass;
            this.listener = listener;
        }
    }
}

