/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.FlushStrategy;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.InitialValueAttributeAccessor;
import com.blazebit.persistence.view.impl.change.PluralDirtyChecker;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.proxy.MutableStateTrackable;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateQueryFactory;
import com.blazebit.persistence.view.impl.update.flush.AttributeFetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.BasicDirtyChecker;
import com.blazebit.persistence.view.impl.update.flush.CollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.CompositeAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.EmbeddableAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.FetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.MergeCollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.PersistCollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;
import com.blazebit.persistence.view.impl.update.flush.UnmappedOwnerAwareDeleter;
import com.blazebit.persistence.view.impl.update.flush.UpdateCollectionElementAttributeFlusher;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public abstract class AbstractPluralAttributeFlusher<X extends AbstractPluralAttributeFlusher<X, A, R, E, V>, A, R, E, V>
extends AttributeFetchGraphNode<X>
implements DirtyAttributeFlusher<X, E, V>,
PluralDirtyChecker<V, E> {
    protected final Class<?> ownerEntityClass;
    protected final String ownerIdAttributeName;
    protected final String ownerMapping;
    protected final DirtyAttributeFlusher<?, Object, Object> ownerIdFlusher;
    protected final boolean supportsCollectionDml;
    protected final String ownerIdWhereFragment;
    protected final String[] ownerIdBindFragments;
    protected final DirtyAttributeFlusher<?, Object, Object> elementFlusher;
    protected final FlushStrategy flushStrategy;
    protected final AttributeAccessor entityAttributeAccessor;
    protected final InitialValueAttributeAccessor viewAttributeAccessor;
    protected final boolean optimisticLockProtected;
    protected final boolean collectionUpdatable;
    protected final boolean viewOnlyDeleteCascaded;
    protected final boolean jpaProviderDeletesCollection;
    protected final CollectionRemoveListener cascadeDeleteListener;
    protected final CollectionRemoveListener removeListener;
    protected final TypeDescriptor elementDescriptor;
    protected final EqualityChecker elementEqualityChecker;
    protected final BasicDirtyChecker<Object> elementDirtyChecker;
    protected final PluralFlushOperation flushOperation;
    protected final List<? extends A> collectionActions;
    protected final List<CollectionElementAttributeFlusher<E, V>> elementFlushers;

    public AbstractPluralAttributeFlusher(String attributeName, String mapping, boolean fetch, Class<?> ownerEntityClass, String ownerIdAttributeName, String ownerMapping, DirtyAttributeFlusher<?, ?, ?> ownerIdFlusher, DirtyAttributeFlusher<?, ?, ?> elementFlusher, boolean supportsCollectionDml, FlushStrategy flushStrategy, AttributeAccessor entityAttributeAccessor, InitialValueAttributeAccessor viewAttributeAccessor, boolean optimisticLockProtected, boolean collectionUpdatable, boolean viewOnlyDeleteCascaded, boolean jpaProviderDeletesCollection, CollectionRemoveListener cascadeDeleteListener, CollectionRemoveListener removeListener, TypeDescriptor elementDescriptor) {
        super(attributeName, mapping, fetch, null);
        this.ownerEntityClass = ownerEntityClass;
        this.ownerIdAttributeName = ownerIdAttributeName;
        this.ownerMapping = ownerMapping;
        this.ownerIdFlusher = ownerIdFlusher;
        this.supportsCollectionDml = supportsCollectionDml;
        this.elementFlusher = elementFlusher;
        if (ownerIdFlusher == null) {
            this.ownerIdWhereFragment = null;
            this.ownerIdBindFragments = null;
        } else {
            StringBuilder sb = new StringBuilder();
            ownerIdFlusher.appendUpdateQueryFragment(null, sb, null, null, " AND ");
            this.ownerIdWhereFragment = sb.toString();
            sb.setLength(0);
            ownerIdFlusher.appendUpdateQueryFragment(null, sb, null, null, ",");
            String[] fragments = sb.toString().split("\\s*(=|,)\\s*");
            for (int i = 1; i < fragments.length; i += 2) {
                fragments[i] = "FUNCTION('TREAT_INTEGER', " + fragments[i] + ")";
            }
            this.ownerIdBindFragments = fragments;
        }
        this.flushStrategy = flushStrategy;
        this.entityAttributeAccessor = entityAttributeAccessor;
        this.viewAttributeAccessor = viewAttributeAccessor;
        this.optimisticLockProtected = optimisticLockProtected;
        this.collectionUpdatable = collectionUpdatable;
        this.viewOnlyDeleteCascaded = viewOnlyDeleteCascaded;
        this.jpaProviderDeletesCollection = jpaProviderDeletesCollection;
        this.cascadeDeleteListener = cascadeDeleteListener;
        this.removeListener = removeListener;
        this.elementDescriptor = elementDescriptor;
        this.elementDirtyChecker = elementDescriptor.isSubview() || elementDescriptor.isJpaEntity() ? null : new BasicDirtyChecker(elementDescriptor);
        this.elementEqualityChecker = elementDescriptor.isSubview() ? (elementDescriptor.isIdentifiable() ? new EntityIdWithViewIdEqualityChecker(elementDescriptor.getViewToEntityMapper()) : new EntityWithViewEqualityChecker(elementDescriptor.getViewToEntityMapper())) : (elementDescriptor.isIdentifiable() ? new IdentityEqualityChecker(elementDescriptor.getBasicUserType()) : new DeepEqualityChecker(elementDescriptor.getBasicUserType()));
        this.flushOperation = null;
        this.collectionActions = null;
        this.elementFlushers = null;
    }

    protected AbstractPluralAttributeFlusher(AbstractPluralAttributeFlusher<?, ?, ?, ?, ?> original, boolean fetch) {
        this(original, fetch, null, null, null);
    }

    protected AbstractPluralAttributeFlusher(AbstractPluralAttributeFlusher<?, ?, ?, ?, ?> original, boolean fetch, PluralFlushOperation flushOperation, List<? extends A> collectionActions, List<CollectionElementAttributeFlusher<E, V>> elementFlushers) {
        super(original.attributeName, original.mapping, fetch, elementFlushers == null ? original.getNestedGraphNode() : AbstractPluralAttributeFlusher.computeElementFetchGraphNode(elementFlushers));
        this.ownerEntityClass = original.ownerEntityClass;
        this.ownerIdAttributeName = original.ownerIdAttributeName;
        this.ownerMapping = original.ownerMapping;
        this.ownerIdFlusher = original.ownerIdFlusher;
        this.supportsCollectionDml = original.supportsCollectionDml;
        this.ownerIdWhereFragment = original.ownerIdWhereFragment;
        this.ownerIdBindFragments = original.ownerIdBindFragments;
        this.elementFlusher = original.elementFlusher;
        this.flushStrategy = original.flushStrategy;
        this.entityAttributeAccessor = original.entityAttributeAccessor;
        this.viewAttributeAccessor = original.viewAttributeAccessor;
        this.optimisticLockProtected = original.optimisticLockProtected;
        this.collectionUpdatable = original.collectionUpdatable;
        this.viewOnlyDeleteCascaded = original.viewOnlyDeleteCascaded;
        this.jpaProviderDeletesCollection = original.jpaProviderDeletesCollection;
        this.cascadeDeleteListener = original.cascadeDeleteListener;
        this.removeListener = original.removeListener;
        this.elementDescriptor = original.elementDescriptor;
        this.elementDirtyChecker = original.elementDirtyChecker;
        this.elementEqualityChecker = original.elementEqualityChecker;
        this.flushOperation = flushOperation;
        this.collectionActions = collectionActions;
        this.elementFlushers = elementFlushers;
    }

    @Override
    protected FetchGraphNode<?> getNestedGraphNode() {
        FetchGraphNode<?> nestedGraphNode = super.getNestedGraphNode();
        return nestedGraphNode == null && this.elementDescriptor.getViewToEntityMapper() != null && this.elementFlushers == null ? this.elementDescriptor.getViewToEntityMapper().getFullGraphNode() : nestedGraphNode;
    }

    private static <E, V> FetchGraphNode<?> computeElementFetchGraphNode(List<CollectionElementAttributeFlusher<E, V>> elementFlushers) {
        if (elementFlushers == null || elementFlushers.isEmpty()) {
            return null;
        }
        CollectionElementAttributeFlusher<E, V> elementAttributeFlusher = null;
        ArrayList filteredElementFlushers = null;
        for (int i = 0; i < elementFlushers.size(); ++i) {
            CollectionElementAttributeFlusher<E, V> flusher = elementFlushers.get(i);
            if (flusher instanceof MergeCollectionElementAttributeFlusher) {
                if (filteredElementFlushers != null) continue;
                filteredElementFlushers = new ArrayList();
                for (int j = 0; j < i; ++j) {
                    filteredElementFlushers.add(elementFlushers.get(j));
                }
                continue;
            }
            if (elementAttributeFlusher == null) {
                elementAttributeFlusher = flusher;
            }
            if (filteredElementFlushers == null) continue;
            filteredElementFlushers.add(flusher);
        }
        if (filteredElementFlushers == null) {
            if (elementFlushers.size() == 1) {
                return elementAttributeFlusher;
            }
        } else {
            if (filteredElementFlushers.isEmpty()) {
                return null;
            }
            if (filteredElementFlushers.size() == 1) {
                return elementAttributeFlusher;
            }
            elementFlushers = filteredElementFlushers;
        }
        return elementAttributeFlusher.mergeWith(elementFlushers);
    }

    @Override
    public boolean appendUpdateQueryFragment(UpdateContext context, StringBuilder sb, String mappingPrefix, String parameterPrefix, String separator) {
        return true;
    }

    @Override
    public boolean supportsQueryFlush() {
        return this.supportsCollectionDml || this.mapping == null || this.flushStrategy != FlushStrategy.ENTITY && (!this.collectionUpdatable || !this.fetch && this.flushOperation == PluralFlushOperation.ELEMENT_ONLY);
    }

    @Override
    public boolean loadForEntityFlush() {
        return this.mapping != null;
    }

    @Override
    public Query flushQuery(UpdateContext context, String parameterPrefix, UpdateQueryFactory queryFactory, Query query, Object ownerView, Object view, V value, UnmappedOwnerAwareDeleter ownerAwareDeleter) {
        if (!this.supportsQueryFlush()) {
            throw new UnsupportedOperationException("Query flush not supported for configuration!");
        }
        for (CollectionElementAttributeFlusher<E, V> elementFlusher : this.elementFlushers) {
            elementFlusher.flushQuery(context, null, queryFactory, null, ownerView, view, value, ownerAwareDeleter);
        }
        return query;
    }

    protected final V getEntityAttributeValue(E entity) {
        if (this.entityAttributeAccessor == null || entity == null) {
            return null;
        }
        Object value = this.entityAttributeAccessor.getValue(entity);
        if (value == null) {
            value = this.createJpaCollection();
            this.entityAttributeAccessor.setValue(entity, value);
        }
        return (V)value;
    }

    protected abstract V createJpaCollection();

    @Override
    public final String getMapping() {
        if (this.ownerMapping == null) {
            return this.mapping;
        }
        return this.ownerMapping + "." + this.mapping;
    }

    protected void invokeFlushOperation(UpdateContext context, Object ownerView, Object view, E entity, V value) {
        switch (this.flushOperation) {
            case COLLECTION_REPLAY_AND_ELEMENT: {
                if (this.flushStrategy == FlushStrategy.ENTITY || context.isForceEntity()) {
                    for (CollectionElementAttributeFlusher<E, V> elementFlusher : this.elementFlushers) {
                        elementFlusher.flushEntity(context, entity, ownerView, view, value, null);
                    }
                } else {
                    for (CollectionElementAttributeFlusher<E, V> elementFlusher : this.elementFlushers) {
                        elementFlusher.flushQuery(context, null, null, null, ownerView, view, value, null);
                    }
                }
                this.invokeCollectionAction(context, ownerView, view, this.getEntityAttributeValue(entity), value, this.collectionActions);
                return;
            }
            case COLLECTION_REPLAY_ONLY: {
                this.invokeCollectionAction(context, ownerView, view, this.getEntityAttributeValue(entity), value, this.collectionActions);
                return;
            }
            case COLLECTION_REPLACE_AND_ELEMENT: {
                if (this.flushStrategy == FlushStrategy.ENTITY || context.isForceEntity()) {
                    for (CollectionElementAttributeFlusher<E, V> elementFlusher : this.elementFlushers) {
                        elementFlusher.flushEntity(context, entity, ownerView, view, value, null);
                    }
                } else {
                    for (CollectionElementAttributeFlusher<E, V> elementFlusher : this.elementFlushers) {
                        elementFlusher.flushQuery(context, null, null, null, ownerView, view, value, null);
                    }
                }
                this.replaceCollection(context, ownerView, view, entity, value, this.flushStrategy);
                return;
            }
            case COLLECTION_REPLACE_ONLY: {
                this.replaceCollection(context, ownerView, view, entity, value, this.flushStrategy);
                return;
            }
            case ELEMENT_ONLY: {
                this.mergeCollectionElements(context, ownerView, view, entity, value);
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported flush operation: " + (Object)((Object)this.flushOperation));
    }

    protected abstract void invokeCollectionAction(UpdateContext var1, Object var2, Object var3, V var4, Object var5, List<? extends A> var6);

    protected abstract V replaceWithRecordingCollection(UpdateContext var1, Object var2, V var3, List<? extends A> var4);

    @Override
    public boolean isPassThrough() {
        return !this.collectionUpdatable && !this.elementDescriptor.shouldFlushMutations();
    }

    @Override
    public String getElementIdAttributeName() {
        return null;
    }

    @Override
    public AttributeAccessor getViewAttributeAccessor() {
        return this.viewAttributeAccessor;
    }

    @Override
    public AttributeAccessor getEntityAttributeAccessor() {
        return this.entityAttributeAccessor;
    }

    @Override
    public boolean isOptimisticLockProtected() {
        return this.optimisticLockProtected;
    }

    @Override
    public boolean requiresFlushAfterPersist(V value) {
        return false;
    }

    @Override
    public boolean requiresDeferredFlush(V value) {
        return false;
    }

    protected final <X> X persistOrMerge(EntityManager em, X object) {
        return this.persistOrMerge(em, object, this.elementDescriptor);
    }

    protected final <X> X persistOrMerge(EntityManager em, X object, TypeDescriptor typeDescriptor) {
        if (object != null) {
            if (typeDescriptor.getBasicUserType().shouldPersist(object)) {
                if (typeDescriptor.shouldJpaPersist()) {
                    em.persist(object);
                }
            } else if (typeDescriptor.shouldJpaMerge()) {
                return (X)em.merge(object);
            }
        }
        return object;
    }

    protected final void persistIfNeeded(EntityManager em, Object object, BasicUserType<Object> basicUserType) {
        if (object != null && basicUserType.shouldPersist(object)) {
            em.persist(object);
        }
    }

    protected abstract boolean mergeCollectionElements(UpdateContext var1, Object var2, Object var3, E var4, V var5);

    protected abstract void replaceCollection(UpdateContext var1, Object var2, Object var3, E var4, V var5, FlushStrategy var6);

    protected abstract boolean isIndexed();

    protected abstract void addFlatViewElementFlushActions(UpdateContext var1, TypeDescriptor var2, List<A> var3, V var4);

    protected static Object getViewElement(UpdateContext context, TypeDescriptor typeDescriptor, Object jpaCollectionObject) {
        if (jpaCollectionObject != null && typeDescriptor.isSubview() && typeDescriptor.isIdentifiable()) {
            CompositeAttributeFlusher compositeFlusher = (CompositeAttributeFlusher)typeDescriptor.getViewToEntityMapper().getFullGraphNode();
            Object entityId = compositeFlusher.getIdFlusher().getEntityAttributeAccessor().getValue(jpaCollectionObject);
            return context.getEntityViewManager().getReference(compositeFlusher.getViewTypeClass(), compositeFlusher.createViewIdByEntityId(entityId));
        }
        return jpaCollectionObject;
    }

    protected static boolean identityContains(Collection<Object> addedElements, MutableStateTrackable element) {
        for (Object addedElement : addedElements) {
            if (addedElement != element) continue;
            return true;
        }
        return false;
    }

    protected final DirtyAttributeFlusher<X, E, V> getElementOnlyFlusher(UpdateContext context, V current) {
        ArrayList actions = new ArrayList();
        List<CollectionElementAttributeFlusher<E, V>> elementFlushers = this.getElementFlushers(context, current, actions);
        if (elementFlushers == null) {
            if (!actions.isEmpty()) {
                return this.partialFlusher(true, PluralFlushOperation.COLLECTION_REPLAY_ONLY, actions, Collections.EMPTY_LIST);
            }
            return this;
        }
        if (elementFlushers.isEmpty()) {
            if (!actions.isEmpty()) {
                return this.partialFlusher(true, PluralFlushOperation.COLLECTION_REPLAY_ONLY, actions, Collections.EMPTY_LIST);
            }
            return null;
        }
        if (this.elementDescriptor.shouldJpaPersist() && elementFlushers.get(0) instanceof PersistCollectionElementAttributeFlusher) {
            return this.partialFlusher(false, PluralFlushOperation.ELEMENT_ONLY, Collections.EMPTY_LIST, elementFlushers);
        }
        if (this.flushStrategy == FlushStrategy.ENTITY && !context.isForceEntity()) {
            return this.partialFlusher(true, PluralFlushOperation.ELEMENT_ONLY, Collections.EMPTY_LIST, elementFlushers);
        }
        return this.partialFlusher(false, PluralFlushOperation.ELEMENT_ONLY, Collections.EMPTY_LIST, elementFlushers);
    }

    protected final DirtyAttributeFlusher<X, E, V> getReplaceOrMergeOnlyFlusher(UpdateContext context, V initial, V current) {
        if (this.collectionEquals(initial, current)) {
            return null;
        }
        return this.partialFlusher(false, PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    protected final DirtyAttributeFlusher<X, E, V> getReplaceOrMergeAndElementFlusher(UpdateContext context, V initial, V current) {
        List<CollectionElementAttributeFlusher<E, V>> elementFlushers = this.getElementFlushers(context, current, null);
        if (elementFlushers == null) {
            return this;
        }
        if (elementFlushers.isEmpty()) {
            if (this.collectionEquals(initial, current)) {
                return null;
            }
            return this.getReplaceOrMergeOnlyFlusher(context, initial, current);
        }
        return this.partialFlusher(true, PluralFlushOperation.COLLECTION_REPLACE_AND_ELEMENT, Collections.EMPTY_LIST, elementFlushers);
    }

    protected final DirtyAttributeFlusher<X, E, V> getReplayOnlyFlusher(UpdateContext context, V initial, V current, List<? extends A> collectionActions) {
        if (collectionActions.isEmpty() && this.collectionEquals(initial, current)) {
            return null;
        }
        return this.partialFlusher(true, PluralFlushOperation.COLLECTION_REPLAY_ONLY, collectionActions, Collections.emptyList());
    }

    protected final DirtyAttributeFlusher<X, E, V> getReplayAndElementFlusher(UpdateContext context, V initial, V current, List<? extends A> collectionActions, List<CollectionElementAttributeFlusher<E, V>> elementFlushers) {
        if (elementFlushers.isEmpty()) {
            if (collectionActions.isEmpty() && this.collectionEquals(initial, current)) {
                return null;
            }
            return this.getReplayOnlyFlusher(context, initial, current, collectionActions);
        }
        return this.partialFlusher(true, PluralFlushOperation.COLLECTION_REPLAY_AND_ELEMENT, collectionActions, elementFlushers);
    }

    protected abstract List<CollectionElementAttributeFlusher<E, V>> getElementFlushers(UpdateContext var1, V var2, List<? extends A> var3);

    protected final boolean determineElementFlushers(UpdateContext context, TypeDescriptor typeDescriptor, List<CollectionElementAttributeFlusher<E, V>> elementFlushers, Iterable<?> values, List<? extends A> actions, V current) {
        if (typeDescriptor.shouldFlushMutations()) {
            if (typeDescriptor.isSubview()) {
                ViewToEntityMapper mapper = typeDescriptor.getViewToEntityMapper();
                if (typeDescriptor.isIdentifiable()) {
                    for (Object o : values) {
                        MutableStateTrackable element;
                        DirtyAttributeFlusher flusher;
                        if (!(o instanceof MutableStateTrackable) || (flusher = mapper.getNestedDirtyFlusher(context, element = (MutableStateTrackable)o, null)) == null) continue;
                        elementFlushers.add(new UpdateCollectionElementAttributeFlusher(flusher, element, this.optimisticLockProtected, mapper));
                    }
                } else if (typeDescriptor.supportsDirtyCheck() && !typeDescriptor.isIdentifiable() && this.isIndexed()) {
                    this.addFlatViewElementFlushActions(context, typeDescriptor, actions, current);
                } else {
                    for (Object o : values) {
                        MutableStateTrackable element;
                        DirtyAttributeFlusher flusher;
                        if (!(o instanceof MutableStateTrackable) || (flusher = mapper.getNestedDirtyFlusher(context, element = (MutableStateTrackable)o, null)) == null) continue;
                        return true;
                    }
                }
            } else if (typeDescriptor.isJpaEntity()) {
                for (Object element : values) {
                    if (typeDescriptor.getBasicUserType().shouldPersist(element) && typeDescriptor.shouldJpaPersist()) {
                        elementFlushers.add(this.createPersistFlusher(typeDescriptor, element));
                        continue;
                    }
                    if (element == null || !typeDescriptor.shouldJpaMerge()) continue;
                    elementFlushers.add(this.createMergeFlusher(typeDescriptor, element));
                }
            } else if (typeDescriptor.getBasicUserType().supportsDirtyChecking()) {
                for (Object element : values) {
                    String[] dirtyProperties = typeDescriptor.getBasicUserType().getDirtyProperties(element);
                    if (dirtyProperties == null) continue;
                    return true;
                }
            } else {
                if (this.canFlushSeparateCollectionOperations()) {
                    return true;
                }
                throw new IllegalArgumentException("Element flushers for non-identifiable type not determinable: " + typeDescriptor);
            }
        }
        return false;
    }

    protected abstract boolean canFlushSeparateCollectionOperations();

    protected abstract CollectionElementAttributeFlusher<E, V> createPersistFlusher(TypeDescriptor var1, Object var2);

    protected abstract CollectionElementAttributeFlusher<E, V> createMergeFlusher(TypeDescriptor var1, Object var2);

    protected abstract AbstractPluralAttributeFlusher<X, A, R, E, V> partialFlusher(boolean var1, PluralFlushOperation var2, List<? extends A> var3, List<CollectionElementAttributeFlusher<E, V>> var4);

    protected abstract boolean collectionEquals(V var1, V var2);

    protected abstract DirtyAttributeFlusher<X, E, V> getDirtyFlusherForRecordingCollection(UpdateContext var1, V var2, R var3, List<Runnable> var4);

    protected static final class EntityIdWithViewIdEqualityChecker
    implements EqualityChecker {
        private final ViewToEntityMapper mapper;
        private final ViewToEntityMapper idMapper;

        public EntityIdWithViewIdEqualityChecker(ViewToEntityMapper mapper) {
            this.mapper = mapper;
            DirtyAttributeFlusher<?, ?, ?> idFlusher = mapper.getIdFlusher();
            this.idMapper = idFlusher instanceof EmbeddableAttributeFlusher ? ((EmbeddableAttributeFlusher)idFlusher).getViewToEntityMapper() : null;
        }

        @Override
        public boolean isEqual(UpdateContext context, Object entity, Object view) {
            if (entity == null) {
                return view == null;
            }
            if (view == null) {
                return false;
            }
            Object idValue = this.mapper.getViewIdAccessor().getValue(view);
            if (this.idMapper == null) {
                return this.mapper.getEntityIdAccessor().getValue(entity).equals(idValue);
            }
            return this.mapper.getEntityIdAccessor().getValue(entity).equals(this.idMapper.applyToEntity(context, null, idValue));
        }
    }

    protected static final class EntityWithViewEqualityChecker
    implements EqualityChecker {
        private final ViewToEntityMapper mapper;

        public EntityWithViewEqualityChecker(ViewToEntityMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public boolean isEqual(UpdateContext context, Object entity, Object view) {
            if (entity == null) {
                return view == null;
            }
            if (view == null) {
                return false;
            }
            return entity.equals(this.mapper.applyToEntity(context, null, view));
        }
    }

    protected static final class DeepEqualityChecker
    implements EqualityChecker {
        private final BasicUserType<Object> type;

        public DeepEqualityChecker(BasicUserType<Object> type) {
            this.type = type;
        }

        @Override
        public boolean isEqual(UpdateContext context, Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            if (object2 == null) {
                return false;
            }
            return this.type.isDeepEqual(object1, object2);
        }
    }

    protected static final class EqualsEqualityChecker
    implements EqualityChecker {
        public static final EqualsEqualityChecker INSTANCE = new EqualsEqualityChecker();

        private EqualsEqualityChecker() {
        }

        @Override
        public boolean isEqual(UpdateContext context, Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            if (object2 == null) {
                return false;
            }
            return object1.equals(object2);
        }
    }

    protected static final class IdentityEqualityChecker
    implements EqualityChecker {
        private final BasicUserType<Object> type;

        public IdentityEqualityChecker(BasicUserType<Object> type) {
            this.type = type;
        }

        @Override
        public boolean isEqual(UpdateContext context, Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            if (object2 == null) {
                return false;
            }
            return this.type.isEqual(object1, object2);
        }
    }

    protected static interface EqualityChecker {
        public boolean isEqual(UpdateContext var1, Object var2, Object var3);
    }

    protected static enum PluralFlushOperation {
        ELEMENT_ONLY,
        COLLECTION_REPLACE_ONLY,
        COLLECTION_REPLACE_AND_ELEMENT,
        COLLECTION_REPLAY_ONLY,
        COLLECTION_REPLAY_AND_ELEMENT;

    }

    protected static enum EntryState {
        EXISTED{

            @Override
            EntryState onAdd() {
                return EXISTED;
            }

            @Override
            EntryState onRemove() {
                return REMOVED;
            }
        }
        ,
        ADDED{

            @Override
            EntryState onAdd() {
                return ADDED;
            }

            @Override
            EntryState onRemove() {
                return EXISTED;
            }
        }
        ,
        REMOVED{

            @Override
            EntryState onAdd() {
                return EXISTED;
            }

            @Override
            EntryState onRemove() {
                return REMOVED;
            }
        };


        abstract EntryState onAdd();

        abstract EntryState onRemove();
    }
}

