/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.InverseRemoveStrategy;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.InitialValueAttributeAccessor;
import com.blazebit.persistence.view.impl.entity.EntityLoaderFetchGraphNode;
import com.blazebit.persistence.view.impl.proxy.DirtyStateTrackable;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateQueryFactory;
import com.blazebit.persistence.view.impl.update.flush.BasicDirtyChecker;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.FetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.InverseCollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.InverseFlusher;
import com.blazebit.persistence.view.impl.update.flush.PostFlushDeleter;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;
import com.blazebit.persistence.view.impl.update.flush.UnmappedBasicAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedOwnerAwareDeleter;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;

public class BasicAttributeFlusher<E, V>
extends BasicDirtyChecker<V>
implements DirtyAttributeFlusher<BasicAttributeFlusher<E, V>, E, V> {
    protected final String parameterName;
    protected final AttributeAccessor entityAttributeAccessor;
    private final String attributeName;
    private final String mapping;
    private final boolean fetch;
    private final boolean supportsQueryFlush;
    private final boolean optimisticLockProtected;
    private final EntityLoaderFetchGraphNode<?> fetchGraphNode;
    private final boolean updatable;
    private final boolean cascadeDelete;
    private final boolean orphanRemoval;
    private final boolean viewOnlyDeleteCascaded;
    private final Map.Entry<AttributeAccessor, BasicAttributeFlusher>[] componentFlushers;
    private final String updateFragment;
    private final AttributeAccessor viewAttributeAccessor;
    private final InitialValueAttributeAccessor initialValueViewAttributeAccessor;
    private final UnmappedBasicAttributeCascadeDeleter deleter;
    private final InverseFlusher<E> inverseFlusher;
    private final InverseCollectionElementAttributeFlusher.Strategy inverseRemoveStrategy;
    private final V value;
    private final boolean update;
    private final BasicFlushOperation flushOperation;

    public BasicAttributeFlusher(String attributeName, String mapping, boolean supportsQueryFlush, boolean optimisticLockProtected, boolean updatable, boolean cascadeDelete, boolean orphanRemoval, boolean viewOnlyDeleteCascaded, Map.Entry<AttributeAccessor, BasicAttributeFlusher>[] componentFlushers, TypeDescriptor elementDescriptor, String updateFragment, String parameterName, AttributeAccessor entityAttributeAccessor, AttributeAccessor viewAttributeAccessor, UnmappedBasicAttributeCascadeDeleter deleter, InverseFlusher<E> inverseFlusher, InverseRemoveStrategy inverseRemoveStrategy) {
        super(elementDescriptor);
        this.attributeName = attributeName;
        this.mapping = mapping;
        this.optimisticLockProtected = optimisticLockProtected;
        this.cascadeDelete = cascadeDelete;
        this.orphanRemoval = orphanRemoval;
        this.viewOnlyDeleteCascaded = viewOnlyDeleteCascaded;
        this.fetch = elementDescriptor.shouldJpaMerge();
        this.supportsQueryFlush = supportsQueryFlush;
        this.fetchGraphNode = elementDescriptor.getEntityToEntityMapper() == null ? null : elementDescriptor.getEntityToEntityMapper().getFullGraphNode();
        this.updatable = updatable;
        this.componentFlushers = componentFlushers;
        this.updateFragment = updateFragment;
        this.parameterName = parameterName;
        this.entityAttributeAccessor = entityAttributeAccessor;
        this.viewAttributeAccessor = viewAttributeAccessor;
        this.initialValueViewAttributeAccessor = viewAttributeAccessor instanceof InitialValueAttributeAccessor ? (InitialValueAttributeAccessor)viewAttributeAccessor : null;
        this.deleter = deleter;
        this.inverseFlusher = inverseFlusher;
        this.inverseRemoveStrategy = InverseCollectionElementAttributeFlusher.Strategy.of(inverseRemoveStrategy);
        this.value = null;
        this.update = updatable;
        this.flushOperation = null;
    }

    private BasicAttributeFlusher(BasicAttributeFlusher<E, V> original, EntityLoaderFetchGraphNode<?> fetchGraphNode, V value, boolean update, BasicFlushOperation flushOperation) {
        super(original.elementDescriptor);
        this.attributeName = original.attributeName;
        this.mapping = original.mapping;
        this.fetch = fetchGraphNode != null;
        this.supportsQueryFlush = original.supportsQueryFlush;
        this.optimisticLockProtected = original.optimisticLockProtected;
        this.fetchGraphNode = fetchGraphNode;
        this.updatable = original.updatable;
        this.componentFlushers = original.componentFlushers;
        this.cascadeDelete = original.cascadeDelete;
        this.orphanRemoval = original.orphanRemoval;
        this.viewOnlyDeleteCascaded = original.viewOnlyDeleteCascaded;
        this.updateFragment = original.updateFragment;
        this.parameterName = original.parameterName;
        this.entityAttributeAccessor = original.entityAttributeAccessor;
        this.viewAttributeAccessor = original.viewAttributeAccessor;
        this.initialValueViewAttributeAccessor = original.initialValueViewAttributeAccessor;
        this.deleter = original.deleter;
        this.inverseFlusher = original.inverseFlusher;
        this.inverseRemoveStrategy = original.inverseRemoveStrategy;
        this.value = value;
        this.update = update;
        this.flushOperation = flushOperation;
    }

    @Override
    public V cloneDeep(Object view, V oldValue, V newValue) {
        if (this.updatable) {
            return (V)this.elementDescriptor.getBasicUserType().deepClone(newValue);
        }
        return oldValue;
    }

    @Override
    public Object getNewInitialValue(UpdateContext context, V clonedValue, V currentValue) {
        if (this.elementDescriptor.getBasicUserType().isMutable() && this.elementDescriptor.getBasicUserType().supportsDeepCloning() && !this.elementDescriptor.getBasicUserType().supportsDirtyTracking()) {
            return clonedValue;
        }
        return currentValue;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public String getMapping() {
        return this.mapping;
    }

    @Override
    public boolean appendUpdateQueryFragment(UpdateContext context, StringBuilder sb, String mappingPrefix, String parameterPrefix, String separator) {
        if ((this.updatable || this.isPassThrough()) && (this.flushOperation == null || this.update) && this.inverseFlusher == null && this.updateFragment != null) {
            if (this.componentFlushers == null) {
                if (mappingPrefix == null) {
                    sb.append(this.updateFragment);
                    sb.append(" = :");
                    sb.append(this.parameterName);
                } else {
                    sb.append(mappingPrefix).append(this.updateFragment);
                    sb.append(" = :");
                    sb.append(parameterPrefix).append(this.parameterName);
                }
            } else {
                this.componentFlushers[0].getValue().appendUpdateQueryFragment(context, sb, mappingPrefix, parameterPrefix, separator);
                for (int i = 1; i < this.componentFlushers.length; ++i) {
                    sb.append(separator);
                    this.componentFlushers[i].getValue().appendUpdateQueryFragment(context, sb, mappingPrefix, parameterPrefix, separator);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void appendFetchJoinQueryFragment(String base, StringBuilder sb) {
        if (this.fetch) {
            String newBase = base.replace('.', '_') + "_" + this.attributeName;
            sb.append(" LEFT JOIN FETCH ").append(base).append('.').append(this.mapping).append(" ").append(newBase);
            if (this.fetchGraphNode != null) {
                this.fetchGraphNode.appendFetchJoinQueryFragment(base, sb);
            }
        }
    }

    @Override
    public FetchGraphNode<?> mergeWith(List<BasicAttributeFlusher<E, V>> fetchGraphNodes) {
        for (int i = 0; i < fetchGraphNodes.size(); ++i) {
            BasicAttributeFlusher<E, V> flusher = fetchGraphNodes.get(i);
            if (flusher.fetchGraphNode == this.fetchGraphNode) continue;
            if (this.fetchGraphNode == null) {
                return flusher;
            }
            return this;
        }
        return this;
    }

    @Override
    public boolean supportsQueryFlush() {
        return this.supportsQueryFlush;
    }

    @Override
    public boolean loadForEntityFlush() {
        return true;
    }

    @Override
    public Query flushQuery(UpdateContext context, String parameterPrefix, UpdateQueryFactory queryFactory, Query query, Object ownerView, Object view, V value, UnmappedOwnerAwareDeleter ownerAwareDeleter) {
        Object oldValue;
        boolean doUpdate;
        V finalValue = this.flushOperation == null ? value : this.value;
        finalValue = this.getConvertedValue(finalValue);
        boolean bl = doUpdate = !(query == null || !this.updatable && !this.isPassThrough() || this.flushOperation != null && !this.update);
        if (doUpdate && this.orphanRemoval) {
            oldValue = this.initialValueViewAttributeAccessor.getInitialValue(view);
            if (!this.elementDescriptor.getBasicUserType().isEqual(oldValue, finalValue)) {
                this.deleter.remove(context, oldValue);
            }
        }
        if (doUpdate && this.inverseFlusher != null) {
            oldValue = this.initialValueViewAttributeAccessor.getInitialValue(view);
            if (oldValue != null && !this.elementDescriptor.getBasicUserType().isEqual(oldValue, finalValue)) {
                if (this.inverseRemoveStrategy == InverseCollectionElementAttributeFlusher.Strategy.SET_NULL) {
                    this.inverseFlusher.flushQuerySetElement(context, oldValue, view, null, null, null);
                } else {
                    this.inverseFlusher.removeElement(context, null, oldValue);
                }
            }
            if (finalValue != null) {
                this.inverseFlusher.flushQuerySetElement(context, finalValue, view, view, null, null);
            }
        }
        finalValue = this.persistOrMerge(context, null, view, finalValue);
        if (doUpdate && this.inverseFlusher == null) {
            if (this.componentFlushers == null) {
                String parameter = parameterPrefix == null ? this.parameterName : parameterPrefix + this.parameterName;
                query.setParameter(parameter, finalValue);
            } else {
                for (int i = 0; i < this.componentFlushers.length; ++i) {
                    Object val = this.componentFlushers[i].getKey().getValue(finalValue);
                    this.componentFlushers[i].getValue().flushQuery(context, parameterPrefix, queryFactory, query, ownerView, view, val, ownerAwareDeleter);
                }
            }
        }
        return query;
    }

    private V persistOrMerge(UpdateContext context, E entity, Object view, V value) {
        if (this.flushOperation != null) {
            if (this.flushOperation == BasicFlushOperation.PERSIST) {
                context.getEntityManager().persist(value);
            } else if (this.flushOperation == BasicFlushOperation.MERGE) {
                if (this.fetchGraphNode != null) {
                    Object id = this.fetchGraphNode.getEntityId(context, value);
                    Object object = this.fetchGraphNode.toEntity(context, null, id);
                }
                value = context.getEntityManager().merge(value);
                if (this.updatable && value != this.value) {
                    this.viewAttributeAccessor.setValue(view, value);
                }
            }
            return value;
        }
        if (this.elementDescriptor.shouldJpaPersistOrMerge()) {
            boolean shouldJpaPersistOrMerge;
            Object realValue;
            if (this.updatable) {
                realValue = value;
                shouldJpaPersistOrMerge = realValue != null;
            } else {
                realValue = this.viewAttributeAccessor.getValue(view);
                boolean bl = shouldJpaPersistOrMerge = !(realValue == null || value != realValue && !this.idEqual(value, realValue) || entity != null && !this.idEqual(this.entityAttributeAccessor.getValue(entity), realValue));
            }
            if (shouldJpaPersistOrMerge) {
                boolean shouldPersist = this.elementDescriptor.getBasicUserType().shouldPersist(realValue);
                if (shouldPersist) {
                    if (this.elementDescriptor.shouldJpaPersist()) {
                        context.getEntityManager().persist(realValue);
                    }
                    return realValue;
                }
                if (this.elementDescriptor.shouldJpaMerge()) {
                    if (this.fetchGraphNode != null) {
                        Object id = this.fetchGraphNode.getEntityId(context, realValue);
                        Object object = this.fetchGraphNode.toEntity(context, null, id);
                    }
                    Object newValue = context.getEntityManager().merge(realValue);
                    if (this.updatable && newValue != realValue) {
                        this.viewAttributeAccessor.setValue(view, newValue);
                    }
                    return (V)newValue;
                }
            }
        } else if (this.elementDescriptor.shouldFlushMutations()) {
            return (V)this.viewAttributeAccessor.getValue(view);
        }
        return value;
    }

    protected final V getConvertedValue(V value) {
        TypeConverter<Object, Object> converter = this.elementDescriptor.getConverter();
        if (converter != null) {
            return (V)converter.convertToUnderlyingType(value);
        }
        return value;
    }

    @Override
    public boolean flushEntity(UpdateContext context, E entity, Object ownerView, Object view, V value, Runnable postReplaceListener) {
        Object oldValue;
        boolean doUpdate;
        V finalValue = this.flushOperation == null ? value : this.value;
        finalValue = this.getConvertedValue(finalValue);
        boolean bl = doUpdate = this.updatable || this.isPassThrough();
        if (doUpdate && this.orphanRemoval) {
            oldValue = this.initialValueViewAttributeAccessor.getInitialValue(view);
            if (!this.elementDescriptor.getBasicUserType().isEqual(oldValue, finalValue)) {
                this.deleter.remove(context, oldValue);
            }
        }
        if (doUpdate && this.inverseFlusher != null) {
            oldValue = this.initialValueViewAttributeAccessor.getInitialValue(view);
            if (oldValue != null && !this.elementDescriptor.getBasicUserType().isEqual(oldValue, finalValue)) {
                if (this.inverseRemoveStrategy == InverseCollectionElementAttributeFlusher.Strategy.SET_NULL) {
                    this.inverseFlusher.flushEntitySetElement(context, oldValue, entity, null, null);
                } else {
                    this.inverseFlusher.removeElement(context, entity, oldValue);
                }
            }
            if (finalValue != null) {
                this.inverseFlusher.flushEntitySetElement(context, finalValue, entity, entity, null);
            }
        }
        boolean wasDirty = false;
        if (finalValue != null && this.elementDescriptor.shouldFlushMutations()) {
            if (this.elementDescriptor.supportsDirtyCheck()) {
                BasicUserType<Object> basicUserType = this.elementDescriptor.getBasicUserType();
                wasDirty = basicUserType.getDirtyProperties(finalValue) != null;
            } else if (this.elementDescriptor.shouldJpaPersistOrMerge()) {
                wasDirty = true;
            }
        }
        finalValue = this.persistOrMerge(context, entity, view, finalValue);
        if (doUpdate) {
            if (!(wasDirty || this.elementDescriptor.getBasicUserType() == null || !this.elementDescriptor.getBasicUserType().supportsDeepEqualChecking() && this.elementDescriptor.shouldFlushMutations())) {
                Object oldVal;
                Object object = oldVal = entity == null ? null : this.entityAttributeAccessor.getValue(entity);
                if (oldVal == null || finalValue == null) {
                    wasDirty = oldVal != finalValue;
                } else if (!this.elementDescriptor.getBasicUserType().supportsDeepEqualChecking()) {
                    wasDirty = !this.elementDescriptor.getBasicUserType().isEqual(oldVal, finalValue);
                } else {
                    boolean bl2 = wasDirty = !this.elementDescriptor.getBasicUserType().isDeepEqual(oldVal, finalValue);
                }
                if (wasDirty) {
                    this.entityAttributeAccessor.setValue(entity, finalValue);
                }
            } else {
                this.entityAttributeAccessor.setValue(entity, finalValue);
                wasDirty = true;
            }
        }
        return wasDirty;
    }

    public void flushEntityComponents(UpdateContext context, E entity, V value) {
        for (int i = 0; i < this.componentFlushers.length; ++i) {
            Object val = this.componentFlushers[i].getKey().getValue(value);
            this.componentFlushers[i].getValue().flushEntity(context, entity, null, null, val, null);
        }
    }

    @Override
    public List<PostFlushDeleter> remove(UpdateContext context, E entity, Object view, V value) {
        Object valueToDelete;
        if (this.cascadeDelete && (valueToDelete = view instanceof DirtyStateTrackable && this.viewAttributeAccessor instanceof InitialValueAttributeAccessor ? ((InitialValueAttributeAccessor)this.viewAttributeAccessor).getInitialValue(view) : value) != null) {
            this.deleter.remove(context, this.getConvertedValue(valueToDelete));
        }
        return Collections.emptyList();
    }

    @Override
    public void removeFromEntity(UpdateContext context, E entity) {
        Object valueToDelete;
        if (this.cascadeDelete && (valueToDelete = this.entityAttributeAccessor.getValue(entity)) != null) {
            this.deleter.remove(context, valueToDelete);
        }
    }

    @Override
    public List<PostFlushDeleter> removeByOwnerId(UpdateContext context, Object ownerId) {
        if (this.deleter != null) {
            this.deleter.removeByOwnerId(context, ownerId);
        }
        return Collections.emptyList();
    }

    @Override
    public void remove(UpdateContext context, Object id) {
        if (this.deleter != null) {
            this.deleter.removeById(context, id);
        }
    }

    @Override
    public boolean requiresDeleteCascadeAfterRemove() {
        return this.cascadeDelete;
    }

    @Override
    public boolean isViewOnlyDeleteCascaded() {
        return this.viewOnlyDeleteCascaded;
    }

    private boolean idEqual(Object entityValue, Object newValue) {
        if (entityValue == null || newValue == null) {
            return false;
        }
        return this.elementDescriptor.getBasicUserType().isEqual(entityValue, newValue);
    }

    @Override
    public boolean isPassThrough() {
        return !this.updatable && !this.elementDescriptor.shouldFlushMutations();
    }

    @Override
    public String getElementIdAttributeName() {
        return this.attributeName;
    }

    @Override
    public AttributeAccessor getViewAttributeAccessor() {
        return this.viewAttributeAccessor;
    }

    @Override
    public AttributeAccessor getEntityAttributeAccessor() {
        return this.entityAttributeAccessor;
    }

    @Override
    public boolean isOptimisticLockProtected() {
        return this.optimisticLockProtected;
    }

    @Override
    public boolean requiresFlushAfterPersist(V value) {
        if (this.inverseFlusher != null) {
            return this.flushOperation != null && this.update || this.flushOperation == null;
        }
        return false;
    }

    @Override
    public boolean requiresDeferredFlush(V value) {
        return false;
    }

    @Override
    public DirtyAttributeFlusher<BasicAttributeFlusher<E, V>, E, V> getDirtyFlusher(UpdateContext context, Object view, Object initial, Object current, List<Runnable> preFlushListeners) {
        if (this.updatable) {
            if (initial != current) {
                if (initial == null) {
                    return this.noFetchFlusher(current, true, true);
                }
                if (current == null) {
                    return new BasicAttributeFlusher<E, Object>(this, null, null, true, BasicFlushOperation.NONE);
                }
                if (this.elementDescriptor.shouldFlushMutations()) {
                    if (this.elementDescriptor.getBasicUserType().supportsDirtyChecking()) {
                        String[] dirtyProperties = this.elementDescriptor.getBasicUserType().getDirtyProperties(current);
                        if (dirtyProperties == null) {
                            if (this.elementDescriptor.getBasicUserType().isEqual(initial, current)) {
                                return null;
                            }
                            return new BasicAttributeFlusher<E, Object>(this, null, current, true, BasicFlushOperation.NONE);
                        }
                        if (dirtyProperties.length == 0) {
                            return this.fetchFlusher(this.fetchGraphNode, current, true, true);
                        }
                        return this.fetchFlusher(this.elementDescriptor.getEntityToEntityMapper().getFetchGraph(dirtyProperties), current, true, true);
                    }
                    if (this.elementDescriptor.getBasicUserType().isDeepEqual(initial, current)) {
                        return null;
                    }
                    return this.noFetchFlusher(current, true, true);
                }
                if (this.elementDescriptor.getBasicUserType().isEqual(initial, current)) {
                    return null;
                }
                return this;
            }
            if (initial == null) {
                return null;
            }
            if (this.elementDescriptor.shouldFlushMutations()) {
                return this.mutableFlusher(current, !this.elementDescriptor.isJpaEntity());
            }
            return null;
        }
        if (this.elementDescriptor.shouldFlushMutations()) {
            Object newValue = this.viewAttributeAccessor.getValue(view);
            if (current == newValue || this.elementDescriptor.isIdentifiable() && this.idEqual(initial, newValue)) {
                return this.mutableFlusher(current, false);
            }
            return null;
        }
        return null;
    }

    private DirtyAttributeFlusher<BasicAttributeFlusher<E, V>, E, V> noFetchFlusher(Object current, boolean flushAttribute, boolean update) {
        return this.fetchFlusher(null, current, flushAttribute, update);
    }

    private DirtyAttributeFlusher<BasicAttributeFlusher<E, V>, E, V> fetchFlusher(EntityLoaderFetchGraphNode<?> fetchGraphNode, Object current, boolean flushAttribute, boolean update) {
        if (this.elementDescriptor.shouldJpaPersistOrMerge()) {
            if (this.elementDescriptor.getBasicUserType().shouldPersist(current)) {
                if (this.elementDescriptor.isCascadePersist()) {
                    if (this.elementDescriptor.shouldJpaPersist()) {
                        return new BasicAttributeFlusher<E, Object>(this, fetchGraphNode, current, update, BasicFlushOperation.PERSIST);
                    }
                    return new BasicAttributeFlusher<E, Object>(this, fetchGraphNode, current, update, BasicFlushOperation.NONE);
                }
                if (flushAttribute) {
                    return new BasicAttributeFlusher<E, Object>(this, fetchGraphNode, current, update, BasicFlushOperation.NONE);
                }
                return null;
            }
            if (this.elementDescriptor.isCascadeUpdate()) {
                if (this.elementDescriptor.shouldJpaMerge()) {
                    return new BasicAttributeFlusher<E, Object>(this, fetchGraphNode, current, update, BasicFlushOperation.MERGE);
                }
                return new BasicAttributeFlusher<E, Object>(this, fetchGraphNode, current, update, BasicFlushOperation.NONE);
            }
            if (flushAttribute) {
                return new BasicAttributeFlusher<E, Object>(this, fetchGraphNode, current, update, BasicFlushOperation.NONE);
            }
            return null;
        }
        if (flushAttribute) {
            return new BasicAttributeFlusher<E, Object>(this, fetchGraphNode, current, update, BasicFlushOperation.NONE);
        }
        return null;
    }

    protected DirtyAttributeFlusher<BasicAttributeFlusher<E, V>, E, V> mutableFlusher(Object current, boolean update) {
        if (this.elementDescriptor.getBasicUserType().supportsDirtyChecking()) {
            String[] dirtyProperties = this.elementDescriptor.getBasicUserType().getDirtyProperties(current);
            if (dirtyProperties == null) {
                return null;
            }
            if (dirtyProperties.length == 0) {
                return this.fetchFlusher(this.fetchGraphNode, current, !this.elementDescriptor.isJpaEntity(), update);
            }
            return this.fetchFlusher(this.elementDescriptor.getEntityToEntityMapper().getFetchGraph(dirtyProperties), current, !this.elementDescriptor.isJpaEntity(), update);
        }
        return this.fetchFlusher(this.fetchGraphNode, current, !this.elementDescriptor.isJpaEntity(), update);
    }

    private static enum BasicFlushOperation {
        NONE,
        PERSIST,
        MERGE;

    }
}

