/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.DeleteCriteriaBuilder;
import com.blazebit.persistence.InsertCriteriaBuilder;
import com.blazebit.persistence.view.FlushStrategy;
import com.blazebit.persistence.view.InverseRemoveStrategy;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.InitialValueAttributeAccessor;
import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.CollectionAddAllAction;
import com.blazebit.persistence.view.impl.collection.CollectionClearAction;
import com.blazebit.persistence.view.impl.collection.CollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveAllAction;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.proxy.DirtyStateTrackable;
import com.blazebit.persistence.view.impl.proxy.MutableStateTrackable;
import com.blazebit.persistence.view.impl.update.EntityViewUpdater;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateQueryFactory;
import com.blazebit.persistence.view.impl.update.flush.AbstractPluralAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.AttributeFetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.CollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.CollectionElementFetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.CompositeAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.FetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.FusedCollectionActions;
import com.blazebit.persistence.view.impl.update.flush.FusedCollectionElementActions;
import com.blazebit.persistence.view.impl.update.flush.InverseCollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.InverseFlusher;
import com.blazebit.persistence.view.impl.update.flush.MergeCollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.PersistCollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.PostFlushCollectionElementByIdDeleter;
import com.blazebit.persistence.view.impl.update.flush.PostFlushCollectionElementDeleter;
import com.blazebit.persistence.view.impl.update.flush.PostFlushDeleter;
import com.blazebit.persistence.view.impl.update.flush.RecordingCollectionResetter;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;
import com.blazebit.persistence.view.impl.update.flush.UnmappedOwnerAwareDeleter;
import com.blazebit.persistence.view.impl.update.flush.UpdateCollectionElementAttributeFlusher;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;

public class CollectionAttributeFlusher<E, V extends Collection<?>>
extends AbstractPluralAttributeFlusher<CollectionAttributeFlusher<E, V>, CollectionAction<?>, RecordingCollection<?, ?>, E, V>
implements DirtyAttributeFlusher<CollectionAttributeFlusher<E, V>, E, V> {
    private static final Object REMOVED_MARKER = new Object();
    private final CollectionInstantiator collectionInstantiator;
    private final InverseFlusher<E> inverseFlusher;
    private final InverseCollectionElementAttributeFlusher.Strategy inverseRemoveStrategy;

    public CollectionAttributeFlusher(String attributeName, String mapping, Class<?> ownerEntityClass, String ownerIdAttributeName, String ownerMapping, DirtyAttributeFlusher<?, ?, ?> ownerIdFlusher, DirtyAttributeFlusher<?, ?, ?> elementFlusher, boolean supportsCollectionDml, FlushStrategy flushStrategy, AttributeAccessor entityAttributeAccessor, InitialValueAttributeAccessor viewAttributeAccessor, boolean optimisticLockProtected, boolean collectionUpdatable, boolean viewOnlyDeleteCascaded, boolean jpaProviderDeletesCollection, CollectionRemoveListener cascadeDeleteListener, CollectionRemoveListener removeListener, CollectionInstantiator collectionInstantiator, TypeDescriptor elementDescriptor, InverseFlusher<E> inverseFlusher, InverseRemoveStrategy inverseRemoveStrategy) {
        super(attributeName, mapping, collectionUpdatable || elementDescriptor.shouldFlushMutations(), ownerEntityClass, ownerIdAttributeName, ownerMapping, ownerIdFlusher, elementFlusher, supportsCollectionDml, flushStrategy, entityAttributeAccessor, viewAttributeAccessor, optimisticLockProtected, collectionUpdatable, viewOnlyDeleteCascaded, jpaProviderDeletesCollection, cascadeDeleteListener, removeListener, elementDescriptor);
        this.collectionInstantiator = collectionInstantiator;
        this.inverseFlusher = inverseFlusher;
        this.inverseRemoveStrategy = InverseCollectionElementAttributeFlusher.Strategy.of(inverseRemoveStrategy);
    }

    protected CollectionAttributeFlusher(CollectionAttributeFlusher original, boolean fetch) {
        this(original, fetch, (AbstractPluralAttributeFlusher.PluralFlushOperation)null, (List<CollectionAction<?>>)null, (List<CollectionElementAttributeFlusher<E, V>>)null);
    }

    protected CollectionAttributeFlusher(CollectionAttributeFlusher original, boolean fetch, AbstractPluralAttributeFlusher.PluralFlushOperation flushOperation, List<? extends CollectionAction<?>> collectionActions, List<CollectionElementAttributeFlusher<E, V>> elementFlushers) {
        super(original, fetch, flushOperation, collectionActions, elementFlushers);
        this.collectionInstantiator = original.collectionInstantiator;
        this.inverseFlusher = original.inverseFlusher;
        this.inverseRemoveStrategy = original.inverseRemoveStrategy;
    }

    protected V createCollection(int size) {
        return (V)this.collectionInstantiator.createCollection(size);
    }

    protected V createJpaCollection(int size) {
        return (V)this.collectionInstantiator.createJpaCollection(size);
    }

    @Override
    protected V createJpaCollection() {
        return (V)this.collectionInstantiator.createJpaCollection(0);
    }

    protected RecordingCollection<?, ?> createRecordingCollection(int size) {
        return this.collectionInstantiator.createRecordingCollection(size);
    }

    @Override
    public V cloneDeep(Object view, V oldValue, V newValue) {
        BasicUserType<Object> basicUserType;
        if (newValue == null || newValue.isEmpty()) {
            return newValue;
        }
        if (this.elementDescriptor.shouldFlushMutations() && !this.elementDescriptor.isSubview() && (basicUserType = this.elementDescriptor.getBasicUserType()) != null && !basicUserType.supportsDirtyChecking() && basicUserType.supportsDeepCloning()) {
            V newCollection;
            V collection = newCollection = this.createCollection(newValue.size());
            for (Object o : newValue) {
                collection.add((Object)basicUserType.deepClone(o));
            }
            return newCollection;
        }
        return newValue;
    }

    @Override
    public Object getNewInitialValue(UpdateContext context, V clonedValue, V currentValue) {
        BasicUserType<Object> basicUserType = this.elementDescriptor.getBasicUserType();
        if (this.elementDescriptor.shouldFlushMutations() && !this.elementDescriptor.isSubview() && basicUserType != null && basicUserType.supportsDeepCloning() && !basicUserType.supportsDirtyTracking()) {
            return clonedValue;
        }
        return currentValue;
    }

    @Override
    protected void invokeCollectionAction(UpdateContext context, Object ownerView, Object view, V targetCollection, Object value, List<? extends CollectionAction<?>> collectionActions) {
        ViewToEntityMapper viewToEntityMapper = this.elementDescriptor.getLoadOnlyViewToEntityMapper();
        if (this.mapping == null) {
            targetCollection = this.createCollection(0);
            for (CollectionAction<?> action : collectionActions) {
                action.doAction(targetCollection, context, viewToEntityMapper, this.removeListener);
            }
        } else if (this.flushStrategy == FlushStrategy.QUERY && !context.isForceEntity()) {
            this.flushCollectionOperations(context, ownerView, view, (Collection)value, null, collectionActions);
        } else {
            for (CollectionAction<?> action : collectionActions) {
                action.doAction(targetCollection, context, viewToEntityMapper, this.removeListener);
            }
        }
    }

    @Override
    protected V replaceWithRecordingCollection(UpdateContext context, Object view, V value, List<? extends CollectionAction<?>> actions) {
        RecordingCollection<?, ?> initialValue;
        RecordingCollection<?, ?> collection;
        List initialState = (List)this.viewAttributeAccessor.getInitialValue(view);
        List list = initialState = initialState != null ? initialState : Collections.emptyList();
        if (value instanceof RecordingCollection) {
            collection = (RecordingCollection<?, ?>)value;
        } else {
            if (value != null) {
                collection = this.createRecordingCollection(value.size());
                collection.getDelegate().addAll(value);
            } else {
                collection = this.createRecordingCollection(0);
            }
            this.viewAttributeAccessor.setValue(view, collection);
        }
        if (actions != null && !actions.isEmpty() && collection != initialState) {
            collection.initiateActionsAgainstState(actions, initialState);
            collection.resetActions(context);
        }
        if ((initialValue = this.cloneDeep(view, (V)null, (V)collection)) != value) {
            this.viewAttributeAccessor.setInitialValue(view, initialValue);
        }
        return (V)collection;
    }

    @Override
    public boolean supportsQueryFlush() {
        return this.inverseFlusher != null && this.inverseFlusher.supportsQueryFlush() || this.inverseFlusher == null && super.supportsQueryFlush();
    }

    @Override
    public boolean requiresFlushAfterPersist(V value) {
        if (this.inverseFlusher != null) {
            return this.elementFlushers != null || !(value instanceof RecordingCollection) || ((RecordingCollection)value).hasActions();
        }
        return false;
    }

    @Override
    public boolean requiresDeferredFlush(V value) {
        return false;
    }

    protected boolean executeActions(UpdateContext context, Collection<Object> jpaCollection, List<CollectionAction<Collection<?>>> actions, ViewToEntityMapper mapper) {
        for (CollectionAction<Collection<?>> action : actions) {
            action.doAction(jpaCollection, context, mapper, this.removeListener);
        }
        return !actions.isEmpty();
    }

    @Override
    public FetchGraphNode<?> mergeWith(List<CollectionAttributeFlusher<E, V>> fetchGraphNodes) {
        boolean newFetch;
        boolean fetchChanged = false;
        ArrayList<Object> nestedFlushers = new ArrayList<Object>(fetchGraphNodes.size());
        for (int i = 0; i < fetchGraphNodes.size(); ++i) {
            CollectionAttributeFlusher<E, V> node = fetchGraphNodes.get(i);
            fetchChanged |= this.fetch != node.fetch;
            FetchGraphNode<?> nestedGraphNode = node.getNestedGraphNode();
            if (nestedGraphNode == null) continue;
            if (nestedGraphNode instanceof CollectionElementFetchGraphNode) {
                CollectionElementFetchGraphNode collectionElementFetchGraphNode = (CollectionElementFetchGraphNode)nestedGraphNode;
                if (collectionElementFetchGraphNode.nestedGraphNode == null) continue;
                nestedFlushers.add(collectionElementFetchGraphNode.nestedGraphNode);
                continue;
            }
            nestedFlushers.add(nestedGraphNode);
        }
        boolean bl = newFetch = fetchChanged || this.fetch;
        if (nestedFlushers.isEmpty()) {
            if (fetchChanged && this.fetch != newFetch) {
                return new AttributeFetchGraphNode(this.attributeName, this.mapping, newFetch, fetchGraphNodes.get(0));
            }
            return this;
        }
        FetchGraphNode firstFlusher = (FetchGraphNode)nestedFlushers.get(0);
        FetchGraphNode<?> fetchGraphNode = firstFlusher.mergeWith(nestedFlushers);
        if (!fetchChanged && fetchGraphNode == firstFlusher) {
            return this;
        }
        return new AttributeFetchGraphNode(this.attributeName, this.mapping, newFetch, fetchGraphNode);
    }

    @Override
    public Query flushQuery(UpdateContext context, String parameterPrefix, UpdateQueryFactory queryFactory, Query query, Object ownerView, Object view, V current, UnmappedOwnerAwareDeleter ownerAwareDeleter) {
        if (!this.supportsQueryFlush()) {
            throw new UnsupportedOperationException("Query flush not supported for configuration!");
        }
        if (this.flushOperation != null) {
            if (!(current instanceof RecordingCollection)) {
                ArrayList actions = new ArrayList();
                actions.add(new CollectionClearAction());
                if (current != null && !current.isEmpty()) {
                    actions.add(new CollectionAddAllAction(current, this.collectionInstantiator.allowsDuplicates()));
                }
                current = this.replaceWithRecordingCollection(context, view, current, (List<? extends CollectionAction<?>>)actions);
            }
            this.invokeFlushOperation(context, ownerView, view, null, current);
        } else {
            boolean isRecording = current instanceof RecordingCollection;
            if (isRecording) {
                RecordingCollection recordingCollection = (RecordingCollection)current;
                if (this.inverseFlusher != null) {
                    Map<Object, Object> removed;
                    Map<Object, Object> added;
                    if (this.entityAttributeAccessor != null && recordingCollection.hasActions()) {
                        Map<Object, Object>[] addedAndRemoved = this.getAddedAndRemovedElementsForInverseFlusher(recordingCollection, context, null);
                        added = addedAndRemoved[0];
                        removed = addedAndRemoved[1];
                    } else {
                        added = removed = Collections.emptyMap();
                    }
                    this.visitInverseElementFlushersForActions(context, recordingCollection, added, removed, new ElementFlusherQueryExecutor(context, null, ownerView));
                } else {
                    if (this.entityAttributeAccessor == null) {
                        recordingCollection.resetActions(context);
                    }
                    List<Object> embeddables = null;
                    if (this.elementDescriptor.shouldFlushMutations()) {
                        if (this.elementDescriptor.shouldJpaPersistOrMerge()) {
                            this.mergeAndRequeue(context, recordingCollection, (Collection<Object>)recordingCollection.getDelegate());
                        } else if (this.elementDescriptor.isSubview() && (this.elementDescriptor.isIdentifiable() || this.isIndexed())) {
                            embeddables = this.flushCollectionViewElements(context, current);
                        }
                    }
                    if (this.entityAttributeAccessor != null && this.collectionUpdatable) {
                        Collection<Object> initial = (Collection)this.viewAttributeAccessor.getInitialValue(view);
                        if (initial instanceof RecordingCollection) {
                            initial = ((RecordingCollection)initial).getInitialVersion();
                        }
                        recordingCollection.resetActions(context);
                        if (initial == null) {
                            this.replaceCollection(context, ownerView, view, (E)null, current, FlushStrategy.QUERY);
                        } else {
                            this.flushCollectionOperations(context, ownerView, view, initial, current, embeddables, null);
                        }
                    }
                }
            } else {
                AbstractPluralAttributeFlusher.EqualityChecker equalityChecker = this.elementDescriptor.isSubview() ? AbstractPluralAttributeFlusher.EqualsEqualityChecker.INSTANCE : new AbstractPluralAttributeFlusher.IdentityEqualityChecker(this.elementDescriptor.getBasicUserType());
                Collection<Object> initial = (Collection)this.viewAttributeAccessor.getInitialValue(view);
                if (initial instanceof RecordingCollection) {
                    initial = ((RecordingCollection)initial).getInitialVersion();
                }
                List<CollectionAction<Collection<?>>> actions = initial == null || !this.elementDescriptor.supportsDeepEqualityCheck() || this.elementDescriptor.getBasicUserType() != null && !this.elementDescriptor.getBasicUserType().supportsDeepCloning() ? this.replaceActions(current) : this.determineCollectionActions(context, initial, current, equalityChecker);
                current = this.replaceWithRecordingCollection(context, view, current, (List<? extends CollectionAction<?>>)actions);
                List<Object> embeddables = null;
                if (this.elementDescriptor.shouldFlushMutations()) {
                    if (this.elementDescriptor.shouldJpaPersistOrMerge()) {
                        this.mergeAndRequeue(context, null, (Collection<Object>)current);
                    } else if (this.elementDescriptor.isSubview() && (this.elementDescriptor.isIdentifiable() || this.isIndexed())) {
                        embeddables = this.flushCollectionViewElements(context, current);
                    }
                }
                if (this.entityAttributeAccessor != null && this.collectionUpdatable) {
                    if (initial == null) {
                        this.replaceCollection(context, ownerView, view, (E)null, current, FlushStrategy.QUERY);
                    } else {
                        this.flushCollectionOperations(context, ownerView, view, initial, current, embeddables, null);
                    }
                }
            }
        }
        return query;
    }

    protected final DeleteCriteriaBuilder<?> createCollectionDeleter(UpdateContext context) {
        DeleteCriteriaBuilder deleteCb = context.getEntityViewManager().getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", this.getMapping());
        deleteCb.setWhereExpression(this.ownerIdWhereFragment);
        return deleteCb;
    }

    protected Collection<Object> appendRemoveSpecific(UpdateContext context, DeleteCriteriaBuilder<?> deleteCb, FusedCollectionActions fusedCollectionActions) {
        deleteCb.where("e." + this.getMapping()).in(fusedCollectionActions.getRemoved(context));
        return new HashSet<Object>(fusedCollectionActions.getRemoved());
    }

    protected List<Object> getEntityReferencesForCollectionOperation(UpdateContext context, Collection<Object> objects) {
        ArrayList<Object> entityReferences = new ArrayList<Object>(objects.size());
        ViewToEntityMapper loadOnlyViewToEntityMapper = this.elementDescriptor.getLoadOnlyViewToEntityMapper();
        for (Object o : objects) {
            if (o == null) continue;
            entityReferences.add(loadOnlyViewToEntityMapper.applyToEntity(context, null, o));
        }
        return entityReferences;
    }

    protected boolean deleteElements(UpdateContext context, Object ownerView, Object view, V initial, V value, boolean removeSpecific, FusedCollectionActions fusedCollectionActions) {
        DeleteCriteriaBuilder<?> deleteCb = null;
        boolean removedAll = true;
        Collection<Object> removedObjects = Collections.emptyList();
        if (fusedCollectionActions != null) {
            if (fusedCollectionActions.getRemoveCount() > 0) {
                if (this.inverseFlusher == null) {
                    deleteCb = this.createCollectionDeleter(context);
                }
                if (removeSpecific) {
                    if (this.inverseFlusher == null) {
                        String entityIdAttributeName = this.elementDescriptor.getAttributeIdAttributeName();
                        if (entityIdAttributeName != null) {
                            removedObjects = this.appendRemoveSpecific(context, deleteCb, fusedCollectionActions);
                            removedAll = false;
                            if (removedObjects.isEmpty()) {
                                deleteCb = null;
                            }
                        }
                    } else {
                        for (Object e : fusedCollectionActions.getRemoved(context)) {
                            this.inverseFlusher.flushQuerySetElement(context, e, ownerView, null, null, null);
                        }
                    }
                } else if (this.inverseFlusher != null) {
                    for (Object e : value) {
                        this.inverseFlusher.flushQuerySetElement(context, e, ownerView, null, null, null);
                    }
                    return true;
                }
            } else {
                removedAll = false;
            }
        } else if (this.inverseFlusher != null) {
            if (this.inverseRemoveStrategy == InverseCollectionElementAttributeFlusher.Strategy.REMOVE) {
                if (initial != null && initial.isEmpty()) {
                    this.inverseFlusher.removeByOwnerIdOnly(context, ((EntityViewProxy)ownerView).$$_getId());
                    return true;
                }
                Collection<Object> currentReferences = this.inverseFlusher.loadByOwnerId(context, ((EntityViewProxy)ownerView).$$_getId());
                Iterator<Object> iterator = currentReferences.iterator();
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    if (!value.contains(element)) continue;
                    iterator.remove();
                }
                if (!currentReferences.isEmpty()) {
                    this.inverseFlusher.removeElements(context, currentReferences);
                }
                return false;
            }
            if (this.inverseRemoveStrategy == InverseCollectionElementAttributeFlusher.Strategy.SET_NULL) {
                for (Object e : value) {
                    this.inverseFlusher.flushQuerySetElement(context, e, ownerView, null, null, null);
                }
                return true;
            }
        } else {
            deleteCb = this.createCollectionDeleter(context);
        }
        if (deleteCb != null) {
            Query deleteQuery = deleteCb.getQuery();
            this.ownerIdFlusher.flushQuery(context, null, null, deleteQuery, ownerView, view, this.ownerIdFlusher.getViewAttributeAccessor().getValue(ownerView), null);
            deleteQuery.executeUpdate();
            if (removedAll) {
                return true;
            }
            if (this.removeListener != null) {
                for (Object removedObject : removedObjects) {
                    this.removeListener.onCollectionRemove(context, removedObject);
                }
            }
        }
        return false;
    }

    protected void addElements(UpdateContext context, Object ownerView, Object view, Collection<Object> removedAllObjects, boolean flushAtOnce, boolean removedAllWithoutCollectionActions, V value, List<Object> embeddablesToUpdate, FusedCollectionActions fusedCollectionActions) {
        Object elementsToAdd;
        if (fusedCollectionActions == null || !removedAllObjects.isEmpty()) {
            elementsToAdd = this.elementDescriptor.getViewToEntityMapper() == null || this.inverseFlusher != null ? value : this.getEntityReferencesForCollectionOperation(context, (Collection<Object>)value);
            removedAllObjects.removeAll((Collection<?>)value);
        } else {
            removedAllObjects.removeAll(fusedCollectionActions.getAdded());
            elementsToAdd = this.inverseFlusher == null ? fusedCollectionActions.getAdded(context) : fusedCollectionActions.getAdded();
        }
        if (elementsToAdd == null || elementsToAdd.isEmpty() || elementsToAdd.size() == 1 && elementsToAdd.iterator().next() == null) {
            return;
        }
        String mapping = this.getMapping();
        if (this.inverseFlusher == null) {
            boolean checkTransient;
            InsertCriteriaBuilder insertCb = context.getEntityViewManager().getCriteriaBuilderFactory().insertCollection(context.getEntityManager(), this.ownerEntityClass, mapping);
            String entityIdAttributeName = this.elementDescriptor.getEntityIdAttributeName();
            String attributeIdAttributeName = this.elementDescriptor.getAttributeIdAttributeName();
            if (flushAtOnce) {
                if (entityIdAttributeName == null) {
                    insertCb.fromValues(this.ownerEntityClass, mapping, "val", (Collection)elementsToAdd);
                } else if (attributeIdAttributeName.equals(entityIdAttributeName)) {
                    insertCb.fromIdentifiableValues(this.elementDescriptor.getJpaType(), "val", (Collection)elementsToAdd);
                } else {
                    insertCb.fromIdentifiableValues(this.elementDescriptor.getJpaType(), attributeIdAttributeName, "val", (Collection)elementsToAdd);
                }
            } else if (entityIdAttributeName == null) {
                insertCb.fromValues(this.ownerEntityClass, mapping, "val", 1);
            } else if (attributeIdAttributeName.equals(entityIdAttributeName)) {
                insertCb.fromIdentifiableValues(this.elementDescriptor.getJpaType(), "val", 1);
            } else {
                insertCb.fromIdentifiableValues(this.elementDescriptor.getJpaType(), attributeIdAttributeName, "val", 1);
            }
            for (int i = 0; i < this.ownerIdBindFragments.length; i += 2) {
                insertCb.bind(this.ownerIdBindFragments[i]).select(this.ownerIdBindFragments[i + 1]);
            }
            insertCb.bind(mapping).select("val");
            Query insertQuery = insertCb.getQuery();
            this.ownerIdFlusher.flushQuery(context, null, null, insertQuery, ownerView, view, this.ownerIdFlusher.getViewAttributeAccessor().getValue(ownerView), null);
            boolean bl = checkTransient = this.elementDescriptor.isJpaEntity() && !this.elementDescriptor.shouldJpaPersist();
            if (flushAtOnce) {
                if (checkTransient) {
                    Iterator iterator = elementsToAdd.iterator();
                    while (iterator.hasNext()) {
                        Object o = iterator.next();
                        if (!this.elementDescriptor.getBasicUserType().shouldPersist(o)) continue;
                        throw new IllegalStateException("Collection " + this.attributeName + " references an unsaved transient instance - save the transient instance before flushing: " + o);
                    }
                }
                insertQuery.executeUpdate();
            } else {
                Object[] singletonArray = new Object[1];
                List<Object> singletonList = Arrays.asList(singletonArray);
                Iterator iterator = elementsToAdd.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (o == null) continue;
                    if (checkTransient && this.elementDescriptor.getBasicUserType().shouldPersist(o)) {
                        throw new IllegalStateException("Collection " + this.attributeName + " references an unsaved transient instance - save the transient instance before flushing: " + o);
                    }
                    singletonArray[0] = o;
                    insertQuery.setParameter("val", singletonList);
                    insertQuery.executeUpdate();
                }
            }
        } else if (removedAllWithoutCollectionActions) {
            DirtyAttributeFlusher fullFlusher = (DirtyAttributeFlusher)this.elementDescriptor.getViewToEntityMapper().getFullGraphNode();
            Object ownerEntity = context.getEntityManager().getReference(this.ownerEntityClass, this.ownerIdFlusher.getViewAttributeAccessor().getValue(ownerView));
            Iterator iterator = elementsToAdd.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                this.inverseFlusher.flushEntitySetElement(context, o, null, ownerEntity, fullFlusher);
            }
        } else {
            Iterator iterator = elementsToAdd.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                this.inverseFlusher.flushQuerySetElement(context, o, null, ownerView, null, null);
            }
        }
    }

    @Override
    protected boolean canFlushSeparateCollectionOperations() {
        return !this.collectionInstantiator.allowsDuplicates();
    }

    @Override
    protected boolean isIndexed() {
        return false;
    }

    @Override
    protected void addFlatViewElementFlushActions(UpdateContext context, TypeDescriptor elementDescriptor, List<CollectionAction<?>> actions, V current) {
        throw new UnsupportedOperationException("Not indexed!");
    }

    protected void flushCollectionOperations(UpdateContext context, Object ownerView, Object view, V value, List<Object> embeddablesToUpdate, List<? extends CollectionAction<?>> collectionActions) {
        FusedCollectionActions fusedCollectionActions = null;
        if (this.canFlushSeparateCollectionOperations()) {
            if (collectionActions.isEmpty()) {
                if (embeddablesToUpdate != null) {
                    this.addElements(context, ownerView, view, Collections.emptyList(), true, false, value, embeddablesToUpdate, null);
                }
                return;
            }
            if (!(collectionActions.get(0) instanceof CollectionClearAction)) {
                fusedCollectionActions = this.getFusedOperations(collectionActions);
            }
        }
        this.flushCollectionOperations(context, ownerView, view, null, value, embeddablesToUpdate, fusedCollectionActions);
    }

    protected void flushCollectionOperations(UpdateContext context, Object ownerView, Object view, V initial, V value, List<Object> embeddablesToUpdate, FusedCollectionActions fusedCollectionActions) {
        List<Object> removedAllObjects;
        boolean removeSpecific = fusedCollectionActions != null && fusedCollectionActions.operationCount() < value.size() + 1;
        boolean removedAllWithoutCollectionActions = false;
        if (this.deleteElements(context, ownerView, view, initial, value, removeSpecific, fusedCollectionActions)) {
            if (fusedCollectionActions == null) {
                if (initial == null) {
                    removedAllObjects = Collections.emptyList();
                } else {
                    removedAllObjects = new ArrayList(initial);
                    removedAllWithoutCollectionActions = true;
                }
            } else {
                removedAllObjects = new ArrayList<Object>(fusedCollectionActions.getRemoved());
            }
        } else {
            removedAllObjects = Collections.emptyList();
        }
        this.addElements(context, ownerView, view, removedAllObjects, true, removedAllWithoutCollectionActions, value, embeddablesToUpdate, fusedCollectionActions);
        if (this.removeListener != null) {
            for (Object e : removedAllObjects) {
                this.removeListener.onCollectionRemove(context, e);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean flushEntity(UpdateContext context, E entity, Object ownerView, Object view, V value, Runnable postReplaceListener) {
        if (this.flushOperation != null) {
            if (!(value instanceof RecordingCollection)) {
                value = this.replaceWithRecordingCollection(context, view, value, (List<? extends CollectionAction<?>>)this.collectionActions);
            }
            this.invokeFlushOperation(context, ownerView, view, entity, value);
            return true;
        }
        if (this.collectionUpdatable) {
            boolean replace = false;
            boolean wasDirty = false;
            boolean isRecording = value instanceof RecordingCollection;
            List<CollectionAction<Collection<?>>> actions = null;
            if (isRecording) {
                RecordingCollection recordingCollection = (RecordingCollection)value;
                if (this.inverseFlusher != null) {
                    void var13_21;
                    Map<Object, Object> added;
                    if (recordingCollection.hasActions()) {
                        Map<Object, Object>[] addedAndRemoved = this.getAddedAndRemovedElementsForInverseFlusher(recordingCollection, context, null);
                        added = addedAndRemoved[0];
                        Map<Object, Object> map = addedAndRemoved[1];
                    } else {
                        Map map = Collections.emptyMap();
                        added = map;
                    }
                    if (this.flushStrategy == FlushStrategy.ENTITY || context.isForceEntity() || !this.inverseFlusher.supportsQueryFlush()) {
                        this.visitInverseElementFlushersForActions(context, recordingCollection, added, (Map<Object, Object>)var13_21, new ElementFlusherEntityExecutor(context, entity));
                        return true;
                    } else {
                        this.visitInverseElementFlushersForActions(context, recordingCollection, added, (Map<Object, Object>)var13_21, new ElementFlusherQueryExecutor(context, entity, null));
                    }
                    return true;
                }
                if (this.elementDescriptor.shouldFlushMutations()) {
                    if (this.elementDescriptor.shouldJpaPersistOrMerge()) {
                        wasDirty |= this.mergeAndRequeue(context, recordingCollection, (Collection<Object>)recordingCollection.getDelegate());
                    } else if (this.elementDescriptor.isSubview() && this.elementDescriptor.isIdentifiable()) {
                        this.flushCollectionViewElements(context, value);
                        wasDirty = true;
                    } else if (this.fetch && this.elementDescriptor.supportsDeepEqualityCheck() && this.entityAttributeAccessor != null) {
                        Collection jpaCollection = (Collection)this.entityAttributeAccessor.getValue(entity);
                        if (jpaCollection == null || jpaCollection.isEmpty()) {
                            replace = true;
                        } else {
                            actions = this.determineJpaCollectionActions(context, jpaCollection, value, this.elementEqualityChecker);
                            if (actions.size() <= value.size()) return this.executeActions(context, jpaCollection, actions, this.elementDescriptor.getLoadOnlyViewToEntityMapper());
                            replace = true;
                        }
                    } else {
                        replace = true;
                    }
                }
                if (!replace) {
                    if (this.entityAttributeAccessor == null) {
                        wasDirty |= !recordingCollection.resetActions(context).isEmpty();
                    } else {
                        Collection collection = (Collection)this.entityAttributeAccessor.getValue(entity);
                        if (collection == null) {
                            replace = true;
                        } else {
                            wasDirty |= recordingCollection.hasActions();
                            recordingCollection.replay(collection, context, this.elementDescriptor.getLoadOnlyViewToEntityMapper(), this.removeListener);
                        }
                    }
                }
            } else {
                actions = this.replaceActions(value);
                value = this.replaceWithRecordingCollection(context, view, value, (List<? extends CollectionAction<?>>)actions);
                if (this.fetch) {
                    if (this.inverseFlusher != null) {
                        void var13_24;
                        Map<Object, Object> added;
                        Collection jpaCollection = (Collection)this.entityAttributeAccessor.getValue(entity);
                        actions = this.determineJpaCollectionActions(context, jpaCollection, value, this.elementEqualityChecker);
                        if (!actions.isEmpty()) {
                            Map<Object, Object>[] addedAndRemoved = this.getAddedAndRemovedElementsForInverseFlusher(actions);
                            added = addedAndRemoved[0];
                            Map<Object, Object> map = addedAndRemoved[1];
                        } else {
                            Map map = Collections.emptyMap();
                            added = map;
                        }
                        if (this.flushStrategy == FlushStrategy.ENTITY || context.isForceEntity() || !this.inverseFlusher.supportsQueryFlush()) {
                            this.visitInverseElementFlushersForActions(context, (Iterable<?>)value, added, (Map<Object, Object>)var13_24, new ElementFlusherEntityExecutor(context, entity));
                            return true;
                        } else {
                            this.visitInverseElementFlushersForActions(context, (Iterable<?>)value, added, (Map<Object, Object>)var13_24, new ElementFlusherQueryExecutor(context, entity, null));
                        }
                        return true;
                    }
                    if (value == null || value.isEmpty()) {
                        replace = true;
                    } else if (this.elementDescriptor.shouldFlushMutations()) {
                        if (this.elementDescriptor.shouldJpaPersistOrMerge()) {
                            wasDirty |= this.mergeAndRequeue(context, null, (Collection<Object>)value);
                        } else if (this.elementDescriptor.isSubview()) {
                            if (this.elementDescriptor.isIdentifiable()) {
                                this.flushCollectionViewElements(context, value);
                                wasDirty = true;
                            }
                        } else if (!this.elementDescriptor.supportsDeepEqualityCheck()) {
                            replace = true;
                        }
                    }
                    if (!replace) {
                        if (this.entityAttributeAccessor == null) {
                            wasDirty = true;
                        } else {
                            Collection jpaCollection = (Collection)this.entityAttributeAccessor.getValue(entity);
                            if (jpaCollection == null || jpaCollection.isEmpty()) {
                                replace = true;
                            } else {
                                actions = this.determineJpaCollectionActions(context, jpaCollection, value, this.elementEqualityChecker);
                                if (actions.size() > value.size()) {
                                    replace = true;
                                } else {
                                    wasDirty |= this.executeActions(context, jpaCollection, actions, this.elementDescriptor.getLoadOnlyViewToEntityMapper());
                                }
                            }
                        }
                    }
                } else {
                    replace = true;
                }
            }
            if (!replace) return wasDirty;
            if (isRecording) {
                ((RecordingCollection)value).resetActions(context);
            }
            this.replaceCollection(context, ownerView, view, entity, value, FlushStrategy.ENTITY);
            return true;
        }
        if (this.elementDescriptor.shouldFlushMutations()) {
            if (value == null || value.isEmpty()) return false;
            return this.mergeCollectionElements(context, ownerView, view, entity, value);
        }
        this.replaceCollection(context, ownerView, view, entity, value, FlushStrategy.ENTITY);
        return true;
    }

    private Map<Object, Object> getViewsFromEntities(UpdateContext context, Collection<?> initialViews, Map<Object, Object> entityMap, AbstractPluralAttributeFlusher.EqualityChecker elementEqualityChecker) {
        if (entityMap.isEmpty()) {
            return entityMap;
        }
        CompositeAttributeFlusher compositeFlusher = (CompositeAttributeFlusher)this.elementDescriptor.getViewToEntityMapper().getFullGraphNode();
        Class<?> viewTypeClass = compositeFlusher.getViewTypeClass();
        HashMap<Object, Object> map = new HashMap<Object, Object>(entityMap.size());
        block0: for (Object entity : entityMap.values()) {
            Object initialView2;
            if (initialViews != null && !initialViews.isEmpty()) {
                for (Object initialView2 : initialViews) {
                    if (!elementEqualityChecker.isEqual(context, entity, initialView2)) continue;
                    map.put(initialView2, initialView2);
                    continue block0;
                }
            }
            Object entityId = context.getEntityViewManager().getEntityIdAccessor().getValue(entity);
            initialView2 = context.getEntityViewManager().getReference(viewTypeClass, compositeFlusher.createViewIdByEntityId(entityId));
            map.put(initialView2, initialView2);
        }
        return map;
    }

    protected List<CollectionAction<Collection<?>>> replaceActions(V value) {
        ArrayList actions = new ArrayList();
        actions.add(new CollectionClearAction());
        if (value != null && !value.isEmpty()) {
            actions.add(new CollectionAddAllAction(value, this.collectionInstantiator.allowsDuplicates()));
        }
        return actions;
    }

    @Override
    public List<PostFlushDeleter> remove(UpdateContext context, E entity, Object view, V value) {
        Collection<Object> collection = view instanceof DirtyStateTrackable ? (Collection)this.viewAttributeAccessor.getInitialValue(view) : value;
        if (collection != null && !collection.isEmpty()) {
            if (this.flushStrategy == FlushStrategy.QUERY && !context.isForceEntity() && !this.jpaProviderDeletesCollection) {
                this.removeByOwnerId(context, ((EntityViewProxy)view).$$_getId(), false);
            }
            if (this.cascadeDeleteListener != null) {
                ArrayList<Object> elements;
                if (collection instanceof RecordingCollection) {
                    RecordingCollection recordingCollection = (RecordingCollection)collection;
                    Set set = recordingCollection.getRemovedElements();
                    Set addedElements = recordingCollection.getAddedElements();
                    elements = new ArrayList(collection.size() + set.size());
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Object element = iterator.next();
                        if (addedElements.contains(element)) continue;
                        elements.add(element);
                    }
                    elements.addAll(set);
                } else {
                    elements = new ArrayList<Object>(collection);
                }
                if (elements.size() > 0) {
                    if (this.inverseFlusher == null) {
                        return Collections.singletonList(new PostFlushCollectionElementDeleter(this.cascadeDeleteListener, elements));
                    }
                    for (Object e : elements) {
                        this.cascadeDeleteListener.onCollectionRemove(context, e);
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<PostFlushDeleter> removeByOwnerId(UpdateContext context, Object id) {
        return this.removeByOwnerId(context, id, true);
    }

    private List<PostFlushDeleter> removeByOwnerId(UpdateContext context, Object ownerId, boolean cascade) {
        EntityViewManagerImpl evm = context.getEntityViewManager();
        String mapping = this.getMapping();
        if (cascade) {
            if (this.inverseFlusher == null) {
                ArrayList<Object> elementIds;
                if (evm.getDbmsDialect().supportsReturningColumns()) {
                    List tuples = ((DeleteCriteriaBuilder)evm.getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", mapping).where(this.ownerIdAttributeName).eq(ownerId)).executeWithReturning(new String[]{mapping + "." + this.elementDescriptor.getAttributeIdAttributeName()}).getResultList();
                    elementIds = new ArrayList<Object>(tuples.size());
                    for (Tuple tuple : tuples) {
                        elementIds.add(tuple.get(0));
                    }
                } else {
                    elementIds = ((CriteriaBuilder)((CriteriaBuilder)evm.getCriteriaBuilderFactory().create(context.getEntityManager(), this.ownerEntityClass, "e").where(this.ownerIdAttributeName).eq(ownerId)).select("e." + mapping + "." + this.elementDescriptor.getAttributeIdAttributeName())).getResultList();
                    if (!elementIds.isEmpty() && !this.jpaProviderDeletesCollection) {
                        DeleteCriteriaBuilder cb = evm.getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", mapping);
                        cb.where(this.ownerIdAttributeName).eq(ownerId);
                        cb.executeUpdate();
                    }
                }
                return Collections.singletonList(new PostFlushCollectionElementByIdDeleter(this.elementDescriptor.getElementToEntityMapper(), elementIds));
            }
            return this.inverseFlusher.removeByOwnerId(context, ownerId);
        }
        if (!this.jpaProviderDeletesCollection) {
            DeleteCriteriaBuilder cb = evm.getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", mapping);
            cb.where(this.ownerIdAttributeName).eq(ownerId);
            cb.executeUpdate();
        }
        return Collections.emptyList();
    }

    @Override
    public void remove(UpdateContext context, Object id) {
        throw new UnsupportedOperationException("Unsupported!");
    }

    @Override
    public void removeFromEntity(UpdateContext context, E entity) {
        Collection value = (Collection)this.entityAttributeAccessor.getValue(entity);
        if (value != null) {
            if (this.cascadeDeleteListener != null) {
                if (!value.isEmpty()) {
                    for (Object element : value) {
                        this.cascadeDeleteListener.onEntityCollectionRemove(context, element);
                    }
                    this.entityAttributeAccessor.setValue(entity, null);
                }
            } else {
                value.clear();
            }
        }
    }

    @Override
    public boolean requiresDeleteCascadeAfterRemove() {
        return false;
    }

    @Override
    public boolean isViewOnlyDeleteCascaded() {
        return this.viewOnlyDeleteCascaded;
    }

    @Override
    protected boolean mergeCollectionElements(UpdateContext context, Object ownerView, Object view, E entity, V value) {
        if (this.elementFlushers != null) {
            if (this.flushStrategy == FlushStrategy.ENTITY || context.isForceEntity() || !this.supportsQueryFlush()) {
                for (CollectionElementAttributeFlusher elementFlusher : this.elementFlushers) {
                    elementFlusher.flushEntity(context, entity, ownerView, view, value, null);
                }
            } else {
                for (CollectionElementAttributeFlusher elementFlusher : this.elementFlushers) {
                    elementFlusher.flushQuery(context, null, null, null, ownerView, view, value, null);
                }
            }
            return !this.elementFlushers.isEmpty();
        }
        boolean needsRequeuing = this.elementDescriptor.shouldJpaMerge();
        if (needsRequeuing) {
            if (value instanceof RecordingCollection) {
                return this.mergeAndRequeue(context, (RecordingCollection)value, (Collection<Object>)((RecordingCollection)value).getDelegate());
            }
            return this.mergeAndRequeue(context, null, (Collection<Object>)value);
        }
        if (this.elementDescriptor.isSubview()) {
            this.flushCollectionViewElements(context, value);
            return true;
        }
        if (this.elementDescriptor.shouldJpaPersist()) {
            EntityManager em = context.getEntityManager();
            BasicUserType<Object> basicUserType = this.elementDescriptor.getBasicUserType();
            for (Object o : value) {
                this.persistIfNeeded(em, o, basicUserType);
            }
            return true;
        }
        return false;
    }

    protected boolean mergeAndRequeue(UpdateContext context, RecordingCollection recordingCollection, Collection<Object> newCollection) {
        EntityManager em = context.getEntityManager();
        Collection queuedElements = null;
        Iterator<Object> iter = newCollection.iterator();
        while (iter.hasNext()) {
            Object merged;
            Object o = iter.next();
            if (o == (merged = this.persistOrMerge(em, o))) continue;
            if (queuedElements == null) {
                queuedElements = (Collection)this.createCollection(newCollection.size());
            }
            iter.remove();
            queuedElements.add(merged);
            if (recordingCollection == null) continue;
            recordingCollection.replaceActionElement(o, merged);
        }
        if (queuedElements != null) {
            newCollection.addAll(queuedElements);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> flushCollectionViewElements(UpdateContext context, V value) {
        ViewToEntityMapper viewToEntityMapper = this.elementDescriptor.getViewToEntityMapper();
        Iterator<Object> iter = this.getRecordingIterator(value);
        ArrayList<Object> embeddables = new ArrayList<Object>();
        try {
            while (iter.hasNext()) {
                Object elem = iter.next();
                Object embeddable = viewToEntityMapper.applyToEntity(context, null, elem);
                if (this.elementDescriptor.isIdentifiable() || this.mapping == null) continue;
                embeddables.add(embeddable);
            }
        }
        finally {
            this.resetRecordingIterator(value);
        }
        return embeddables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceCollection(UpdateContext context, Object ownerView, Object view, E entity, V value, FlushStrategy flushStrategy) {
        if (flushStrategy == FlushStrategy.QUERY) {
            List<Object> removedAllObjects;
            boolean removedAllWithoutCollectionActions = false;
            if (this.deleteElements(context, ownerView, view, null, value, false, null)) {
                removedAllObjects = Collections.emptyList();
                removedAllWithoutCollectionActions = true;
            } else {
                removedAllObjects = Collections.emptyList();
            }
            this.addElements(context, ownerView, view, removedAllObjects, true, removedAllWithoutCollectionActions, value, null, null);
            if (this.removeListener != null) {
                for (Object e : removedAllObjects) {
                    this.removeListener.onCollectionRemove(context, e);
                }
            }
        } else if (this.entityAttributeAccessor != null) {
            if (this.elementDescriptor.isSubview()) {
                V newCollection;
                if (value == null) {
                    newCollection = this.createJpaCollection(0);
                } else {
                    newCollection = this.createJpaCollection(value.size());
                    ViewToEntityMapper viewToEntityMapper = this.elementDescriptor.getViewToEntityMapper();
                    Iterator<Object> iter = this.getRecordingIterator(value);
                    try {
                        while (iter.hasNext()) {
                            Object object = iter.next();
                            newCollection.add((Object)viewToEntityMapper.applyToEntity(context, null, object));
                        }
                    }
                    finally {
                        this.resetRecordingIterator(value);
                    }
                }
                this.entityAttributeAccessor.setValue(entity, newCollection);
            } else {
                this.entityAttributeAccessor.setValue(entity, value);
            }
        }
    }

    private Iterator<Object> getRecordingIterator(V value) {
        if (value instanceof RecordingCollection && this.elementDescriptor.getViewToEntityMapper() != null) {
            return ((RecordingCollection)value).recordingIterator();
        }
        return value.iterator();
    }

    private void resetRecordingIterator(V value) {
        if (value instanceof RecordingCollection) {
            ((RecordingCollection)value).resetRecordingIterator();
        }
    }

    @Override
    public <X> DirtyChecker<X>[] getNestedCheckers(V current) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirtyChecker<E> getElementDirtyChecker(E element) {
        if (!this.elementDescriptor.shouldFlushMutations()) {
            return null;
        }
        if (this.elementDescriptor.isSubview()) {
            EntityViewUpdater updater = this.elementDescriptor.getViewToEntityMapper().getUpdater(element);
            if (updater == null) {
                throw new IllegalArgumentException("Found unexpected element in plural attribute '" + this.attributeName + "'. The object does not seem to be flushable: " + element);
            }
            return updater.getDirtyChecker();
        }
        if (this.elementDescriptor.isJpaEntity()) {
            return this.elementDescriptor.getEntityToEntityMapper().getDirtyChecker();
        }
        return this.elementDirtyChecker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DirtyChecker.DirtyKind getDirtyKind(V initial, V current) {
        if (current == null) {
            if (initial != null) return DirtyChecker.DirtyKind.UPDATED;
            return DirtyChecker.DirtyKind.NONE;
        }
        if (initial == null) {
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (initial == current) {
            if (!(current instanceof RecordingCollection)) return DirtyChecker.DirtyKind.NONE;
            RecordingCollection recordingCollection = (RecordingCollection)current;
            if (recordingCollection.hasActions()) {
                return DirtyChecker.DirtyKind.MUTATED;
            }
            if (!this.elementDescriptor.shouldFlushMutations()) return DirtyChecker.DirtyKind.NONE;
            if (!this.elementDescriptor.supportsDirtyCheck()) return DirtyChecker.DirtyKind.MUTATED;
            if (this.elementDescriptor.isSubview()) {
                if (!recordingCollection.$$_isDirty()) {
                    return DirtyChecker.DirtyKind.NONE;
                }
                ViewToEntityMapper mapper = this.elementDescriptor.getViewToEntityMapper();
                for (Object o : recordingCollection) {
                    if (!(o instanceof DirtyStateTrackable)) continue;
                    DirtyStateTrackable element = (DirtyStateTrackable)o;
                    if (mapper.getUpdater(o).getDirtyChecker().getDirtyKind(element, element) == DirtyChecker.DirtyKind.NONE) continue;
                    return DirtyChecker.DirtyKind.MUTATED;
                }
                return DirtyChecker.DirtyKind.NONE;
            } else {
                BasicUserType<Object> userType = this.elementDescriptor.getBasicUserType();
                for (Object o : recordingCollection) {
                    String[] dirtyProperties = userType.getDirtyProperties(o);
                    if (dirtyProperties == null) continue;
                    return DirtyChecker.DirtyKind.MUTATED;
                }
            }
            return DirtyChecker.DirtyKind.NONE;
        } else {
            if (initial.size() != current.size()) {
                return DirtyChecker.DirtyKind.MUTATED;
            }
            if (!this.elementDescriptor.shouldFlushMutations()) return this.collectionEquals(initial, current) ? DirtyChecker.DirtyKind.NONE : DirtyChecker.DirtyKind.MUTATED;
            if (this.elementDescriptor.supportsDirtyCheck()) {
                if (this.elementDescriptor.isSubview()) {
                    ViewToEntityMapper mapper = this.elementDescriptor.getViewToEntityMapper();
                    for (Object o : current) {
                        if (!initial.contains(o)) {
                            return DirtyChecker.DirtyKind.MUTATED;
                        }
                        if (!(o instanceof DirtyStateTrackable)) continue;
                        DirtyStateTrackable element = (DirtyStateTrackable)o;
                        if (mapper.getUpdater(o).getDirtyChecker().getDirtyKind(element, element) == DirtyChecker.DirtyKind.NONE) continue;
                        return DirtyChecker.DirtyKind.MUTATED;
                    }
                    return DirtyChecker.DirtyKind.NONE;
                } else {
                    BasicUserType<Object> userType = this.elementDescriptor.getBasicUserType();
                    for (Object o : current) {
                        if (!initial.contains(o)) {
                            return DirtyChecker.DirtyKind.MUTATED;
                        }
                        String[] dirtyProperties = userType.getDirtyProperties(o);
                        if (dirtyProperties == null) continue;
                        return DirtyChecker.DirtyKind.MUTATED;
                    }
                }
                return DirtyChecker.DirtyKind.NONE;
            } else {
                if (!this.elementDescriptor.getBasicUserType().supportsDeepCloning()) return DirtyChecker.DirtyKind.MUTATED;
                return this.collectionEquals(initial, current) ? DirtyChecker.DirtyKind.NONE : DirtyChecker.DirtyKind.MUTATED;
            }
        }
    }

    @Override
    public DirtyAttributeFlusher<CollectionAttributeFlusher<E, V>, E, V> getDirtyFlusher(UpdateContext context, Object view, Object initial, Object current, List<Runnable> preFlushListeners) {
        if (this.collectionUpdatable) {
            if (initial != current) {
                if (current == null || ((Collection)current).isEmpty()) {
                    if (initial == null || ((Collection)initial).isEmpty()) {
                        return null;
                    }
                    if (this.inverseFlusher != null) {
                        Map<Object, Object> added = Collections.emptyMap();
                        IdentityHashMap<Object, Object> removed = new IdentityHashMap<Object, Object>();
                        if (initial != null) {
                            for (Object o : (Collection)initial) {
                                removed.put(o, o);
                            }
                        }
                        List<CollectionElementAttributeFlusher<E, V>> elementFlushers = this.getInverseElementFlushersForActions(context, (Collection)current, added, removed);
                        return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.ELEMENT_ONLY, Collections.EMPTY_LIST, (List)elementFlushers);
                    }
                    return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
                }
                if (initial == null || ((Collection)initial).isEmpty()) {
                    RecordingCollectionResetter.add(context, preFlushListeners, current);
                    if (this.inverseFlusher != null) {
                        IdentityHashMap<Object, Object> added = new IdentityHashMap<Object, Object>();
                        Map<Object, Object> removed = Collections.emptyMap();
                        for (Object o : (Collection)current) {
                            added.put(o, o);
                        }
                        List<CollectionElementAttributeFlusher<E, V>> elementFlushers = this.getInverseElementFlushersForActions(context, (Collection)current, added, removed);
                        return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.ELEMENT_ONLY, Collections.EMPTY_LIST, (List)elementFlushers);
                    }
                    return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
                }
                if (initial instanceof RecordingCollection) {
                    initial = ((RecordingCollection)initial).getInitialVersion();
                }
                if (this.elementDescriptor.shouldFlushMutations()) {
                    if (this.elementDescriptor.supportsDirtyCheck()) {
                        return this.determineDirtyFlusherForNewCollection(context, (Collection)initial, (Collection)current, preFlushListeners);
                    }
                    if (this.elementDescriptor.supportsDeepEqualityCheck()) {
                        if (this.canFlushSeparateCollectionOperations() && this.elementDescriptor.getBasicUserType() != null && this.elementDescriptor.getBasicUserType().supportsDeepCloning()) {
                            AbstractPluralAttributeFlusher.EqualityChecker equalityChecker = this.elementDescriptor.isSubview() ? AbstractPluralAttributeFlusher.EqualsEqualityChecker.INSTANCE : new AbstractPluralAttributeFlusher.IdentityEqualityChecker(this.elementDescriptor.getBasicUserType());
                            List<CollectionAction<Collection<?>>> actions = initial == null ? this.replaceActions((Collection)current) : this.determineCollectionActions(context, (Collection)initial, (Collection)current, equalityChecker);
                            if (actions.isEmpty()) {
                                return null;
                            }
                            return this.partialFlusher(true, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_ONLY, actions, Collections.emptyList());
                        }
                        return this;
                    }
                    if (this.elementDescriptor.isJpaEntity()) {
                        AbstractPluralAttributeFlusher.EqualityChecker equalityChecker = this.elementDescriptor.isSubview() ? AbstractPluralAttributeFlusher.EqualsEqualityChecker.INSTANCE : new AbstractPluralAttributeFlusher.IdentityEqualityChecker(this.elementDescriptor.getBasicUserType());
                        List<CollectionAction<Collection<?>>> actions = initial == null ? this.replaceActions((Collection)current) : this.determineCollectionActions(context, (Collection)initial, (Collection)current, equalityChecker);
                        return this.partialFlusher(true, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_AND_ELEMENT, actions, this.getElementFlushers(context, (V)((Collection)current), (List<? extends CollectionAction<?>>)actions));
                    }
                    RecordingCollectionResetter.add(context, preFlushListeners, current);
                    return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
                }
                return this.determineDirtyFlusherForNewCollection(context, (Collection)initial, (Collection)current, preFlushListeners);
            }
            if (initial == null || !(initial instanceof RecordingCollection) && ((Collection)initial).isEmpty()) {
                return null;
            }
            if (current instanceof RecordingCollection && !((RecordingCollection)current).hasActions() && ((RecordingCollection)current).isEmpty()) {
                return null;
            }
            if (this.elementDescriptor.shouldFlushMutations()) {
                if (this.elementDescriptor.supportsDirtyCheck()) {
                    if (current instanceof RecordingCollection) {
                        return this.getDirtyFlusherForRecordingCollection(context, (V)((Collection)initial), (RecordingCollection)current, preFlushListeners);
                    }
                    return this;
                }
                if (this.elementDescriptor.supportsDeepEqualityCheck() || this.elementDescriptor.isJpaEntity()) {
                    if (current instanceof RecordingCollection) {
                        List<? extends CollectionAction<?>> actions = RecordingCollectionResetter.add(context, preFlushListeners, current);
                        if (this.elementDescriptor.isIdentifiable()) {
                            return this.partialFlusher(true, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_AND_ELEMENT, (List)actions, this.getElementFlushers(context, (V)((Collection)current), actions));
                        }
                    }
                    return this;
                }
                RecordingCollectionResetter.add(context, preFlushListeners, current);
                return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
            }
            if (current instanceof RecordingCollection) {
                return this.getDirtyFlusherForRecordingCollection(context, (V)((Collection)initial), (RecordingCollection)current, preFlushListeners);
            }
            return this;
        }
        if (this.elementDescriptor.shouldFlushMutations()) {
            if (initial != current) {
                return null;
            }
            if (!this.elementDescriptor.isIdentifiable()) {
                return this;
            }
            return this.getElementOnlyFlusher(context, (Collection)current);
        }
        return null;
    }

    @Override
    protected CollectionElementAttributeFlusher<E, V> createPersistFlusher(TypeDescriptor typeDescriptor, Object element) {
        return new PersistCollectionElementAttributeFlusher(element, this.optimisticLockProtected);
    }

    @Override
    protected CollectionElementAttributeFlusher<E, V> createMergeFlusher(TypeDescriptor typeDescriptor, Object element) {
        return new MergeCollectionElementAttributeFlusher(element, this.optimisticLockProtected);
    }

    protected DirtyAttributeFlusher<CollectionAttributeFlusher<E, V>, E, V> determineDirtyFlusherForNewCollection(UpdateContext context, V initial, V current, List<Runnable> preFlushListeners) {
        AbstractPluralAttributeFlusher.EqualityChecker equalityChecker = this.elementDescriptor.isSubview() ? AbstractPluralAttributeFlusher.EqualsEqualityChecker.INSTANCE : new AbstractPluralAttributeFlusher.IdentityEqualityChecker(this.elementDescriptor.getBasicUserType());
        List collectionActions = this.determineCollectionActions(context, initial, current, equalityChecker);
        if (collectionActions.size() == 0) {
            List<CollectionElementAttributeFlusher<E, V>> elementFlushers = this.getElementFlushers(context, current, (List<? extends CollectionAction<?>>)collectionActions);
            RecordingCollectionResetter.add(context, preFlushListeners, current);
            if (elementFlushers == null) {
                return this;
            }
            return this.getReplayAndElementFlusher(context, initial, current, collectionActions, elementFlushers);
        }
        if (this.inverseFlusher != null) {
            Map<Object, Object>[] addedAndRemoved = current instanceof RecordingCollection ? this.getAddedAndRemovedElementsForInverseFlusher((RecordingCollection)current, context, preFlushListeners) : this.getAddedAndRemovedElementsForInverseFlusher((Collection<?>)current, collectionActions);
            Map<Object, Object> added = addedAndRemoved[0];
            Map<Object, Object> removed = addedAndRemoved[1];
            List<CollectionElementAttributeFlusher<E, V>> elementFlushers = this.getInverseElementFlushersForActions(context, (Iterable<?>)current, added, removed);
            return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.ELEMENT_ONLY, Collections.EMPTY_LIST, (List)elementFlushers);
        }
        if (collectionActions.size() > current.size()) {
            RecordingCollectionResetter.add(context, preFlushListeners, current);
            if (this.elementDescriptor.shouldFlushMutations()) {
                return this.getReplaceOrMergeAndElementFlusher(context, initial, current);
            }
            return this.getReplaceOrMergeOnlyFlusher(context, initial, current);
        }
        if (current instanceof RecordingCollection) {
            RecordingCollection recordingCollection = (RecordingCollection)current;
            recordingCollection.initiateActionsAgainstState(collectionActions, initial);
        }
        if (this.elementDescriptor.shouldFlushMutations()) {
            List<CollectionElementAttributeFlusher<E, V>> elementFlushers = this.getElementFlushers(context, current, (List<? extends CollectionAction<?>>)collectionActions);
            if (elementFlushers == null) {
                return this;
            }
            RecordingCollectionResetter.add(context, preFlushListeners, current);
            return this.getReplayAndElementFlusher(context, initial, current, collectionActions, elementFlushers);
        }
        RecordingCollectionResetter.add(context, preFlushListeners, current);
        return this.getReplayOnlyFlusher(context, initial, current, collectionActions);
    }

    protected List<CollectionAction<Collection<?>>> determineJpaCollectionActions(UpdateContext context, V initial, V current, AbstractPluralAttributeFlusher.EqualityChecker equalityChecker) {
        ArrayList actions = new ArrayList();
        Object[] objectsToAdd = current.toArray();
        CollectionRemoveAllAction removeAllAction = new CollectionRemoveAllAction(0, this.collectionInstantiator.allowsDuplicates());
        int addSize = objectsToAdd.length;
        block0: for (Object initialObject : initial) {
            for (int i = 0; i < objectsToAdd.length; ++i) {
                Object currentObject = objectsToAdd[i];
                if (currentObject == REMOVED_MARKER || !equalityChecker.isEqual(context, initialObject, currentObject)) continue;
                objectsToAdd[i] = REMOVED_MARKER;
                --addSize;
                continue block0;
            }
            removeAllAction.add(CollectionAttributeFlusher.getViewElement(context, this.elementDescriptor, initialObject));
        }
        if (!removeAllAction.isEmpty()) {
            actions.add(removeAllAction);
        }
        this.addAddAction(actions, objectsToAdd, addSize);
        return actions;
    }

    protected final List<CollectionAction<Collection<?>>> determineCollectionActionsForSubview(UpdateContext context, V initial, V current) {
        ArrayList actions = new ArrayList();
        Object[] objectsToAdd = current.toArray();
        int addSize = objectsToAdd.length;
        if (initial != null && !initial.isEmpty()) {
            AttributeAccessor subviewIdAccessor = this.elementDescriptor.getViewToEntityMapper().getViewIdAccessor();
            CollectionRemoveAllAction removeAllAction = new CollectionRemoveAllAction(0, this.collectionInstantiator.allowsDuplicates());
            block0: for (Object initialObject : initial) {
                Object initialViewId = subviewIdAccessor.getValue(initialObject);
                for (int i = 0; i < objectsToAdd.length; ++i) {
                    Object currentViewId;
                    Object currentObject = objectsToAdd[i];
                    if (currentObject == REMOVED_MARKER || !initialViewId.equals(currentViewId = subviewIdAccessor.getValue(currentObject))) continue;
                    objectsToAdd[i] = REMOVED_MARKER;
                    --addSize;
                    continue block0;
                }
                removeAllAction.add(initialObject);
            }
            if (!removeAllAction.isEmpty()) {
                actions.add(removeAllAction);
            }
        }
        this.addAddAction(actions, objectsToAdd, addSize);
        return actions;
    }

    protected final List<CollectionAction<Collection<?>>> determineCollectionActionsForNonSubview(UpdateContext context, V initial, V current, AbstractPluralAttributeFlusher.EqualityChecker equalityChecker) {
        ArrayList actions = new ArrayList();
        Object[] objectsToAdd = current.toArray();
        int addSize = objectsToAdd.length;
        if (initial != null && !initial.isEmpty()) {
            CollectionRemoveAllAction removeAllAction = new CollectionRemoveAllAction(0, this.collectionInstantiator.allowsDuplicates());
            block0: for (Object initialObject : initial) {
                for (int i = 0; i < objectsToAdd.length; ++i) {
                    Object currentObject = objectsToAdd[i];
                    if (currentObject == REMOVED_MARKER || !equalityChecker.isEqual(context, initialObject, currentObject)) continue;
                    objectsToAdd[i] = REMOVED_MARKER;
                    --addSize;
                    continue block0;
                }
                removeAllAction.add(initialObject);
            }
            if (!removeAllAction.isEmpty()) {
                actions.add(removeAllAction);
            }
        }
        this.addAddAction(actions, objectsToAdd, addSize);
        return actions;
    }

    private void addAddAction(List<CollectionAction<Collection<?>>> actions, Object[] objectsToAdd, int addSize) {
        if (addSize != 0) {
            CollectionAddAllAction addAllAction = new CollectionAddAllAction(addSize, this.collectionInstantiator.allowsDuplicates());
            for (int i = 0; i < objectsToAdd.length; ++i) {
                Object currentObject = objectsToAdd[i];
                if (currentObject == REMOVED_MARKER) continue;
                addAllAction.add(currentObject);
            }
            actions.add(addAllAction);
        }
    }

    protected List<CollectionAction<Collection<?>>> determineCollectionActions(UpdateContext context, V initial, V current, AbstractPluralAttributeFlusher.EqualityChecker equalityChecker) {
        if (this.elementDescriptor.isSubview() && this.elementDescriptor.isIdentifiable()) {
            return this.determineCollectionActionsForSubview(context, initial, current);
        }
        return this.determineCollectionActionsForNonSubview(context, initial, current, equalityChecker);
    }

    @Override
    protected List<CollectionElementAttributeFlusher<E, V>> getElementFlushers(UpdateContext context, V current, List<? extends CollectionAction<?>> actions) {
        ArrayList elementFlushers = new ArrayList();
        if (this.determineElementFlushers(context, this.elementDescriptor, elementFlushers, (Iterable<?>)current, actions, current)) {
            return null;
        }
        return elementFlushers;
    }

    protected CollectionAttributeFlusher<E, V> partialFlusher(boolean fetch, AbstractPluralAttributeFlusher.PluralFlushOperation operation, List<? extends CollectionAction<?>> collectionActions, List<CollectionElementAttributeFlusher<E, V>> elementFlushers) {
        return new CollectionAttributeFlusher<E, V>(this, fetch, operation, collectionActions, elementFlushers);
    }

    @Override
    protected boolean collectionEquals(V initial, V current) {
        if (initial.size() != current.size()) {
            return false;
        }
        return initial.containsAll((Collection<?>)current);
    }

    protected boolean areActionsQueueable(RecordingCollection<?, ?> collection) {
        return false;
    }

    private List<CollectionElementAttributeFlusher<E, V>> getInverseElementFlushersForActions(UpdateContext context, Iterable<?> current, Map<Object, Object> added, Map<Object, Object> removed) {
        ElementFlusherCollector listener = new ElementFlusherCollector();
        this.visitInverseElementFlushersForActions(context, current, added, removed, listener);
        return listener.elementFlushers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitInverseElementFlushersForActions(UpdateContext context, Iterable<?> current, Map<Object, Object> added, Map<Object, Object> removed, ElementChangeListener<E, V> listener) {
        if (this.elementDescriptor.isSubview()) {
            ViewToEntityMapper mapper = this.elementDescriptor.getViewToEntityMapper();
            for (Object element : removed.values()) {
                listener.onRemovedInverseElement(element);
            }
            Iterator<Object> iter = this.getRecordingIterator((Collection)current);
            try {
                while (iter.hasNext()) {
                    Object element;
                    DirtyAttributeFlusher flusher;
                    Iterator<Object> elem = iter.next();
                    if (!(elem instanceof MutableStateTrackable) || (flusher = mapper.getNestedDirtyFlusher(context, (MutableStateTrackable)(element = (MutableStateTrackable)((Object)elem)), null)) == null) continue;
                    Object addedElement = added.remove(element);
                    if (addedElement != null) {
                        listener.onAddedAndUpdatedInverseElement(flusher, element);
                        continue;
                    }
                    listener.onUpdatedInverseElement(flusher, element);
                }
            }
            finally {
                this.resetRecordingIterator((Collection)current);
            }
            for (Object element : added.values()) {
                listener.onAddedInverseElement(element);
            }
        } else if (this.elementDescriptor.isJpaEntity()) {
            for (Object element : removed.values()) {
                listener.onRemovedInverseElement(element);
            }
            for (Object element : current) {
                Object addedElement;
                CollectionElementAttributeFlusher flusher;
                if (this.elementDescriptor.getBasicUserType().shouldPersist(element) && this.elementDescriptor.shouldJpaPersist()) {
                    flusher = new PersistCollectionElementAttributeFlusher(element, this.optimisticLockProtected);
                    addedElement = added.remove(element);
                    if (addedElement != null) {
                        listener.onAddedAndUpdatedInverseElement(flusher, element);
                        continue;
                    }
                    listener.onUpdatedInverseElement(flusher, element);
                    continue;
                }
                if (this.elementDescriptor.shouldJpaMerge()) {
                    if (element == null) continue;
                    flusher = new MergeCollectionElementAttributeFlusher(element, this.optimisticLockProtected);
                    addedElement = added.remove(element);
                    if (addedElement != null) {
                        listener.onAddedAndUpdatedInverseElement(flusher, element);
                        continue;
                    }
                    listener.onUpdatedInverseElement(flusher, element);
                    continue;
                }
                Object addedElement2 = added.remove(element);
                if (addedElement2 == null) continue;
                listener.onAddedInverseElement(element);
            }
        } else {
            throw new UnsupportedOperationException("Not yet implemented!");
        }
    }

    @Override
    protected DirtyAttributeFlusher<CollectionAttributeFlusher<E, V>, E, V> getDirtyFlusherForRecordingCollection(UpdateContext context, V initial, RecordingCollection<?, ?> collection, List<Runnable> preFlushListeners) {
        if (collection.hasActions()) {
            List<? extends CollectionAction<?>> actions = RecordingCollectionResetter.add(context, preFlushListeners, collection);
            boolean queueable = this.areActionsQueueable(collection);
            if (queueable) {
                if (this.elementDescriptor.shouldFlushMutations()) {
                    List<CollectionElementAttributeFlusher<E, V>> elementFlushers;
                    if (this.elementDescriptor.isBasic()) {
                        return this;
                    }
                    if (this.elementDescriptor.isSubview() && this.elementDescriptor.supportsDirtyCheck() && !this.elementDescriptor.isIdentifiable() && this.isIndexed()) {
                        actions = new ArrayList(actions);
                    }
                    if ((elementFlushers = this.getElementFlushers(context, (V)collection, actions)) == null) {
                        return this;
                    }
                    int actionUnrelatedDirtyCount = this.getActionUnrelatedDirtyObjectCount(initial, elementFlushers, actions);
                    if (actionUnrelatedDirtyCount == 0) {
                        return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_AND_ELEMENT, (List)actions, (List)elementFlushers);
                    }
                    return this.partialFlusher(true, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_AND_ELEMENT, (List)actions, (List)elementFlushers);
                }
                return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_ONLY, (List)actions, Collections.emptyList());
            }
            if (this.inverseFlusher != null) {
                Map<Object, Object>[] addedAndRemoved = this.getAddedAndRemovedElementsForInverseFlusher(actions);
                Map<Object, Object> added = addedAndRemoved[0];
                Map<Object, Object> removed = addedAndRemoved[1];
                List<CollectionElementAttributeFlusher<E, V>> elementFlushers = this.getInverseElementFlushersForActions(context, collection, added, removed);
                return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.ELEMENT_ONLY, Collections.EMPTY_LIST, (List)elementFlushers);
            }
            if (this.elementDescriptor.shouldFlushMutations()) {
                List elementFlushers;
                if (this.elementDescriptor.isBasic()) {
                    return this;
                }
                if (this.elementDescriptor.isSubview() && this.elementDescriptor.supportsDirtyCheck() && !this.elementDescriptor.isIdentifiable() && this.isIndexed()) {
                    actions = new ArrayList(actions);
                }
                if ((elementFlushers = this.getElementFlushers(context, (V)collection, actions)) == null) {
                    return this;
                }
                return this.getReplayAndElementFlusher(context, initial, collection, actions, elementFlushers);
            }
            return this.getReplayOnlyFlusher(context, initial, collection, actions);
        }
        if (this.elementDescriptor.shouldFlushMutations()) {
            if (this.elementDescriptor.isBasic()) {
                return this;
            }
            return this.getElementOnlyFlusher(context, collection);
        }
        return null;
    }

    protected FusedCollectionActions getFusedOperations(List<? extends CollectionAction<?>> collectionActions) {
        if (this.collectionInstantiator.allowsDuplicates()) {
            return null;
        }
        IdentityHashMap<Object, Object> added = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> removed = new IdentityHashMap<Object, Object>();
        for (CollectionAction<?> a : collectionActions) {
            Collection<Object> addedObjects = a.getAddedObjects();
            Collection<Object> removedObjects = a.getRemovedObjects();
            for (Object addedObject : addedObjects) {
                removed.remove(addedObject);
            }
            for (Object removedObject : removedObjects) {
                added.remove(removedObject);
                removed.put(removedObject, removedObject);
            }
            for (Object addedObject : addedObjects) {
                added.put(addedObject, addedObject);
            }
        }
        return new FusedCollectionElementActions(this.elementDescriptor.getViewToEntityMapper() == null ? null : this.elementDescriptor.getLoadOnlyViewToEntityMapper(), removed, added);
    }

    private Map<Object, Object>[] getAddedAndRemovedElementsForInverseFlusher(RecordingCollection<?, ?> collection, UpdateContext context, List<Runnable> preFlushListeners) {
        List<? extends CollectionAction<?>> collectionActions = RecordingCollectionResetter.add(context, preFlushListeners, collection);
        return this.getAddedAndRemovedElementsForInverseFlusher(collectionActions);
    }

    private Map<Object, Object>[] getAddedAndRemovedElementsForInverseFlusher(List<? extends CollectionAction<?>> collectionActions) {
        IdentityHashMap<Object, Object> added = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> removed = new IdentityHashMap<Object, Object>();
        for (CollectionAction<?> a : collectionActions) {
            Collection<Object> addedObjects = a.getAddedObjects();
            Collection<Object> removedObjects = a.getRemovedObjects();
            for (Object addedObject : addedObjects) {
                removed.remove(addedObject);
            }
            for (Object removedObject : removedObjects) {
                added.remove(removedObject);
                removed.put(removedObject, removedObject);
            }
            for (Object addedObject : addedObjects) {
                added.put(addedObject, addedObject);
            }
        }
        return new Map[]{added, removed};
    }

    private Map<Object, Object>[] getAddedAndRemovedElementsForInverseFlusher(Collection<?> collection, List<CollectionAction<Collection<?>>> collectionActions) {
        IdentityHashMap<Object, Object> added = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> removed = new IdentityHashMap<Object, Object>();
        for (CollectionAction<Collection<?>> a : collectionActions) {
            Collection<Object> addedObjects = a.getAddedObjects(collection);
            Collection<Object> removedObjects = a.getRemovedObjects(collection);
            for (Object addedObject : addedObjects) {
                removed.remove(addedObject);
            }
            for (Object removedObject : removedObjects) {
                added.remove(removedObject);
                removed.put(removedObject, removedObject);
            }
            for (Object addedObject : addedObjects) {
                added.put(addedObject, addedObject);
            }
        }
        return new Map[]{added, removed};
    }

    protected final int getActionUnrelatedDirtyObjectCount(V initial, List<CollectionElementAttributeFlusher<E, V>> elementFlushers, List<? extends CollectionAction<?>> actions) {
        int count = 0;
        block0: for (CollectionElementAttributeFlusher<E, V> flusherEntry : elementFlushers) {
            Object objectToFlush = flusherEntry.getElement();
            for (CollectionAction<?> a : actions) {
                if (!a.containsObject(initial, objectToFlush)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    private class ElementFlusherQueryExecutor
    implements ElementChangeListener<E, V> {
        private final UpdateContext context;
        private final E entity;
        private final Object view;

        public ElementFlusherQueryExecutor(UpdateContext context, E entity, Object view) {
            this.context = context;
            this.entity = entity;
            this.view = view;
        }

        @Override
        public void onAddedInverseElement(Object element) {
            if (this.view != null) {
                CollectionAttributeFlusher.this.inverseFlusher.flushQuerySetElement(this.context, element, this.view, this.view, null, null);
            } else {
                CollectionAttributeFlusher.this.inverseFlusher.flushQuerySetEntityOnElement(this.context, element, this.entity, this.entity, null, null);
            }
        }

        @Override
        public void onAddedAndUpdatedInverseElement(DirtyAttributeFlusher<?, E, V> flusher, Object element) {
            if (this.view != null) {
                CollectionAttributeFlusher.this.inverseFlusher.flushQuerySetElement(this.context, element, this.view, this.view, null, flusher);
            } else {
                CollectionAttributeFlusher.this.inverseFlusher.flushQuerySetEntityOnElement(this.context, element, this.entity, this.entity, null, flusher);
            }
        }

        @Override
        public void onUpdatedInverseElement(DirtyAttributeFlusher<?, E, V> flusher, Object element) {
            new UpdateCollectionElementAttributeFlusher(flusher, element, CollectionAttributeFlusher.this.optimisticLockProtected, CollectionAttributeFlusher.this.elementDescriptor.getViewToEntityMapper()).flushQuery(this.context, null, null, null, null, null, null, null);
        }

        @Override
        public void onRemovedInverseElement(Object element) {
            if (CollectionAttributeFlusher.this.inverseRemoveStrategy == InverseCollectionElementAttributeFlusher.Strategy.SET_NULL) {
                CollectionAttributeFlusher.this.inverseFlusher.flushQuerySetElement(this.context, element, this.view, null, null, null);
            } else if (CollectionAttributeFlusher.this.inverseRemoveStrategy != InverseCollectionElementAttributeFlusher.Strategy.IGNORE) {
                CollectionAttributeFlusher.this.inverseFlusher.removeElement(this.context, this.entity, element);
            }
        }
    }

    private class ElementFlusherEntityExecutor
    implements ElementChangeListener<E, V> {
        private final UpdateContext context;
        private final E entity;

        public ElementFlusherEntityExecutor(UpdateContext context, E entity) {
            this.context = context;
            this.entity = entity;
        }

        @Override
        public void onAddedInverseElement(Object element) {
            CollectionAttributeFlusher.this.inverseFlusher.flushEntitySetElement(this.context, element, this.entity, this.entity, null);
        }

        @Override
        public void onAddedAndUpdatedInverseElement(DirtyAttributeFlusher<?, E, V> flusher, Object element) {
            CollectionAttributeFlusher.this.inverseFlusher.flushEntitySetElement(this.context, element, this.entity, this.entity, flusher);
        }

        @Override
        public void onUpdatedInverseElement(DirtyAttributeFlusher<?, E, V> flusher, Object element) {
            UpdateCollectionElementAttributeFlusher elementFlusher = new UpdateCollectionElementAttributeFlusher(flusher, element, CollectionAttributeFlusher.this.optimisticLockProtected, CollectionAttributeFlusher.this.elementDescriptor.getViewToEntityMapper());
            if (CollectionAttributeFlusher.this.flushStrategy == FlushStrategy.ENTITY) {
                elementFlusher.flushEntity(this.context, null, null, null, null, null);
            } else {
                elementFlusher.flushQuery(this.context, null, null, null, null, null, null, null);
            }
        }

        @Override
        public void onRemovedInverseElement(Object element) {
            if (CollectionAttributeFlusher.this.inverseRemoveStrategy == InverseCollectionElementAttributeFlusher.Strategy.SET_NULL) {
                CollectionAttributeFlusher.this.inverseFlusher.flushEntitySetElement(this.context, element, this.entity, null, null);
            } else if (CollectionAttributeFlusher.this.inverseRemoveStrategy != InverseCollectionElementAttributeFlusher.Strategy.IGNORE) {
                Collection entityCollection = (Collection)CollectionAttributeFlusher.this.entityAttributeAccessor.getValue(this.entity);
                if (entityCollection != null) {
                    if (CollectionAttributeFlusher.this.elementDescriptor.getViewToEntityMapper() == null) {
                        entityCollection.remove(element);
                    } else {
                        AttributeAccessor entityIdAccessor = CollectionAttributeFlusher.this.elementDescriptor.getViewToEntityMapper().getEntityIdAccessor();
                        AttributeAccessor subviewIdAccessor = CollectionAttributeFlusher.this.elementDescriptor.getViewToEntityMapper().getViewIdAccessor();
                        Object subviewId = subviewIdAccessor.getValue(element);
                        Iterator iterator = entityCollection.iterator();
                        while (iterator.hasNext()) {
                            Object collectionElement = iterator.next();
                            Object elementId = entityIdAccessor.getValue(collectionElement);
                            if (!elementId.equals(subviewId)) continue;
                            iterator.remove();
                            break;
                        }
                    }
                }
                CollectionAttributeFlusher.this.inverseFlusher.removeElement(this.context, this.entity, element);
            }
        }
    }

    private class ElementFlusherCollector
    implements ElementChangeListener<E, V> {
        final List<CollectionElementAttributeFlusher<E, V>> elementFlushers = new ArrayList();

        private ElementFlusherCollector() {
        }

        @Override
        public void onAddedInverseElement(Object element) {
            this.elementFlushers.add(new InverseCollectionElementAttributeFlusher(null, element, CollectionAttributeFlusher.this.optimisticLockProtected, CollectionAttributeFlusher.this.inverseFlusher, InverseCollectionElementAttributeFlusher.Strategy.SET));
        }

        @Override
        public void onAddedAndUpdatedInverseElement(DirtyAttributeFlusher<?, E, V> flusher, Object element) {
            this.elementFlushers.add(new InverseCollectionElementAttributeFlusher(flusher, element, CollectionAttributeFlusher.this.optimisticLockProtected, CollectionAttributeFlusher.this.inverseFlusher, InverseCollectionElementAttributeFlusher.Strategy.SET));
        }

        @Override
        public void onUpdatedInverseElement(DirtyAttributeFlusher<?, E, V> flusher, Object element) {
            this.elementFlushers.add(new UpdateCollectionElementAttributeFlusher(flusher, element, CollectionAttributeFlusher.this.optimisticLockProtected, CollectionAttributeFlusher.this.elementDescriptor.getViewToEntityMapper()));
        }

        @Override
        public void onRemovedInverseElement(Object element) {
            this.elementFlushers.add(new InverseCollectionElementAttributeFlusher(null, element, CollectionAttributeFlusher.this.optimisticLockProtected, CollectionAttributeFlusher.this.inverseFlusher, CollectionAttributeFlusher.this.inverseRemoveStrategy));
        }
    }

    static interface ElementChangeListener<E, V> {
        public void onAddedInverseElement(Object var1);

        public void onAddedAndUpdatedInverseElement(DirtyAttributeFlusher<?, E, V> var1, Object var2);

        public void onUpdatedInverseElement(DirtyAttributeFlusher<?, E, V> var1, Object var2);

        public void onRemovedInverseElement(Object var1);
    }
}

