/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.entity.EmbeddableUpdaterBasedViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.proxy.DirtyStateTrackable;
import com.blazebit.persistence.view.impl.proxy.MutableStateTrackable;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateQueryFactory;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.EmbeddableAttributeFetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.PostFlushDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedOwnerAwareDeleter;
import java.util.Collections;
import java.util.List;
import javax.persistence.Query;

public class EmbeddableAttributeFlusher<E, V>
extends EmbeddableAttributeFetchGraphNode<EmbeddableAttributeFlusher<E, V>, DirtyAttributeFlusher<?, E, V>>
implements DirtyAttributeFlusher<EmbeddableAttributeFlusher<E, V>, E, V> {
    private final boolean optimisticLockProtected;
    private final String updateFragment;
    private final String parameterName;
    private final boolean passThrough;
    private final boolean supportsQueryFlush;
    private final AttributeAccessor entityAttributeAccessor;
    private final AttributeAccessor viewAttributeAccessor;
    private final EmbeddableUpdaterBasedViewToEntityMapper viewToEntityMapper;

    public EmbeddableAttributeFlusher(String attributeName, String mapping, String updateFragment, String parameterName, boolean optimisticLockProtected, boolean passThrough, boolean supportsQueryFlush, AttributeAccessor entityAttributeAccessor, AttributeAccessor viewAttributeAccessor, EmbeddableUpdaterBasedViewToEntityMapper viewToEntityMapper) {
        super(attributeName, mapping, (DirtyAttributeFlusher)viewToEntityMapper.getFullGraphNode());
        this.updateFragment = updateFragment;
        this.parameterName = parameterName;
        this.optimisticLockProtected = optimisticLockProtected;
        this.passThrough = passThrough;
        this.supportsQueryFlush = supportsQueryFlush;
        this.entityAttributeAccessor = entityAttributeAccessor;
        this.viewAttributeAccessor = viewAttributeAccessor;
        this.viewToEntityMapper = viewToEntityMapper;
    }

    private EmbeddableAttributeFlusher(EmbeddableAttributeFlusher<E, V> original, DirtyAttributeFlusher<?, E, V> nestedFlusher) {
        super(original.attributeName, original.mapping, nestedFlusher);
        this.updateFragment = original.updateFragment;
        this.parameterName = original.parameterName;
        this.optimisticLockProtected = original.optimisticLockProtected;
        this.passThrough = original.passThrough;
        this.supportsQueryFlush = original.supportsQueryFlush;
        this.entityAttributeAccessor = original.entityAttributeAccessor;
        this.viewAttributeAccessor = original.viewAttributeAccessor;
        this.viewToEntityMapper = original.viewToEntityMapper;
    }

    public ViewToEntityMapper getViewToEntityMapper() {
        return this.viewToEntityMapper;
    }

    @Override
    public String getMapping() {
        return this.updateFragment;
    }

    @Override
    public V cloneDeep(Object view, V oldValue, V newValue) {
        return newValue;
    }

    @Override
    public Object getNewInitialValue(UpdateContext context, V clonedValue, V currentValue) {
        return currentValue;
    }

    @Override
    public boolean supportsQueryFlush() {
        return this.nestedGraphNode == null || ((DirtyAttributeFlusher)this.nestedGraphNode).supportsQueryFlush();
    }

    @Override
    public boolean loadForEntityFlush() {
        return true;
    }

    @Override
    public boolean appendUpdateQueryFragment(UpdateContext context, StringBuilder sb, String mappingPrefix, String parameterPrefix, String separator) {
        String parameter;
        String mapping;
        if (mappingPrefix == null) {
            mapping = this.updateFragment;
            parameter = this.parameterName;
        } else {
            mapping = mappingPrefix + this.updateFragment;
            parameter = parameterPrefix + this.parameterName;
        }
        if (this.supportsQueryFlush) {
            sb.append(mapping);
            sb.append(" = :");
            sb.append(parameter);
            return true;
        }
        return ((DirtyAttributeFlusher)this.nestedGraphNode).appendUpdateQueryFragment(context, sb, mapping, parameter, separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query flushQuery(UpdateContext context, String parameterPrefix, UpdateQueryFactory queryFactory, Query query, Object ownerView, Object view, V value, UnmappedOwnerAwareDeleter ownerAwareDeleter) {
        try {
            String parameter = parameterPrefix == null ? this.parameterName : parameterPrefix + this.parameterName;
            if (this.supportsQueryFlush) {
                query.setParameter(parameter, this.viewToEntityMapper.applyToEntity(context, null, value));
            } else if (value == null || this.nestedGraphNode != this.viewToEntityMapper.getFullGraphNode()) {
                ((DirtyAttributeFlusher)this.nestedGraphNode).flushQuery(context, parameter, queryFactory, query, ownerView, view, value, ownerAwareDeleter);
            } else {
                ((DirtyAttributeFlusher)this.viewToEntityMapper.getUpdater(value).getFullGraphNode()).flushQuery(context, parameter, queryFactory, query, ownerView, view, value, ownerAwareDeleter);
            }
            Query query2 = query;
            return query2;
        }
        finally {
            if (value instanceof MutableStateTrackable) {
                MutableStateTrackable updatableProxy = (MutableStateTrackable)value;
                context.getInitialStateResetter().addPersistedView(updatableProxy);
            }
        }
    }

    @Override
    public boolean flushEntity(UpdateContext context, E entity, Object ownerView, Object view, V value, Runnable postReplaceListener) {
        Object embeddableValue = null;
        if (entity != null) {
            embeddableValue = this.entityAttributeAccessor.getValue(entity);
        }
        if (value == null) {
            if (entity != null) {
                this.entityAttributeAccessor.setValue(entity, null);
            }
            return embeddableValue != null;
        }
        if (value instanceof MutableStateTrackable) {
            if (embeddableValue == null) {
                embeddableValue = this.viewToEntityMapper.createEmbeddable(context);
                if (entity != null) {
                    this.entityAttributeAccessor.setValue(entity, embeddableValue);
                }
            }
            if (this.nestedGraphNode != this.viewToEntityMapper.getFullGraphNode()) {
                return ((DirtyAttributeFlusher)this.nestedGraphNode).flushEntity(context, embeddableValue, ownerView, value, value, postReplaceListener);
            }
            return ((DirtyAttributeFlusher)this.viewToEntityMapper.getUpdater(value).getFullGraphNode()).flushEntity(context, embeddableValue, ownerView, value, value, postReplaceListener);
        }
        if (entity != null) {
            this.entityAttributeAccessor.setValue(entity, this.viewToEntityMapper.applyToEntity(context, embeddableValue, value));
        }
        return false;
    }

    @Override
    public List<PostFlushDeleter> remove(UpdateContext context, E entity, Object view, V value) {
        return Collections.emptyList();
    }

    @Override
    public void remove(UpdateContext context, Object id) {
    }

    @Override
    public void removeFromEntity(UpdateContext context, E entity) {
    }

    @Override
    public List<PostFlushDeleter> removeByOwnerId(UpdateContext context, Object id) {
        return Collections.emptyList();
    }

    @Override
    public boolean requiresDeleteCascadeAfterRemove() {
        return false;
    }

    @Override
    public boolean isViewOnlyDeleteCascaded() {
        return false;
    }

    @Override
    public boolean isPassThrough() {
        return this.passThrough;
    }

    @Override
    public String getElementIdAttributeName() {
        return null;
    }

    @Override
    public AttributeAccessor getViewAttributeAccessor() {
        return this.viewAttributeAccessor;
    }

    @Override
    public AttributeAccessor getEntityAttributeAccessor() {
        return this.entityAttributeAccessor;
    }

    @Override
    public boolean isOptimisticLockProtected() {
        return this.optimisticLockProtected;
    }

    @Override
    public boolean requiresFlushAfterPersist(V value) {
        return this.nestedGraphNode != null && ((DirtyAttributeFlusher)this.nestedGraphNode).requiresFlushAfterPersist(value);
    }

    @Override
    public boolean requiresDeferredFlush(V value) {
        return this.nestedGraphNode != null && ((DirtyAttributeFlusher)this.nestedGraphNode).requiresDeferredFlush(value);
    }

    @Override
    public <X> DirtyChecker<X>[] getNestedCheckers(V current) {
        return this.viewToEntityMapper.getUpdater(current).getDirtyChecker().getNestedCheckers((DirtyStateTrackable)current);
    }

    @Override
    public DirtyChecker.DirtyKind getDirtyKind(V initial, V current) {
        if (current == null) {
            if (initial == null) {
                return DirtyChecker.DirtyKind.NONE;
            }
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (initial == null) {
            return DirtyChecker.DirtyKind.UPDATED;
        }
        return this.viewToEntityMapper.getUpdater(current).getDirtyChecker().getDirtyKind((DirtyStateTrackable)initial, (DirtyStateTrackable)current);
    }

    @Override
    public DirtyAttributeFlusher<EmbeddableAttributeFlusher<E, V>, E, V> getDirtyFlusher(UpdateContext context, Object view, Object initial, Object current, List<Runnable> preFlushListeners) {
        if (this.isPassThrough()) {
            return null;
        }
        if (!(initial == current || initial != null && initial.equals(current))) {
            return this;
        }
        if (current instanceof MutableStateTrackable) {
            MutableStateTrackable mutableStateTrackable = (MutableStateTrackable)current;
            if (!mutableStateTrackable.$$_isDirty()) {
                return null;
            }
            DirtyAttributeFlusher flusher = this.viewToEntityMapper.getNestedDirtyFlusher(context, mutableStateTrackable, this);
            if (flusher != null) {
                return new EmbeddableAttributeFlusher(this, flusher);
            }
        }
        return null;
    }
}

