/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.FusedCollectionActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class FusedCollectionElementActions
implements FusedCollectionActions {
    private final ViewToEntityMapper loadOnlyViewToEntityMapper;
    private final Map<Object, Object> removed;
    private final Map<Object, Object> added;

    public FusedCollectionElementActions(ViewToEntityMapper loadOnlyViewToEntityMapper, Map<Object, Object> removed, Map<Object, Object> added) {
        this.loadOnlyViewToEntityMapper = loadOnlyViewToEntityMapper;
        this.removed = removed;
        this.added = added;
    }

    @Override
    public int operationCount() {
        return this.removed.size() + this.added.size();
    }

    @Override
    public int getRemoveCount() {
        return this.removed.size();
    }

    @Override
    public int getAddCount() {
        return this.added.size();
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }

    @Override
    public Collection<Object> getAdded() {
        return this.added.keySet();
    }

    @Override
    public Collection<Object> getAdded(UpdateContext context) {
        if (this.loadOnlyViewToEntityMapper == null) {
            return this.added.keySet();
        }
        return this.getEntityReferencesForCollectionOperation(context, this.added.keySet());
    }

    @Override
    public Collection<Object> getRemoved() {
        return this.removed.keySet();
    }

    @Override
    public Collection<Object> getRemoved(UpdateContext context) {
        if (this.loadOnlyViewToEntityMapper == null) {
            return this.removed.keySet();
        }
        return this.getEntityReferencesForCollectionOperation(context, this.removed.keySet());
    }

    private List<Object> getEntityReferencesForCollectionOperation(UpdateContext context, Collection<Object> objects) {
        ArrayList<Object> entityReferences = new ArrayList<Object>(objects.size());
        for (Object o : objects) {
            if (o == null) continue;
            entityReferences.add(this.loadOnlyViewToEntityMapper.applyToEntity(context, null, o));
        }
        return entityReferences;
    }
}

