/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.impl.collection.ListAction;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.FusedCollectionActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class FusedCollectionIndexActions
implements FusedCollectionActions {
    private final List<RemoveRangeOperation> removeRangeOperations;
    private final List<IndexTranslateOperation> indexTranslateOperations;
    private final List<ReplaceOperation> replaceOperations;
    private final List<Object> appendedObjects;
    private final int appendIndex;
    private final int removeCount;
    private final int addCount;
    private final int updateCount;

    public FusedCollectionIndexActions(List<? extends ListAction<?>> collectionActions) {
        IndexTranslateOperation indexTranslateOperation;
        int i;
        ArrayList<IndexTranslateOperation> translateOperations = new ArrayList<IndexTranslateOperation>();
        ArrayList<ReplaceOperation> replaceOperations = new ArrayList<ReplaceOperation>();
        ArrayList<Object> appendedObjects = new ArrayList<Object>();
        int appendIndex = Integer.MAX_VALUE;
        for (ListAction<?> collectionAction : collectionActions) {
            RemoveOperation removeOperation;
            int index;
            List<Map.Entry<Object, Integer>> insertedObjectMap = collectionAction.getInsertedObjectEntries();
            List<Map.Entry<Object, Integer>> appendedObjectMap = collectionAction.getAppendedObjectEntries();
            List<Map.Entry<Object, Integer>> removedObjectMap = collectionAction.getRemovedObjectEntries();
            List<Map.Entry<Object, Integer>> trimmedObjectMap = collectionAction.getTrimmedObjectEntries();
            for (Map.Entry<Object, Integer> entry : removedObjectMap) {
                if (appendIndex <= entry.getValue()) {
                    int indexToRemove = entry.getValue() - appendIndex;
                    appendedObjects.remove(indexToRemove);
                    if (!appendedObjects.isEmpty()) continue;
                    appendIndex = Integer.MAX_VALUE;
                    continue;
                }
                index = FusedCollectionIndexActions.applyIndexTranslations(translateOperations, -entry.getValue().intValue());
                removeOperation = new RemoveOperation(index, entry.getKey());
                FusedCollectionIndexActions.addTranslateOperation(translateOperations, index, Integer.MAX_VALUE, -1, removeOperation, null);
            }
            for (Map.Entry<Object, Integer> entry : trimmedObjectMap) {
                index = FusedCollectionIndexActions.applyIndexTranslations(translateOperations, -entry.getValue().intValue());
                appendIndex = Math.min(index, appendIndex);
                removeOperation = new RemoveOperation(index, entry.getKey());
                FusedCollectionIndexActions.addTranslateOperation(translateOperations, index, Integer.MAX_VALUE, -1, removeOperation, null);
            }
            for (Map.Entry<Object, Integer> entry : insertedObjectMap) {
                index = entry.getValue();
                ReplaceOperation replaceOperation = new ReplaceOperation(index, entry.getKey());
                replaceOperations.add(replaceOperation);
                FusedCollectionIndexActions.addTranslateOperation(translateOperations, index, Integer.MAX_VALUE, 1, null, replaceOperation);
            }
            block4: for (Map.Entry<Object, Integer> entry : appendedObjectMap) {
                index = entry.getValue();
                block5: for (int i2 = 0; i2 < translateOperations.size(); ++i2) {
                    IndexTranslateOperation translateOperation = (IndexTranslateOperation)translateOperations.get(i2);
                    if (translateOperation.offset != -1 || translateOperation.startIndex > index || index > translateOperation.endIndex) continue;
                    Iterator iterator = translateOperation.removeOperations.iterator();
                    while (iterator.hasNext()) {
                        RemoveOperation removeOperation2 = (RemoveOperation)iterator.next();
                        if (index != removeOperation2.index) continue;
                        if (removeOperation2.removedObject != entry.getKey()) break block5;
                        iterator.remove();
                        if (!translateOperation.removeOperations.isEmpty()) continue block4;
                        translateOperations.remove(i2);
                        continue block4;
                    }
                    break;
                }
                appendIndex = Math.min(index, appendIndex);
                appendedObjects.add(entry.getKey());
            }
        }
        TreeSet removeOperations = new TreeSet();
        if (appendIndex != Integer.MAX_VALUE) {
            for (i = 0; i < translateOperations.size(); ++i) {
                indexTranslateOperation = (IndexTranslateOperation)translateOperations.get(i);
                removeOperations.addAll(indexTranslateOperation.removeOperations);
                if (indexTranslateOperation.endIndex != Integer.MAX_VALUE) continue;
                if (indexTranslateOperation.startIndex > appendIndex && indexTranslateOperation.removeOperations.isEmpty() || indexTranslateOperation.startIndex + indexTranslateOperation.removeOperations.size() == appendIndex + 1) {
                    translateOperations.remove(i);
                    --i;
                    continue;
                }
                indexTranslateOperation.endIndex = appendIndex;
            }
        } else {
            for (i = 0; i < translateOperations.size(); ++i) {
                indexTranslateOperation = (IndexTranslateOperation)translateOperations.get(i);
                removeOperations.addAll(indexTranslateOperation.removeOperations);
            }
        }
        ArrayList<RemoveRangeOperation> removeRangeOperations = new ArrayList<RemoveRangeOperation>();
        Iterator iterator = removeOperations.iterator();
        RemoveRangeOperation lastRangeOp = null;
        while (iterator.hasNext()) {
            RemoveOperation removeOp = (RemoveOperation)iterator.next();
            if (lastRangeOp == null || lastRangeOp.endIndex != removeOp.index) {
                ArrayList<Object> removedObjects = new ArrayList<Object>();
                removedObjects.add(removeOp.removedObject);
                lastRangeOp = new RemoveRangeOperation(removeOp.index, removeOp.index + 1, removedObjects);
                removeRangeOperations.add(lastRangeOp);
                continue;
            }
            lastRangeOp.endIndex++;
            lastRangeOp.removedObjects.add(removeOp.removedObject);
        }
        int updateCount = translateOperations.size();
        int addCount = appendedObjects.size();
        for (int i3 = 0; i3 < replaceOperations.size(); ++i3) {
            ReplaceOperation replaceOperation = (ReplaceOperation)replaceOperations.get(i3);
            if (replaceOperation.oldObject == null) {
                ++addCount;
                continue;
            }
            ++updateCount;
        }
        this.removeRangeOperations = removeRangeOperations;
        this.indexTranslateOperations = translateOperations;
        this.replaceOperations = replaceOperations;
        this.appendedObjects = appendedObjects;
        this.appendIndex = appendIndex;
        this.removeCount = removeRangeOperations.size();
        this.addCount = addCount;
        this.updateCount = updateCount;
    }

    private static void addTranslateOperation(List<IndexTranslateOperation> translateOperations, int startIndex, int endIndex, int offset, RemoveOperation removeOperation, ReplaceOperation replaceOperation) {
        if (translateOperations.isEmpty()) {
            translateOperations.add(new IndexTranslateOperation(startIndex, endIndex, offset, removeOperation == null ? new ArrayList<RemoveOperation>() : new ArrayList<RemoveOperation>(Collections.singletonList(removeOperation))));
        } else {
            for (int i = 0; i < translateOperations.size(); ++i) {
                IndexTranslateOperation indexTranslateOperation = translateOperations.get(i);
                if (indexTranslateOperation.startIndex > startIndex || indexTranslateOperation.endIndex < endIndex) continue;
                int indexDiff = Math.abs(indexTranslateOperation.startIndex - startIndex);
                if (indexDiff == 0 && indexTranslateOperation.offset + offset == 0 && indexTranslateOperation.removeOperations.size() == 1 && replaceOperation != null) {
                    translateOperations.remove(i);
                    replaceOperation.oldObject = ((RemoveOperation)indexTranslateOperation.removeOperations.get(0)).removedObject;
                    return;
                }
                if (indexDiff == 1 && indexTranslateOperation.endIndex == endIndex) {
                    ArrayList<RemoveOperation> newList;
                    if (removeOperation == null) {
                        newList = indexTranslateOperation.removeOperations;
                    } else {
                        newList = new ArrayList<RemoveOperation>(indexTranslateOperation.removeOperations.size() + 1);
                        newList.addAll(indexTranslateOperation.removeOperations);
                        newList.add(removeOperation);
                    }
                    translateOperations.set(i, new IndexTranslateOperation(Math.min(indexTranslateOperation.startIndex, startIndex), endIndex, indexTranslateOperation.offset + offset, newList));
                    return;
                }
                translateOperations.set(i, new IndexTranslateOperation(indexTranslateOperation.startIndex, startIndex, indexTranslateOperation.offset, indexTranslateOperation.removeOperations));
                translateOperations.add(i + 1, new IndexTranslateOperation(startIndex, endIndex, offset, removeOperation == null ? new ArrayList<RemoveOperation>() : new ArrayList<RemoveOperation>(Collections.singletonList(removeOperation))));
                return;
            }
            translateOperations.add(new IndexTranslateOperation(startIndex, endIndex, offset, removeOperation == null ? new ArrayList<RemoveOperation>() : new ArrayList<RemoveOperation>(Collections.singletonList(removeOperation))));
        }
    }

    private static int applyIndexTranslations(List<IndexTranslateOperation> indexTranslateOperations, int index) {
        int absIndex = Math.abs(index);
        for (int i = 0; i < indexTranslateOperations.size(); ++i) {
            IndexTranslateOperation indexTranslateOperation = indexTranslateOperations.get(i);
            if (absIndex < indexTranslateOperation.startIndex || absIndex > indexTranslateOperation.endIndex) continue;
            absIndex = Math.abs(index += indexTranslateOperation.offset);
        }
        return absIndex;
    }

    @Override
    public int operationCount() {
        return this.addCount + this.removeCount + this.updateCount;
    }

    @Override
    public int getRemoveCount() {
        return this.removeCount;
    }

    @Override
    public int getAddCount() {
        return this.addCount;
    }

    @Override
    public int getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public Collection<Object> getRemoved() {
        ArrayList<Object> objects = new ArrayList<Object>(this.removeCount);
        for (int i = 0; i < this.removeRangeOperations.size(); ++i) {
            RemoveRangeOperation removeRangeOperation = this.removeRangeOperations.get(i);
            objects.addAll(removeRangeOperation.removedObjects);
        }
        return objects;
    }

    @Override
    public Collection<Object> getRemoved(UpdateContext context) {
        ArrayList<Object> indexes = new ArrayList<Object>(this.removeCount);
        for (int i = 0; i < this.removeRangeOperations.size(); ++i) {
            RemoveRangeOperation removeRangeOperation = this.removeRangeOperations.get(i);
            for (int j = removeRangeOperation.startIndex; j < removeRangeOperation.endIndex; ++j) {
                indexes.add(j);
            }
        }
        return indexes;
    }

    public List<IndexTranslateOperation> getTranslations() {
        return this.indexTranslateOperations;
    }

    @Override
    public Collection<Object> getAdded() {
        return this.appendedObjects;
    }

    @Override
    public Collection<Object> getAdded(UpdateContext context) {
        return this.appendedObjects;
    }

    public int getAppendIndex() {
        return this.appendIndex;
    }

    public List<ReplaceOperation> getReplaces() {
        return this.replaceOperations;
    }

    public static class ReplaceOperation {
        private final int index;
        private final Object newObject;
        private Object oldObject;

        public ReplaceOperation(int index, Object newObject) {
            this.index = index;
            this.newObject = newObject;
        }

        public int getIndex() {
            return this.index;
        }

        public Object getNewObject() {
            return this.newObject;
        }
    }

    public static class IndexTranslateOperation {
        private int startIndex;
        private int endIndex;
        private int offset;
        private final List<RemoveOperation> removeOperations;

        public IndexTranslateOperation(int startIndex, int endIndex, int offset, List<RemoveOperation> removeOperations) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.offset = offset;
            this.removeOperations = removeOperations;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    private static class RemoveRangeOperation {
        private int startIndex;
        private int endIndex;
        private final List<Object> removedObjects;

        public RemoveRangeOperation(int startIndex, int endIndex, List<Object> removedObjects) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.removedObjects = removedObjects;
        }
    }

    private static class RemoveOperation
    implements Comparable<RemoveOperation> {
        private final int index;
        private final Object removedObject;

        public RemoveOperation(int index, Object removedObject) {
            this.index = index;
            this.removedObject = removedObject;
        }

        @Override
        public int compareTo(RemoveOperation o) {
            return Integer.compare(this.index, o.index);
        }
    }
}

