/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.impl.collection.MapAction;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.proxy.DirtyTracker;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FusedMapActions {
    private final ViewToEntityMapper keyViewToEntityMapper;
    private final Map<Object, Object> removed;
    private final Map<Object, Object> added;
    private final Map<Object, Object> replaces;
    private final int removeCount;
    private final int removeValueCount;

    public FusedMapActions(ViewToEntityMapper keyViewToEntityMapper, List<? extends MapAction<?>> collectionActions) {
        this.keyViewToEntityMapper = keyViewToEntityMapper;
        HashMap<Object, Object> removed = new HashMap<Object, Object>();
        HashMap<Object, Object> added = new HashMap<Object, Object>();
        HashMap<Object, Object> replaces = new HashMap<Object, Object>();
        int removeCount = 0;
        int removeValueCount = 0;
        for (MapAction<?> action : collectionActions) {
            Object value;
            Object key;
            Iterator<Object> removedElementsIter;
            Collection<Object> addedKeys = action.getAddedKeys();
            Collection<Object> removedKeys = action.getRemovedKeys();
            Collection<Object> addedElements = action.getAddedElements();
            Collection<Object> removedElements = action.getRemovedElements();
            Iterator<Object> addedKeysIter = addedKeys.iterator();
            if (addedKeysIter.hasNext()) {
                Iterator<Object> addedElementsIter = addedElements.iterator();
                removedElementsIter = removedElements.iterator();
                while (addedKeysIter.hasNext()) {
                    Object removedValue;
                    key = addedKeysIter.next();
                    value = addedElementsIter.next();
                    Object oldValue = removed.remove(key);
                    Object object = removedValue = removedElementsIter.hasNext() ? removedElementsIter.next() : null;
                    if (oldValue == null) {
                        if (removedValue == null) {
                            added.put(key, value);
                            continue;
                        }
                        if (removedValue == value && (!(value instanceof DirtyTracker) || !((DirtyTracker)value).$$_isDirty() || added.get(key) == value)) continue;
                        removed.put(new RemoveWrapper(key), removedValue);
                        replaces.put(key, value);
                        if (removedValue == value) continue;
                        --removeValueCount;
                        continue;
                    }
                    --removeCount;
                    --removeValueCount;
                }
                continue;
            }
            Iterator<Object> removedKeysIter = removedKeys.iterator();
            removedElementsIter = removedElements.iterator();
            while (removedKeysIter.hasNext()) {
                key = removedKeysIter.next();
                value = removedElementsIter.next();
                Object removedValue = added.remove(key);
                if (removedValue != null) continue;
                removed.put(key, value);
                ++removeCount;
                if (value == null) continue;
                ++removeValueCount;
            }
        }
        this.removed = removed;
        this.added = added;
        this.replaces = replaces;
        this.removeCount = removeCount;
        this.removeValueCount = removeValueCount;
    }

    public int operationCount() {
        return this.removeCount + this.added.size() + this.replaces.size();
    }

    public int getRemoveCount() {
        return this.removeCount;
    }

    public int getRemoveValueCount() {
        return this.removeValueCount;
    }

    public int getAddCount() {
        return this.added.size();
    }

    public int getUpdateCount() {
        return this.replaces.size();
    }

    public Map<Object, Object> getAdded() {
        return this.added;
    }

    public Map<Object, Object> getRemoved() {
        return this.removed;
    }

    public Collection<Object> getRemovedKeys(UpdateContext context) {
        if (this.keyViewToEntityMapper == null) {
            ArrayList<Object> entityReferences = new ArrayList<Object>(this.removed.size());
            for (Object o : this.removed.keySet()) {
                if (o instanceof RemoveWrapper) {
                    o = ((RemoveWrapper)o).object;
                }
                entityReferences.add(o);
            }
            return entityReferences;
        }
        ArrayList<Object> entityReferences = new ArrayList<Object>(this.removed.size());
        for (Object o : this.removed.keySet()) {
            if (o instanceof RemoveWrapper) {
                o = ((RemoveWrapper)o).object;
            }
            entityReferences.add(this.keyViewToEntityMapper.applyToEntity(context, null, o));
        }
        return entityReferences;
    }

    public Map<Object, Object> getReplaces() {
        return this.replaces;
    }

    public static class RemoveWrapper {
        private final Object object;

        public RemoveWrapper(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof RemoveWrapper) {
                RemoveWrapper that = (RemoveWrapper)o;
                return this.getObject().equals(that.getObject());
            }
            if (this.object == o) {
                return true;
            }
            return this.object.equals(o);
        }

        public int hashCode() {
            return this.getObject().hashCode();
        }
    }
}

