/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.InverseRemoveStrategy;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateQueryFactory;
import com.blazebit.persistence.view.impl.update.flush.CollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.InverseFlusher;
import com.blazebit.persistence.view.impl.update.flush.UnmappedOwnerAwareDeleter;
import javax.persistence.Query;

public class InverseCollectionElementAttributeFlusher<E, V>
extends CollectionElementAttributeFlusher<E, V> {
    private final InverseFlusher<E> inverseFlusher;
    private final Strategy strategy;

    public InverseCollectionElementAttributeFlusher(DirtyAttributeFlusher<?, E, V> nestedGraphNode, Object element, boolean optimisticLockProtected, InverseFlusher<E> inverseFlusher, Strategy strategy) {
        super(nestedGraphNode, element, optimisticLockProtected);
        this.inverseFlusher = inverseFlusher;
        this.strategy = strategy;
    }

    @Override
    public Query flushQuery(UpdateContext context, String parameterPrefix, UpdateQueryFactory queryFactory, Query query, Object ownerView, Object view, V value, UnmappedOwnerAwareDeleter ownerAwareDeleter) {
        if (this.strategy == Strategy.REMOVE) {
            this.inverseFlusher.removeElement(context, null, this.element);
        } else if (this.strategy != Strategy.IGNORE) {
            this.inverseFlusher.flushQuerySetElement(context, this.element, ownerView, this.strategy == Strategy.SET_NULL ? null : ownerView, parameterPrefix, (DirtyAttributeFlusher)this.nestedGraphNode);
        }
        return query;
    }

    @Override
    public boolean flushEntity(UpdateContext context, E entity, Object ownerView, Object view, V value, Runnable postReplaceListener) {
        if (this.strategy == Strategy.REMOVE) {
            this.inverseFlusher.removeElement(context, entity, this.element);
        } else if (this.strategy != Strategy.IGNORE) {
            this.inverseFlusher.flushEntitySetElement(context, this.element, entity, this.strategy == Strategy.SET_NULL ? null : (Object)entity, (DirtyAttributeFlusher)this.nestedGraphNode);
        }
        return true;
    }

    public static enum Strategy {
        SET,
        SET_NULL,
        REMOVE,
        IGNORE;


        public static Strategy of(InverseRemoveStrategy inverseRemoveStrategy) {
            if (inverseRemoveStrategy == null) {
                return null;
            }
            switch (inverseRemoveStrategy) {
                case SET_NULL: {
                    return SET_NULL;
                }
                case REMOVE: {
                    return REMOVE;
                }
                case IGNORE: {
                    return IGNORE;
                }
            }
            throw new IllegalArgumentException("Unsupported remove strategy: " + inverseRemoveStrategy);
        }
    }
}

