/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.DeleteCriteriaBuilder;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.view.OptimisticLockException;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.InverseElementToEntityMapper;
import com.blazebit.persistence.view.impl.entity.InverseEntityToEntityMapper;
import com.blazebit.persistence.view.impl.entity.InverseViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.LoadOnlyViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.LoadOrPersistViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.ReferenceEntityLoader;
import com.blazebit.persistence.view.impl.entity.TargetViewClassBasedInverseViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.mapper.CollectionAddMapper;
import com.blazebit.persistence.view.impl.mapper.CollectionRemoveMapper;
import com.blazebit.persistence.view.impl.mapper.Mapper;
import com.blazebit.persistence.view.impl.mapper.Mappers;
import com.blazebit.persistence.view.impl.mapper.NoopMapper;
import com.blazebit.persistence.view.impl.mapper.NullMapper;
import com.blazebit.persistence.view.impl.mapper.SimpleMapper;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.type.EntityBasicUserType;
import com.blazebit.persistence.view.impl.update.EntityViewUpdaterImpl;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.CompositeAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.ParentCollectionReferenceAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.ParentReferenceAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.PostFlushDeleter;
import com.blazebit.persistence.view.impl.update.flush.PostFlushInverseCollectionElementByIdDeleter;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;
import com.blazebit.persistence.view.impl.update.flush.UnmappedAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedBasicAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedWritableBasicAttributeSetNullCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.ViewTypeCascadeDeleter;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;

public final class InverseFlusher<E> {
    private final Class<?> parentEntityClass;
    private final String attributeName;
    private final String parentIdAttributeName;
    private final String childIdAttributeName;
    private final UnmappedAttributeCascadeDeleter deleter;
    private final ViewToEntityMapper parentReferenceViewToEntityMapper;
    private final DirtyAttributeFlusher<?, E, Object> parentReferenceAttributeFlusher;
    private final Mapper<E, Object> parentEntityOnChildViewMapper;
    private final TargetViewClassBasedInverseViewToEntityMapper childViewToEntityMapper;
    private final ViewToEntityMapper childReferenceViewToEntityMapper;
    private final Mapper<E, Object> parentEntityOnChildEntityMapper;
    private final InverseEntityToEntityMapper childEntityToEntityMapper;

    public InverseFlusher(Class<?> parentEntityClass, String attributeName, String parentIdAttributeName, String childIdAttributeName, UnmappedAttributeCascadeDeleter deleter, ViewToEntityMapper parentReferenceViewToEntityMapper, DirtyAttributeFlusher<?, E, Object> parentReferenceAttributeFlusher, Mapper<E, Object> parentEntityOnChildViewMapper, TargetViewClassBasedInverseViewToEntityMapper childViewToEntityMapper, ViewToEntityMapper childReferenceViewToEntityMapper, Mapper<E, Object> parentEntityOnChildEntityMapper, InverseEntityToEntityMapper childEntityToEntityMapper) {
        this.parentEntityClass = parentEntityClass;
        this.attributeName = attributeName;
        this.parentIdAttributeName = parentIdAttributeName;
        this.childIdAttributeName = childIdAttributeName;
        this.deleter = deleter;
        this.parentReferenceViewToEntityMapper = parentReferenceViewToEntityMapper;
        this.parentReferenceAttributeFlusher = parentReferenceAttributeFlusher;
        this.parentEntityOnChildViewMapper = parentEntityOnChildViewMapper;
        this.childViewToEntityMapper = childViewToEntityMapper;
        this.childReferenceViewToEntityMapper = childReferenceViewToEntityMapper;
        this.parentEntityOnChildEntityMapper = parentEntityOnChildEntityMapper;
        this.childEntityToEntityMapper = childEntityToEntityMapper;
    }

    public static <E> InverseFlusher<E> forAttribute(EntityViewManagerImpl evm, ManagedViewType<?> viewType, AbstractMethodAttribute<?, ?> attribute, TypeDescriptor childTypeDescriptor, EntityViewUpdaterImpl owner, String ownerMapping) {
        if (attribute.getMappedBy() != null) {
            ParentReferenceAttributeFlusher<Object, Object> parentReferenceAttributeFlusher;
            Class childType;
            Mapper mapper;
            HashMap mappers;
            ViewType childViewType;
            String attributeLocation = attribute.getLocation();
            Type elementType = attribute instanceof PluralAttribute ? ((PluralAttribute)attribute).getElementType() : ((SingularAttribute)attribute).getType();
            Class elementEntityClass = null;
            AttributeAccessor parentReferenceAttributeAccessor = null;
            Mapper<Object, Object> parentEntityOnChildViewMapper = null;
            Mapper<Object, Object> parentEntityOnChildEntityAddMapper = null;
            Mapper<Object, Object> parentEntityOnChildEntityRemoveMapper = null;
            TargetViewClassBasedInverseViewToEntityMapper childViewToEntityMapper = null;
            InverseEntityToEntityMapper childEntityToEntityMapper = null;
            LoadOnlyViewToEntityMapper parentReferenceViewToEntityMapper = new LoadOnlyViewToEntityMapper(new ReferenceEntityLoader(evm, viewType, EntityViewUpdaterImpl.createViewIdMapper(evm, viewType)), Accessors.forViewId(evm, (ViewType)viewType, true), evm.getEntityIdAccessor());
            LoadOrPersistViewToEntityMapper childReferenceViewToEntityMapper = null;
            TypeDescriptor parentReferenceTypeDescriptor = TypeDescriptor.forInverseAttribute(parentReferenceViewToEntityMapper);
            if (attribute.getWritableMappedByMappings() != null) {
                if (childTypeDescriptor.isSubview()) {
                    childViewType = (ViewType)elementType;
                    elementEntityClass = childViewType.getEntityClass();
                    mappers = new HashMap();
                    for (ManagedViewType<?> type : attribute.getViewTypes()) {
                        mapper = Mappers.forViewConvertToViewAttributeMapping(evm, (ViewType)viewType, (ViewType)type, attribute.getWritableMappedByMappings(), Mappers.forEntityAttributeMappingConvertToViewAttributeMapping(evm, viewType.getEntityClass(), type, attribute.getWritableMappedByMappings()));
                        if (mapper == null) {
                            mapper = NoopMapper.INSTANCE;
                        }
                        mappers.put(type.getJavaType(), mapper);
                    }
                    parentEntityOnChildViewMapper = Mappers.targetViewClassBasedMapper(mappers);
                    parentEntityOnChildEntityAddMapper = parentEntityOnChildEntityRemoveMapper = Mappers.forEntityAttributeMapping(evm, viewType.getEntityClass(), childViewType.getEntityClass(), attribute.getWritableMappedByMappings());
                    childReferenceViewToEntityMapper = new LoadOrPersistViewToEntityMapper(attributeLocation, evm, childViewType.getJavaType(), attribute.getReadOnlyAllowedSubtypes(), attribute.getPersistCascadeAllowedSubtypes(), attribute.getUpdateCascadeAllowedSubtypes(), new ReferenceEntityLoader(evm, (ManagedViewType<?>)childViewType, EntityViewUpdaterImpl.createViewIdMapper(evm, childViewType)), Accessors.forViewId(evm, childViewType, true), evm.getEntityIdAccessor(), true, owner, ownerMapping);
                } else if (childTypeDescriptor.isJpaEntity()) {
                    elementEntityClass = childType = elementType.getJavaType();
                    parentEntityOnChildViewMapper = Mappers.forEntityAttributeMapping(evm, viewType.getEntityClass(), childType, attribute.getWritableMappedByMappings());
                    parentEntityOnChildEntityAddMapper = parentEntityOnChildEntityRemoveMapper = Mappers.forEntityAttributeMapping(evm, viewType.getEntityClass(), elementEntityClass, attribute.getWritableMappedByMappings());
                }
            } else if (childTypeDescriptor.isSubview()) {
                childViewType = (ViewType)elementType;
                elementEntityClass = childViewType.getEntityClass();
                parentReferenceAttributeAccessor = Accessors.forEntityMapping(evm, childViewType.getEntityClass(), attribute.getMappedBy());
                childReferenceViewToEntityMapper = new LoadOrPersistViewToEntityMapper(attributeLocation, evm, childViewType.getJavaType(), attribute.getReadOnlyAllowedSubtypes(), attribute.getPersistCascadeAllowedSubtypes(), attribute.getUpdateCascadeAllowedSubtypes(), new ReferenceEntityLoader(evm, (ManagedViewType<?>)childViewType, EntityViewUpdaterImpl.createViewIdMapper(evm, childViewType)), Accessors.forViewId(evm, childViewType, true), evm.getEntityIdAccessor(), true, owner, ownerMapping);
                parentEntityOnChildEntityAddMapper = parentEntityOnChildEntityRemoveMapper = Mappers.forAccessor(parentReferenceAttributeAccessor);
                mappers = new HashMap();
                for (ManagedViewType<?> type : attribute.getViewTypes()) {
                    mapper = Mappers.forViewConvertToViewAttributeMapping(evm, (ViewType)viewType, (ViewType)type, attribute.getMappedBy(), null);
                    if (mapper == null) {
                        mapper = NoopMapper.INSTANCE;
                    }
                    mappers.put(type.getJavaType(), mapper);
                }
                parentEntityOnChildViewMapper = Mappers.targetViewClassBasedMapper(mappers);
            } else if (childTypeDescriptor.isJpaEntity()) {
                elementEntityClass = childType = elementType.getJavaType();
                parentReferenceAttributeAccessor = Accessors.forEntityMapping(evm, childType, attribute.getMappedBy());
                parentEntityOnChildEntityAddMapper = parentEntityOnChildEntityRemoveMapper = Mappers.forAccessor(parentReferenceAttributeAccessor);
                parentEntityOnChildViewMapper = Mappers.forAccessor(parentReferenceAttributeAccessor);
            }
            ManagedType managedType = evm.getMetamodel().getEntityMetamodel().getManagedType(elementEntityClass);
            Attribute inverseAttribute = JpaMetamodelUtils.getAttribute((ManagedType)managedType, (String)attribute.getMappedBy());
            if (inverseAttribute != null && inverseAttribute.isCollection()) {
                parentEntityOnChildEntityAddMapper = new CollectionAddMapper(parentEntityOnChildEntityAddMapper == null ? parentReferenceAttributeAccessor : ((SimpleMapper)parentEntityOnChildEntityAddMapper).getAttributeAccessor());
                parentEntityOnChildEntityRemoveMapper = new CollectionRemoveMapper(parentEntityOnChildEntityRemoveMapper == null ? parentReferenceAttributeAccessor : ((SimpleMapper)parentEntityOnChildEntityRemoveMapper).getAttributeAccessor());
                parentReferenceAttributeFlusher = new ParentCollectionReferenceAttributeFlusher(attributeLocation, attribute.getMappedBy(), viewType.getFlushStrategy(), parentReferenceAttributeAccessor, null, null, null, TypeDescriptor.forInverseCollectionAttribute(viewType.getEntityClass(), new EntityBasicUserType(evm.getJpaProvider())));
            } else {
                parentEntityOnChildEntityRemoveMapper = new NullMapper(parentEntityOnChildEntityRemoveMapper);
                parentReferenceAttributeFlusher = new ParentReferenceAttributeFlusher(evm, viewType.getEntityClass(), attributeLocation, attribute.getMappedBy(), attribute.getWritableMappedByMappings(), parentReferenceTypeDescriptor, parentReferenceAttributeAccessor, parentEntityOnChildViewMapper);
            }
            UnmappedAttributeCascadeDeleter deleter = null;
            String parentIdAttributeName = null;
            String childIdAttributeName = null;
            if (attribute.isDeleteCascaded()) {
                EntityMetamodel entityMetamodel = evm.getMetamodel().getEntityMetamodel();
                ExtendedManagedType ownerManagedType = (ExtendedManagedType)entityMetamodel.getManagedType(ExtendedManagedType.class, viewType.getEntityClass());
                ExtendedManagedType elementManagedType = (ExtendedManagedType)entityMetamodel.getManagedType(ExtendedManagedType.class, elementEntityClass);
                parentIdAttributeName = ownerManagedType.getIdAttribute().getName();
                childIdAttributeName = elementManagedType.getIdAttribute().getName();
                String mapping = attribute.getMappedBy();
                if (mapping != null) {
                    if (mapping.isEmpty()) {
                        deleter = new UnmappedWritableBasicAttributeSetNullCascadeDeleter(evm, ownerManagedType.getType(), elementManagedType, attribute.getWritableMappedByMappings());
                    } else {
                        ExtendedAttribute extendedAttribute = elementManagedType.getAttribute(mapping);
                        if (childTypeDescriptor.isSubview()) {
                            deleter = new ViewTypeCascadeDeleter(childTypeDescriptor.getViewToEntityMapper());
                        } else if (childTypeDescriptor.isJpaEntity()) {
                            deleter = new UnmappedBasicAttributeCascadeDeleter(evm, mapping, extendedAttribute, mapping + "." + parentIdAttributeName, false);
                        }
                    }
                }
            }
            if (childTypeDescriptor.isSubview()) {
                InverseViewToEntityMapper first = null;
                HashMap mappers2 = new HashMap();
                for (ManagedViewType<?> type : attribute.getViewTypes()) {
                    InverseViewToEntityMapper inverseViewToEntityMapper = new InverseViewToEntityMapper(evm, (ViewType)type, parentEntityOnChildViewMapper, parentEntityOnChildEntityAddMapper, parentEntityOnChildEntityRemoveMapper, childTypeDescriptor.getViewToEntityMapper(), parentReferenceAttributeFlusher, EntityViewUpdaterImpl.createIdFlusher(evm, (ViewType)type, EntityViewUpdaterImpl.createViewIdMapper(evm, type)));
                    mappers2.put(type.getJavaType(), inverseViewToEntityMapper);
                    if (type != elementType) continue;
                    first = inverseViewToEntityMapper;
                }
                childViewToEntityMapper = new TargetViewClassBasedInverseViewToEntityMapper(first, mappers2);
            } else if (childTypeDescriptor.isJpaEntity()) {
                Class childType2 = elementType.getJavaType();
                childEntityToEntityMapper = new InverseEntityToEntityMapper(evm, evm.getMetamodel().getEntityMetamodel().entity(childType2), parentEntityOnChildEntityAddMapper, parentEntityOnChildEntityRemoveMapper, parentReferenceAttributeFlusher);
            }
            return new InverseFlusher<Object>(viewType.getEntityClass(), attribute.getMapping(), parentIdAttributeName, childIdAttributeName, deleter, parentReferenceViewToEntityMapper, parentReferenceAttributeFlusher, parentEntityOnChildViewMapper, childViewToEntityMapper, childReferenceViewToEntityMapper, parentEntityOnChildEntityAddMapper, childEntityToEntityMapper);
        }
        return null;
    }

    public Collection<Object> loadByOwnerId(UpdateContext context, Object ownerId) {
        EntityViewManagerImpl evm = context.getEntityViewManager();
        CriteriaBuilder cb = evm.getCriteriaBuilderFactory().create(context.getEntityManager(), this.parentEntityClass, "e");
        cb.where(this.parentIdAttributeName).eq(ownerId);
        cb.select("e." + this.attributeName + "." + this.childIdAttributeName);
        List elementIds = cb.getResultList();
        if (elementIds.isEmpty()) {
            return Collections.emptySet();
        }
        CompositeAttributeFlusher compositeFlusher = evm.getUpdater(this.childViewToEntityMapper.getViewType(), null, null, null).getFullGraphNode();
        ArrayList<Object> elements = new ArrayList<Object>(elementIds.size());
        for (Object elementId : elementIds) {
            elements.add(evm.getReference(this.childViewToEntityMapper.getViewType().getJavaType(), compositeFlusher.createViewIdByEntityId(elementId)));
        }
        return elements;
    }

    public void removeByOwnerIdOnly(UpdateContext context, Object ownerId) {
        EntityViewManagerImpl evm = context.getEntityViewManager();
        DeleteCriteriaBuilder cb = evm.getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.parentEntityClass, "e", this.attributeName);
        cb.where(this.parentIdAttributeName).eq(ownerId);
        cb.executeUpdate();
    }

    public List<PostFlushDeleter> removeByOwnerId(UpdateContext context, Object ownerId) {
        EntityViewManagerImpl evm = context.getEntityViewManager();
        List elementIds = ((CriteriaBuilder)((CriteriaBuilder)evm.getCriteriaBuilderFactory().create(context.getEntityManager(), this.parentEntityClass, "e").where(this.parentIdAttributeName).eq(ownerId)).select("e." + this.attributeName + "." + this.childIdAttributeName)).getResultList();
        if (!elementIds.isEmpty()) {
            this.removeByOwnerIdOnly(context, ownerId);
        }
        return Collections.singletonList(new PostFlushInverseCollectionElementByIdDeleter(this.deleter, elementIds));
    }

    public void removeElement(UpdateContext context, Object ownerEntity, Object element) {
        if (this.childViewToEntityMapper != null) {
            this.removeViewElement(context, element);
        } else {
            this.removeEntityElement(context, element);
        }
    }

    public void removeElements(UpdateContext context, Iterable<?> elements) {
        if (this.childViewToEntityMapper != null) {
            for (Object element : elements) {
                this.removeViewElement(context, element);
            }
        } else {
            for (Object element : elements) {
                this.removeEntityElement(context, element);
            }
        }
    }

    private void removeViewElement(UpdateContext context, Object element) {
        this.childReferenceViewToEntityMapper.remove(context, element);
    }

    private void removeEntityElement(UpdateContext context, Object element) {
        context.getEntityManager().remove(element);
    }

    private E getParentEntityReference(UpdateContext context, Object view) {
        return (E)(view == null ? null : this.parentReferenceViewToEntityMapper.applyToEntity(context, null, view));
    }

    public void flushQuerySetElement(UpdateContext context, Object element, Object oldParent, Object view, String parameterPrefix, DirtyAttributeFlusher<?, E, Object> nestedGraphNode) {
        if (this.childViewToEntityMapper != null) {
            this.flushQuerySetEntityOnViewElement(context, element, this.getParentEntityReference(context, oldParent), this.getParentEntityReference(context, view), parameterPrefix, nestedGraphNode);
        } else {
            this.flushQuerySetEntityOnEntityElement(context, element, this.getParentEntityReference(context, oldParent), this.getParentEntityReference(context, view), parameterPrefix, nestedGraphNode);
        }
    }

    public void flushQuerySetEntityOnElement(UpdateContext context, Object element, E oldParent, E entity, String parameterPrefix, DirtyAttributeFlusher<?, E, Object> nestedGraphNode) {
        if (this.childViewToEntityMapper != null) {
            this.flushQuerySetEntityOnViewElement(context, element, oldParent, entity, parameterPrefix, nestedGraphNode);
        } else {
            this.flushQuerySetEntityOnEntityElement(context, element, oldParent, entity, parameterPrefix, nestedGraphNode);
        }
    }

    private void flushQuerySetEntityOnViewElement(UpdateContext context, Object element, E oldParent, E newValue, String parameterPrefix, DirtyAttributeFlusher<?, E, Object> nestedGraphNode) {
        this.flushQuerySetEntityOnElement(context, element, oldParent, newValue, parameterPrefix, nestedGraphNode, this.childViewToEntityMapper);
    }

    private void flushQuerySetEntityOnEntityElement(UpdateContext context, Object element, E oldParent, E newValue, String parameterPrefix, DirtyAttributeFlusher<?, E, Object> nestedGraphNode) {
        this.parentEntityOnChildEntityMapper.map(newValue, element);
        this.flushQuerySetEntityOnElement(context, element, oldParent, newValue, parameterPrefix, nestedGraphNode, this.childEntityToEntityMapper);
    }

    private void flushQuerySetEntityOnElement(UpdateContext context, Object element, E oldParent, E newValue, String parameterPrefix, DirtyAttributeFlusher<?, E, Object> nestedGraphNode, InverseElementToEntityMapper elementToEntityMapper) {
        if (this.shouldPersist(element) || nestedGraphNode != null && !nestedGraphNode.supportsQueryFlush()) {
            elementToEntityMapper.flushEntity(context, oldParent, newValue, element, nestedGraphNode);
        } else {
            int updated;
            int orphanRemovalStartIndex = context.getOrphanRemovalDeleters().size();
            Query q = elementToEntityMapper.createInverseUpdateQuery(context, element, nestedGraphNode, this.parentReferenceAttributeFlusher);
            if (nestedGraphNode != null) {
                nestedGraphNode.flushQuery(context, parameterPrefix, null, q, element, null, element, null);
            }
            this.parentReferenceAttributeFlusher.flushQuery(context, parameterPrefix, null, q, null, null, newValue, null);
            if (q != null && (updated = q.executeUpdate()) != 1) {
                throw new OptimisticLockException(null, element);
            }
            context.removeOrphans(orphanRemovalStartIndex);
        }
    }

    public void flushEntitySetElement(UpdateContext context, Iterable<?> elements, E oldParent, E newValue) {
        if (this.childViewToEntityMapper != null) {
            for (Object element : elements) {
                this.flushEntitySetViewElement(context, element, oldParent, newValue, null);
            }
        } else {
            for (Object element : elements) {
                this.flushEntitySetEntityElement(context, element, oldParent, newValue, null);
            }
        }
    }

    public void flushEntitySetElement(UpdateContext context, Object element, E oldParent, E newValue, DirtyAttributeFlusher<?, E, Object> nestedGraphNode) {
        if (this.childViewToEntityMapper != null) {
            this.flushEntitySetViewElement(context, element, oldParent, newValue, nestedGraphNode);
        } else {
            this.flushEntitySetEntityElement(context, element, oldParent, newValue, nestedGraphNode);
        }
    }

    private void flushEntitySetViewElement(UpdateContext context, Object child, E oldParent, E newParent, DirtyAttributeFlusher<?, E, Object> nestedGraphNode) {
        this.childViewToEntityMapper.flushEntity(context, oldParent, newParent, child, nestedGraphNode);
    }

    private void flushEntitySetEntityElement(UpdateContext context, Object child, E oldParent, E newParent, DirtyAttributeFlusher<?, E, Object> nestedGraphNode) {
        this.childEntityToEntityMapper.flushEntity(context, oldParent, newParent, child, nestedGraphNode);
    }

    private boolean shouldPersist(Object view) {
        return view instanceof EntityViewProxy && ((EntityViewProxy)view).$$_isNew();
    }

    public boolean supportsQueryFlush() {
        return this.parentReferenceAttributeFlusher.supportsQueryFlush();
    }
}

