/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.OptimisticLockException;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.proxy.MutableStateTrackable;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateQueryFactory;
import com.blazebit.persistence.view.impl.update.flush.BasicAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.PostFlushDeleter;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;
import com.blazebit.persistence.view.impl.update.flush.UnmappedOwnerAwareDeleter;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.VersionBasicUserType;
import java.util.Collections;
import java.util.List;
import javax.persistence.Query;

public class VersionAttributeFlusher<E, V>
extends BasicAttributeFlusher<E, V> {
    private final boolean jpaVersion;

    public VersionAttributeFlusher(String attributeName, String mapping, VersionBasicUserType<Object> userType, String updateFragment, String parameterName, AttributeAccessor entityAttributeAccessor, AttributeAccessor viewAttributeAccessor, boolean jpaVersion) {
        super(attributeName, mapping, true, false, true, false, false, false, null, new TypeDescriptor(false, false, false, false, false, false, false, false, null, null, null, null, (BasicUserType<Object>)userType, null, null, null), updateFragment, parameterName, entityAttributeAccessor, viewAttributeAccessor, null, null, null);
        this.jpaVersion = jpaVersion;
    }

    public final V nextValue(V value) {
        return (V)((VersionBasicUserType)this.elementDescriptor.getBasicUserType()).nextValue(value);
    }

    @Override
    public Query flushQuery(UpdateContext context, String parameterPrefix, UpdateQueryFactory queryFactory, Query query, Object ownerView, Object view, V value, UnmappedOwnerAwareDeleter ownerAwareDeleter) {
        if (query != null) {
            String parameter = parameterPrefix == null ? this.parameterName : parameterPrefix + this.parameterName;
            V nextValue = this.nextValue(value);
            query.setParameter(parameter, nextValue);
            ((MutableStateTrackable)view).$$_setVersion(nextValue);
        }
        return query;
    }

    public void flushQueryInitialVersion(UpdateContext context, String parameterPrefix, Query query, Object view, V value) {
        if (query != null) {
            String parameter = parameterPrefix == null ? this.parameterName : parameterPrefix + this.parameterName;
            query.setParameter(parameter, value);
        }
    }

    @Override
    public boolean flushEntity(UpdateContext context, E entity, Object ownerView, Object view, V value, Runnable postReplaceListener) {
        Object entityValue = this.entityAttributeAccessor.getValue(entity);
        if (value != entityValue && !this.elementDescriptor.getBasicUserType().isDeepEqual(value, entityValue)) {
            throw new OptimisticLockException(entity, view);
        }
        V nextValue = this.nextValue(value);
        if (!this.jpaVersion) {
            this.entityAttributeAccessor.setValue(entity, nextValue);
        }
        ((MutableStateTrackable)view).$$_setVersion(nextValue);
        return true;
    }

    @Override
    public List<PostFlushDeleter> remove(UpdateContext context, E entity, Object view, V value) {
        Object entityValue;
        if (entity != null && value != (entityValue = this.entityAttributeAccessor.getValue(entity)) && !this.elementDescriptor.getBasicUserType().isDeepEqual(value, entityValue)) {
            throw new OptimisticLockException(entity, view);
        }
        return Collections.emptyList();
    }
}

