/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.exception.ExceptionUtils;
import com.blazebit.lang.StringUtils;
import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.Path;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.AbstractCachingExpressionFactory;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.MacroConfiguration;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlMacro;
import com.blazebit.persistence.spi.PackageOpener;
import com.blazebit.persistence.view.AttributeFilterProvider;
import com.blazebit.persistence.view.ConvertOperationBuilder;
import com.blazebit.persistence.view.ConvertOption;
import com.blazebit.persistence.view.EntityViewBuilder;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.persistence.view.FlushOperationBuilder;
import com.blazebit.persistence.view.PostCommitListener;
import com.blazebit.persistence.view.PostPersistEntityListener;
import com.blazebit.persistence.view.PostPersistListener;
import com.blazebit.persistence.view.PostRemoveListener;
import com.blazebit.persistence.view.PostRollbackListener;
import com.blazebit.persistence.view.PostUpdateListener;
import com.blazebit.persistence.view.PrePersistEntityListener;
import com.blazebit.persistence.view.PrePersistListener;
import com.blazebit.persistence.view.PreRemoveListener;
import com.blazebit.persistence.view.PreUpdateListener;
import com.blazebit.persistence.view.StaticBuilder;
import com.blazebit.persistence.view.StaticMetamodel;
import com.blazebit.persistence.view.StaticRelation;
import com.blazebit.persistence.view.ViewFilterProvider;
import com.blazebit.persistence.view.ViewTransition;
import com.blazebit.persistence.view.change.SingularChangeModel;
import com.blazebit.persistence.view.filter.BetweenFilter;
import com.blazebit.persistence.view.filter.ContainsFilter;
import com.blazebit.persistence.view.filter.ContainsIgnoreCaseFilter;
import com.blazebit.persistence.view.filter.EndsWithFilter;
import com.blazebit.persistence.view.filter.EndsWithIgnoreCaseFilter;
import com.blazebit.persistence.view.filter.EqualFilter;
import com.blazebit.persistence.view.filter.GreaterOrEqualFilter;
import com.blazebit.persistence.view.filter.GreaterThanFilter;
import com.blazebit.persistence.view.filter.LessOrEqualFilter;
import com.blazebit.persistence.view.filter.LessThanFilter;
import com.blazebit.persistence.view.filter.NullFilter;
import com.blazebit.persistence.view.filter.StartsWithFilter;
import com.blazebit.persistence.view.filter.StartsWithIgnoreCaseFilter;
import com.blazebit.persistence.view.impl.EntityViewBuilderImpl;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.EntityViewConfigurationImpl;
import com.blazebit.persistence.view.impl.EntityViewListenerClassKey;
import com.blazebit.persistence.view.impl.EntityViewListenerFactory;
import com.blazebit.persistence.view.impl.EntityViewSettingHelper;
import com.blazebit.persistence.view.impl.JpqlMacroAdapter;
import com.blazebit.persistence.view.impl.MacroConfigurationExpressionFactory;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.EntityIdAttributeAccessor;
import com.blazebit.persistence.view.impl.change.ViewChangeModel;
import com.blazebit.persistence.view.impl.filter.BetweenFilterImpl;
import com.blazebit.persistence.view.impl.filter.ContainsFilterImpl;
import com.blazebit.persistence.view.impl.filter.ContainsIgnoreCaseFilterImpl;
import com.blazebit.persistence.view.impl.filter.EndsWithFilterImpl;
import com.blazebit.persistence.view.impl.filter.EndsWithIgnoreCaseFilterImpl;
import com.blazebit.persistence.view.impl.filter.EqualFilterImpl;
import com.blazebit.persistence.view.impl.filter.GreaterOrEqualFilterImpl;
import com.blazebit.persistence.view.impl.filter.GreaterThanFilterImpl;
import com.blazebit.persistence.view.impl.filter.LessOrEqualFilterImpl;
import com.blazebit.persistence.view.impl.filter.LessThanFilterImpl;
import com.blazebit.persistence.view.impl.filter.NullFilterImpl;
import com.blazebit.persistence.view.impl.filter.StartsWithFilterImpl;
import com.blazebit.persistence.view.impl.filter.StartsWithIgnoreCaseFilterImpl;
import com.blazebit.persistence.view.impl.macro.DefaultViewRootJpqlMacro;
import com.blazebit.persistence.view.impl.mapper.ConvertOperationBuilderImpl;
import com.blazebit.persistence.view.impl.mapper.ViewMapper;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.ConstrainedAttribute;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingConstructorImpl;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContextImpl;
import com.blazebit.persistence.view.impl.metamodel.ViewMetamodelImpl;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImpl;
import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import com.blazebit.persistence.view.impl.objectbuilder.ViewTypeObjectBuilderTemplate;
import com.blazebit.persistence.view.impl.proxy.ProxyFactory;
import com.blazebit.persistence.view.impl.type.DefaultBasicUserTypeRegistry;
import com.blazebit.persistence.view.impl.update.DefaultUpdateContext;
import com.blazebit.persistence.view.impl.update.EntityViewUpdaterImpl;
import com.blazebit.persistence.view.impl.update.Listeners;
import com.blazebit.persistence.view.impl.update.SimpleUpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.CompositeAttributeFlusher;
import com.blazebit.persistence.view.impl.update.listener.ViewInstancePostCommitListener;
import com.blazebit.persistence.view.impl.update.listener.ViewInstancePostPersistEntityListener;
import com.blazebit.persistence.view.impl.update.listener.ViewInstancePostRemoveListener;
import com.blazebit.persistence.view.impl.update.listener.ViewInstancePostRollbackListener;
import com.blazebit.persistence.view.impl.update.listener.ViewInstancePostUpdateListener;
import com.blazebit.persistence.view.impl.update.listener.ViewInstancePrePersistEntityListener;
import com.blazebit.persistence.view.impl.update.listener.ViewInstancePreRemoveListener;
import com.blazebit.persistence.view.impl.update.listener.ViewInstancePreUpdateListener;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.AttributeFilterMapping;
import com.blazebit.persistence.view.metamodel.AttributePath;
import com.blazebit.persistence.view.metamodel.AttributePaths;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MapAttribute;
import com.blazebit.persistence.view.metamodel.MappingConstructor;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.MethodMultiListAttribute;
import com.blazebit.persistence.view.metamodel.MethodMultiMapAttribute;
import com.blazebit.persistence.view.metamodel.MethodPluralAttribute;
import com.blazebit.persistence.view.metamodel.MethodSingularAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.ViewMetamodel;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.TransactionSupport;
import com.blazebit.persistence.view.spi.ViewJpqlMacro;
import com.blazebit.persistence.view.spi.type.DirtyStateTrackable;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import com.blazebit.reflection.ReflectionUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;

public class EntityViewManagerImpl
implements EntityViewManager {
    private static final String META_MODEL_CLASS_NAME_SUFFIX = "_";
    private static final String RELATION_CLASS_NAME_SUFFIX = "Relation";
    private static final String MULTI_RELATION_CLASS_NAME_SUFFIX = "MultiRelation";
    private static final String BUILDER_CLASS_NAME_SUFFIX = "Builder";
    private static final Set<ViewTransition> VIEW_TRANSITIONS = EnumSet.allOf(ViewTransition.class);
    private static final Method SYNTHETIC_VERSION_GETTER;
    private final CriteriaBuilderFactory cbf;
    private final JpaProvider jpaProvider;
    private final DbmsDialect dbmsDialect;
    private final ExpressionFactory expressionFactory;
    private final PackageOpener packageOpener;
    private final AttributeAccessor entityIdAccessor;
    private final ViewMetamodelImpl metamodel;
    private final ProxyFactory proxyFactory;
    private final TransactionSupport transactionSupport;
    private final Map<String, Object> optionalParameters;
    private final boolean supportsTransientReference;
    private final ConcurrentMap<ViewTypeObjectBuilderTemplate.Key, ViewTypeObjectBuilderTemplate<?>> objectBuilderCache;
    private final ConcurrentMap<ManagedViewType<?>, EntityViewUpdaterImpl> entityViewUpdaterCache;
    private final ConcurrentMap<ContextAwareUpdaterKey, EntityViewUpdaterImpl> contextAwareEntityViewUpdaterCache;
    private final ConcurrentMap<ViewMapper.Key<?, ?>, ViewMapper<?, ?>> entityViewMappers;
    private final ConcurrentMap<ViewMapperConfigKey, ViewMapper<?, ?>> configuredEntityViewMappers;
    private final ConcurrentMap<Class<?>, Constructor<?>> createConstructorCache;
    private final ConcurrentMap<Class<?>, Constructor<?>> referenceConstructorCache;
    private final ConcurrentMap<Class<?>, ListenerTypeInfo> listenerClassTypeInfo;
    private final ClassValue<EntityViewManager> serializableDelegates;
    private final Map<String, Class<? extends AttributeFilterProvider>> filterMappings;
    private final Map<Class<?>, Set<Class<?>>> javaTypeToManagedTypeJavaTypes;
    private final Map<Class<?>, Listeners> listeners;
    private final Map<Class<?>, Set<Class<?>>> convertibleManagedViewTypes;
    private final Map<ViewBuilderKey, Constructor<? extends EntityViewBuilder<?>>> viewBuilderClasses;
    private final boolean unsafeDisabled;
    private final boolean strictCascadingCheck;

    public EntityViewManagerImpl(EntityViewConfigurationImpl config, CriteriaBuilderFactory cbf) {
        this.cbf = cbf;
        this.jpaProvider = (JpaProvider)cbf.getService(JpaProvider.class);
        this.dbmsDialect = (DbmsDialect)cbf.getService(DbmsDialect.class);
        EntityMetamodel entityMetamodel = (EntityMetamodel)cbf.getService(EntityMetamodel.class);
        this.expressionFactory = (ExpressionFactory)cbf.getService(ExpressionFactory.class);
        this.packageOpener = (PackageOpener)cbf.getService(PackageOpener.class);
        this.entityIdAccessor = new EntityIdAttributeAccessor(this.jpaProvider);
        this.unsafeDisabled = Boolean.valueOf(String.valueOf(config.getProperty("com.blazebit.persistence.view.proxy.unsafe_allowed"))) == false;
        this.strictCascadingCheck = Boolean.valueOf(String.valueOf(config.getProperty("com.blazebit.persistence.view.updater.strict_cascading_check")));
        this.proxyFactory = new ProxyFactory(this.unsafeDisabled, this.strictCascadingCheck, this.packageOpener);
        this.transactionSupport = config.getTransactionSupport();
        this.optionalParameters = Collections.unmodifiableMap(new HashMap<String, Object>(config.getOptionalParameters()));
        this.serializableDelegates = new ClassValue<EntityViewManager>(){

            @Override
            protected EntityViewManager computeValue(Class<?> type) {
                try {
                    return (EntityViewManager)type.getField("SERIALIZABLE_ENTITY_VIEW_MANAGER").get(null);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        boolean validateManagedTypes = Boolean.valueOf(String.valueOf(config.getProperty("com.blazebit.persistence.view.managed_type_validation_disabled"))) == false;
        boolean validateExpressions = Boolean.valueOf(String.valueOf(config.getProperty("com.blazebit.persistence.view.expression_validation_disabled"))) == false;
        boolean scanStaticBuilder = Boolean.valueOf(String.valueOf(config.getProperty("com.blazebit.persistence.view.static_builder_scanning_disabled"))) == false;
        boolean scanStaticImplementations = Boolean.valueOf(String.valueOf(config.getProperty("com.blazebit.persistence.view.static_implementation_scanning_disabled"))) == false;
        boolean scanStaticMetamodels = Boolean.valueOf(String.valueOf(config.getProperty("com.blazebit.persistence.view.static_metamodel_scanning_disabled"))) == false;
        Set<String> errors = config.getBootContext().getErrors();
        Map functions = cbf.getRegisteredFunctions();
        HashMap<String, JpqlFunction> registeredFunctions = new HashMap<String, JpqlFunction>(functions.size());
        for (Map.Entry entry : functions.entrySet()) {
            registeredFunctions.put(((String)entry.getKey()).toLowerCase(), (JpqlFunction)entry.getValue());
        }
        MetamodelBuildingContextImpl context = new MetamodelBuildingContextImpl(config.getProperties(), new DefaultBasicUserTypeRegistry(config.getUserTypeRegistry(), cbf), entityMetamodel, this.jpaProvider, this.dbmsDialect, registeredFunctions, this.expressionFactory, this.proxyFactory, config.getBootContext().getViewMappingMap(), errors);
        ViewMetamodelImpl viewMetamodel = null;
        RuntimeException exception = null;
        Map<Class<?>, Object> typeTestValues = config.getTypeTestValues();
        try {
            viewMetamodel = new ViewMetamodelImpl(entityMetamodel, context, typeTestValues, validateManagedTypes, validateExpressions);
        }
        catch (RuntimeException ex) {
            exception = ex;
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("There are error(s) in entity views!");
            for (String error : errors) {
                sb.append('\n');
                sb.append(error);
            }
            throw new IllegalArgumentException(sb.toString(), exception);
        }
        if (exception != null) {
            throw new IllegalArgumentException("An error happened during entity view metamodel building!", exception);
        }
        this.metamodel = viewMetamodel;
        this.supportsTransientReference = this.jpaProvider.supportsTransientEntityAsParameter();
        this.objectBuilderCache = new ConcurrentHashMap();
        this.entityViewUpdaterCache = new ConcurrentHashMap();
        this.contextAwareEntityViewUpdaterCache = new ConcurrentHashMap<ContextAwareUpdaterKey, EntityViewUpdaterImpl>();
        this.entityViewMappers = new ConcurrentHashMap();
        this.configuredEntityViewMappers = new ConcurrentHashMap();
        this.createConstructorCache = new ConcurrentHashMap();
        this.referenceConstructorCache = new ConcurrentHashMap();
        this.listenerClassTypeInfo = new ConcurrentHashMap();
        this.filterMappings = new HashMap<String, Class<? extends AttributeFilterProvider>>();
        this.registerFilterMappings();
        HashMap javaTypeToManagedTypeJavaTypes = new HashMap();
        for (ManagedType managedType : entityMetamodel.getManagedTypes()) {
            Class javaType = managedType.getJavaType();
            if (javaType == null) continue;
            for (Class superType : ReflectionUtils.getSuperTypes((Class)javaType)) {
                HashSet<Class> classes = (HashSet<Class>)javaTypeToManagedTypeJavaTypes.get(superType);
                if (classes == null) {
                    classes = new HashSet<Class>();
                    javaTypeToManagedTypeJavaTypes.put(superType, classes);
                }
                classes.add(javaType);
            }
        }
        this.javaTypeToManagedTypeJavaTypes = javaTypeToManagedTypeJavaTypes;
        HashMap convertibleManagedViewTypes = new HashMap();
        HashMap listeners = new HashMap();
        HashMap viewBuilderConstructors = new HashMap();
        HashMap relationConstructors = new HashMap(viewMetamodel.getManagedViews().size());
        HashMap multiRelationConstructors = new HashMap(viewMetamodel.getManagedViews().size());
        for (ManagedViewType managedViewType : viewMetamodel.getManagedViews()) {
            Class clazz = managedViewType.getJavaType();
            Listeners l = new Listeners(managedViewType.getEntityClass());
            listeners.put(clazz, l);
            if (managedViewType.getPrePersistMethod() != null) {
                l.addPrePersistEntityListener(clazz, new ViewInstancePrePersistEntityListener(managedViewType.getPrePersistMethod()));
            }
            if (managedViewType.getPostPersistMethod() != null) {
                l.addPostPersistEntityListener(clazz, new ViewInstancePostPersistEntityListener(managedViewType.getPostPersistMethod()));
            }
            if (managedViewType.getPreUpdateMethod() != null) {
                l.addPreUpdateListener(clazz, new ViewInstancePreUpdateListener(managedViewType.getPreUpdateMethod()));
            }
            if (managedViewType.getPostUpdateMethod() != null) {
                l.addPostUpdateListener(clazz, new ViewInstancePostUpdateListener(managedViewType.getPostUpdateMethod()));
            }
            if (managedViewType.getPreRemoveMethod() != null) {
                l.addPreRemoveListener(clazz, new ViewInstancePreRemoveListener(managedViewType.getPreRemoveMethod()));
            }
            if (managedViewType.getPostRemoveMethod() != null) {
                l.addPostRemoveListener(clazz, new ViewInstancePostRemoveListener(managedViewType.getPostRemoveMethod()));
            }
            if (managedViewType.getPostCommitMethod() != null) {
                l.addPostCommitListener(clazz, new ViewInstancePostCommitListener(managedViewType.getPostCommitMethod()), managedViewType.getPostCommitTransitions());
            }
            if (managedViewType.getPostRollbackMethod() != null) {
                l.addPostRollbackListener(clazz, new ViewInstancePostRollbackListener(managedViewType.getPostRollbackMethod()), managedViewType.getPostCommitTransitions());
            }
            if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                this.proxyFactory.setImplementation(clazz);
            } else if (scanStaticImplementations) {
                this.proxyFactory.loadImplementation(errors, managedViewType, this);
            }
            if (scanStaticMetamodels) {
                this.initializeStaticMetamodel(errors, managedViewType, relationConstructors, multiRelationConstructors);
            }
            if (scanStaticBuilder) {
                EntityViewManagerImpl.initializeStaticBuilder(errors, managedViewType, viewBuilderConstructors);
            }
            HashSet<Class> classes = new HashSet<Class>();
            convertibleManagedViewTypes.put(clazz, classes);
            for (ManagedViewType<?> targetType : viewMetamodel.getManagedViews()) {
                if (!this.isConvertible(managedViewType, targetType)) continue;
                classes.add(targetType.getJavaType());
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("There are error(s) in entity views!");
            for (String string : errors) {
                sb.append('\n');
                sb.append(string);
            }
            throw new IllegalArgumentException(sb.toString(), exception);
        }
        this.convertibleManagedViewTypes = convertibleManagedViewTypes;
        this.viewBuilderClasses = viewBuilderConstructors;
        for (Map.Entry<EntityViewListenerClassKey, EntityViewListenerFactory<?>> entry : config.getBootContext().getViewListeners().entrySet()) {
            for (Class clazz : (Set)javaTypeToManagedTypeJavaTypes.get(entry.getKey().getEntityClass())) {
                Class<?> entityViewClass = entry.getKey().getEntityViewClass();
                ManagedViewType managedView = this.metamodel.managedView(entityViewClass);
                if (managedView != null && !managedView.getEntityClass().isAssignableFrom(clazz)) continue;
                Listeners l = (Listeners)listeners.get(clazz);
                if (l == null) {
                    l = new Listeners(clazz);
                    listeners.put(clazz, l);
                }
                Object listener = entry.getValue().createListener();
                Class<?> kind = entry.getValue().getListenerKind();
                if (PrePersistListener.class == kind) {
                    l.addPrePersistListener(entityViewClass, (PrePersistListener)listener);
                    continue;
                }
                if (PrePersistEntityListener.class == kind) {
                    l.addPrePersistEntityListener(entityViewClass, (PrePersistEntityListener)listener);
                    continue;
                }
                if (PostPersistListener.class == kind) {
                    l.addPostPersistListener(entityViewClass, (PostPersistListener)listener);
                    continue;
                }
                if (PostPersistEntityListener.class == kind) {
                    l.addPostPersistEntityListener(entityViewClass, (PostPersistEntityListener)listener);
                    continue;
                }
                if (PreUpdateListener.class == kind) {
                    l.addPreUpdateListener(entityViewClass, (PreUpdateListener)listener);
                    continue;
                }
                if (PostUpdateListener.class == kind) {
                    l.addPostUpdateListener(entityViewClass, (PostUpdateListener)listener);
                    continue;
                }
                if (PreRemoveListener.class == kind) {
                    l.addPreRemoveListener(entityViewClass, (PreRemoveListener)listener);
                    continue;
                }
                if (PostRemoveListener.class == kind) {
                    l.addPostRemoveListener(entityViewClass, (PostRemoveListener)listener);
                    continue;
                }
                if (PostCommitListener.class == kind) {
                    l.addPostCommitListener(entityViewClass, (PostCommitListener)listener, VIEW_TRANSITIONS);
                    continue;
                }
                if (PostRollbackListener.class != kind) continue;
                l.addPostRollbackListener(entityViewClass, (PostRollbackListener)listener, VIEW_TRANSITIONS);
            }
        }
        this.listeners = listeners;
        if (Boolean.valueOf(String.valueOf(config.getProperty("com.blazebit.persistence.view.eager_loading"))).booleanValue()) {
            for (ViewTypeImpl viewTypeImpl : this.metamodel.views()) {
                String string = StringUtils.firstToLower((CharSequence)viewTypeImpl.getEntityClass().getSimpleName());
                MacroConfigurationExpressionFactory macroAwareExpressionFactory = context.createMacroAwareExpressionFactory(string);
                ViewJpqlMacro viewJpqlMacro = (ViewJpqlMacro)macroAwareExpressionFactory.getDefaultMacroConfiguration().get("VIEW").getState()[0];
                EmbeddingViewJpqlMacro embeddingViewJpqlMacro = (EmbeddingViewJpqlMacro)macroAwareExpressionFactory.getDefaultMacroConfiguration().get("EMBEDDING_VIEW").getState()[0];
                this.getTemplate(macroAwareExpressionFactory, viewTypeImpl, null, null, viewJpqlMacro, null, embeddingViewJpqlMacro);
                for (MappingConstructor constructor : viewTypeImpl.getConstructors()) {
                    this.getTemplate(macroAwareExpressionFactory, viewTypeImpl, (MappingConstructorImpl)constructor, null, viewJpqlMacro, null, embeddingViewJpqlMacro);
                }
            }
        } else if (Boolean.valueOf(String.valueOf(config.getProperty("com.blazebit.persistence.view.proxy.eager_loading"))).booleanValue()) {
            for (ViewType viewType : this.metamodel.getViews()) {
                this.proxyFactory.getProxy(this, (ManagedViewTypeImplementor)viewType);
            }
        }
        if (Boolean.valueOf(String.valueOf(config.getProperty("com.blazebit.persistence.view.updater.eager_loading"))).booleanValue()) {
            for (ManagedViewType managedViewType : this.metamodel.getViews()) {
                this.getUpdater(null, (ManagedViewTypeImplementor)managedViewType, null, null, null);
            }
        }
    }

    private static String getMetamodelClassName(Class<?> javaType) {
        return EntityViewManagerImpl.getGeneratedClassName(javaType, META_MODEL_CLASS_NAME_SUFFIX);
    }

    private static String getGeneratedClassName(Class<?> javaType, String suffix) {
        int i;
        String fqcn = javaType.getName();
        StringBuilder sb = new StringBuilder(fqcn.length() + suffix.length());
        if (javaType.getPackage() == null) {
            i = 0;
        } else {
            String packageName = javaType.getPackage().getName();
            sb.append(packageName).append('.');
            i = packageName.length() + 1;
        }
        while (i < fqcn.length()) {
            char c = fqcn.charAt(i);
            if (c != '$') {
                sb.append(c);
            }
            ++i;
        }
        sb.append(suffix);
        return sb.toString();
    }

    private static String getRelationClassName(Class<?> javaType) {
        return EntityViewManagerImpl.getGeneratedClassName(javaType, RELATION_CLASS_NAME_SUFFIX);
    }

    private static String getMultiRelationClassName(Class<?> javaType) {
        return EntityViewManagerImpl.getGeneratedClassName(javaType, MULTI_RELATION_CLASS_NAME_SUFFIX);
    }

    private void initializeStaticMetamodel(Set<String> errors, ManagedViewType<?> managedView, Map<Class<?>, Constructor<?>> relationConstructors, Map<Class<?>, Constructor<?>> multiRelationConstructors) {
        Class<?> metamodelClass;
        Class javaType = managedView.getJavaType();
        try {
            StringWriter sw;
            metamodelClass = javaType.getClassLoader().loadClass(EntityViewManagerImpl.getMetamodelClassName(javaType));
            StaticMetamodel annotation = metamodelClass.getAnnotation(StaticMetamodel.class);
            if (annotation != null && annotation.value() != javaType) {
                errors.add("The static metamodel class '" + metamodelClass.getName() + "' was expected to be defined for the entity view type '" + javaType.getName() + "' but was defined for: " + annotation.value().getName());
                return;
            }
            Class<?> relationClass = javaType.getClassLoader().loadClass(EntityViewManagerImpl.getRelationClassName(javaType));
            StaticRelation staticRelation = relationClass.getAnnotation(StaticRelation.class);
            if (staticRelation != null && staticRelation.value() != javaType) {
                errors.add("The static relation class '" + relationClass.getName() + "' was expected to be defined for the entity view type '" + javaType.getName() + "' but was defined for: " + annotation.value().getName());
                return;
            }
            Class<?> multiRelationClass = javaType.getClassLoader().loadClass(EntityViewManagerImpl.getMultiRelationClassName(javaType));
            StaticRelation staticMultiRelation = multiRelationClass.getAnnotation(StaticRelation.class);
            if (staticMultiRelation != null && staticMultiRelation.value() != javaType) {
                errors.add("The static relation class '" + multiRelationClass.getName() + "' was expected to be defined for the entity view type '" + javaType.getName() + "' but was defined for: " + annotation.value().getName());
                return;
            }
            if (!relationConstructors.containsKey(javaType)) {
                try {
                    relationConstructors.put(javaType, relationClass.getConstructor(AttributePath.class));
                }
                catch (NoSuchMethodException e) {
                    sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    errors.add("The initialization of the static relation class '" + relationClass.getName() + "' failed: " + sw.toString());
                }
            }
            if (!multiRelationConstructors.containsKey(javaType)) {
                try {
                    multiRelationConstructors.put(javaType, multiRelationClass.getConstructor(AttributePath.class));
                }
                catch (NoSuchMethodException e) {
                    sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    errors.add("The initialization of the static relation class '" + multiRelationClass.getName() + "' failed: " + sw.toString());
                }
            }
        }
        catch (ClassNotFoundException e) {
            return;
        }
        try {
            for (MethodAttribute attribute : managedView.getAttributes()) {
                if (attribute.isSubview()) {
                    Class<?> relationClass;
                    AttributePath path;
                    Class elementType;
                    if (attribute instanceof PluralAttribute) {
                        elementType = ((PluralAttribute)attribute).getElementType().getJavaType();
                        path = AttributePaths.of((MethodPluralAttribute)((MethodPluralAttribute)attribute));
                    } else {
                        elementType = attribute.getJavaType();
                        path = AttributePaths.of((MethodSingularAttribute)((MethodSingularAttribute)attribute));
                    }
                    if (attribute instanceof MethodMultiListAttribute || attribute instanceof MethodMultiMapAttribute) {
                        Constructor<?> multiRelationConstructor = multiRelationConstructors.get(elementType);
                        if (multiRelationConstructor == null) {
                            relationClass = javaType.getClassLoader().loadClass(EntityViewManagerImpl.getMultiRelationClassName(elementType));
                            multiRelationConstructor = relationClass.getConstructor(AttributePath.class);
                            multiRelationConstructors.put(elementType, multiRelationConstructor);
                        }
                        metamodelClass.getDeclaredField(attribute.getName()).set(null, multiRelationConstructor.newInstance(path));
                    } else {
                        Constructor<?> relationConstructor = relationConstructors.get(elementType);
                        if (relationConstructor == null) {
                            relationClass = javaType.getClassLoader().loadClass(EntityViewManagerImpl.getRelationClassName(elementType));
                            relationConstructor = relationClass.getConstructor(AttributePath.class);
                            relationConstructors.put(elementType, relationConstructor);
                        }
                        metamodelClass.getDeclaredField(attribute.getName()).set(null, relationConstructor.newInstance(path));
                    }
                } else if (!SYNTHETIC_VERSION_GETTER.equals(attribute.getJavaMethod())) {
                    metamodelClass.getDeclaredField(attribute.getName()).set(null, attribute);
                }
                for (AttributeFilterMapping filter : attribute.getFilters()) {
                    String name = attribute.getName() + META_MODEL_CLASS_NAME_SUFFIX;
                    name = filter.getName().isEmpty() ? name + "filter" : name + filter.getName();
                    metamodelClass.getDeclaredField(name).set(null, filter);
                }
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            errors.add("The initialization of the static metamodel class '" + metamodelClass.getName() + "' failed: " + sw.toString());
        }
    }

    private static String getBuilderClassName(Class<?> javaType) {
        return EntityViewManagerImpl.getGeneratedClassName(javaType, BUILDER_CLASS_NAME_SUFFIX);
    }

    private static void initializeStaticBuilder(Set<String> errors, ManagedViewType<?> managedView, Map<ViewBuilderKey, Constructor<? extends EntityViewBuilder<?>>> viewBuilderConstructors) {
        Class<?> builderClass;
        Class javaType = managedView.getJavaType();
        try {
            builderClass = javaType.getClassLoader().loadClass(EntityViewManagerImpl.getBuilderClassName(javaType));
            StaticBuilder annotation = builderClass.getAnnotation(StaticBuilder.class);
            if (annotation != null && annotation.value() != javaType) {
                errors.add("The static builder class '" + builderClass.getName() + "' was expected to be defined for the entity view type '" + javaType.getName() + "' but was defined for: " + annotation.value().getName());
                return;
            }
        }
        catch (ClassNotFoundException e) {
            return;
        }
        try {
            int size = managedView.getConstructors().size();
            if (size == 0) {
                Class<?> constructorClass = javaType.getClassLoader().loadClass(builderClass.getName() + "$Init");
                viewBuilderConstructors.put(new ViewBuilderKey(managedView, null), constructorClass.getDeclaredConstructor(Map.class));
            } else if (size == 1) {
                MappingConstructor constructor = (MappingConstructor)managedView.getConstructors().iterator().next();
                Class<?> constructorClass = javaType.getClassLoader().loadClass(builderClass.getName() + "$" + Character.toUpperCase(constructor.getName().charAt(0)) + constructor.getName().substring(1));
                viewBuilderConstructors.put(new ViewBuilderKey(managedView, null), constructorClass.getDeclaredConstructor(Map.class));
                viewBuilderConstructors.put(new ViewBuilderKey(managedView, constructor), constructorClass.getDeclaredConstructor(Map.class));
            } else {
                for (MappingConstructor constructor : managedView.getConstructors()) {
                    Class<?> constructorClass = javaType.getClassLoader().loadClass(builderClass.getName() + "$" + Character.toUpperCase(constructor.getName().charAt(0)) + constructor.getName().substring(1));
                    viewBuilderConstructors.put(new ViewBuilderKey(managedView, constructor), constructorClass.getDeclaredConstructor(Map.class));
                }
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            errors.add("The initialization of the static builder class '" + builderClass.getName() + "' failed: " + sw.toString());
        }
    }

    private boolean isConvertible(ManagedViewType<?> sourceType, ManagedViewType<?> targetType) {
        if (targetType.getJavaType().isAssignableFrom(sourceType.getJavaType())) {
            return true;
        }
        if (!targetType.getEntityClass().isAssignableFrom(sourceType.getEntityClass())) {
            return false;
        }
        Set attributes = targetType.getAttributes();
        if (attributes.size() > sourceType.getAttributes().size()) {
            return false;
        }
        for (MethodAttribute targetAttribute : attributes) {
            MethodAttribute sourceAttribute = sourceType.getAttribute(targetAttribute.getName());
            if (sourceAttribute == null) {
                return false;
            }
            if (targetAttribute.isCollection()) {
                if (!sourceAttribute.isCollection()) {
                    return false;
                }
                PluralAttribute targetPluralAttribute = (PluralAttribute)targetAttribute;
                PluralAttribute sourcePluralAttribute = (PluralAttribute)sourceAttribute;
                if (sourcePluralAttribute.getCollectionType() != targetPluralAttribute.getCollectionType()) {
                    return false;
                }
                if (targetAttribute.isSubview()) {
                    if (!sourceAttribute.isSubview() || !this.isConvertible((ManagedViewType)sourcePluralAttribute.getElementType(), (ManagedViewType)targetPluralAttribute.getElementType())) {
                        return false;
                    }
                    if (targetPluralAttribute.getCollectionType() != PluralAttribute.CollectionType.MAP) continue;
                    MapAttribute targetMapAttr = (MapAttribute)targetAttribute;
                    MapAttribute sourceMapAttr = (MapAttribute)sourceAttribute;
                    if (!(targetMapAttr.isKeySubview() ? !sourceMapAttr.isKeySubview() || !this.isConvertible((ManagedViewType)sourceMapAttr.getKeyType(), (ManagedViewType)targetMapAttr.getKeyType()) : sourceMapAttr.isKeySubview() || targetMapAttr.getKeyType().getConvertedType() != sourceMapAttr.getKeyType().getConvertedType())) continue;
                    return false;
                }
                if (!sourceAttribute.isSubview() && targetPluralAttribute.getElementType().getConvertedType() == sourcePluralAttribute.getElementType().getConvertedType()) continue;
                return false;
            }
            if (targetAttribute.isSubview()) {
                return sourceAttribute.isSubview() && !sourceAttribute.isCollection() && this.isConvertible((ManagedViewType)((com.blazebit.persistence.view.metamodel.SingularAttribute)sourceAttribute).getType(), (ManagedViewType)((com.blazebit.persistence.view.metamodel.SingularAttribute)targetAttribute).getType());
            }
            if (targetAttribute.getConvertedJavaType() == sourceAttribute.getConvertedJavaType()) continue;
            return false;
        }
        return true;
    }

    public CriteriaBuilderFactory getCriteriaBuilderFactory() {
        return this.cbf;
    }

    public Map<Class<?>, Listeners> getListeners() {
        return this.listeners;
    }

    public Map<Class<?>, Set<Class<?>>> getConvertibleManagedViewTypes() {
        return this.convertibleManagedViewTypes;
    }

    public ManagedViewType<?> getListenerManagedView(Class<?> listenerClass, Class<?> listenerKindClass) {
        return this.getListenerTypeArguments(listenerClass, listenerKindClass).managedViewType;
    }

    public Class<?> getListenerEntityClass(Class<?> listenerClass, Class<?> listenerKindClass) {
        return this.getListenerTypeArguments(listenerClass, listenerKindClass).entityClass;
    }

    private ListenerTypeInfo getListenerTypeArguments(Class<?> listenerClass, Class<?> listenerKindClass) {
        ListenerTypeInfo listenerTypeInfo = (ListenerTypeInfo)this.listenerClassTypeInfo.get(listenerClass);
        if (listenerTypeInfo == null) {
            TypeVariable<Class<?>>[] typeParameters = listenerKindClass.getTypeParameters();
            Class entityViewClass = ReflectionUtils.resolveTypeVariable(listenerClass, typeParameters[0]);
            ManagedViewType managedViewType = this.metamodel.managedView(entityViewClass);
            if (managedViewType == null) {
                throw new IllegalArgumentException("Lifecycle listener class " + listenerClass.getName() + " uses a non-registered entity view type: " + entityViewClass.getName());
            }
            Class<?> entityClass = null;
            if (typeParameters.length > 1) {
                entityClass = ReflectionUtils.resolveTypeVariable(listenerClass, typeParameters[1]);
                entityClass = EntityViewManagerImpl.getCommonClass(entityClass, managedViewType.getEntityClass());
            }
            listenerTypeInfo = new ListenerTypeInfo(managedViewType, entityClass);
            this.listenerClassTypeInfo.putIfAbsent(listenerClass, listenerTypeInfo);
        }
        return listenerTypeInfo;
    }

    private static Class<?> getCommonClass(Class<?> class1, Class<?> class2) {
        if (class2.isAssignableFrom(class1)) {
            return class2;
        }
        if (class1.isAssignableFrom(class2)) {
            return class1;
        }
        throw new IllegalArgumentException("The classes [" + class1.getName() + ", " + class2.getName() + "] are not in a inheritance relationship, so there is no common class!");
    }

    public Set<Class<?>> getJavaTypeToManagedTypeJavaTypes(Class<?> javaType) {
        Set<Class<?>> classes = this.javaTypeToManagedTypeJavaTypes.get(javaType);
        if (classes == null) {
            return Collections.emptySet();
        }
        return classes;
    }

    public <T> T getService(Class<T> serviceClass) {
        if (Metamodel.class.isAssignableFrom(serviceClass)) {
            return (T)this.metamodel.getEntityMetamodel();
        }
        if (TransactionSupport.class.isAssignableFrom(serviceClass)) {
            return (T)this.transactionSupport;
        }
        if (CriteriaBuilderFactory.class.isAssignableFrom(serviceClass)) {
            return (T)this.cbf;
        }
        return (T)this.cbf.getService(serviceClass);
    }

    public ViewMetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    public Map<String, Object> getOptionalParameters() {
        return this.optionalParameters;
    }

    public JpaProvider getJpaProvider() {
        return this.jpaProvider;
    }

    public DbmsDialect getDbmsDialect() {
        return this.dbmsDialect;
    }

    public AttributeAccessor getEntityIdAccessor() {
        return this.entityIdAccessor;
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public <T> T find(EntityManager entityManager, Class<T> entityViewClass, Object entityId) {
        return this.find(entityManager, EntityViewSetting.create(entityViewClass), entityId);
    }

    public <T> T find(EntityManager entityManager, EntityViewSetting<T, CriteriaBuilder<T>> entityViewSetting, Object entityId) {
        ViewType managedViewType = this.metamodel.viewOrError(entityViewSetting.getEntityViewClass());
        EntityType entityType = (EntityType)managedViewType.getJpaManagedType();
        SingularAttribute idAttribute = JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)entityType);
        CriteriaBuilder cb = (CriteriaBuilder)this.cbf.create(entityManager, managedViewType.getEntityClass()).where(idAttribute.getName()).eq(entityId);
        List resultList = this.applySetting(entityViewSetting, cb).getResultList();
        return resultList.isEmpty() ? null : (T)resultList.get(0);
    }

    public <T> T getReference(Class<T> entityViewClass, Object id) {
        Constructor constructor = (Constructor)this.referenceConstructorCache.get(entityViewClass);
        try {
            ViewType managedViewType = this.metamodel.viewOrError(entityViewClass);
            if (constructor == null) {
                Class proxyClass = this.proxyFactory.getProxy(this, managedViewType);
                constructor = proxyClass.getConstructor(managedViewType.getIdAttribute().getConvertedJavaType());
                this.referenceConstructorCache.put(entityViewClass, constructor);
            }
            if (!managedViewType.getIdAttribute().getJavaType().isInstance(id)) {
                id = this.getUpdater(null, (ManagedViewTypeImplementor<?>)managedViewType, null, null, null).getFullGraphNode().createViewIdByEntityId(id);
            }
            return constructor.newInstance(id);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't instantiate entity view object for type: " + entityViewClass.getName() + "\nDid you forget to add a no-args constructor to the view? Consider adding a no-args constructor annotated with @ViewConstructor(\"reference\").", e);
        }
    }

    public Object getEntityId(EntityManager entityManager, EntityViewProxy proxy) {
        SimpleUpdateContext context = new SimpleUpdateContext(this, entityManager);
        Class entityViewClass = proxy.$$_getEntityViewClass();
        ManagedViewType viewType = this.metamodel.managedViewOrError(entityViewClass);
        EntityViewUpdaterImpl updater = this.getUpdater(null, (ManagedViewTypeImplementor<?>)viewType, null, null, null);
        return ((CompositeAttributeFlusher)updater.getFullGraphNode()).getEntityIdCopy(context, proxy);
    }

    public <T> T getEntityReference(EntityManager entityManager, Object view) {
        if (!(view instanceof EntityViewProxy)) {
            throw new IllegalArgumentException("Can't retrieve entity reference for non entity view object: " + view);
        }
        EntityViewProxy proxy = (EntityViewProxy)view;
        return (T)entityManager.getReference(proxy.$$_getJpaManagedClass(), this.getEntityId(entityManager, proxy));
    }

    public <T> T create(Class<T> entityViewClass) {
        return this.create0(entityViewClass, this.optionalParameters);
    }

    public <T> T create(Class<T> entityViewClass, Map<String, Object> optionalParameters) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.optionalParameters);
        map.putAll(optionalParameters);
        return this.create0(entityViewClass, Collections.unmodifiableMap(map));
    }

    public <T> T create0(Class<T> entityViewClass, Map<String, Object> optionalParameters) {
        block4: {
            Constructor constructor = (Constructor)this.createConstructorCache.get(entityViewClass);
            try {
                if (constructor == null) {
                    ManagedViewType managedViewType = this.metamodel.managedViewOrError(entityViewClass);
                    if (!managedViewType.isCreatable()) break block4;
                    Class proxyClass = this.proxyFactory.getProxy(this, managedViewType);
                    constructor = proxyClass.getConstructor(proxyClass, Map.class);
                    this.createConstructorCache.put(entityViewClass, constructor);
                }
                return constructor.newInstance(null, optionalParameters);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Couldn't instantiate entity view object for type: " + entityViewClass.getName() + "\nDid you forget to add a no-args constructor to the view? Consider adding a no-args constructor annotated with @ViewConstructor(\"create\").", e);
            }
        }
        throw new IllegalArgumentException("Can't create instance of non-creatable view type: " + entityViewClass.getName() + "\nDid you forget to annotate it with @CreatableEntityView?");
    }

    public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz) {
        return this.createBuilder((X)clazz, null, null);
    }

    public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz, String constructorName) {
        return this.createBuilder((X)clazz, null, constructorName);
    }

    public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz, Map<String, Object> optionalParameters) {
        return this.createBuilder((X)clazz, optionalParameters, null);
    }

    public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz, Map<String, Object> optionalParameters, String constructorName) {
        ManagedViewType managedViewTypeImplementor = this.metamodel.managedViewOrError((Class)clazz);
        MappingConstructorImpl mappingConstructor = null;
        if (constructorName != null) {
            mappingConstructor = (MappingConstructorImpl)managedViewTypeImplementor.getConstructor(constructorName);
        }
        if (optionalParameters == null || optionalParameters.isEmpty()) {
            optionalParameters = this.optionalParameters;
        } else {
            Map<String, Object> tempOptionalParameters = optionalParameters;
            optionalParameters = new HashMap<String, Object>(optionalParameters.size() + this.optionalParameters.size());
            optionalParameters.putAll(this.optionalParameters);
            optionalParameters.putAll(tempOptionalParameters);
        }
        Constructor<EntityViewBuilder<?>> viewBuilderConstructor = this.viewBuilderClasses.get(new ViewBuilderKey(managedViewTypeImplementor, mappingConstructor));
        if (viewBuilderConstructor == null) {
            return new EntityViewBuilderImpl(this, managedViewTypeImplementor, mappingConstructor, optionalParameters);
        }
        try {
            return viewBuilderConstructor.newInstance(optionalParameters);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not construct view builder for entity view: " + clazz.getName(), e);
        }
    }

    public <X> EntityViewBuilder<X> createBuilder(X view) {
        return this.createBuilder(view, null, null);
    }

    public <X> EntityViewBuilder<X> createBuilder(X view, String constructorName) {
        return this.createBuilder(view, null, constructorName);
    }

    public <X> EntityViewBuilder<X> createBuilder(X view, Map<String, Object> optionalParameters) {
        return this.createBuilder(view, optionalParameters, null);
    }

    public <X> EntityViewBuilder<X> createBuilder(X view, Map<String, Object> optionalParameters, String constructorName) {
        Class clazz = ((EntityViewProxy)view).$$_getEntityViewClass();
        EntityViewBuilder<Class> builder = this.createBuilder((X)clazz, optionalParameters, constructorName);
        if (builder instanceof EntityViewBuilderImpl) {
            EntityViewBuilderImpl builderImpl = (EntityViewBuilderImpl)builder;
            ManagedViewTypeImpl.InheritanceSubtypeConfiguration inheritanceSubtypeConfiguration = builderImpl.getManagedViewType().getInheritanceSubtypeConfiguration(null);
            Object[] tuple = builderImpl.getTuple();
            for (ConstrainedAttribute<AbstractMethodAttribute<X, ?>> constrainedAttribute : inheritanceSubtypeConfiguration.getAttributesClosure().values()) {
                tuple[constrainedAttribute.getAttribute().getAttributeIndex()] = EntityViewManagerImpl.getValueForBuilder(constrainedAttribute, view, optionalParameters);
            }
        } else {
            ManagedViewType managedViewTypeImplementor = this.metamodel.managedViewOrError(clazz);
            ManagedViewTypeImpl.InheritanceSubtypeConfiguration inheritanceSubtypeConfiguration = managedViewTypeImplementor.getInheritanceSubtypeConfiguration(null);
            for (ConstrainedAttribute<AbstractMethodAttribute<X, ?>> value : inheritanceSubtypeConfiguration.getAttributesClosure().values()) {
                builder.with(value.getAttribute().getName(), EntityViewManagerImpl.getValueForBuilder(value, view, optionalParameters));
            }
        }
        return builder;
    }

    private static <X> Object getValueForBuilder(ConstrainedAttribute<AbstractMethodAttribute<? super X, ?>> value, X view, Map<String, Object> optionalParameters) {
        Object newValue;
        if (value.getAttribute().isCollection()) {
            ContainerAccumulator<?> containerAccumulator = value.getAttribute().getContainerAccumulator();
            newValue = containerAccumulator.createContainer(value.getAttribute().needsDirtyTracker(), 0);
            containerAccumulator.addAll(newValue, value.getAttribute().getValue(view), value.getAttribute().needsDirtyTracker());
        } else {
            newValue = value.getAttribute().getValue(view);
            if (newValue == null && value.getAttribute().getMappingType() == Attribute.MappingType.PARAMETER) {
                newValue = optionalParameters.get(value.getAttribute().getMapping());
            }
        }
        return newValue;
    }

    public <T> T convert(Object source, Class<T> entityViewClass, ConvertOption ... convertOptions) {
        return this.getViewMapper(ViewMapper.Key.create((ViewMetamodel)this.metamodel, source, entityViewClass, null, convertOptions)).map(source, this.optionalParameters);
    }

    public <T> T convert(Object source, Class<T> entityViewClass, String constructorName, ConvertOption ... convertOptions) {
        return this.getViewMapper(ViewMapper.Key.create((ViewMetamodel)this.metamodel, source, entityViewClass, constructorName, convertOptions)).map(source, this.optionalParameters);
    }

    public <T> T convert(Object source, Class<T> entityViewClass, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.optionalParameters);
        map.putAll(optionalParameters);
        return this.getViewMapper(ViewMapper.Key.create((ViewMetamodel)this.metamodel, source, entityViewClass, null, convertOptions)).map(source, Collections.unmodifiableMap(map));
    }

    public <T> T convert(Object source, Class<T> entityViewClass, String constructorName, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.optionalParameters);
        map.putAll(optionalParameters);
        return this.getViewMapper(ViewMapper.Key.create((ViewMetamodel)this.metamodel, source, entityViewClass, constructorName, convertOptions)).map(source, Collections.unmodifiableMap(map));
    }

    public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, ConvertOption ... convertOptions) {
        return new ConvertOperationBuilderImpl<T>(this, ViewMapper.Key.create((ViewMetamodel)this.metamodel, source, entityViewClass, null, convertOptions), source, this.optionalParameters);
    }

    public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, String constructorName, ConvertOption ... convertOptions) {
        return new ConvertOperationBuilderImpl<T>(this, ViewMapper.Key.create((ViewMetamodel)this.metamodel, source, entityViewClass, constructorName, convertOptions), source, this.optionalParameters);
    }

    public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.optionalParameters);
        map.putAll(optionalParameters);
        return new ConvertOperationBuilderImpl<T>(this, ViewMapper.Key.create((ViewMetamodel)this.metamodel, source, entityViewClass, null, convertOptions), source, Collections.unmodifiableMap(map));
    }

    public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, String constructorName, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.optionalParameters);
        map.putAll(optionalParameters);
        return new ConvertOperationBuilderImpl<T>(this, ViewMapper.Key.create((ViewMetamodel)this.metamodel, source, entityViewClass, constructorName, convertOptions), source, Collections.unmodifiableMap(map));
    }

    public final <S, T> ViewMapper<S, T> getViewMapper(ViewMapper.Key<Object, T> key) {
        ViewMapper<Object, T> old;
        ViewMapper<Object, T> viewMapper = (ViewMapper<Object, T>)this.entityViewMappers.get(key);
        if (viewMapper == null && (old = this.entityViewMappers.putIfAbsent(key, viewMapper = key.createViewMapper(this, this.proxyFactory, Collections.emptyMap()))) != null) {
            viewMapper = old;
        }
        return viewMapper;
    }

    public final <S, T> ViewMapper<S, T> getViewMapper(ViewMapper.Key<Object, T> viewMapperKey, Map<String, ViewMapper.Key<Object, Object>> subMappers) {
        ViewMapper old;
        ViewMapperConfigKey key = new ViewMapperConfigKey(viewMapperKey, subMappers);
        ViewMapper viewMapper = (ViewMapper)this.configuredEntityViewMappers.get(key);
        if (viewMapper == null && (old = this.configuredEntityViewMappers.putIfAbsent(key, viewMapper = key.key.createViewMapper(this, this.proxyFactory, key.subMappers))) != null) {
            viewMapper = old;
        }
        return viewMapper;
    }

    public <T> SingularChangeModel<T> getChangeModel(T entityView) {
        if (!(entityView instanceof DirtyStateTrackable)) {
            throw new IllegalArgumentException("Change model can only be accessed for updatable entity views that use dirty tracking! Switch to the LAZY or PARTIAL FlushMode instead!");
        }
        DirtyStateTrackable updatableProxy = (DirtyStateTrackable)entityView;
        Class entityViewClass = updatableProxy.$$_getEntityViewClass();
        ManagedViewType viewType = this.metamodel.managedViewOrError(entityViewClass);
        EntityViewUpdaterImpl updater = this.getUpdater(null, (ManagedViewTypeImplementor<?>)viewType, null, null, null);
        return new ViewChangeModel<DirtyStateTrackable>((ManagedViewTypeImplementor<DirtyStateTrackable>)viewType, updatableProxy, updater.getDirtyChecker());
    }

    public void update(EntityManager entityManager, Object view) {
        this.save(entityManager, view);
    }

    public void updateFull(EntityManager entityManager, Object view) {
        this.saveFull(entityManager, view);
    }

    public void save(EntityManager em, Object view) {
        this.update(em, view, false);
    }

    public void saveFull(EntityManager em, Object view) {
        this.update(em, view, true);
    }

    public void saveTo(EntityManager em, Object view, Object entity) {
        this.updateTo(em, view, entity, false);
    }

    public void saveFullTo(EntityManager em, Object view, Object entity) {
        this.updateTo(em, view, entity, true);
    }

    public void remove(EntityManager entityManager, Object view) {
        this.remove(new DefaultUpdateContext(this, entityManager, false, false, true, null, view, null), view);
    }

    public void remove(UpdateContext context, Object view) {
        if (!(view instanceof EntityViewProxy)) {
            throw new IllegalArgumentException("Can't remove non entity view object: " + view);
        }
        EntityViewProxy proxy = (EntityViewProxy)view;
        Class entityViewClass = proxy.$$_getEntityViewClass();
        ManagedViewType viewType = this.metamodel.managedViewOrError(entityViewClass);
        EntityViewUpdaterImpl updater = this.getUpdater(null, (ManagedViewTypeImplementor<?>)viewType, null, null, null);
        try {
            if (proxy.$$_isNew()) {
                MutableStateTrackable updatableProxy = (MutableStateTrackable)proxy;
                if (updatableProxy.$$_hasParent()) {
                    throw new IllegalStateException("Can't remove not-yet-persisted object [" + view + "] that is referenced by: " + updatableProxy.$$_getParent());
                }
            } else {
                MutableStateTrackable updatableProxy;
                if (proxy instanceof MutableStateTrackable && (updatableProxy = (MutableStateTrackable)proxy).$$_hasParent()) {
                    throw new IllegalStateException("Can't remove object [" + view + "] that is still referenced by: " + updatableProxy.$$_getParent());
                }
                updater.remove(context, proxy);
            }
        }
        catch (Throwable t) {
            context.getTransactionAccess().markRollbackOnly();
            ExceptionUtils.doThrow((Throwable)t);
        }
    }

    public void remove(EntityManager entityManager, Class<?> entityViewClass, Object viewId) {
        this.remove(new DefaultUpdateContext(this, entityManager, false, false, true, entityViewClass, viewId, null), entityViewClass, viewId);
    }

    public void remove(UpdateContext context, Class<?> entityViewClass, Object viewId) {
        ManagedViewType viewType = this.metamodel.managedView(entityViewClass);
        if (viewType == null) {
            throw new IllegalArgumentException("Can't remove non entity view object: " + entityViewClass.getName());
        }
        EntityViewUpdaterImpl updater = this.getUpdater(null, (ManagedViewTypeImplementor<?>)viewType, null, null, null);
        try {
            updater.remove(context, viewId);
        }
        catch (Throwable t) {
            context.getTransactionAccess().markRollbackOnly();
            ExceptionUtils.doThrow((Throwable)t);
        }
    }

    public FlushOperationBuilder removeWith(EntityManager entityManager, Object view) {
        return new DefaultUpdateContext(this, entityManager, false, false, true, null, view, null);
    }

    public FlushOperationBuilder removeWith(EntityManager entityManager, Class<?> entityViewClass, Object viewId) {
        return new DefaultUpdateContext(this, entityManager, false, false, true, entityViewClass, viewId, null);
    }

    public void update(EntityManager em, Object view, boolean forceFull) {
        this.update(new DefaultUpdateContext(this, em, forceFull, false, false, null, view, null), view);
    }

    public void updateTo(EntityManager em, Object view, Object entity, boolean forceFull) {
        this.updateTo(new DefaultUpdateContext(this, em, forceFull, true, false, null, view, null), view, entity);
    }

    public FlushOperationBuilder saveWith(EntityManager em, Object view) {
        return new DefaultUpdateContext(this, em, false, false, false, null, view, null);
    }

    public FlushOperationBuilder saveFullWith(EntityManager em, Object view) {
        return new DefaultUpdateContext(this, em, true, false, false, null, view, null);
    }

    public FlushOperationBuilder saveWithTo(EntityManager em, Object view, Object entity) {
        return new DefaultUpdateContext(this, em, false, true, false, null, view, entity);
    }

    public FlushOperationBuilder saveFullWithTo(EntityManager em, Object view, Object entity) {
        return new DefaultUpdateContext(this, em, true, true, false, null, view, entity);
    }

    public void update(UpdateContext context, Object view) {
        if (!(view instanceof MutableStateTrackable)) {
            throw new IllegalArgumentException("Can't update non-updatable entity views: " + view);
        }
        MutableStateTrackable updatableProxy = (MutableStateTrackable)view;
        Class entityViewClass = updatableProxy.$$_getEntityViewClass();
        ManagedViewType viewType = this.metamodel.managedViewOrError(entityViewClass);
        EntityViewUpdaterImpl updater = this.getUpdater(null, (ManagedViewTypeImplementor<?>)viewType, null, null, null);
        try {
            if (updatableProxy.$$_isNew()) {
                updater.executePersist(context, updatableProxy);
            } else {
                updater.executeUpdate(context, updatableProxy);
            }
        }
        catch (Throwable t) {
            context.getTransactionAccess().markRollbackOnly();
            ExceptionUtils.doThrow((Throwable)t);
        }
    }

    public void updateTo(UpdateContext context, Object view, Object entity) {
        if (!(view instanceof MutableStateTrackable)) {
            throw new IllegalArgumentException("Can't update non-updatable entity views: " + view);
        }
        MutableStateTrackable updatableProxy = (MutableStateTrackable)view;
        if (updatableProxy.$$_isNew()) {
            throw new IllegalArgumentException("Can't flush new entity view to existing entity: " + view);
        }
        Class entityViewClass = updatableProxy.$$_getEntityViewClass();
        ManagedViewType viewType = this.metamodel.managedViewOrError(entityViewClass);
        EntityViewUpdaterImpl updater = this.getUpdater(null, (ManagedViewTypeImplementor<?>)viewType, null, null, null);
        try {
            updater.executeUpdate(context, entity, updatableProxy);
        }
        catch (Throwable t) {
            context.getTransactionAccess().markRollbackOnly();
            ExceptionUtils.doThrow((Throwable)t);
        }
    }

    public Object persist(UpdateContext context, Object view) {
        if (!(view instanceof MutableStateTrackable)) {
            throw new IllegalArgumentException("Can't persist non-updatable entity views: " + view);
        }
        MutableStateTrackable updatableProxy = (MutableStateTrackable)view;
        Class entityViewClass = updatableProxy.$$_getEntityViewClass();
        ManagedViewType viewType = this.metamodel.managedViewOrError(entityViewClass);
        EntityViewUpdaterImpl updater = this.getUpdater(null, (ManagedViewTypeImplementor<?>)viewType, null, null, null);
        return updater.executePersist(context, updatableProxy);
    }

    public <T, Q extends FullQueryBuilder<T, Q>> Q applySetting(EntityViewSetting<T, Q> setting, CriteriaBuilder<?> criteriaBuilder) {
        return EntityViewSettingHelper.apply(setting, this, criteriaBuilder, null);
    }

    public <T, Q extends FullQueryBuilder<T, Q>> Q applySetting(EntityViewSetting<T, Q> setting, CriteriaBuilder<?> criteriaBuilder, String entityViewRoot) {
        return EntityViewSettingHelper.apply(setting, this, criteriaBuilder, entityViewRoot);
    }

    public boolean isUnsafeDisabled() {
        return this.unsafeDisabled;
    }

    public boolean supportsTransientReference() {
        return this.supportsTransientReference;
    }

    public <T extends ViewFilterProvider> T createViewFilter(Class<T> filterClass) {
        try {
            return (T)((ViewFilterProvider)filterClass.newInstance());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not instantiate the view filter class: " + filterClass.getName(), ex);
        }
    }

    public <T extends AttributeFilterProvider<?>> T createAttributeFilter(Class<T> filterClass, Class<?> expectedType, Object argument) {
        Class<? extends AttributeFilterProvider> filterClassImpl = this.filterMappings.get(filterClass.getName());
        if (filterClassImpl == null) {
            return this.createFilterInstance(filterClass, expectedType, argument);
        }
        return (T)this.createFilterInstance(filterClassImpl, expectedType, argument);
    }

    private <T extends AttributeFilterProvider<?>> T createFilterInstance(Class<T> filterClass, Class<?> expectedType, Object argument) {
        try {
            Constructor<?>[] constructors = filterClass.getDeclaredConstructors();
            Constructor<?> filterConstructor = this.findConstructor(constructors, Class.class, Object.class);
            if (filterConstructor != null) {
                return (T)((AttributeFilterProvider)filterConstructor.newInstance(expectedType, argument));
            }
            filterConstructor = this.findConstructor(constructors, Class.class);
            if (filterConstructor != null) {
                return (T)((AttributeFilterProvider)filterConstructor.newInstance(expectedType));
            }
            filterConstructor = this.findConstructor(constructors, Object.class);
            if (filterConstructor != null) {
                return (T)((AttributeFilterProvider)filterConstructor.newInstance(argument));
            }
            filterConstructor = this.findConstructor(constructors, new Class[0]);
            if (filterConstructor == null) {
                throw new IllegalArgumentException("No suitable constructor found for filter class '" + filterClass.getName() + "'");
            }
            return (T)((AttributeFilterProvider)filterConstructor.newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not create an instance of the filter class '" + filterClass.getName() + "'", ex);
        }
    }

    private <T> Constructor<T> findConstructor(Constructor<T>[] constructors, Class<?> ... classes) {
        for (int i = 0; i < constructors.length; ++i) {
            if (!Arrays.equals(constructors[i].getParameterTypes(), classes)) continue;
            return constructors[i];
        }
        return null;
    }

    public ObjectBuilder<?> createObjectBuilder(ManagedViewTypeImplementor<?> viewType, MappingConstructorImpl<?> mappingConstructor, String entityViewRoot, String embeddingViewPath, FullQueryBuilder<?, ?> criteriaBuilder, EntityViewConfiguration configuration, int offset, int suffix, boolean nullFlatViewIfEmpty) {
        Path root = EntityViewManagerImpl.getPath(criteriaBuilder, entityViewRoot);
        return this.createObjectBuilder(viewType, mappingConstructor, root.getJavaType(), root.getPath(), embeddingViewPath, criteriaBuilder, configuration, offset, suffix, nullFlatViewIfEmpty);
    }

    public ObjectBuilder<?> createObjectBuilder(ManagedViewTypeImplementor<?> viewType, MappingConstructorImpl<?> mappingConstructor, Class<?> rootType, String entityViewRoot, String embeddingViewPath, FullQueryBuilder<?, ?> criteriaBuilder, EntityViewConfiguration configuration, int offset, int suffix, boolean nullFlatViewIfEmpty) {
        ExpressionFactory ef = (ExpressionFactory)criteriaBuilder.getService(ExpressionFactory.class);
        if (!viewType.getEntityClass().isAssignableFrom(rootType)) {
            if (rootType.isAssignableFrom(viewType.getEntityClass())) {
                entityViewRoot = "TREAT(" + entityViewRoot + " AS " + this.metamodel.getEntityMetamodel().getEntity(viewType.getJavaType()).getName() + ")";
            } else {
                throw new IllegalArgumentException("The given view type with the entity type '" + viewType.getEntityClass().getName() + "' can not be applied to the query builder with result type '" + rootType.getName() + "'");
            }
        }
        MacroConfiguration originalMacroConfiguration = ef.getDefaultMacroConfiguration();
        ExpressionFactory cachingExpressionFactory = ef.unwrap(AbstractCachingExpressionFactory.class);
        DefaultViewRootJpqlMacro viewRootJpqlMacro = new DefaultViewRootJpqlMacro(entityViewRoot);
        ViewJpqlMacro viewJpqlMacro = configuration.getViewJpqlMacro();
        EmbeddingViewJpqlMacro embeddingViewJpqlMacro = configuration.getEmbeddingViewJpqlMacro();
        viewJpqlMacro.setViewPath(entityViewRoot);
        HashMap<String, JpqlMacroAdapter> macros = new HashMap<String, JpqlMacroAdapter>();
        macros.put("view", new JpqlMacroAdapter((JpqlMacro)viewJpqlMacro, cachingExpressionFactory));
        macros.put("view_root", new JpqlMacroAdapter((JpqlMacro)viewRootJpqlMacro, cachingExpressionFactory));
        macros.put("embedding_view", new JpqlMacroAdapter((JpqlMacro)embeddingViewJpqlMacro, cachingExpressionFactory));
        MacroConfiguration macroConfiguration = originalMacroConfiguration.with(macros);
        MacroConfigurationExpressionFactory macroEf = new MacroConfigurationExpressionFactory(cachingExpressionFactory, macroConfiguration);
        criteriaBuilder.registerMacro("view_root", (JpqlMacro)viewRootJpqlMacro);
        return this.getTemplate(macroEf, viewType, mappingConstructor, entityViewRoot, viewJpqlMacro, embeddingViewPath, embeddingViewJpqlMacro, offset).createObjectBuilder((ParameterHolder<?>)criteriaBuilder, configuration.getOptionalParameters(), configuration, suffix, false, nullFlatViewIfEmpty);
    }

    private static Path getPath(FullQueryBuilder<?, ?> queryBuilder, String entityViewRoot) {
        return queryBuilder.getRequiredPath(entityViewRoot);
    }

    public ViewTypeObjectBuilderTemplate<?> getTemplate(MacroConfigurationExpressionFactory ef, ViewTypeImpl<?> viewType, MappingConstructorImpl<?> mappingConstructor, String entityViewRoot, ViewJpqlMacro viewJpqlMacro, String embeddingViewPath, EmbeddingViewJpqlMacro embeddingViewJpqlMacro) {
        return this.getTemplate(ef, viewType, mappingConstructor, entityViewRoot, viewJpqlMacro, embeddingViewPath, embeddingViewJpqlMacro, 0);
    }

    public ViewTypeObjectBuilderTemplate<?> getTemplate(MacroConfigurationExpressionFactory ef, ManagedViewTypeImplementor<?> viewType, MappingConstructorImpl<?> mappingConstructor, String entityViewRoot, ViewJpqlMacro viewJpqlMacro, String embeddingViewPath, EmbeddingViewJpqlMacro embeddingViewJpqlMacro, int offset) {
        ViewTypeObjectBuilderTemplate<?> oldValue;
        ViewTypeObjectBuilderTemplate.Key key = new ViewTypeObjectBuilderTemplate.Key(ef, viewType, mappingConstructor, entityViewRoot, embeddingViewPath, offset);
        if (!key.isCacheable()) {
            return key.createValue(this, this.proxyFactory, viewJpqlMacro, embeddingViewJpqlMacro, ef);
        }
        ViewTypeObjectBuilderTemplate<?> value = (ViewTypeObjectBuilderTemplate<?>)this.objectBuilderCache.get(key);
        if (value == null && (oldValue = this.objectBuilderCache.putIfAbsent(key, value = key.createValue(this, this.proxyFactory, viewJpqlMacro, embeddingViewJpqlMacro, ef))) != null) {
            value = oldValue;
        }
        return value;
    }

    public void addUpdater(Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewTypeImplementor<?> viewType, ManagedViewTypeImplementor<?> declaredViewType, EntityViewUpdaterImpl owner, String ownerMapping, EntityViewUpdaterImpl updater) {
        if (declaredViewType != null && declaredViewType != viewType || owner != null) {
            ContextAwareUpdaterKey key = new ContextAwareUpdaterKey(viewType, declaredViewType, owner, ownerMapping);
            localCache.put(key, updater);
        } else {
            localCache.put(viewType, updater);
        }
    }

    public EntityViewUpdaterImpl getUpdater(Map<Object, EntityViewUpdaterImpl> localCache, ManagedViewTypeImplementor<?> viewType, ManagedViewTypeImplementor<?> declaredViewType, EntityViewUpdaterImpl owner, String ownerMapping) {
        EntityViewUpdaterImpl value;
        if (declaredViewType != null && declaredViewType != viewType || owner != null) {
            EntityViewUpdaterImpl value2;
            ContextAwareUpdaterKey key = new ContextAwareUpdaterKey(viewType, declaredViewType, owner, ownerMapping);
            if ((localCache == null || (value2 = localCache.get(key)) == null) && (value2 = (EntityViewUpdaterImpl)this.contextAwareEntityViewUpdaterCache.get(key)) == null) {
                value2 = new EntityViewUpdaterImpl(this, localCache == null ? (localCache = new HashMap<Object, EntityViewUpdaterImpl>()) : localCache, viewType, declaredViewType, owner, ownerMapping);
                this.contextAwareEntityViewUpdaterCache.putAll(localCache);
            }
            return value2;
        }
        if ((localCache == null || (value = localCache.get(viewType)) == null) && (value = (EntityViewUpdaterImpl)this.entityViewUpdaterCache.get(viewType)) == null) {
            value = new EntityViewUpdaterImpl(this, localCache == null ? (localCache = new HashMap<Object, EntityViewUpdaterImpl>()) : localCache, viewType, null, null, null);
            this.entityViewUpdaterCache.putAll(localCache);
        }
        return value;
    }

    private void registerFilterMappings() {
        this.filterMappings.put(ContainsFilter.class.getName(), ContainsFilterImpl.class);
        this.filterMappings.put(ContainsIgnoreCaseFilter.class.getName(), ContainsIgnoreCaseFilterImpl.class);
        this.filterMappings.put(StartsWithFilter.class.getName(), StartsWithFilterImpl.class);
        this.filterMappings.put(StartsWithIgnoreCaseFilter.class.getName(), StartsWithIgnoreCaseFilterImpl.class);
        this.filterMappings.put(EndsWithFilter.class.getName(), EndsWithFilterImpl.class);
        this.filterMappings.put(EndsWithIgnoreCaseFilter.class.getName(), EndsWithIgnoreCaseFilterImpl.class);
        this.filterMappings.put(EqualFilter.class.getName(), EqualFilterImpl.class);
        this.filterMappings.put(NullFilter.class.getName(), NullFilterImpl.class);
        this.filterMappings.put(GreaterThanFilter.class.getName(), GreaterThanFilterImpl.class);
        this.filterMappings.put(GreaterOrEqualFilter.class.getName(), GreaterOrEqualFilterImpl.class);
        this.filterMappings.put(LessThanFilter.class.getName(), LessThanFilterImpl.class);
        this.filterMappings.put(LessOrEqualFilter.class.getName(), LessOrEqualFilterImpl.class);
        this.filterMappings.put(BetweenFilter.class.getName(), BetweenFilterImpl.class);
    }

    public EntityViewManager getSerializableDelegate(Class<?> entityViewClass) {
        return this.serializableDelegates.get(this.proxyFactory.getProxy(this, this.metamodel.managedViewOrError(entityViewClass)));
    }

    public void close() {
        this.proxyFactory.clear();
    }

    static {
        try {
            SYNTHETIC_VERSION_GETTER = EntityViewProxy.class.getMethod("$$_getVersion", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ViewBuilderKey {
        private final ManagedViewType<?> managedViewType;
        private final MappingConstructor<?> constructor;

        public ViewBuilderKey(ManagedViewType<?> managedViewType, MappingConstructor<?> constructor) {
            this.managedViewType = managedViewType;
            this.constructor = constructor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ViewBuilderKey)) {
                return false;
            }
            ViewBuilderKey that = (ViewBuilderKey)o;
            if (!this.managedViewType.equals(that.managedViewType)) {
                return false;
            }
            return this.constructor != null ? this.constructor.equals(that.constructor) : that.constructor == null;
        }

        public int hashCode() {
            int result = this.managedViewType.hashCode();
            result = 31 * result + (this.constructor != null ? this.constructor.hashCode() : 0);
            return result;
        }
    }

    private static class ListenerTypeInfo {
        private final ManagedViewType<?> managedViewType;
        private final Class<?> entityClass;

        public ListenerTypeInfo(ManagedViewType<?> managedViewType, Class<?> entityClass) {
            this.managedViewType = managedViewType;
            this.entityClass = entityClass;
        }
    }

    private static class ViewMapperConfigKey {
        private final ViewMapper.Key<?, ?> key;
        private final Map<String, ViewMapper.Key<Object, Object>> subMappers;

        public ViewMapperConfigKey(ViewMapper.Key<?, ?> key, Map<String, ViewMapper.Key<Object, Object>> subMappers) {
            this.key = key;
            this.subMappers = subMappers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ViewMapperConfigKey)) {
                return false;
            }
            ViewMapperConfigKey that = (ViewMapperConfigKey)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return this.subMappers.equals(that.subMappers);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.subMappers.hashCode();
            return result;
        }
    }

    private static class ContextAwareUpdaterKey {
        private final ManagedViewTypeImplementor<?> viewType;
        private final ManagedViewTypeImplementor<?> declaredViewType;
        private final EntityViewUpdaterImpl owner;
        private final String ownerMapping;

        public ContextAwareUpdaterKey(ManagedViewTypeImplementor<?> viewType, ManagedViewTypeImplementor<?> declaredViewType, EntityViewUpdaterImpl owner, String ownerMapping) {
            this.viewType = viewType;
            this.declaredViewType = declaredViewType;
            this.owner = owner;
            this.ownerMapping = ownerMapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContextAwareUpdaterKey)) {
                return false;
            }
            ContextAwareUpdaterKey that = (ContextAwareUpdaterKey)o;
            if (!this.viewType.equals(that.viewType)) {
                return false;
            }
            if (this.declaredViewType != null ? !this.declaredViewType.equals(that.declaredViewType) : that.declaredViewType != null) {
                return false;
            }
            if (this.owner != that.owner) {
                return false;
            }
            return this.ownerMapping != null ? this.ownerMapping.equals(that.ownerMapping) : that.ownerMapping == null;
        }

        public int hashCode() {
            int result = this.viewType.hashCode();
            result = 31 * result + (this.declaredViewType != null ? this.declaredViewType.hashCode() : 0);
            result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
            result = 31 * result + (this.ownerMapping != null ? this.ownerMapping.hashCode() : 0);
            return result;
        }
    }
}

