/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import java.util.LinkedHashSet;
import java.util.Set;

public class TupleIdDescriptor {
    private final TupleIdDescriptor parent;
    private final Set<Integer> idPositions;

    public TupleIdDescriptor() {
        this(null);
    }

    public TupleIdDescriptor(TupleIdDescriptor parent) {
        this.parent = parent;
        this.idPositions = new LinkedHashSet<Integer>();
    }

    public int[] createIdPositions() {
        Set<Integer> realIdPositions = this.computeIdPositions();
        int[] positions = new int[realIdPositions.size()];
        int i = 0;
        for (Integer realIdPosition : realIdPositions) {
            positions[i++] = realIdPosition;
        }
        return positions;
    }

    private Set<Integer> computeIdPositions() {
        if (this.parent == null) {
            return this.idPositions;
        }
        Set<Integer> parentIdPositions = this.parent.computeIdPositions();
        LinkedHashSet<Integer> realIdPositions = new LinkedHashSet<Integer>(parentIdPositions.size() + this.idPositions.size());
        realIdPositions.addAll(parentIdPositions);
        realIdPositions.addAll(this.idPositions);
        return realIdPositions;
    }

    public void addIdPosition(int idPosition) {
        this.idPositions.add(idPosition);
    }
}

