/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.listener;

import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.ViewTransition;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;

public class ViewInstanceTransitionListener {
    private final Method listener;
    private final int parameterCount;
    private final int entityViewManagerIndex;
    private final int entityManagerIndex;
    private final int transitionIndex;

    public ViewInstanceTransitionListener(Method listener) {
        int entityViewManagerIndex = -1;
        int entityManagerIndex = -1;
        int transitionIndex = -1;
        Class<?>[] parameterTypes = listener.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (EntityViewManager.class == parameterTypes[i]) {
                entityViewManagerIndex = i;
                continue;
            }
            if (EntityManager.class == parameterTypes[i]) {
                entityManagerIndex = i;
                continue;
            }
            if (ViewTransition.class == parameterTypes[i]) {
                transitionIndex = i;
                continue;
            }
            throw new IllegalArgumentException("Illegal argument at index " + i + " of type " + parameterTypes[i].getName() + " in lifecycle method " + listener.getDeclaringClass().getName() + "." + listener.getName() + "! Allowed argument types are [" + EntityViewManager.class.getSimpleName() + ", " + EntityManager.class.getSimpleName() + ", " + ViewTransition.class.getSimpleName() + "]");
        }
        listener.setAccessible(true);
        this.listener = listener;
        this.parameterCount = parameterTypes.length;
        this.entityViewManagerIndex = entityViewManagerIndex;
        this.entityManagerIndex = entityManagerIndex;
        this.transitionIndex = transitionIndex;
    }

    protected final Object invoke(EntityViewManager entityViewManager, EntityManager entityManager, Object view, ViewTransition viewTransition) {
        Object[] parameters = new Object[this.parameterCount];
        if (this.entityViewManagerIndex != -1) {
            parameters[this.entityViewManagerIndex] = entityViewManager;
        }
        if (this.entityManagerIndex != -1) {
            parameters[this.entityManagerIndex] = entityManager;
        }
        if (this.transitionIndex != -1) {
            parameters[this.transitionIndex] = viewTransition;
        }
        try {
            return this.listener.invoke(view, parameters);
        }
        catch (Exception e) {
            throw new RuntimeException("Error happened during invocation of the lifecycle method", e);
        }
    }
}

