/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.view.impl.EntityViewListenerFactory;
import java.lang.reflect.Constructor;

public final class SimpleEntityViewListenerFactory<T>
implements EntityViewListenerFactory<T> {
    private final Class<? extends T> entityViewListenerClass;
    private final Constructor<? extends T> entityViewListenerConstructor;
    private final Class<? super T> listenerKind;

    public SimpleEntityViewListenerFactory(Class<? extends T> entityViewListenerClass, Class<? super T> listenerKind) {
        this.entityViewListenerClass = entityViewListenerClass;
        this.listenerKind = listenerKind;
        try {
            Constructor<T> constructor = entityViewListenerClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.entityViewListenerConstructor = constructor;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't access empty constructor of entity view listener class: " + entityViewListenerClass, e);
        }
    }

    @Override
    public Class<? super T> getListenerKind() {
        return this.listenerKind;
    }

    @Override
    public Class<T> getListenerClass() {
        return this.entityViewListenerClass;
    }

    @Override
    public T createListener() {
        try {
            return this.entityViewListenerConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't instantiate entity view listener", e);
        }
    }
}

