/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformator;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.UpdatableViewMap;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import com.blazebit.persistence.view.spi.type.BasicUserTypeStringSupport;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.List;

public class SingularMultisetTupleTransformer<C>
implements TupleTransformer {
    private final int startIndex;
    private final boolean hasSelectOrSubselectFetchedAttributes;
    private final TupleTransformator tupleTransformator;
    private final TupleTransformer subviewTupleTransformer;
    private final BasicUserTypeStringSupport<Object>[] fieldConverters;
    private final TypeConverter<Object, Object> elementConverter;

    public SingularMultisetTupleTransformer(int startIndex, boolean hasSelectOrSubselectFetchedAttributes, TupleTransformator tupleTransformator, TupleTransformer subviewTupleTransformer, BasicUserTypeStringSupport<Object>[] fieldConverters, TypeConverter<Object, Object> elementConverter) {
        this.startIndex = startIndex;
        this.hasSelectOrSubselectFetchedAttributes = hasSelectOrSubselectFetchedAttributes;
        this.tupleTransformator = tupleTransformator;
        this.subviewTupleTransformer = subviewTupleTransformer;
        this.elementConverter = elementConverter;
        this.fieldConverters = fieldConverters;
    }

    @Override
    public int getConsumeStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getConsumeEndIndex() {
        return this.startIndex + 1;
    }

    @Override
    public Object[] transform(Object[] tuple, UpdatableViewMap updatableViewMap) {
        if (tuple[this.startIndex] != null) {
            List objects = (List)tuple[this.startIndex];
            for (int i = 0; i < objects.size(); ++i) {
                Object[] elementTuple = (Object[])objects.get(i);
                for (int j = 0; j < this.fieldConverters.length; ++j) {
                    if (!(elementTuple[j] instanceof CharSequence)) continue;
                    elementTuple[j] = this.fieldConverters[j].fromString((CharSequence)elementTuple[j]);
                }
            }
            this.tupleTransformator.transformAll(objects);
            if (!objects.isEmpty()) {
                Object[] transformedTuple = this.subviewTupleTransformer.transform((Object[])objects.get(0), updatableViewMap);
                tuple[this.startIndex] = this.elementConverter == null ? transformedTuple[0] : this.elementConverter.convertToViewType(transformedTuple[0]);
            }
        }
        return tuple;
    }
}

