/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.TupleId;
import com.blazebit.persistence.view.impl.objectbuilder.TupleReuse;
import com.blazebit.persistence.view.impl.objectbuilder.ViewTypeObjectBuilderTemplate;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.UpdatableViewMap;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;

public class UpdatableSubviewTupleTransformer
implements TupleTransformer {
    private final ViewTypeObjectBuilderTemplate<Object[]> template;
    private final int nullCheckObjectIndex;
    private final int consumeStartIndex;
    private final int consumeEndIndex;
    private final ObjectBuilder<Object[]> objectBuilder;

    public UpdatableSubviewTupleTransformer(ViewTypeObjectBuilderTemplate<Object[]> template, ObjectBuilder<Object[]> objectBuilder, boolean nullIfEmpty) {
        this.template = template;
        this.consumeStartIndex = template.getTupleOffset() + 1;
        this.consumeEndIndex = template.getTupleOffset() + template.getMappers().length;
        this.objectBuilder = objectBuilder;
        if (nullIfEmpty) {
            int i;
            int[] idPositions = template.getIdPositions();
            for (i = idPositions.length - 1; i >= 0 && idPositions[i] < 0; --i) {
            }
            this.nullCheckObjectIndex = idPositions[i];
        } else {
            this.nullCheckObjectIndex = -1;
        }
    }

    @Override
    public int getConsumeStartIndex() {
        return this.consumeStartIndex;
    }

    @Override
    public int getConsumeEndIndex() {
        return this.consumeEndIndex;
    }

    @Override
    public Object[] transform(Object[] tuple, UpdatableViewMap updatableViewMap) {
        if (this.nullCheckObjectIndex == -1 || tuple[this.nullCheckObjectIndex] != null) {
            TupleId id = new TupleId(this.template.getIdPositions(), tuple);
            UpdatableViewMap.UpdatableViewKey key = new UpdatableViewMap.UpdatableViewKey(this.template.getViewClass(), id);
            Object o = updatableViewMap.get(key);
            if (o != null) {
                tuple[this.template.getTupleOffset()] = o;
            } else {
                o = this.objectBuilder.build(tuple);
                updatableViewMap.put(key, o);
                tuple[this.template.getTupleOffset()] = o;
            }
        } else {
            tuple[this.template.getTupleOffset()] = null;
        }
        for (int i = this.consumeStartIndex; i < this.consumeEndIndex; ++i) {
            tuple[i] = TupleReuse.CONSUMED;
        }
        return tuple;
    }
}

