/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.proxy;

import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingConstructorImpl;
import com.blazebit.persistence.view.impl.proxy.DirectConstructorReflectionInstantiator;
import com.blazebit.persistence.view.impl.proxy.ObjectInstantiator;
import com.blazebit.persistence.view.impl.proxy.ProxyFactory;
import com.blazebit.persistence.view.impl.proxy.TupleConstructorReflectionInstantiator;
import com.blazebit.persistence.view.impl.type.PrimitiveBooleanTypeConverter;
import com.blazebit.persistence.view.impl.type.PrimitiveByteTypeConverter;
import com.blazebit.persistence.view.impl.type.PrimitiveCharTypeConverter;
import com.blazebit.persistence.view.impl.type.PrimitiveDoubleTypeConverter;
import com.blazebit.persistence.view.impl.type.PrimitiveFloatTypeConverter;
import com.blazebit.persistence.view.impl.type.PrimitiveIntTypeConverter;
import com.blazebit.persistence.view.impl.type.PrimitiveLongTypeConverter;
import com.blazebit.persistence.view.impl.type.PrimitiveShortTypeConverter;
import com.blazebit.persistence.view.spi.type.BasicDirtyTracker;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.DirtyStateTrackable;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractReflectionInstantiator<T>
implements ObjectInstantiator<T> {
    private static final Map<Class<?>, TypeConverter<Object, Object>> PRIMITIVE_TYPE_CONVERTERS;
    private static final Map<Class<?>, Object> DEFAULT_VALUES;
    protected final MutableBasicUserTypeEntry[] mutableBasicUserTypes;
    protected final TypeConverterEntry[] typeConverters;

    public AbstractReflectionInstantiator(List<MutableBasicUserTypeEntry> mutableBasicUserTypes, List<TypeConverterEntry> typeConverterEntries, Class<?>[] parameterTypes) {
        this.mutableBasicUserTypes = mutableBasicUserTypes.toArray(new MutableBasicUserTypeEntry[mutableBasicUserTypes.size()]);
        this.typeConverters = AbstractReflectionInstantiator.withPrimitiveConverters(typeConverterEntries, parameterTypes);
    }

    public static Object[] createDefaultObject(int offset, Class<?>[] parameterTypes, int constructorParameterCount) {
        Object[] array = new Object[offset + constructorParameterCount];
        int parameterOffset = parameterTypes.length - constructorParameterCount;
        for (int i = 0; i < constructorParameterCount; ++i) {
            array[offset + i] = DEFAULT_VALUES.get(parameterTypes[parameterOffset + i]);
        }
        return array;
    }

    public static <T> ObjectInstantiator<T> createInstantiator(MappingConstructorImpl<T> mappingConstructor, ProxyFactory proxyFactory, ManagedViewTypeImplementor<T> managedViewType, Class<?>[] constructorParameterTypes, EntityViewManagerImpl evm, List<MutableBasicUserTypeEntry> mutableBasicUserTypes, List<TypeConverterEntry> typeConverterEntries) {
        if (managedViewType.getJavaType().isInterface() || Modifier.isAbstract(managedViewType.getJavaType().getModifiers())) {
            return new TupleConstructorReflectionInstantiator<T>(mappingConstructor, proxyFactory, managedViewType, constructorParameterTypes, evm, mutableBasicUserTypes, typeConverterEntries);
        }
        return new DirectConstructorReflectionInstantiator<T>(mappingConstructor, proxyFactory, managedViewType, constructorParameterTypes, evm, mutableBasicUserTypes, typeConverterEntries);
    }

    protected final void prepareTuple(Object[] tuple) {
        for (int i = 0; i < this.typeConverters.length; ++i) {
            TypeConverterEntry entry = this.typeConverters[i];
            tuple[entry.index] = entry.typeConverter.convertToViewType(tuple[entry.index]);
        }
    }

    protected final void finalizeInstance(Object instance) {
        if (this.mutableBasicUserTypes.length != 0) {
            Object[] initialState = ((DirtyStateTrackable)instance).$$_getInitialState();
            for (int i = 0; i < this.mutableBasicUserTypes.length; ++i) {
                MutableBasicUserTypeEntry entry = this.mutableBasicUserTypes[i];
                Object value = initialState[entry.index];
                if (value == null) continue;
                BasicUserType<Object> userType = entry.userType;
                if (userType.supportsDirtyTracking() && value instanceof BasicDirtyTracker) {
                    ((BasicDirtyTracker)value).$$_setParent((BasicDirtyTracker)instance, entry.index);
                    continue;
                }
                initialState[entry.index] = userType.deepClone(value);
            }
        }
    }

    static TypeConverterEntry[] withPrimitiveConverters(List<TypeConverterEntry> typeConverterEntries, Class<?>[] parameterTypes) {
        ArrayList<TypeConverterEntry> primitiveConverters = new ArrayList<TypeConverterEntry>(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (!parameterType.isPrimitive()) continue;
            primitiveConverters.add(new TypeConverterEntry(i, PRIMITIVE_TYPE_CONVERTERS.get(parameterType)));
        }
        TypeConverterEntry[] array = new TypeConverterEntry[typeConverterEntries.size() + primitiveConverters.size()];
        int index = 0;
        for (TypeConverterEntry typeConverterEntry : typeConverterEntries) {
            array[index++] = typeConverterEntry;
        }
        for (TypeConverterEntry typeConverterEntry : primitiveConverters) {
            array[index++] = typeConverterEntry;
        }
        return array;
    }

    static {
        HashMap primitiveTypeConverters = new HashMap();
        primitiveTypeConverters.put(Boolean.TYPE, PrimitiveBooleanTypeConverter.INSTANCE);
        primitiveTypeConverters.put(Byte.TYPE, PrimitiveByteTypeConverter.INSTANCE);
        primitiveTypeConverters.put(Character.TYPE, PrimitiveCharTypeConverter.INSTANCE);
        primitiveTypeConverters.put(Short.TYPE, PrimitiveShortTypeConverter.INSTANCE);
        primitiveTypeConverters.put(Integer.TYPE, PrimitiveIntTypeConverter.INSTANCE);
        primitiveTypeConverters.put(Long.TYPE, PrimitiveLongTypeConverter.INSTANCE);
        primitiveTypeConverters.put(Float.TYPE, PrimitiveFloatTypeConverter.INSTANCE);
        primitiveTypeConverters.put(Double.TYPE, PrimitiveDoubleTypeConverter.INSTANCE);
        PRIMITIVE_TYPE_CONVERTERS = primitiveTypeConverters;
        HashMap defaultValues = new HashMap();
        defaultValues.put(Boolean.TYPE, false);
        defaultValues.put(Byte.TYPE, (byte)0);
        defaultValues.put(Character.TYPE, Character.valueOf('\u0000'));
        defaultValues.put(Short.TYPE, (short)0);
        defaultValues.put(Integer.TYPE, 0);
        defaultValues.put(Long.TYPE, 0L);
        defaultValues.put(Float.TYPE, Float.valueOf(0.0f));
        defaultValues.put(Double.TYPE, 0.0);
        DEFAULT_VALUES = defaultValues;
    }

    public static final class MutableBasicUserTypeEntry {
        final int index;
        final BasicUserType<Object> userType;

        public MutableBasicUserTypeEntry(int index, BasicUserType<Object> userType) {
            this.index = index;
            this.userType = userType;
        }
    }

    public static final class TypeConverterEntry {
        final int index;
        final TypeConverter<Object, Object> typeConverter;

        public TypeConverterEntry(int index, TypeConverter<Object, Object> typeConverter) {
            this.index = index;
            this.typeConverter = typeConverter;
        }
    }
}

