/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.lang.reflect.Method;

public abstract class AbstractLocalDateTimeTypeConverter<T>
implements TypeConverter<T, Object> {
    private static final Method OF_INSTANT;
    private static final Method OF_EPOCH_MILLI;
    private static final Method TO_INSTANT;
    private static final Method TO_EPOCH_MILLI;
    private static final Object ZONE_ID;
    private static final Object ZONE_OFFSET;

    protected final Object ofEpochMilli(long milli) {
        try {
            Object instant = OF_EPOCH_MILLI.invoke(null, milli);
            return OF_INSTANT.invoke(null, instant, ZONE_ID);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final long toEpochMillis(Object object) {
        try {
            Object instant = TO_INSTANT.invoke(object, ZONE_OFFSET);
            return (Long)TO_EPOCH_MILLI.invoke(instant, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method ofInstant = null;
        Method ofEpochMilli = null;
        Method toInstant = null;
        Method toEpochMilli = null;
        Object zoneId = null;
        Object zoneOffset = null;
        try {
            Class<?> c = Class.forName("java.time.LocalDateTime");
            Class<?> instantClass = Class.forName("java.time.Instant");
            Class<?> zoneIdClass = Class.forName("java.time.ZoneId");
            Class<?> zoneOffsetClass = Class.forName("java.time.ZoneOffset");
            ofInstant = c.getMethod("ofInstant", instantClass, zoneIdClass);
            toInstant = c.getMethod("toInstant", zoneOffsetClass);
            ofEpochMilli = instantClass.getMethod("ofEpochMilli", Long.TYPE);
            toEpochMilli = instantClass.getMethod("toEpochMilli", new Class[0]);
            zoneId = zoneIdClass.getMethod("systemDefault", new Class[0]).invoke(null, new Object[0]);
            zoneOffset = zoneOffsetClass.getMethod("systemDefault", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OF_INSTANT = ofInstant;
        OF_EPOCH_MILLI = ofEpochMilli;
        TO_INSTANT = toInstant;
        TO_EPOCH_MILLI = toEpochMilli;
        ZONE_ID = zoneId;
        ZONE_OFFSET = zoneOffset;
    }
}

